/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import javax.microedition.io.Connector;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordStore;
import javax.wireless.messaging.Message;
import javax.wireless.messaging.MessageConnection;
import javax.wireless.messaging.TextMessage;

public final class MCF_LicenseChecker
implements Runnable,
CommandListener {
    public boolean childStarted = false;
    private boolean started = false;
    private boolean unlocked = false;
    private MCF_LicenseMidlet app;
    private int state;
    private int nextState;
    private Displayable curScreen;
    private String[] texts;
    private int formPositiveAction;
    private int formNegativeAction;
    private Command cmdPositive;
    private Command cmdNegative;
    private int key;
    private static final int KEY_OK = -6;
    private static final int KEY_BACK = -7;
    private static final String RMS_NAME = "demo";
    private static final String TEXT_FILE = "MCF_texts.txt";
    private static final int TXT_SENDING_CAPTION = 0;
    private static final int TXT_WAIT_PLEASE = 1;
    private static final int TXT_DEMO_CAPTION = 2;
    private static final int TXT_DEMO_TEXT = 3;
    private static final int TXT_THANKS_CAPTION = 4;
    private static final int TXT_THANKS_TEXT = 5;
    private static final int TXT_ERROR_SMS_CAPTION = 6;
    private static final int TXT_ERROR_SMS_TEXT = 7;
    private static final int TXT_OK = 8;
    private static final int TXT_EXIT = 9;
    private static final int STATE_INIT = 0;
    private static final int STATE_EXIT = 1;
    private static final int STATE_QUESTION = 2;
    private static final int STATE_THANKS = 3;
    private static final int STATE_ERROR_SMS = 4;
    private static final int STATE_SEND_SMS = 5;
    private String debugInfo;

    public MCF_LicenseChecker(MCF_LicenseMidlet mCF_LicenseMidlet) {
        this.app = mCF_LicenseMidlet;
    }

    public void startApp() {
        if (!this.started) {
            this.started = true;
            new Thread(this).start();
        }
    }

    public void run() {
        long l2 = this.getTimeLimit();
        if (l2 != 0L) {
            this.childStarted = true;
            this.app.startApp();
            if (l2 < 0L) {
                return;
            }
            long l3 = System.currentTimeMillis();
            while (l3 <= System.currentTimeMillis() && l3 + l2 > System.currentTimeMillis()) {
                Thread.yield();
                try {
                    Thread.sleep(50L);
                }
                catch (Exception exception) {}
            }
            this.app.pauseApp();
            this.childStarted = false;
        }
        while (this.state != 1) {
            if (this.nextState > 0) {
                this.init();
            }
            this.turn();
            Thread.yield();
            try {
                Thread.sleep(50L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (Display.getDisplay((MIDlet)this.app).getCurrent() == this.curScreen || this.curScreen == null) continue;
            this.setCurrent(this.curScreen);
        }
    }

    private void init() {
        this.key = 0;
        this.state = this.nextState;
        this.nextState = 0;
        switch (this.state) {
            case 1: {
                this.app.notifyDestroyed();
                break;
            }
            case 5: {
                this.initForm(0, 1, -1, -1, -1, -1);
                break;
            }
            case 2: {
                this.initForm(2, 3, 8, 5, 9, 1);
                break;
            }
            case 3: {
                this.initForm(4, 5, 8, 1, -1, -1);
                break;
            }
            case 4: {
                this.initForm(6, 7, 8, 5, 9, 1);
            }
        }
    }

    private void turn() {
        switch (this.state) {
            case 0: {
                this.loadTexts();
                this.nextState = 2;
                break;
            }
            case 5: {
                this.sendSMS();
                break;
            }
            default: {
                if (this.key == -6 && this.formPositiveAction >= 0) {
                    this.nextState = this.formPositiveAction;
                }
                if (this.key != -7 || this.formNegativeAction < 0) break;
                this.nextState = this.formNegativeAction;
            }
        }
    }

    private void sendSMS() {
        String string = this.app.getAppProperty("Short-Number");
        String string2 = this.app.getAppProperty("Code");
        try {
            String string3 = "sms://" + string;
            MessageConnection messageConnection = (MessageConnection)Connector.open((String)string3);
            TextMessage textMessage = (TextMessage)messageConnection.newMessage("text");
            textMessage.setAddress(string3);
            textMessage.setPayloadText(string2);
            messageConnection.send((Message)textMessage);
            messageConnection.close();
            this.nextState = 3;
        }
        catch (Throwable throwable) {
            this.nextState = 4;
        }
    }

    private void initForm(int n2, int n3, int n4, int n5, int n6, int n7) {
        Form form = new Form(this.getString(n2));
        form.append(this.getString(n3));
        if (n4 >= 0) {
            this.cmdPositive = new Command(this.getString(n4), 4, 0);
            form.addCommand(this.cmdPositive);
        } else {
            this.cmdPositive = null;
        }
        if (n6 >= 0) {
            this.cmdNegative = new Command(this.getString(n6), 2, 1);
            form.addCommand(this.cmdNegative);
        } else {
            this.cmdNegative = null;
        }
        form.setCommandListener((CommandListener)this);
        this.formPositiveAction = n5;
        this.formNegativeAction = n7;
        this.setCurrent((Displayable)form);
    }

    public void commandAction(Command command, Displayable displayable) {
        if (displayable == this.curScreen && command != null) {
            if (command == this.cmdPositive) {
                this.key = -6;
            } else if (command == this.cmdNegative) {
                this.key = -7;
            }
        }
    }

    private void setCurrent(Displayable displayable) {
        this.curScreen = displayable;
        Display.getDisplay((MIDlet)this.app).setCurrent(displayable);
        Thread.yield();
    }

    private void loadTexts() {
        byte[] byArray = this.getResource(TEXT_FILE);
        String string = this.utf8(byArray);
        int n2 = string.indexOf(13);
        while (n2 >= 0) {
            string = string.substring(0, n2) + string.substring(n2 + 1);
            n2 = string.indexOf(13);
        }
        n2 = 0;
        while (n2 < string.length()) {
            int n3 = string.indexOf(10, n2);
            if (n3 < 0) {
                n3 = string.length();
            }
            String string2 = string.substring(n2, n3);
            int n4 = string2.indexOf("\\n");
            while (n4 >= 0) {
                string2 = string2.substring(0, n4) + '\n' + string2.substring(n4 + 2);
                n4 = string2.indexOf("\\n");
            }
            this.texts = MCF_LicenseChecker.addToArray(this.texts, string2);
            n2 = n3 + 1;
        }
    }

    private String getString(int n2) {
        if (n2 < 0 || this.texts == null || n2 >= this.texts.length) {
            return null;
        }
        String string = this.texts[n2];
        int n3 = string.indexOf(60);
        while (n3 >= 0) {
            int n4 = string.indexOf(62, n3);
            if (n3 < n4) {
                String string2 = string.substring(n3 + 1, n4);
                String string3 = this.decodeURI(this.app.getAppProperty(string2));
                if (string3 != null) {
                    string = string.substring(0, n3) + string3 + string.substring(n4 + 1);
                } else {
                    n3 = n4;
                }
            } else {
                n3 = -1;
            }
            n3 = string.indexOf(60, n3);
        }
        return string;
    }

    public String utf8(byte[] byArray) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeShort(byArray.length);
            dataOutputStream.write(byArray);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            return dataInputStream.readUTF();
        }
        catch (Exception exception) {
            return new String(byArray);
        }
    }

    private String decodeURI(String string) {
        if (string == null || string.indexOf(37) < 0) {
            return string;
        }
        String string2 = null;
        try {
            int n2;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            int n3 = string.length();
            for (n2 = 0; n2 < string.length(); ++n2) {
                if (string.charAt(n2) != '%') continue;
                n3 -= 2;
            }
            dataOutputStream.writeShort(n3);
            n2 = 0;
            while (n2 < string.length()) {
                if (string.charAt(n2) == '%') {
                    dataOutputStream.write(Integer.parseInt(string.substring(n2 + 1, n2 + 3), 16));
                    n2 += 3;
                    continue;
                }
                dataOutputStream.write(string.charAt(n2));
                ++n2;
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            string2 = new DataInputStream(new ByteArrayInputStream(byArray)).readUTF();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string2;
    }

    private byte[] getResource(String string) {
        if (string.charAt(0) != '/') {
            string = '/' + string;
        }
        try {
            InputStream inputStream = ((Object)((Object)this.app)).getClass().getResourceAsStream(string);
            byte[] byArray = new byte[1024];
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            int n2 = 1;
            while (n2 > 0) {
                n2 = inputStream.read(byArray);
                if (n2 <= 0) continue;
                byteArrayOutputStream.write(byArray, 0, n2);
            }
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static String[] addToArray(String[] stringArray, String string) {
        if (stringArray == null) {
            stringArray = new String[1];
        } else {
            String[] stringArray2 = new String[stringArray.length + 1];
            System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
            stringArray = stringArray2;
        }
        stringArray[stringArray.length - 1] = string;
        return stringArray;
    }

    private long getTimeLimit() {
        this.unlocked = false;
        int n2 = -1;
        int n3 = 0;
        try {
            n2 = Integer.parseInt(this.app.getAppProperty("Demo-Sessions"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n2 > 0) {
            n3 = this.loadAndSaveData(false);
        }
        if (n2 < 0 || n3 <= n2) {
            long l2 = -1L;
            try {
                l2 = Integer.parseInt(this.app.getAppProperty("Demo-Timeout"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (l2 < 0L) {
                return -1L;
            }
            return l2 * 1000L;
        }
        return 0L;
    }

    private int loadAndSaveData(boolean bl) {
        byte[] byArray;
        RecordStore recordStore = null;
        int n2 = 1;
        try {
            recordStore = RecordStore.openRecordStore((String)RMS_NAME, (boolean)false);
            byArray = recordStore.getRecord(recordStore.getNextRecordID() - 1);
            n2 = Math.min(1 + (byArray[0] & 0xFF), 255);
        }
        catch (Exception exception) {
            try {
                recordStore = RecordStore.openRecordStore((String)RMS_NAME, (boolean)true);
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
        if (this.unlocked) {
            return n2;
        }
        if (bl) {
            this.unlocked = true;
        }
        try {
            byArray = new byte[]{(byte)n2};
            if (recordStore.getNumRecords() > 0) {
                recordStore.setRecord(recordStore.getNextRecordID() - 1, byArray, 0, byArray.length);
            } else {
                recordStore.addRecord(byArray, 0, byArray.length);
            }
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            return 255;
        }
        return n2;
    }

    private void debug(String string) {
    }
}

