/*
 * Decompiled with CFR 0.152.
 */
package BlockBreaker;

import BlockBreaker.Animal;
import BlockBreaker.Ball;
import BlockBreaker.Bonus;
import BlockBreaker.GameCanvas;
import BlockBreaker.Map;
import BlockBreaker.Missile;
import BlockBreaker.PowerUp;
import BlockBreaker.Racket;
import com.nokia.mid.sound.Sound;
import com.nokia.mid.ui.DeviceControl;
import java.io.InputStream;

class Game {
    public static final byte[] DIRECTIONS = new byte[]{1, 3, 2, 6, 4, 12, 8, 9};
    private static final byte[][] MUSICDATA = new byte[10][];
    public static final int RACKET_START_X = 40;
    public static final int RACKET_START_Y = 62;
    public static final int SMALL_RACKET_WIDTH = 17;
    public static final int NORMAL_RACKET_WIDTH = 21;
    public static final int LARGE_RACKET_WIDTH = 25;
    public static final int RACKET_HEIGHT = 3;
    public static final int SMALL_RACKET_FRAME = 0;
    public static final int NORMAL_RACKET_FRAME = 1;
    public static final int LARGE_RACKET_FRAME = 2;
    public static final int MAGNET_RACKET_FRAME = 3;
    public static final int BONUS_DIAMETER = 8;
    public static final int BALL_DIAMETER = 4;
    public static final int BRICK_WIDTH = 10;
    public static final int BRICK_HEIGHT = 3;
    public static int FAST;
    public static int NORMAL;
    public static int SLOW;
    public static final int NB_NUMBER = 5;
    public static final int NB_LIFE = 2;
    public static final int MAX_BALL = 3;
    public Racket racket;
    public Map map;
    public PowerUp pUp;
    public Missile missile;
    public int ballNum = 0;
    public Bonus[] bonusArray = new Bonus[8];
    public Ball[] ballArray = new Ball[3];
    public boolean show_missile = false;
    public boolean scroll = false;
    public boolean bSound = true;
    public byte level = 0;
    public short score = 0;
    public int leftBrick = 0;
    public int life = 2;
    public int currentPUp = -1;
    public int showText = 0;
    public int mapOffset = 0;
    public static Sound sound;
    private GameCanvas canvas;
    private Animal[] animals = new Animal[3];
    public int totalAnimals;

    public Game(GameCanvas gameCanvas) {
        int n;
        this.canvas = gameCanvas;
        this.map = new Map();
        this.pUp = new PowerUp();
        this.animals[0] = new Animal();
        this.animals[1] = new Animal();
        this.animals[2] = new Animal();
        this.missile = new Missile();
        this.racket = new Racket();
        this.map.loadMap(this.canvas.ReadByteArray("map.bin", 8 * 12 * 30 / 2, 8 * 12 * 0 / 2));
        this.pUp.loadPUp(this.canvas.ReadByteArray("pUp.bin", 1050, 0));
        for (n = 0; n < 8; ++n) {
            this.bonusArray[n] = new Bonus(0, 0);
        }
        for (n = 0; n < 3; ++n) {
            this.ballArray[n] = new Ball();
        }
        for (n = 0; n < 10; ++n) {
            Game.MUSICDATA[n] = Game.readSong(String.valueOf(String.valueOf(new StringBuffer("s").append(n).append(".nok"))));
        }
        this.playMusic(0);
    }

    private static byte[] readSong(String string) {
        byte[] byArray = null;
        byte[] byArray2 = new byte[]{0, 0};
        try {
            InputStream inputStream = string.getClass().getResourceAsStream("/res/".concat(String.valueOf(String.valueOf(string))));
            inputStream.read(byArray2);
            int n = byArray2[0];
            if (n < 0) {
                n += 256;
            }
            byArray = new byte[n += byArray2[1] * 256];
            inputStream.read(byArray);
            inputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return byArray;
    }

    public final void initGame() {
        this.level = 0;
        this.score = 0;
        this.initLevel(this.level);
        this.canvas.initLife(2);
    }

    public final void initLevel(int n) {
        this.removePowerUp();
        this.initBall();
        this.racket.init();
        this.map.setLevel(n);
        this.canvas.loadWall();
        this.pUp.setLevel(n);
        this.initAnimals(n);
        this.canvas.levelB_spr[0].setFrame((n + 1) / 10);
        this.canvas.levelB_spr[1].setFrame((n + 1) % 10);
        this.canvas.setScore();
        this.scroll = true;
        this.mapOffset = 36;
    }

    private final void initAnimals(int n) {
        this.totalAnimals = this.canvas.animal_map[n * 8];
        block6: for (int i = 0; i < this.totalAnimals; ++i) {
            this.animals[i].type = this.canvas.animal_map[n * 8 + 1];
            this.animals[i].dir = 1;
            this.animals[i].x = this.canvas.animal_map[n * 8 + 2 * (i + 1)];
            this.animals[i].y = this.canvas.animal_map[n * 8 + 2 * (i + 1) + 1];
            this.animals[i].o_x = this.animals[i].x;
            this.animals[i].o_y = this.animals[i].y;
            this.animals[i].times = i * 100 + 1;
            System.arraycopy(this.canvas.animal_pixs[this.animals[i].type], 0, this.canvas.animal_pix, 0, 12);
            this.canvas.animal_sprs[i].setPosition(this.animals[i].x, this.animals[i].y);
            switch (this.animals[i].type) {
                case 0: 
                case 5: {
                    this.animals[i].speed = 1;
                    this.animals[i].dir = 0;
                    this.animals[i].step = (byte)2;
                    continue block6;
                }
                case 1: 
                case 2: 
                case 3: {
                    this.animals[i].speed = 1;
                    this.animals[i].dir = 0;
                    this.animals[i].step = (byte)2;
                    continue block6;
                }
                case 4: 
                case 6: {
                    this.animals[i].speed = (byte)2;
                    this.animals[i].dir = 0;
                    this.animals[i].step = (byte)2;
                    continue block6;
                }
                case 7: 
                case 8: 
                case 9: {
                    this.animals[i].speed = (byte)2;
                    this.animals[i].dir = 0;
                    this.animals[i].step = (byte)2;
                }
            }
        }
    }

    private final void initBall() {
        this.newBall();
    }

    private void playMusic(int n) {
        try {
            if (sound == null) {
                sound = new Sound(MUSICDATA[n], 1);
                sound.play(1);
                DeviceControl.stopVibra();
            } else {
                if (sound.getState() == 0) {
                    sound.stop();
                }
                sound.init(MUSICDATA[n], 1);
                sound.play(1);
                DeviceControl.stopVibra();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final void newBall() {
        int n;
        if (this.ballNum < 3 && (n = this.canvas.addBall()) < 3) {
            this.ballArray[n].setI(this.racket.left(), this.racket.top() - 5);
            this.ballArray[n].onRacket = true;
            this.ballArray[n].init();
            ++this.ballNum;
        }
    }

    private final void removePowerUp() {
        switch (this.currentPUp) {
            case 0: 
            case 1: {
                this.racket.setSize(1);
                this.canvas.racket_spr.setFrame(1);
                break;
            }
            case 2: {
                this.missile.unload();
                break;
            }
            case 4: {
                this.racket.magnetic = false;
                this.canvas.racket_spr.setFrame(1);
                break;
            }
            case 5: 
            case 6: {
                for (int i = 0; i < 3; ++i) {
                    this.ballArray[i].setSpeed(NORMAL);
                }
                break;
            }
        }
        this.currentPUp = -1;
    }

    private final void removeBall(int n) {
        --this.ballNum;
        this.canvas.removeBall(n);
        if (this.ballNum == 0) {
            switch (this.life) {
                case 2: {
                    this.canvas.gfxManager.deleteObject(this.canvas.life_spr[0]);
                    this.canvas.drawBack = true;
                    break;
                }
                case 1: {
                    this.canvas.gfxManager.deleteObject(this.canvas.life_spr[1]);
                    this.canvas.drawBack = true;
                    break;
                }
                case 0: {
                    this.canvas.switchToGameOver();
                    if (this.bSound) {
                        this.playMusic(1);
                    }
                    return;
                }
            }
            --this.life;
            this.removePowerUp();
            this.newBall();
            if (this.bSound) {
                this.playMusic(4);
            }
        }
    }

    private final void manageBall() {
        for (int i = 0; i < 3; ++i) {
            Ball ball = this.ballArray[i];
            if (!this.canvas.ballSprArray[i].getVisible() || ball.onRacket) continue;
            ball.move();
            if (ball.top() > this.racket.bottom()) {
                this.removeBall(i);
                continue;
            }
            if (ball.left() < 0) {
                ball.xReflect();
                ball.setVelocityF(ball.fDX, ball.fDY + 400);
                ball.setI(0, ball.top());
            }
            if (ball.right() > 78) {
                ball.xReflect();
                ball.setVelocityF(ball.fDX, ball.fDY + 400);
                ball.setI(76, ball.top());
            }
            if (ball.top() < 0) {
                ball.yReflect();
                ball.setVelocityF(ball.fDX, ball.fDY + 400);
                ball.setI(ball.left(), 0);
            }
            this.checkRacket(ball);
            this.checkBrick(ball);
            this.checkAnimal(ball);
        }
    }

    private final void checkRacket(Ball ball) {
        if (ball.isColliding(this.racket)) {
            if (ball.left() - this.racket.left() < 2) {
                ball.setVelocityF(-(ball.speed + 32768), -(ball.speed - 32768));
            } else if (ball.left() - this.racket.left() < 4) {
                ball.setVelocityF(-ball.speed, -ball.speed);
            } else if (ball.left() - this.racket.left() < 6) {
                ball.setVelocityF(-(ball.speed - 32768), -(ball.speed + 32768));
            } else if (ball.left() - this.racket.left() > this.racket.getWidth() - 3) {
                ball.setVelocityF(ball.speed + 32768, -(ball.speed - 32768));
            } else if (ball.left() - this.racket.left() > this.racket.getWidth() - 5) {
                ball.setVelocityF(ball.speed, -ball.speed);
            } else if (ball.left() - this.racket.left() > this.racket.getWidth() - 7) {
                ball.setVelocityF(ball.speed - 32768, -(ball.speed + 32768));
            } else if (ball.getDirection() < 4) {
                ball.yReflect();
            }
            ball.setI(ball.left(), this.racket.top() - 4);
            if (this.racket.magnetic) {
                ball.onRacket = true;
            }
            if (this.bSound) {
                this.playMusic(5);
            }
        }
    }

    private final void checkBrick(Ball ball) {
        byte by = 0;
        byte[] byArray = new byte[]{0, 0, 0, 0};
        int[] nArray = new int[]{0, 0, 0, 0};
        int[] nArray2 = new int[]{0, 0, 0, 0};
        nArray[0] = ball.left() / 10;
        nArray2[0] = ball.top() / 3;
        by = (byte)(this.map.checkBrick(nArray[0], nArray2[0]) << 3);
        byArray[0] = this.map.getBrick(nArray[0], nArray2[0]);
        nArray[1] = ball.right() / 10;
        nArray2[1] = ball.top() / 3;
        by = (byte)(by | (byte)(this.map.checkBrick(nArray[1], nArray2[1]) << 2));
        byArray[1] = this.map.getBrick(nArray[1], nArray2[1]);
        nArray[2] = ball.left() / 10;
        nArray2[2] = ball.bottom() / 3;
        by = (byte)(by | (byte)(this.map.checkBrick(nArray[2], nArray2[2]) << 1));
        byArray[2] = this.map.getBrick(nArray[2], nArray2[2]);
        nArray[3] = ball.right() / 10;
        nArray2[3] = ball.bottom() / 3;
        by = (byte)(by | this.map.checkBrick(nArray[3], nArray2[3]));
        byArray[3] = this.map.getBrick(nArray[3], nArray2[3]);
        if (by == 0) {
            return;
        }
        if (by == 15) {
            switch (ball.getDirection()) {
                case 1: {
                    ball.setI(ball.left() - 1, ball.top() - 1);
                    break;
                }
                case 2: {
                    ball.setI(ball.left() + 1, ball.top() - 1);
                    break;
                }
                case 4: {
                    ball.setI(ball.left() - 1, ball.top() + 1);
                    break;
                }
                case 8: {
                    ball.setI(ball.left() + 1, ball.top() + 1);
                }
            }
            this.checkBrick(ball);
            return;
        }
        if (byArray[0] > 0) {
            this.HitBrick(ball, byArray[0], nArray[0], nArray2[0]);
        }
        if (byArray[1] > 0 && (nArray[0] != nArray[1] || nArray2[0] != nArray2[1])) {
            this.HitBrick(ball, byArray[1], nArray[1], nArray2[1]);
        }
        if (byArray[2] > 0 && (nArray[0] != nArray[2] || nArray2[0] != nArray2[2])) {
            this.HitBrick(ball, byArray[2], nArray[2], nArray2[2]);
        }
        if (!(byArray[3] <= 0 || nArray[1] == nArray[3] && nArray2[1] == nArray2[3] || nArray[2] == nArray[3] && nArray2[2] == nArray2[3])) {
            this.HitBrick(ball, byArray[3], nArray[3], nArray2[3]);
        }
        this.getBallAction(ball, by);
    }

    private void HitBrick(Ball ball, byte by, int n, int n2) {
        int n3 = 0;
        if (this.map.hitBrick(n, n2)) {
            n3 = this.pUp.getRandomPowerup(by);
            if (n3 != -1) {
                this.createNewBonus(ball.left(), ball.top(), n3);
            }
            if (by == 4) {
                this.score = (short)(this.score + 20);
                this.canvas.newExplosion(n * 10, n2 * 3, 1);
            } else {
                this.score = (short)(this.score + 10);
                this.canvas.newExplosion(n * 10, n2 * 3, 0);
            }
            this.canvas.eraseBrick(n, n2);
            --this.leftBrick;
        }
        if (this.bSound) {
            this.playMusic(8);
        }
    }

    private final void createNewBonus(int n, int n2, int n3) {
        int n4 = this.canvas.addBonus(n3);
        if (n4 < 8) {
            if (n > 80 - 8) {
                n = 80 - 8;
            }
            this.bonusArray[n4].setPosition(n, n2);
            this.bonusArray[n4].setType(n3);
        }
    }

    private final void getBallAction(Ball ball, byte by) {
        byte by2 = 0;
        by2 = ball.getDirection();
        block0 : switch (by) {
            case 12: {
                switch (by2) {
                    case 1: {
                        ball.xReflect();
                        ball.setI(ball.right() / 10 * 10 - 4, ball.top());
                        break;
                    }
                    case 2: {
                        ball.xReflect();
                        ball.setI(ball.left() / 10 * 10 + 10, ball.top());
                        break;
                    }
                    case 4: 
                    case 8: {
                        ball.yReflect();
                        ball.setI(ball.left(), ball.top() / 3 * 3 + 3);
                    }
                }
                break;
            }
            case 3: {
                switch (by2) {
                    case 4: {
                        ball.xReflect();
                        ball.setI(ball.right() / 10 * 10 - 4, ball.top());
                        break;
                    }
                    case 8: {
                        ball.xReflect();
                        ball.setI(ball.left() / 10 * 10 + 10, ball.top());
                        break;
                    }
                    case 1: 
                    case 2: {
                        ball.yReflect();
                        ball.setI(ball.left(), ball.bottom() / 3 * 3 - 4);
                    }
                }
                break;
            }
            case 10: {
                switch (by2) {
                    case 1: {
                        ball.yReflect();
                        ball.setI(ball.left(), ball.bottom() / 3 * 3 - 4);
                        break;
                    }
                    case 4: {
                        ball.yReflect();
                        ball.setI(ball.left(), ball.top() / 3 * 3 + 3);
                        break;
                    }
                    case 2: 
                    case 8: {
                        ball.xReflect();
                        ball.setI(ball.left() / 10 * 10 + 10, ball.top());
                    }
                }
                break;
            }
            case 5: {
                switch (by2) {
                    case 2: {
                        ball.yReflect();
                        ball.setI(ball.left(), ball.bottom() / 3 * 3 - 4);
                        break;
                    }
                    case 8: {
                        ball.yReflect();
                        ball.setI(ball.left(), ball.top() / 3 * 3 + 3);
                        break;
                    }
                    case 1: 
                    case 4: {
                        ball.xReflect();
                        ball.setI(ball.right() / 10 * 10 - 4, ball.top());
                    }
                }
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 14: {
                ball.xReflect();
                ball.yReflect();
                break;
            }
            case 1: {
                switch (by2) {
                    case 1: {
                        int n = ball.left() % 10;
                        int n2 = ball.top() % 3;
                        if (n >= n2) {
                            ball.xReflect();
                            ball.setI(ball.right() / 10 * 10 - 4, ball.top());
                            break block0;
                        }
                        ball.yReflect();
                        ball.setI(ball.left(), ball.bottom() / 3 * 3 - 4);
                        break block0;
                    }
                    case 2: {
                        ball.yReflect();
                        ball.setI(ball.left(), ball.bottom() / 3 * 3 - 4);
                        break block0;
                    }
                    case 4: {
                        ball.xReflect();
                        ball.setI(ball.right() / 10 * 10 - 4, ball.top());
                        break block0;
                    }
                }
                break;
            }
            case 2: {
                switch (by2) {
                    case 1: {
                        ball.yReflect();
                        ball.setI(ball.left(), ball.bottom() / 3 * 3 - 4);
                        break block0;
                    }
                    case 2: {
                        int n = ball.right() % 10;
                        int n3 = ball.top() % 3;
                        if (n >= n3) {
                            ball.xReflect();
                            ball.setI(ball.left() / 10 * 10 + 10, ball.top());
                            break block0;
                        }
                        ball.yReflect();
                        ball.setI(ball.left(), ball.bottom() / 3 * 3 - 4);
                        break block0;
                    }
                    case 8: {
                        ball.xReflect();
                        ball.setI(ball.left() / 10 * 10 + 10, ball.top());
                        break block0;
                    }
                }
                break;
            }
            case 4: {
                switch (by2) {
                    case 1: {
                        ball.xReflect();
                        ball.setI(ball.right() / 10 * 10 - 4, ball.top());
                        break block0;
                    }
                    case 4: {
                        int n = ball.left() % 10;
                        int n4 = ball.bottom() % 3;
                        if (n >= n4) {
                            ball.xReflect();
                            ball.setI(ball.right() / 10 * 10 - 4, ball.top());
                            break block0;
                        }
                        ball.yReflect();
                        ball.setI(ball.left(), ball.top() / 3 * 3 + 3);
                        break block0;
                    }
                    case 8: {
                        ball.yReflect();
                        ball.setI(ball.left(), ball.top() / 3 * 3 + 3);
                        break block0;
                    }
                }
                break;
            }
            case 8: {
                switch (by2) {
                    case 2: {
                        ball.xReflect();
                        ball.setI(ball.left() / 10 * 10 + 10, ball.top());
                        break block0;
                    }
                    case 4: {
                        ball.yReflect();
                        ball.setI(ball.left(), ball.top() / 3 * 3 + 3);
                        break block0;
                    }
                    case 8: {
                        int n = ball.right() % 10;
                        int n5 = ball.bottom() % 3;
                        if (n >= n5) {
                            ball.xReflect();
                            ball.setI(ball.left() / 10 * 10 + 10, ball.top());
                            break block0;
                        }
                        ball.yReflect();
                        ball.setI(ball.left(), ball.top() / 3 * 3 + 3);
                        break block0;
                    }
                }
            }
        }
    }

    private final void checkAnimal(Ball ball) {
        for (int i = 0; i < this.totalAnimals; ++i) {
            if (this.animals[i].times > 0 || !this.animals[i].isColliding(ball)) continue;
            if (this.bSound) {
                this.playMusic(9);
            }
            ball.turn90();
            if (this.animals[i].type > 4) {
                this.score = (short)(this.score + 20);
                this.canvas.newExplosion(this.animals[i].x, this.animals[i].y, 1);
            } else {
                this.score = (short)(this.score + 10);
                this.canvas.newExplosion(this.animals[i].x, this.animals[i].y, 0);
            }
            this.animals[i].times = 100;
            this.animals[i].x = this.animals[i].o_x;
            this.animals[i].y = this.animals[i].o_y;
            this.canvas.animal_sprs[i].setVisible(false);
            this.canvas.animal_sprs[i].setPosition(this.animals[i].o_x, this.animals[i].o_y);
        }
    }

    private final void manageAnimals() {
        for (int i = 0; i < this.totalAnimals; ++i) {
            if (this.animals[i].times > 0) {
                --this.animals[i].times;
                if (this.animals[i].times != 0) continue;
                this.canvas.animal_sprs[i].setVisible(true);
                continue;
            }
            this.canvas.animal_sprs[i].setFrame((this.canvas.animal_sprs[i].getFrame() + 1) % 2);
            this.moveAnimal(i);
            this.canvas.animal_sprs[i].setPosition(this.animals[i].x, this.animals[i].y);
        }
    }

    private final boolean checkAnimalDir(Animal animal, byte by) {
        int n = 0;
        int n2 = 0;
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        if ((by & 1) > 0) {
            n2 = animal.top() - animal.speed;
            bl &= n2 >= 0 && this.map.checkBrick((animal.left() + 2) / 10, n2 / 3) == 0 && this.map.checkBrick(animal.left() / 10, n2 / 3) == 0 && this.map.checkBrick(animal.right() / 10, n2 / 3) == 0;
            if (n2 >= 0) {
                bl3 = true;
            }
        }
        if ((by & 2) > 0) {
            n = animal.right() + animal.speed;
            bl &= n < 80 && this.map.checkBrick(n / 10, (animal.top() + 2) / 3) == 0 && this.map.checkBrick(n / 10, animal.top() / 3) == 0 && this.map.checkBrick(n / 10, animal.bottom() / 3) == 0;
            if (n < 80) {
                bl2 = true;
            }
        }
        if ((by & 4) > 0) {
            n2 = animal.bottom() + animal.speed;
            bl &= n2 < 65 - 10 && this.map.checkBrick((animal.left() + 2) / 10, n2 / 3) == 0 && this.map.checkBrick(animal.left() / 10, n2 / 3) == 0 && this.map.checkBrick(animal.right() / 10, n2 / 3) == 0;
            if (n2 < 65 - 10) {
                bl3 = true;
            }
        }
        if ((by & 8) > 0) {
            n = animal.left() - animal.speed;
            bl &= n >= 0 && this.map.checkBrick(n / 10, (animal.top() + 2) / 3) == 0 && this.map.checkBrick(n / 10, animal.top() / 3) == 0 && this.map.checkBrick(n / 10, animal.bottom() / 3) == 0;
            if (n >= 0) {
                bl2 = true;
            }
        }
        if (bl2 && bl3) {
            bl &= this.map.checkBrick(n / 10, n2 / 3) == 0 && this.map.checkBrick(n / 10, (n2 - 2) / 3) == 0;
        }
        return bl;
    }

    private final void moveAnimal(int n) {
        boolean bl = true;
        if (this.animals[n].len <= 0 || !this.checkAnimalDir(this.animals[n], DIRECTIONS[this.animals[n].dir])) {
            this.animals[n].dir = (byte)(((long)this.animals[n].dir + System.currentTimeMillis() % (long)4 * (long)2) % (long)8);
            for (int i = 8; i > 0 && !this.checkAnimalDir(this.animals[n], DIRECTIONS[this.animals[n].dir]); --i) {
                this.animals[n].dir = (byte)((this.animals[n].dir + this.animals[n].step) % 8);
            }
            if (this.animals[n].len <= 0) {
                this.animals[n].len = (byte)(System.currentTimeMillis() % (long)40);
            }
        }
        if ((DIRECTIONS[this.animals[n].dir] & 1) > 0) {
            this.animals[n].y -= this.animals[n].speed;
        }
        if ((DIRECTIONS[this.animals[n].dir] & 2) > 0) {
            this.animals[n].x += this.animals[n].speed;
        }
        if ((DIRECTIONS[this.animals[n].dir] & 4) > 0) {
            this.animals[n].y += this.animals[n].speed;
        }
        if ((DIRECTIONS[this.animals[n].dir] & 8) > 0) {
            this.animals[n].x -= this.animals[n].speed;
        }
        this.animals[n].len = (byte)(this.animals[n].len - 1);
    }

    private final void manageRacket() {
        Ball ball;
        int n;
        if (this.canvas.currentKeyState == 1) {
            switch (this.canvas.currentKey) {
                case 1: {
                    for (n = 0; n < 3; ++n) {
                        if (!this.canvas.ballSprArray[n].getVisible()) continue;
                        ball = this.ballArray[n];
                        if (!ball.onRacket || this.scroll) continue;
                        ball.onRacket = false;
                    }
                    if (this.missile.active || this.missile.ammo <= 0) break;
                    this.missile.active = true;
                    this.missile.launch();
                    break;
                }
                case 2: {
                    if (this.racket.left() - this.racket.dX > -8) {
                        this.racket.set(this.racket.left() - this.racket.dX, this.racket.top());
                        break;
                    }
                    this.racket.set(-8, this.racket.top());
                    break;
                }
                case 5: {
                    if (this.racket.right() + this.racket.dX < 80 + 8) {
                        this.racket.set(this.racket.left() + this.racket.dX, this.racket.top());
                        break;
                    }
                    this.racket.set(80 + 8 - this.racket.getWidth(), this.racket.top());
                }
            }
        }
        for (n = 0; n < 3; ++n) {
            if (!this.canvas.ballSprArray[n].getVisible()) continue;
            ball = this.ballArray[n];
            if (!ball.onRacket) continue;
            ball.setI(this.racket.left() + (this.racket.getWidth() - 4) / 2, this.racket.top() - 4);
        }
        if (!this.missile.active) {
            if (this.missile.ammo > 0) {
                this.missile.set(this.racket.X + (this.racket.getWidth() - 5) / 2, this.racket.Y - 8);
            } else if (this.show_missile) {
                this.show_missile = false;
                this.canvas.gfxManager.deleteObject(this.canvas.missile_spr);
            }
        }
    }

    private final void manageBonus() {
        int n;
        int n2;
        for (n2 = 7; n2 > -1; --n2) {
            if (!this.canvas.bonusSprArray[n2].getVisible()) continue;
            Bonus bonus = this.bonusArray[n2];
            bonus.move();
            if (bonus.isColliding(this.racket) && !this.scroll) {
                int n3 = this.currentPUp;
                this.removePowerUp();
                this.currentPUp = bonus.getType();
                switch (this.currentPUp) {
                    case 0: {
                        this.racket.setSize(2);
                        this.canvas.racket_spr.setFrame(2);
                        if (!this.bSound) break;
                        this.playMusic(6);
                        break;
                    }
                    case 1: {
                        this.racket.setSize(0);
                        this.canvas.racket_spr.setFrame(0);
                        if (!this.bSound) break;
                        this.playMusic(7);
                        break;
                    }
                    case 2: {
                        this.missile.reload();
                        if (!this.show_missile) {
                            this.missile.set(this.racket.X + (this.racket.getWidth() - 5) / 2, this.racket.Y - 8);
                            this.canvas.gfxManager.addObject(this.canvas.missile_spr);
                            this.show_missile = true;
                        }
                        if (!this.bSound) break;
                        this.playMusic(6);
                        break;
                    }
                    case 3: {
                        this.newBall();
                        if (!this.bSound) break;
                        this.playMusic(6);
                        break;
                    }
                    case 4: {
                        this.racket.magnetic = true;
                        this.canvas.racket_spr.setFrame(3);
                        if (!this.bSound) break;
                        this.playMusic(6);
                        break;
                    }
                    case 5: {
                        for (n = 0; n < 3; ++n) {
                            this.ballArray[n].setSpeed(FAST);
                        }
                        if (!this.bSound) break;
                        this.playMusic(7);
                        break;
                    }
                    case 6: {
                        for (n = 0; n < 3; ++n) {
                            this.ballArray[n].setSpeed(SLOW);
                        }
                        if (!this.bSound) break;
                        this.playMusic(6);
                    }
                }
                if (n3 != this.currentPUp) {
                    this.showText = 20;
                    this.canvas.puptext_spr.setFrame(this.currentPUp);
                    this.canvas.puptext_spr.setVisible(true);
                }
                this.canvas.removeBonus(n2);
                continue;
            }
            if (bonus.top() <= this.racket.bottom()) continue;
            this.canvas.removeBonus(n2);
        }
        if (this.missile.active) {
            this.missile.move();
            n2 = this.missile.X / 10;
            n = this.missile.Y / 3;
            byte by = this.map.getBrick(n2, n);
            if (by > 0 && !this.scroll) {
                this.map.removeBrick(n2, n);
                if (by == 4) {
                    this.score = (short)(this.score + 20);
                    this.canvas.newExplosion(n2 * 10, n * 3, 1);
                } else if (by < 4) {
                    this.score = (short)(this.score + 10);
                    this.canvas.newExplosion(n2 * 10, n * 3, 0);
                }
                this.canvas.eraseBrick(n2, n);
                if (by != 5) {
                    --this.leftBrick;
                }
                if (this.bSound) {
                    this.playMusic(8);
                }
            }
            if (this.missile.Y < 0) {
                this.missile.active = false;
            }
        }
    }

    public void nextLevel() {
        if (this.level != 29) {
            this.canvas.drawGreat();
            this.canvas.removeAll();
            this.level = (byte)(this.level + 1);
            if (this.bSound) {
                this.playMusic(3);
            }
            this.canvas.save();
            this.initLevel(this.level);
            this.canvas.draw_loading = 1;
        } else {
            if (this.bSound) {
                this.playMusic(2);
            }
            this.level = 0;
            this.canvas.switchToEndOfGame();
            this.canvas.draw_loading = 100;
        }
    }

    public void updateGame() {
        if (!this.scroll) {
            this.manageAnimals();
        }
        this.manageRacket();
        this.manageBall();
        this.manageBonus();
        this.canvas.manageSprite();
        if (this.scroll) {
            --this.mapOffset;
            if (this.mapOffset == 0) {
                this.canvas.levelB_spr[0].setVisible(false);
                this.canvas.levelB_spr[1].setVisible(false);
                for (int i = 0; i < 5; ++i) {
                    this.canvas.number_spr[i].setVisible(false);
                }
                this.scroll = false;
            }
        }
        if (this.leftBrick == 0 && !this.scroll && this.canvas.explosionNum <= 0) {
            this.canvas.switchToNextLevel();
        }
    }

    static {
        RACKET_START_X = 40;
        RACKET_START_Y = 62;
        SMALL_RACKET_WIDTH = 17;
        NORMAL_RACKET_WIDTH = 21;
        LARGE_RACKET_WIDTH = 25;
        RACKET_HEIGHT = 3;
        SMALL_RACKET_FRAME = 0;
        NORMAL_RACKET_FRAME = 1;
        LARGE_RACKET_FRAME = 2;
        MAGNET_RACKET_FRAME = 3;
        BONUS_DIAMETER = 8;
        BALL_DIAMETER = 4;
        BRICK_WIDTH = 10;
        BRICK_HEIGHT = 3;
        FAST = 181072;
        NORMAL = 156072;
        SLOW = 131072;
        NB_NUMBER = 5;
        NB_LIFE = 2;
        MAX_BALL = 3;
        sound = null;
    }
}

