/*
 * Decompiled with CFR 0.152.
 */
package BlockBreaker;

import BlockBreaker.CollisionRect;
import BlockBreaker.Game;

class Ball
extends CollisionRect {
    public boolean onRacket = true;
    public int speed = Game.NORMAL;
    protected int fX = 0;
    protected int fY = 0;
    protected int fDX = 0;
    protected int fDY = 0;

    public Ball() {
    }

    public Ball(int n, int n2) {
        this.setI(n, n2);
        this.onRacket = true;
        this.init();
    }

    public final void init() {
        this.fDX = this.speed;
        this.fDY = -this.speed;
    }

    public final void setSpeed(int n) {
        if (this.speed != n) {
            int n2 = this.speed;
            byte by = this.getDirection();
            this.fDX = this.fDX < 0 ? -this.fDX : this.fDX;
            this.fDY = this.fDY < 0 ? -this.fDY : this.fDY;
            this.speed = n;
            this.fDX = this.fDX - n2 + this.speed;
            this.fDY = this.fDY - n2 + this.speed;
            switch (by) {
                case 2: {
                    this.fDX = -this.fDX;
                    break;
                }
                case 8: {
                    this.fDX = -this.fDX;
                    this.fDY = -this.fDY;
                    break;
                }
                case 4: {
                    this.fDY = -this.fDY;
                }
            }
        }
    }

    public final void setI(int n, int n2) {
        this.fX = n << 16;
        this.fY = n2 << 16;
    }

    public final byte getDirection() {
        if (this.fDX > 0) {
            if (this.fDY > 0) {
                return 1;
            }
            return 4;
        }
        if (this.fDY > 0) {
            return 2;
        }
        return 8;
    }

    public final void move() {
        this.fX += this.fDX;
        this.fY += this.fDY;
    }

    public final void setVelocityF(int n, int n2) {
        this.fDX = n;
        this.fDY = n2;
    }

    public final void xReflect() {
        this.fDX = -this.fDX;
    }

    public final void yReflect() {
        this.fDY = -this.fDY;
    }

    public final int left() {
        return this.fX >> 16;
    }

    public final int right() {
        return (this.fX >> 16) + 4 - 1;
    }

    public final int top() {
        return this.fY >> 16;
    }

    public final int bottom() {
        return (this.fY >> 16) + 4 - 1;
    }
}

