/*
 * Decompiled with CFR 0.152.
 */
package BlockBreaker;

import BlockBreaker.Ball;
import BlockBreaker.Bonus;
import BlockBreaker.GameCanvas;
import BlockBreaker.Map;
import BlockBreaker.Missile;
import BlockBreaker.PowerUp;
import BlockBreaker.Racket;
import BlockBreaker.Sound;
import com.siemens.mp.game.GraphicObject;
import com.siemens.mp.game.Vibrator;
import java.util.Vector;

class Game {
    public static final int RACKET_START_X = 40;
    public static final int RACKET_START_Y = 68;
    public static final int SMALL_RACKET_WIDTH = 17;
    public static final int NORMAL_RACKET_WIDTH = 21;
    public static final int LARGE_RACKET_WIDTH = 25;
    public static final int RACKET_HEIGHT = 4;
    public static final int SMALL_RACKET_FRAME = 0;
    public static final int NORMAL_RACKET_FRAME = 1;
    public static final int LARGE_RACKET_FRAME = 2;
    public static final int MAGNET_RACKET_FRAME = 3;
    public static final int BONUS_DIAMETER = 8;
    public static final int BALL_DIAMETER = 4;
    public static final int BRICK_WIDTH = 10;
    public static final int BRICK_HEIGHT = 4;
    public static int FAST;
    public static int NORMAL;
    public static int SLOW;
    public static int MAX_SPEED;
    public static final int NB_NUMBER = 5;
    public static final int NB_LIFE = 2;
    public static final int MAX_BALL = 3;
    public Sound sound;
    private int gamme = 0;
    private int last_hit = 0;
    Vibrator shake;
    public Racket racket;
    public Map map;
    public PowerUp pUp;
    public Missile missile;
    public Vector bonusManager;
    public Vector ballManager;
    public boolean show_missile = false;
    public boolean scroll = false;
    public boolean bSound = true;
    public boolean bVibration = true;
    public byte level = 0;
    public short score = 0;
    public int leftBrick = 0;
    public int life = 2;
    public int currentPUp = -1;
    public int showText = 0;
    public int mapOffset = 0;
    private GameCanvas canvas;

    public Game(GameCanvas gameCanvas) {
        this.canvas = gameCanvas;
        this.sound = new Sound();
        this.map = new Map();
        this.pUp = new PowerUp();
        this.bonusManager = new Vector();
        this.ballManager = new Vector();
        this.missile = new Missile();
        this.racket = new Racket();
        ++gameCanvas.draw_loading;
        this.map.loadMap(this.canvas.ReadByteArray("map.bin", 1200, 0));
        ++gameCanvas.draw_loading;
        this.pUp.loadPUp(this.canvas.ReadByteArray("pUp.bin", 1050, 0));
        ++gameCanvas.draw_loading;
    }

    public final void initGame() {
        this.level = 0;
        this.score = 0;
        this.initLevel(this.level);
    }

    public final void initLevel(int n) {
        this.removePowerUp();
        this.initBall();
        this.racket.init();
        this.map.setLevel(n);
        this.canvas.loadWall(n);
        this.pUp.setLevel(n);
        this.canvas.level_spr[0].setFrame((n + 1) / 10);
        this.canvas.level_spr[1].setFrame((n + 1) % 10);
        this.canvas.levelB_spr[0].setFrame((n + 1) / 10);
        this.canvas.levelB_spr[1].setFrame((n + 1) % 10);
        this.canvas.initLife();
        this.scroll = true;
        this.mapOffset = 72;
    }

    private final void initBall() {
        for (int i = this.ballManager.size() - 1; i > -1; --i) {
            this.ballManager.removeElementAt(i);
            this.canvas.removeBall(i);
        }
        this.newBall();
    }

    private final void newBall() {
        if (this.ballManager.size() < 3) {
            this.ballManager.addElement(new Ball(this.racket.left(), this.racket.top() - 5));
            this.canvas.addBall();
        }
    }

    private final void removePowerUp() {
        switch (this.currentPUp) {
            case 0: 
            case 1: {
                this.racket.setSize(1);
                this.canvas.racket_spr.setFrame(1);
                break;
            }
            case 2: {
                this.missile.unload();
                break;
            }
            case 4: {
                this.racket.magnetic = false;
                this.canvas.racket_spr.setFrame(1);
                break;
            }
            case 5: 
            case 6: {
                for (int i = 0; i < this.ballManager.size(); ++i) {
                    ((Ball)this.ballManager.elementAt(i)).setSpeed(NORMAL);
                }
                break;
            }
        }
        this.currentPUp = -1;
    }

    private final void removeBall(int n) {
        this.ballManager.removeElementAt(n);
        this.canvas.removeBall(n);
        if (this.bVibration) {
            Vibrator.triggerVibrator((int)1);
        }
        if (this.ballManager.size() == 0) {
            switch (this.life) {
                case 2: {
                    this.canvas.gfxManager.deleteObject((GraphicObject)this.canvas.life_spr[0]);
                    break;
                }
                case 1: {
                    this.canvas.gfxManager.deleteObject((GraphicObject)this.canvas.life_spr[1]);
                    break;
                }
                case 0: {
                    this.canvas.switchToGameOver();
                    if (this.bVibration) {
                        Vibrator.triggerVibrator((int)4000);
                    }
                    if (this.bSound) {
                        this.sound.gameover_mel.play();
                    }
                    return;
                }
            }
            --this.life;
            if (this.bSound) {
                this.sound.lost_mel.play();
            }
            this.removePowerUp();
            this.newBall();
        }
    }

    private final void manageBall() {
        for (int i = this.ballManager.size() - 1; i > -1; --i) {
            Ball ball = (Ball)this.ballManager.elementAt(i);
            if (ball.onRacket) continue;
            ball.move();
            if (ball.top() > this.racket.bottom()) {
                this.removeBall(i);
                continue;
            }
            if (ball.left() < 0) {
                ball.xReflect();
                ball.setVelocityF(ball.fDX, ball.fDY + 400);
                ball.setI(0, ball.top());
            }
            if (ball.right() > 79) {
                ball.xReflect();
                ball.setVelocityF(ball.fDX, ball.fDY + 400);
                ball.setI(76, ball.top());
            }
            if (ball.top() < 0) {
                ball.yReflect();
                ball.setVelocityF(ball.fDX, ball.fDY + 400);
                ball.setI(ball.left(), 0);
            }
            this.checkRacket(ball);
            this.checkBrick(ball);
        }
    }

    private final void checkRacket(Ball ball) {
        if (ball.isColliding(this.racket)) {
            if (ball.left() - this.racket.left() < 2) {
                ball.setVelocityF(-(ball.speed + 65536), -(ball.speed - 65536));
            } else if (ball.left() - this.racket.left() < 4) {
                ball.setVelocityF(-ball.speed, -ball.speed);
            } else if (ball.left() - this.racket.left() < 6) {
                ball.setVelocityF(-(ball.speed - 65536), -(ball.speed + 65536));
            } else if (ball.left() - this.racket.left() > this.racket.getWidth() - 3) {
                ball.setVelocityF(ball.speed + 65536, -(ball.speed - 65536));
            } else if (ball.left() - this.racket.left() > this.racket.getWidth() - 5) {
                ball.setVelocityF(ball.speed, -ball.speed);
            } else if (ball.left() - this.racket.left() > this.racket.getWidth() - 7) {
                ball.setVelocityF(ball.speed - 65536, -(ball.speed + 65536));
            } else if (ball.getDirection() < 4) {
                ball.yReflect();
            }
            ball.setI(ball.left(), this.racket.top() - 4);
            if (this.racket.magnetic) {
                ball.onRacket = true;
            }
            if (this.bSound) {
                this.sound.racket_mel.play();
            }
        }
    }

    private final void checkBrick(Ball ball) {
        byte by = 0;
        byte[] byArray = new byte[]{0, 0, 0, 0};
        int[] nArray = new int[]{0, 0, 0, 0};
        int[] nArray2 = new int[]{0, 0, 0, 0};
        nArray[0] = ball.left() / 10;
        nArray2[0] = ball.top() / 4;
        by = (byte)(this.map.checkBrick(nArray[0], nArray2[0]) << 3);
        byArray[0] = this.map.getBrick(nArray[0], nArray2[0]);
        nArray[1] = ball.right() / 10;
        nArray2[1] = ball.top() / 4;
        by = (byte)(by | (byte)(this.map.checkBrick(nArray[1], nArray2[1]) << 2));
        byArray[1] = this.map.getBrick(nArray[1], nArray2[1]);
        nArray[2] = ball.left() / 10;
        nArray2[2] = ball.bottom() / 4;
        by = (byte)(by | (byte)(this.map.checkBrick(nArray[2], nArray2[2]) << 1));
        byArray[2] = this.map.getBrick(nArray[2], nArray2[2]);
        nArray[3] = ball.right() / 10;
        nArray2[3] = ball.bottom() / 4;
        by = (byte)(by | this.map.checkBrick(nArray[3], nArray2[3]));
        byArray[3] = this.map.getBrick(nArray[3], nArray2[3]);
        if (by == 0) {
            return;
        }
        if (by == 15) {
            switch (ball.getDirection()) {
                case 1: {
                    ball.setI(ball.left() - 1, ball.top() - 1);
                    break;
                }
                case 2: {
                    ball.setI(ball.left() + 1, ball.top() - 1);
                    break;
                }
                case 4: {
                    ball.setI(ball.left() - 1, ball.top() + 1);
                    break;
                }
                case 8: {
                    ball.setI(ball.left() + 1, ball.top() + 1);
                }
            }
            this.checkBrick(ball);
            return;
        }
        this.canvas.gameScreen.setPixels(this.canvas.wall_pix, 8, 8, 80, 72);
        if (byArray[0] > 0) {
            this.HitBrick(ball, byArray[0], nArray[0], nArray2[0]);
        }
        if (byArray[1] > 0 && (nArray[0] != nArray[1] || nArray2[0] != nArray2[1])) {
            this.HitBrick(ball, byArray[1], nArray[1], nArray2[1]);
        }
        if (byArray[2] > 0 && (nArray[0] != nArray[2] || nArray2[0] != nArray2[2])) {
            this.HitBrick(ball, byArray[2], nArray[2], nArray2[2]);
        }
        if (!(byArray[3] <= 0 || nArray[1] == nArray[3] && nArray2[1] == nArray2[3] || nArray[2] == nArray[3] && nArray2[2] == nArray2[3])) {
            this.HitBrick(ball, byArray[3], nArray[3], nArray2[3]);
        }
        this.canvas.gameScreen.getPixelBytes(this.canvas.wall_pix, 8, 8, 80, 72);
        this.getBallAction(ball, by);
    }

    private void HitBrick(Ball ball, byte by, int n, int n2) {
        int n3 = 0;
        if (this.map.hitBrick(n, n2)) {
            n3 = this.pUp.getRandomPowerup(by);
            if (n3 != -1) {
                this.createNewBonus(ball.left(), ball.top(), n3);
            }
            if (by == 4) {
                this.score = (short)(this.score + 20);
                this.canvas.newExplosion(n * 10, n2 * 4, 1);
            } else {
                this.score = (short)(this.score + 10);
                this.canvas.newExplosion(n * 10, n2 * 4, 0);
            }
            this.canvas.eraseBrick(n, n2);
            --this.leftBrick;
            if (this.bSound) {
                if (this.last_hit > 25) {
                    this.gamme = 0;
                } else if (this.gamme < 4) {
                    ++this.gamme;
                }
                this.sound.destroy_mel.play();
                this.last_hit = 0;
            }
        } else if (this.bSound) {
            this.sound.hit_mel.play();
        }
    }

    private final void createNewBonus(int n, int n2, int n3) {
        this.bonusManager.addElement(new Bonus(n, n2));
        ((Bonus)this.bonusManager.lastElement()).setType(n3);
        this.canvas.addBonus(n3);
    }

    private final void getBallAction(Ball ball, byte by) {
        byte by2 = 0;
        by2 = ball.getDirection();
        block0 : switch (by) {
            case 12: {
                switch (by2) {
                    case 1: {
                        ball.xReflect();
                        ball.setI(ball.right() / 10 * 10 - 4, ball.top());
                        break;
                    }
                    case 2: {
                        ball.xReflect();
                        ball.setI(ball.left() / 10 * 10 + 10, ball.top());
                        break;
                    }
                    case 4: 
                    case 8: {
                        ball.yReflect();
                        ball.setI(ball.left(), ball.top() / 4 * 4 + 4);
                    }
                }
                break;
            }
            case 3: {
                switch (by2) {
                    case 4: {
                        ball.xReflect();
                        ball.setI(ball.right() / 10 * 10 - 4, ball.top());
                        break;
                    }
                    case 8: {
                        ball.xReflect();
                        ball.setI(ball.left() / 10 * 10 + 10, ball.top());
                        break;
                    }
                    case 1: 
                    case 2: {
                        ball.yReflect();
                        ball.setI(ball.left(), ball.bottom() / 4 * 4 - 4);
                    }
                }
                break;
            }
            case 10: {
                switch (by2) {
                    case 1: {
                        ball.yReflect();
                        ball.setI(ball.left(), ball.bottom() / 4 * 4 - 4);
                        break;
                    }
                    case 4: {
                        ball.yReflect();
                        ball.setI(ball.left(), ball.top() / 4 * 4 + 4);
                        break;
                    }
                    case 2: 
                    case 8: {
                        ball.xReflect();
                        ball.setI(ball.left() / 10 * 10 + 10, ball.top());
                    }
                }
                break;
            }
            case 5: {
                switch (by2) {
                    case 2: {
                        ball.yReflect();
                        ball.setI(ball.left(), ball.bottom() / 4 * 4 - 4);
                        break;
                    }
                    case 8: {
                        ball.yReflect();
                        ball.setI(ball.left(), ball.top() / 4 * 4 + 4);
                        break;
                    }
                    case 1: 
                    case 4: {
                        ball.xReflect();
                        ball.setI(ball.right() / 10 * 10 - 4, ball.top());
                    }
                }
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 14: {
                ball.xReflect();
                ball.yReflect();
                break;
            }
            case 1: {
                switch (by2) {
                    case 1: {
                        int n = ball.left() % 10;
                        int n2 = ball.top() % 4;
                        if (n >= n2) {
                            ball.xReflect();
                            ball.setI(ball.right() / 10 * 10 - 4, ball.top());
                            break;
                        }
                        ball.yReflect();
                        ball.setI(ball.left(), ball.bottom() / 4 * 4 - 4);
                        break;
                    }
                    case 2: {
                        ball.yReflect();
                        ball.setI(ball.left(), ball.bottom() / 4 * 4 - 4);
                        break;
                    }
                    case 4: {
                        ball.xReflect();
                        ball.setI(ball.right() / 10 * 10 - 4, ball.top());
                        break;
                    }
                    case 8: {
                        System.out.println("Exception: collision!\n");
                    }
                }
                break;
            }
            case 2: {
                switch (by2) {
                    case 1: {
                        ball.yReflect();
                        ball.setI(ball.left(), ball.bottom() / 4 * 4 - 4);
                        break;
                    }
                    case 2: {
                        int n = ball.right() % 10;
                        int n3 = ball.top() % 4;
                        if (n >= n3) {
                            ball.xReflect();
                            ball.setI(ball.left() / 10 * 10 + 10, ball.top());
                            break;
                        }
                        ball.yReflect();
                        ball.setI(ball.left(), ball.bottom() / 4 * 4 - 4);
                        break;
                    }
                    case 8: {
                        ball.xReflect();
                        ball.setI(ball.left() / 10 * 10 + 10, ball.top());
                        break;
                    }
                    case 4: {
                        System.out.println("Exception: collision!\n");
                    }
                }
                break;
            }
            case 4: {
                switch (by2) {
                    case 1: {
                        ball.xReflect();
                        ball.setI(ball.right() / 10 * 10 - 4, ball.top());
                        break;
                    }
                    case 4: {
                        int n = ball.left() % 10;
                        int n4 = ball.bottom() % 4;
                        if (n >= n4) {
                            ball.xReflect();
                            ball.setI(ball.right() / 10 * 10 - 4, ball.top());
                            break;
                        }
                        ball.yReflect();
                        ball.setI(ball.left(), ball.top() / 4 * 4 + 4);
                        break;
                    }
                    case 8: {
                        ball.yReflect();
                        ball.setI(ball.left(), ball.top() / 4 * 4 + 4);
                        break;
                    }
                    case 2: {
                        System.out.println("Exception: collision!\n");
                    }
                }
                break;
            }
            case 8: {
                switch (by2) {
                    case 2: {
                        ball.xReflect();
                        ball.setI(ball.left() / 10 * 10 + 10, ball.top());
                        break block0;
                    }
                    case 4: {
                        ball.yReflect();
                        ball.setI(ball.left(), ball.top() / 4 * 4 + 4);
                        break block0;
                    }
                    case 8: {
                        int n = ball.right() % 10;
                        int n5 = ball.bottom() % 4;
                        if (n >= n5) {
                            ball.xReflect();
                            ball.setI(ball.left() / 10 * 10 + 10, ball.top());
                            break block0;
                        }
                        ball.yReflect();
                        ball.setI(ball.left(), ball.top() / 4 * 4 + 4);
                        break block0;
                    }
                    case 1: {
                        System.out.println("Exception: collision!\n");
                    }
                }
            }
        }
    }

    private final void manageRacket() {
        Ball ball;
        int n;
        if (this.canvas.currentKeyState == 1) {
            switch (this.canvas.currentKey) {
                case 1: {
                    for (n = 0; n < this.ballManager.size(); ++n) {
                        ball = (Ball)this.ballManager.elementAt(n);
                        if (!ball.onRacket || this.scroll) continue;
                        ball.onRacket = false;
                    }
                    if (this.missile.active || this.missile.ammo <= 0) break;
                    this.missile.active = true;
                    this.missile.launch();
                    break;
                }
                case 2: {
                    if (this.racket.left() + this.racket.getWidth() / 2 > this.racket.dX) {
                        this.racket.set(this.racket.left() - this.racket.dX, this.racket.top());
                        break;
                    }
                    this.racket.set(-this.racket.getWidth() / 2, this.racket.top());
                    break;
                }
                case 5: {
                    if (this.racket.right() - this.racket.getWidth() / 2 < 80 - this.racket.dX) {
                        this.racket.set(this.racket.left() + this.racket.dX, this.racket.top());
                        break;
                    }
                    this.racket.set(80 - this.racket.getWidth() / 2, this.racket.top());
                }
            }
        }
        for (n = 0; n < this.ballManager.size(); ++n) {
            ball = (Ball)this.ballManager.elementAt(n);
            if (!ball.onRacket) continue;
            ball.setI(this.racket.left() + (this.racket.getWidth() - 4) / 2, this.racket.top() - 4);
        }
        if (!this.missile.active) {
            if (this.missile.ammo > 0) {
                this.missile.set(this.racket.X + (this.racket.getWidth() - 5) / 2, this.racket.Y - 8);
            } else if (this.show_missile) {
                this.show_missile = false;
                this.canvas.gfxManager.deleteObject((GraphicObject)this.canvas.missile_spr);
            }
        }
    }

    private final void manageBonus() {
        int n;
        int n2;
        for (n2 = this.bonusManager.size() - 1; n2 > -1; --n2) {
            Bonus bonus = (Bonus)this.bonusManager.elementAt(n2);
            bonus.move();
            if (bonus.isColliding(this.racket) && !this.scroll) {
                if (this.bVibration) {
                    Vibrator.triggerVibrator((int)1);
                }
                int n3 = this.currentPUp;
                this.removePowerUp();
                this.currentPUp = bonus.getType();
                switch (this.currentPUp) {
                    case 0: {
                        this.racket.setSize(2);
                        this.canvas.racket_spr.setFrame(2);
                        if (!this.bSound) break;
                        this.sound.bonus_mel.play();
                        break;
                    }
                    case 1: {
                        this.racket.setSize(0);
                        this.canvas.racket_spr.setFrame(0);
                        if (!this.bSound) break;
                        this.sound.malus_mel.play();
                        break;
                    }
                    case 2: {
                        this.missile.reload();
                        if (!this.show_missile) {
                            this.missile.set(this.racket.X + (this.racket.getWidth() - 5) / 2, this.racket.Y - 8);
                            this.canvas.gfxManager.addObject((GraphicObject)this.canvas.missile_spr);
                            this.show_missile = true;
                        }
                        if (!this.bSound) break;
                        this.sound.bonus_mel.play();
                        break;
                    }
                    case 3: {
                        this.newBall();
                        if (!this.bSound) break;
                        this.sound.bonus_mel.play();
                        break;
                    }
                    case 4: {
                        this.racket.magnetic = true;
                        this.canvas.racket_spr.setFrame(3);
                        if (!this.bSound) break;
                        this.sound.bonus_mel.play();
                        break;
                    }
                    case 5: {
                        for (n = 0; n < this.ballManager.size(); ++n) {
                            ((Ball)this.ballManager.elementAt(n)).setSpeed(FAST);
                        }
                        if (!this.bSound) break;
                        this.sound.malus_mel.play();
                        break;
                    }
                    case 6: {
                        for (n = 0; n < this.ballManager.size(); ++n) {
                            ((Ball)this.ballManager.elementAt(n)).setSpeed(SLOW);
                        }
                        if (!this.bSound) break;
                        this.sound.bonus_mel.play();
                    }
                }
                if (n3 != this.currentPUp) {
                    this.showText = 20;
                    this.canvas.puptext_spr.setFrame(this.currentPUp);
                    this.canvas.puptext_spr.setVisible(true);
                }
                this.bonusManager.removeElementAt(n2);
                this.canvas.removeBonus(n2);
                continue;
            }
            if (bonus.top() <= this.racket.bottom() && this.leftBrick != 0) continue;
            this.bonusManager.removeElementAt(n2);
            this.canvas.removeBonus(n2);
        }
        if (this.missile.active) {
            this.missile.move();
            n2 = this.missile.X / 10;
            n = this.missile.Y / 4;
            byte by = this.map.getBrick(n2, n);
            if (by > 0 && !this.scroll) {
                this.map.removeBrick(n2, n);
                if (by == 4) {
                    this.score = (short)(this.score + 20);
                    this.canvas.newExplosion(n2 * 10, n * 4, 1);
                } else if (by < 4) {
                    this.score = (short)(this.score + 10);
                    this.canvas.newExplosion(n2 * 10, n * 4, 0);
                }
                this.canvas.gameScreen.setPixels(this.canvas.wall_pix, 8, 8, 80, 72);
                this.canvas.eraseBrick(n2, n);
                this.canvas.gameScreen.getPixelBytes(this.canvas.wall_pix, 8, 8, 80, 72);
                if (by != 5) {
                    --this.leftBrick;
                }
                if (this.bSound) {
                    this.sound.destroy_mel.play();
                }
            }
            if (this.missile.Y < 0) {
                this.missile.active = false;
            }
        }
    }

    public void nextLevel() {
        if (this.level != 29) {
            this.canvas.drawGreat();
            this.level = (byte)(this.level + 1);
            if (this.bSound) {
                this.sound.nextLevel_mel.play();
            }
            this.canvas.save();
            this.initLevel(this.level);
        } else {
            if (this.bSound) {
                this.sound.end_mel.play();
            }
            this.canvas.switchToEndOfGame();
        }
    }

    public void updateGame() {
        ++this.last_hit;
        this.manageRacket();
        this.manageBall();
        this.manageBonus();
        this.canvas.manageSprite();
        if (this.scroll) {
            --this.mapOffset;
            if (this.mapOffset == 0) {
                this.canvas.levelB_spr[0].setVisible(false);
                this.canvas.levelB_spr[1].setVisible(false);
                this.scroll = false;
            }
        }
        if (this.leftBrick == 0 && this.canvas.explosionSprManager.size() == 0) {
            this.nextLevel();
        }
    }

    static {
        RACKET_START_X = 40;
        RACKET_START_Y = 68;
        SMALL_RACKET_WIDTH = 17;
        NORMAL_RACKET_WIDTH = 21;
        LARGE_RACKET_WIDTH = 25;
        RACKET_HEIGHT = 4;
        SMALL_RACKET_FRAME = 0;
        NORMAL_RACKET_FRAME = 1;
        LARGE_RACKET_FRAME = 2;
        MAGNET_RACKET_FRAME = 3;
        BONUS_DIAMETER = 8;
        BALL_DIAMETER = 4;
        BRICK_WIDTH = 10;
        BRICK_HEIGHT = 4;
        FAST = 196608;
        NORMAL = 161072;
        SLOW = 131072;
        MAX_SPEED = 262144;
        NB_NUMBER = 5;
        NB_LIFE = 2;
        MAX_BALL = 3;
    }
}

