/*
 * Decompiled with CFR 0.152.
 */
package BlockBreaker;

import BlockBreaker.Ball;
import BlockBreaker.BlockBreaker;
import BlockBreaker.Bonus;
import BlockBreaker.Game;
import BlockBreaker.MyScreen;
import com.siemens.mp.game.ExtendedImage;
import com.siemens.mp.game.GraphicObject;
import com.siemens.mp.game.GraphicObjectManager;
import com.siemens.mp.game.Sprite;
import java.util.Vector;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class GameCanvas
extends MyScreen {
    Graphics graphic = null;
    private static final Command[] COMMANDS = new Command[]{new Command("Resume", 3, 1), new Command("New Game", 3, 2), new Command("Continue Game", 3, 3), new Command("Sound On/Off", 3, 4), new Command("Vibration On/Off", 3, 5), new Command("Help", 3, 6), new Command("High Scores", 3, 7), new Command("Menu", 3, 8), new Command("Exit", 6, 9)};
    public static final int LOAD = 0;
    public static final int MENU = 1;
    public static final int GAME = 2;
    public static final int NEW_HIGH_SCORE = 3;
    public static final int GAME_OVER = 4;
    public static final int HIGH_SCORE = 5;
    public static final int END_OF_GAME = 6;
    public static final int HELP = 7;
    public static final int LOADSCREEN = 8;
    public static final int GAME_AREA_WIDTH = 80;
    public static final int GAME_AREA_HEIGHT = 72;
    public static final int GAME_AREA_POSX = 8;
    public static final int GAME_AREA_POSY = 8;
    public static final int LEVEL_HEADER_POSX = 32;
    public static final int LIFE_HEADER_POSX = 46;
    public static final int SCORE_HEADER_POSX = 62;
    public static final int HEADER_POSY = 1;
    public static final int GAME_SCREEN_WIDTH = 96;
    public static final int GAME_SCREEN_HEIGHT = 80;
    public static final int PRESSED = 1;
    public static final int RELEASED = 0;
    public String freeMem = null;
    public final String[] misc_str = new String[]{"Loading", "Press Select", "New High Score", "High Score", "Level"};
    public Image gameScreenImage = null;
    public ExtendedImage gameScreen = null;
    public GraphicObjectManager gfxManager = null;
    public GraphicObjectManager gfxTempManager = null;
    private byte[] loadingsprite_pix = null;
    private byte[] splash_pix = null;
    private byte[] menu_pix = null;
    private byte[] arrow_pix = null;
    private byte[] header_pix = null;
    private byte[] background_pix = null;
    private byte[] puptext_pix = null;
    private byte[] gameOver_pix = null;
    private byte[] help_pix = null;
    private byte[] end_pix = null;
    public byte[] wall_pix = null;
    private byte[] brick_pix = null;
    private byte[] brick_mask = null;
    private byte[] racket_pix = null;
    private byte[] empty = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
    private byte[] hide_level = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private byte[] ball_pix = null;
    private byte[] bonus_pix = null;
    private byte[] missile_pix = null;
    private byte[] number_pix = null;
    private byte[] numberB_pix = null;
    private byte[] life_pix = null;
    private byte[] explosion_pix = null;
    private byte[] score_pix = null;
    private byte[] score_mask = null;
    public Sprite racket_spr = null;
    public Sprite missile_spr = null;
    public Sprite puptext_spr = null;
    public Sprite empty_spr = null;
    public Sprite[] number_spr = null;
    public Sprite[] levelB_spr = null;
    public Sprite[] life_spr = null;
    public Sprite[] level_spr = null;
    public Vector bonusSprManager = null;
    public Vector ballSprManager = null;
    public Vector explosionSprManager = null;
    public Vector scoreSprManager = null;
    private BlockBreaker appz = null;
    public int currentKey;
    public int currentKeyState = 0;
    public int state;
    public int last_state;
    public int screenToLoad = -1;
    private Game game = null;
    private boolean show_high = false;
    private boolean saving = false;
    private byte index_char = 0;
    private int index_name = 0;
    private int index_highScore = 3;
    private byte[] highscore = new byte[]{65, 65, 65, 0, 0};
    private byte[] highscores;
    public boolean paused = true;
    public int draw_loading = 0;
    private int gameover_step = 0;
    private int loading_frm = 0;
    private int menu_frm = 0;
    private boolean menu_anim = false;
    private int help_height = 0;

    public GameCanvas(BlockBreaker blockBreaker) {
        this.appz = blockBreaker;
        this.gameScreenImage = Image.createImage((int)96, (int)80);
        this.gameScreen = new ExtendedImage(this.gameScreenImage);
        this.gameScreen.clear((byte)0);
        this.loadingsprite_pix = this.ReadByteArray("loadingsprite.bin", 70, 0);
        this.splash_pix = this.ReadByteArray("splash.bin", 960, 0);
        this.state = 0;
    }

    public void loadRez() {
        try {
            int n;
            ++this.draw_loading;
            this.game = new Game(this);
            this.gfxManager = new GraphicObjectManager();
            this.gfxTempManager = new GraphicObjectManager();
            this.loadPixMap();
            this.empty_spr = new Sprite(this.empty, 0, 16, 4, this.brick_mask, 0, 1);
            this.puptext_spr = new Sprite(this.puptext_pix, 0, 64, 11, this.puptext_pix, 0, 7);
            this.puptext_spr.setPosition(12, 47);
            this.puptext_spr.setVisible(false);
            this.gfxManager.addObject((GraphicObject)this.puptext_spr);
            this.number_spr = new Sprite[5];
            for (n = 0; n < 5; ++n) {
                this.number_spr[n] = new Sprite(this.number_pix, 0, 8, 5, this.number_pix, 0, 10);
                this.number_spr[n].setPosition(54 + n * 4, -7);
                this.number_spr[n].setFrame(0);
                this.gfxManager.addObject((GraphicObject)this.number_spr[n]);
            }
            this.level_spr = new Sprite[2];
            for (n = 0; n < 2; ++n) {
                this.level_spr[n] = new Sprite(this.number_pix, 0, 8, 5, this.number_pix, 0, 10);
                this.level_spr[n].setPosition(24 + n * 4, -7);
                this.level_spr[n].setFrame(0);
                this.gfxManager.addObject((GraphicObject)this.level_spr[n]);
            }
            this.levelB_spr = new Sprite[2];
            for (n = 0; n < 2; ++n) {
                this.levelB_spr[n] = new Sprite(this.numberB_pix, 0, 8, 14, null, 0, 10);
                this.levelB_spr[n].setPosition(49 + n * 6, 46);
                this.levelB_spr[n].setFrame(0);
                this.levelB_spr[n].setVisible(false);
                this.gfxManager.addObject((GraphicObject)this.levelB_spr[n]);
            }
            this.life_spr = new Sprite[2];
            for (n = 0; n < 2; ++n) {
                this.life_spr[n] = new Sprite(this.ball_pix, 0, 8, 4, this.ball_pix, 0, 1);
                this.life_spr[n].setPosition(38 + n * 5, -6);
                this.life_spr[n].setFrame(0);
                this.gfxManager.addObject((GraphicObject)this.life_spr[n]);
            }
            this.missile_spr = new Sprite(this.missile_pix, 0, 8, 8, this.missile_pix, 0, 1);
            this.racket_spr = new Sprite(this.racket_pix, 0, 32, 4, this.racket_pix, 0, 4);
            this.racket_spr.setFrame(1);
            this.racket_spr.setPosition(40, 68);
            this.gfxManager.addObject((GraphicObject)this.racket_spr);
            this.bonusSprManager = new Vector();
            this.ballSprManager = new Vector();
            this.explosionSprManager = new Vector();
            this.scoreSprManager = new Vector();
        }
        catch (Exception exception) {
            System.out.println("Exception: ".concat(String.valueOf(String.valueOf(exception))));
        }
        this.game.sound.intro_mel.play();
        this.switchToMenu();
        System.gc();
    }

    public void loadPixMap() {
        this.header_pix = this.ReadByteArray("header.bin", 96, 0);
        this.background_pix = this.ReadByteArray("background.bin", 864, 0);
        this.puptext_pix = this.ReadByteArray("puptext.bin", 616, 0);
        ++this.draw_loading;
        this.arrow_pix = this.ReadByteArray("arrow.bin", 4, 0);
        this.menu_pix = this.ReadByteArray("menusprite.bin", 24, 0);
        this.wall_pix = new byte[720];
        this.brick_pix = this.ReadByteArray("bricks.bin", 40, 0);
        this.brick_mask = this.ReadByteArray("brick.bin", 8, 0);
        this.bonus_pix = this.ReadByteArray("bonus.bin", 56, 0);
        this.number_pix = this.ReadByteArray("number.bin", 50, 0);
        ++this.draw_loading;
        this.numberB_pix = this.ReadByteArray("numberB.bin", 140, 0);
        this.ball_pix = this.ReadByteArray("ball.bin", 4, 0);
        this.missile_pix = this.ReadByteArray("missile.bin", 8, 0);
        this.explosion_pix = this.ReadByteArray("explode.bin", 84, 0);
        this.score_pix = this.ReadByteArray("score.bin", 36, 0);
        this.score_mask = this.ReadByteArray("score.mask", 36, 0);
        this.racket_pix = this.ReadByteArray("racket.bin", 64, 0);
        ++this.draw_loading;
    }

    public void unloadPixMap() {
        this.help_pix = null;
        this.end_pix = null;
        this.gameOver_pix = null;
        this.puptext_pix = null;
        this.arrow_pix = null;
        this.menu_pix = null;
        this.wall_pix = null;
        this.brick_pix = null;
        this.brick_mask = null;
        this.bonus_pix = null;
        this.number_pix = null;
        this.numberB_pix = null;
        this.ball_pix = null;
        this.missile_pix = null;
        this.explosion_pix = null;
        this.score_pix = null;
        this.score_mask = null;
        this.racket_pix = null;
    }

    public void Dispose() {
        this.unloadPixMap();
    }

    public void switchToMenu() {
        this.removeCommands();
        this.addCommand(COMMANDS[2]);
        this.addCommand(COMMANDS[1]);
        this.addCommand(COMMANDS[3]);
        this.addCommand(COMMANDS[4]);
        this.addCommand(COMMANDS[5]);
        this.addCommand(COMMANDS[6]);
        this.addCommand(COMMANDS[8]);
        this.last_state = this.state;
        this.state = 1;
    }

    public void switchToGame() {
        this.removeCommands();
        this.addCommand(COMMANDS[0]);
        this.addCommand(COMMANDS[7]);
        this.addCommand(COMMANDS[1]);
        this.addCommand(COMMANDS[3]);
        this.addCommand(COMMANDS[4]);
        this.addCommand(COMMANDS[5]);
        this.addCommand(COMMANDS[6]);
        this.addCommand(COMMANDS[8]);
        this.gameScreen.clear((byte)0);
        this.last_state = this.state;
        this.state = 2;
    }

    public void switchToHelp() {
        this.removeCommands();
        this.gameScreen.clear((byte)0);
        this.last_state = this.state;
        if (this.help_pix == null) {
            this.state = 8;
            this.screenToLoad = 2;
        } else {
            this.state = 7;
        }
    }

    public void switchToHighScore() {
        this.removeCommands();
        this.highscores = this.getHighScore();
        this.gameScreen.clear((byte)0);
        this.show_high = true;
        this.last_state = this.state;
        this.state = 5;
    }

    public void switchToNewHighScore() {
        this.removeCommands();
        this.gameScreen.clear((byte)0);
        this.show_high = true;
        this.last_state = this.state;
        this.state = 3;
    }

    public void switchToGameOver() {
        this.removeCommands();
        this.last_state = this.state;
        if (this.gameOver_pix == null) {
            this.state = 8;
            this.screenToLoad = 0;
        } else {
            this.state = 4;
        }
    }

    public void switchToEndOfGame() {
        this.removeCommands();
        this.last_state = this.state;
        if (this.end_pix == null) {
            this.state = 8;
            this.screenToLoad = 1;
        } else {
            this.state = 6;
        }
    }

    private void removeCommands() {
        for (int i = 0; i < 9; ++i) {
            this.removeCommand(COMMANDS[i]);
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == COMMANDS[0]) {
            this.repaint();
        } else if (command == COMMANDS[1]) {
            this.gameScreen.clear((byte)0);
            this.gameScreen.blitToScreen(0, 0);
            this.gameScreen.blitToScreen(5, 0);
            this.graphic.drawString("Loading", 50, 40, 17);
            this.game.initGame();
            this.switchToGame();
        } else if (command == COMMANDS[2]) {
            this.gameScreen.clear((byte)0);
            this.gameScreen.blitToScreen(0, 0);
            this.gameScreen.blitToScreen(5, 0);
            this.graphic.drawString("Loading", 50, 40, 17);
            this.game.score = 0;
            this.game.level = 0;
            byte[] byArray = this.getSavedGame();
            if (byArray != null) {
                this.game.level = byArray[2];
                this.game.score = (short)(byArray[0] << 8 | byArray[1] & 0xFF);
            }
            this.game.initLevel(this.game.level);
            this.switchToGame();
        } else if (command == COMMANDS[3]) {
            this.game.bSound = !this.game.bSound;
        } else if (command == COMMANDS[4]) {
            this.game.bVibration = !this.game.bVibration;
        } else if (command == COMMANDS[5]) {
            this.switchToHelp();
        } else if (command == COMMANDS[6]) {
            this.switchToHighScore();
        } else if (command == COMMANDS[7]) {
            this.switchToMenu();
        } else if (command == COMMANDS[8]) {
            this.appz.quit();
        }
    }

    protected void keyPressed(int n) {
        this.currentKey = n;
        switch (n) {
            case 49: {
                this.currentKey = 2;
                break;
            }
            case 50: {
                this.currentKey = 1;
                break;
            }
            case 51: {
                this.currentKey = 5;
                break;
            }
            case 53: {
                this.currentKey = 6;
                break;
            }
            case -4: {
                this.currentKey = 8;
                break;
            }
            case -12: {
                if (this.saving) break;
                this.appz.quit();
            }
        }
        switch (this.getGameAction(n)) {
            case 1: {
                this.currentKey = 1;
                break;
            }
            case 2: {
                this.currentKey = 2;
                break;
            }
            case 5: {
                this.currentKey = 5;
                break;
            }
            case 6: {
                this.currentKey = 6;
            }
        }
        this.currentKeyState = 1;
    }

    protected void keyReleased(int n) {
        this.currentKeyState = 0;
    }

    public void save() {
        this.saving = true;
        byte[] byArray = new byte[]{(byte)(this.game.score >> 8), (byte)this.game.score, this.game.level};
        this.replaceSavedGame(byArray);
        this.saving = false;
    }

    public void paint(Graphics graphics) {
        this.graphic = graphics;
        if (this.paused) {
            return;
        }
        block0 : switch (this.state) {
            case 0: {
                this.gameScreen.setPixels(this.splash_pix, 0, 0, 96, 80);
                this.gameScreen.setPixels(this.loadingsprite_pix, 8, 0, 80, 7);
                this.gameScreen.blitToScreen(2, 0);
                if (this.draw_loading >= 8) break;
                graphics.setColor(0xFFFFFF);
                graphics.drawLine(51, 3, 51 + this.draw_loading * 5, 3);
                graphics.setColor(0);
                break;
            }
            case 1: {
                this.gameScreen.setPixels(this.splash_pix, 0, 0, 96, 80);
                if ((this.draw_loading %= 20) < 10) {
                    this.gameScreen.setPixels(this.menu_pix, 72, 67, 24, 8);
                }
                ++this.draw_loading;
                this.gameScreen.blitToScreen(2, 0);
                break;
            }
            case 2: {
                this.game.updateGame();
                this.gameScreen.setPixels(this.background_pix, 0, 8, 96, 72);
                this.gameScreen.setPixels(this.wall_pix, 8, 8 - this.game.mapOffset, 80, 72);
                this.gameScreen.setPixels(this.header_pix, 0, 0, 96, 8);
                this.gfxManager.paint(this.gameScreen, 8, 8);
                this.gameScreen.blitToScreen(2, 0);
                if (this.game.showText > 0) {
                    --this.game.showText;
                    if (this.game.showText == 0) {
                        this.puptext_spr.setVisible(false);
                    }
                }
                if (!this.game.scroll) break;
                this.levelB_spr[0].setVisible(true);
                this.levelB_spr[1].setVisible(true);
                graphics.drawString(this.misc_str[4], 30, 55, 20);
                break;
            }
            case 3: {
                this.updateNewScore();
                if (!this.show_high || this.state != 3) break;
                this.gameScreen.blitToScreen(2, 0);
                graphics.drawString(this.misc_str[2], 50, 10, 17);
                graphics.drawRect(18 + 24 * this.index_name, 60, 15, 15);
                graphics.drawString(String.valueOf(this.game.score), 50, 40, 17);
                for (int i = 0; i < 3; ++i) {
                    graphics.drawChar((char)this.highscore[i], 22 + 24 * i, 62, 20);
                }
                this.show_high = false;
                break;
            }
            case 5: {
                if (this.currentKey == 8 && this.currentKeyState == 1) {
                    if (this.last_state == 2) {
                        this.switchToGame();
                    } else {
                        this.switchToMenu();
                    }
                }
                if (!this.show_high) break;
                this.gameScreen.setPixels(this.arrow_pix, 89, 76, 8, 4);
                this.gameScreen.blitToScreen(2, 0);
                graphics.drawString(this.misc_str[3], 50, 10, 17);
                for (int i = 0; i < 3; ++i) {
                    for (int j = 0; j < 3; ++j) {
                        graphics.drawChar((char)this.highscores[j + i * 5], 20 + j * 8, 30 + i * 15, 20);
                    }
                    graphics.drawString(String.valueOf((short)(this.highscores[3 + i * 5] << 8 | this.highscores[4 + i * 5] & 0xFF)), 55, 30 + i * 15, 20);
                }
                this.show_high = false;
                break;
            }
            case 4: {
                this.updateGameOver();
                if (this.state != 4) break;
                if (this.gameover_step < 80) {
                    this.gameScreen.setPixels(this.gameOver_pix, 0, 0, 96, this.gameover_step);
                } else {
                    this.gameScreen.setPixels(this.gameOver_pix, 0, 0, 96, 80);
                }
                this.gameScreen.setPixels(this.arrow_pix, 89, 76, 8, 4);
                this.gameScreen.blitToScreen(2, 0);
                break;
            }
            case 6: {
                this.updateGameOver();
                if (this.state != 6) break;
                if (this.gameover_step < 80) {
                    this.gameScreen.setPixels(this.end_pix, 0, 0, 96, this.gameover_step);
                } else {
                    this.gameScreen.setPixels(this.end_pix, 0, 0, 96, 80);
                }
                this.gameScreen.setPixels(this.arrow_pix, 89, 76, 8, 4);
                this.gameScreen.blitToScreen(2, 0);
                break;
            }
            case 7: {
                this.updateHelp();
                if (this.state != 7) break;
                this.gameScreen.setPixels(this.help_pix, 0, -this.help_height, 96, 80 + this.help_height);
                this.gameScreen.setPixels(this.arrow_pix, 89, 76, 8, 4);
                this.gameScreen.blitToScreen(2, 0);
                break;
            }
            case 8: {
                switch (this.screenToLoad) {
                    case 0: {
                        this.screenToLoad = -1;
                        this.gameOver_pix = this.ReadByteArray("gameover.bin", 960, 0);
                        this.state = 4;
                        break block0;
                    }
                    case 1: {
                        this.screenToLoad = -1;
                        this.end_pix = this.ReadByteArray("end.bin", 960, 0);
                        this.state = 6;
                        break block0;
                    }
                    case 2: {
                        this.gameScreen.clear((byte)0);
                        this.gameScreen.blitToScreen(0, 0);
                        this.gameScreen.blitToScreen(5, 0);
                        this.graphic.drawString("Loading", 50, 40, 17);
                        this.screenToLoad = -1;
                        this.help_pix = this.ReadByteArray("help.bin", 2388, 0);
                        this.state = 7;
                    }
                }
            }
        }
    }

    private void updateNewScore() {
        if (this.currentKeyState == 1) {
            switch (this.currentKey) {
                case 1: {
                    if (this.index_name < 2) {
                        ++this.index_name;
                    } else {
                        this.highscore[3] = (byte)(this.game.score >> 8);
                        this.highscore[4] = (byte)this.game.score;
                        this.insertHighScore(this.highscore, this.index_highScore);
                        this.index_name = 0;
                        this.switchToHighScore();
                    }
                    this.index_char = (byte)(this.highscore[this.index_name] - 65);
                    this.currentKeyState = 0;
                    this.show_high = true;
                    break;
                }
                case 6: {
                    if (this.index_name > 0) {
                        --this.index_name;
                    }
                    this.index_char = (byte)(this.highscore[this.index_name] - 65);
                    this.currentKeyState = 0;
                    this.show_high = true;
                    break;
                }
                case 2: {
                    this.index_char = (byte)(this.index_char - 1);
                    this.index_char = (byte)(this.index_char + 26);
                    this.index_char = (byte)(this.index_char % 26);
                    this.highscore[this.index_name] = (byte)(this.index_char + 65);
                    this.currentKeyState = 0;
                    this.show_high = true;
                    break;
                }
                case 5: {
                    this.index_char = (byte)(this.index_char + 1);
                    this.index_char = (byte)(this.index_char % 26);
                    this.highscore[this.index_name] = (byte)(this.index_char + 65);
                    this.currentKeyState = 0;
                    this.show_high = true;
                }
            }
        }
    }

    private void updateHelp() {
        if (this.currentKeyState == 1) {
            switch (this.currentKey) {
                case 1: {
                    if (this.help_height > 4) {
                        this.help_height -= 4;
                        break;
                    }
                    this.help_height = 0;
                    break;
                }
                case 6: {
                    if (this.help_height < 115) {
                        this.help_height += 4;
                        break;
                    }
                    this.help_height = 119;
                    break;
                }
                case 8: {
                    if (this.last_state == 2) {
                        this.help_height = 0;
                        this.switchToGame();
                        break;
                    }
                    this.help_height = 0;
                    this.switchToMenu();
                }
            }
        }
    }

    private void updateGameOver() {
        if (this.gameover_step > 200 || this.currentKeyState == 1 && this.currentKey == 8) {
            this.gameover_step = 0;
            this.index_highScore = this.getHighScoreIndex(this.game.score);
            if (this.index_highScore == 3) {
                this.eraseHighScore();
                this.switchToMenu();
            } else {
                this.switchToNewHighScore();
            }
            return;
        }
        this.gameover_step += 2;
    }

    public void loadWall(int n) {
        Sprite sprite;
        ExtendedImage extendedImage = null;
        this.game.leftBrick = 0;
        Image image = Image.createImage((int)80, (int)72);
        extendedImage = new ExtendedImage(image);
        extendedImage.clear((byte)0);
        int n2 = 0;
        while (true) {
            if (n2 >= 8) break;
            int n3 = 0;
            while (true) {
                if (n3 >= 10) break;
                switch (this.game.map.getBrick(n2, n3)) {
                    case 1: {
                        sprite = new Sprite(this.brick_pix, 0, 16, 4, this.brick_pix, 0, 5);
                        sprite.setFrame(0);
                        ++this.game.leftBrick;
                        break;
                    }
                    case 2: {
                        sprite = new Sprite(this.brick_pix, 0, 16, 4, this.brick_pix, 0, 5);
                        sprite.setFrame(1);
                        ++this.game.leftBrick;
                        break;
                    }
                    case 3: {
                        sprite = new Sprite(this.brick_pix, 0, 16, 4, this.brick_pix, 0, 5);
                        sprite.setFrame(2);
                        ++this.game.leftBrick;
                        break;
                    }
                    case 4: {
                        sprite = new Sprite(this.brick_pix, 0, 16, 4, this.brick_pix, 0, 5);
                        sprite.setFrame(3);
                        ++this.game.leftBrick;
                        break;
                    }
                    case 5: {
                        sprite = new Sprite(this.brick_pix, 0, 16, 4, this.brick_pix, 0, 5);
                        sprite.setFrame(4);
                        break;
                    }
                    default: {
                        sprite = new Sprite(this.empty, 0, 16, 4, this.brick_mask, 0, 1);
                    }
                }
                this.gfxTempManager.addObject((GraphicObject)sprite);
                sprite.setPosition(n2 * 10, n3 * 4);
                this.gfxTempManager.paint(extendedImage, 0, 0);
                this.gfxTempManager.deleteObject((GraphicObject)sprite);
                ++n3;
            }
            ++n2;
        }
        extendedImage.getPixelBytes(this.wall_pix, 0, 0, 80, 72);
        image = null;
        extendedImage = null;
        sprite = null;
    }

    public final void eraseBrick(int n, int n2) {
        this.gfxTempManager.addObject((GraphicObject)this.empty_spr);
        this.empty_spr.setPosition(n * 10, n2 * 4);
        this.gfxTempManager.paint(this.gameScreen, 8, 8);
        this.gfxTempManager.deleteObject((GraphicObject)this.empty_spr);
    }

    public final void manageSprite() {
        Sprite sprite;
        int n;
        this.setScore();
        this.racket_spr.setPosition(this.game.racket.left(), this.game.racket.top());
        for (n = 0; n < this.game.ballManager.size(); ++n) {
            Ball ball = (Ball)this.game.ballManager.elementAt(n);
            sprite = (Sprite)this.ballSprManager.elementAt(n);
            sprite.setPosition(ball.left(), ball.top());
        }
        for (n = 0; n < this.game.bonusManager.size(); ++n) {
            sprite = (Sprite)this.bonusSprManager.elementAt(n);
            Bonus bonus = (Bonus)this.game.bonusManager.elementAt(n);
            sprite.setPosition(bonus.left(), bonus.top());
        }
        for (n = this.explosionSprManager.size() - 1; n > -1; --n) {
            sprite = (Sprite)this.explosionSprManager.elementAt(n);
            Sprite sprite2 = (Sprite)this.scoreSprManager.elementAt(n);
            int n2 = sprite.getFrame();
            if (n2 == 2 && sprite.getVisible()) {
                sprite.setVisible(false);
                sprite2.setPosition(sprite2.getXPosition(), sprite2.getYPosition() - 2);
                continue;
            }
            if (n2 == 2) {
                this.gfxManager.deleteObject((GraphicObject)sprite);
                this.gfxManager.deleteObject((GraphicObject)sprite2);
                this.explosionSprManager.removeElementAt(n);
                this.scoreSprManager.removeElementAt(n);
                continue;
            }
            sprite.setFrame(n2 + 1);
            sprite2.setPosition(sprite2.getXPosition(), sprite2.getYPosition() - 2);
        }
        if (this.game.missile.active || this.game.missile.ammo > 0) {
            this.missile_spr.setPosition(this.game.missile.X, this.game.missile.Y);
        }
    }

    private final void setScore() {
        this.number_spr[4].setFrame(this.game.score % 10);
        this.number_spr[3].setFrame(this.game.score % 100 / 10);
        this.number_spr[2].setFrame(this.game.score % 1000 / 100);
        this.number_spr[1].setFrame(this.game.score % 10000 / 1000);
        this.number_spr[0].setFrame(this.game.score % 100000 / 10000);
    }

    public final void initLife() {
        switch (this.game.life) {
            case 0: {
                this.gfxManager.addObject((GraphicObject)this.life_spr[0]);
                this.gfxManager.addObject((GraphicObject)this.life_spr[1]);
                break;
            }
            case 1: {
                this.gfxManager.addObject((GraphicObject)this.life_spr[0]);
            }
        }
        this.game.life = 2;
    }

    public final void newExplosion(int n, int n2, int n3) {
        this.explosionSprManager.addElement(new Sprite(this.explosion_pix, 0, 16, 14, this.explosion_pix, 0, 3));
        Sprite sprite = (Sprite)this.explosionSprManager.lastElement();
        sprite.setPosition(n, n2);
        this.gfxManager.insertObject((GraphicObject)sprite, 0);
        this.scoreSprManager.addElement(new Sprite(this.score_pix, 0, 16, 9, this.score_mask, 0, 2));
        sprite = (Sprite)this.scoreSprManager.lastElement();
        sprite.setPosition(n, n2 - 6);
        sprite.setFrame(n3);
        this.gfxManager.insertObject((GraphicObject)sprite, 0);
    }

    public void addBall() {
        this.ballSprManager.addElement(new Sprite(this.ball_pix, 0, 8, 4, this.ball_pix, 0, 1));
        this.gfxManager.insertObject((GraphicObject)((Sprite)this.ballSprManager.lastElement()), 1);
    }

    public void removeBall(int n) {
        this.gfxManager.deleteObject((GraphicObject)((Sprite)this.ballSprManager.elementAt(n)));
        this.ballSprManager.removeElementAt(n);
    }

    public void addBonus(int n) {
        this.bonusSprManager.addElement(new Sprite(this.bonus_pix, 0, 8, 8, this.bonus_pix, 0, 7));
        ((Sprite)this.bonusSprManager.lastElement()).setFrame(n);
        this.gfxManager.insertObject((GraphicObject)((Sprite)this.bonusSprManager.lastElement()), 1);
    }

    public void removeBonus(int n) {
        this.gfxManager.deleteObject((GraphicObject)((Sprite)this.bonusSprManager.elementAt(n)));
        this.bonusSprManager.removeElementAt(n);
    }

    public void drawGreat() {
        this.graphic.drawString("Great!", 50, 40, 17);
    }

    static {
        LOAD = 0;
        MENU = 1;
        GAME = 2;
        NEW_HIGH_SCORE = 3;
        GAME_OVER = 4;
        HIGH_SCORE = 5;
        END_OF_GAME = 6;
        HELP = 7;
        LOADSCREEN = 8;
        GAME_AREA_WIDTH = 80;
        GAME_AREA_HEIGHT = 72;
        GAME_AREA_POSX = 8;
        GAME_AREA_POSY = 8;
        LEVEL_HEADER_POSX = 32;
        LIFE_HEADER_POSX = 46;
        SCORE_HEADER_POSX = 62;
        HEADER_POSY = 1;
        GAME_SCREEN_WIDTH = 96;
        GAME_SCREEN_HEIGHT = 80;
        PRESSED = 1;
        RELEASED = 0;
    }
}

