/*
 * Decompiled with CFR 0.152.
 */
package com.appon.miniframework.controls;

import com.appon.miniframework.Container;
import com.appon.miniframework.Control;
import com.appon.miniframework.EventManager;
import com.appon.miniframework.MenuSerilize;
import com.appon.miniframework.ScrollableContainer;
import com.appon.miniframework.controls.TabButton;
import com.appon.miniframework.exception.NotValidParameter;
import com.appon.miniframework.exception.OperationNotSupported;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import javax.microedition.lcdui.Graphics;

public class TabPane
extends Container {
    ScrollableContainer container;
    TabButton tabButton = new TabButton();

    public TabPane(int id, int containerId) {
        super(id);
        this.container = new ScrollableContainer(containerId);
        this.container.setParent(this);
    }

    public TabPane(int id) {
        super(id);
    }

    public void takeScrollBackup() {
        this.container.takeScrollBackup();
    }

    public void restoreScrollBackup() {
        this.container.restoreScrollBackup();
    }

    public void setEventManager(EventManager manager) {
        super.setEventManager(manager);
        this.container.setEventManager(manager);
    }

    public void port() {
        super.port();
        this.container.port();
    }

    public void resize() {
        super.resize();
        this.tabButton.resize();
        this.container.setSizeSettingX(2);
        this.container.setSizeSettingY(2);
        this.container.setWidth(this.getWidth());
        this.container.setHeight(this.getHeight() - this.tabButton.getHeight());
        this.container.setPoistion(0, this.tabButton.getHeight());
        this.container.resize();
    }

    public ScrollableContainer getContainer() {
        return this.container;
    }

    public TabButton getTabButton() {
        return this.tabButton;
    }

    public int getSize() {
        return 1;
    }

    public Control getChild(int index) {
        if (index == 0) {
            return this.container;
        }
        throw new NotValidParameter();
    }

    public int getScrolledX() {
        return 0;
    }

    public int getScrolledY() {
        return 0;
    }

    public int getChildrenIndex(Control control) {
        if (control.equals(this.container)) {
            return 0;
        }
        throw new NotValidParameter();
    }

    public void removeChildren(Control children) {
        throw new OperationNotSupported();
    }

    public void addChildrenAt(Control control, int index) {
        throw new OperationNotSupported();
    }

    public void resetSelecton() {
    }

    public void selectChild(int index, boolean isFromTouch) {
    }

    public void stretchDimentions() {
        this.container.stretchDimentions();
    }

    public void paint(Graphics g) {
        this.tabButton.paint(g, false);
        this.container.paintUI(g);
    }

    public int getClassCode() {
        return 1017;
    }

    public byte[] serialize() throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        bos.write(super.serialize());
        bos.write(this.tabButton.serialize());
        MenuSerilize.getInstance();
        MenuSerilize.serialize(this.container, bos);
        return bos.toByteArray();
    }

    public ByteArrayInputStream deserialize(ByteArrayInputStream bis) throws Exception {
        super.deserialize(bis);
        this.tabButton.deserialize(bis);
        MenuSerilize.getInstance();
        this.container = (ScrollableContainer)MenuSerilize.deserialize(bis, MenuSerilize.getInstance());
        this.container.setParent(this);
        return bis;
    }

    public String toString() {
        return "TabPane: " + this.getId();
    }
}

