/*
 * Decompiled with CFR 0.152.
 */
package com.appon.miniframework.layout;

import com.appon.miniframework.Container;
import com.appon.miniframework.Control;
import com.appon.miniframework.Layout;
import com.appon.miniframework.Util;
import java.io.ByteArrayInputStream;

public class GridLayout
implements Layout {
    public static final int LEFT_ALLIGN = 0;
    public static final int CENTER_ALLIGN = 1;
    public static final int RIGHT_ALLIGN = 2;
    public static final int TOP_ALLIGN = 0;
    public static final int BOTTOM_ALLIGN = 2;
    public static final byte CELL_NONE_STRETCH = 0;
    public static final byte CELL_HORIZONTAL_STRETCH = 1;
    public static final byte CELL_VERTICAL_STRETCH = 2;
    public static final byte CELL_HOR_VER_STRETCH = 3;
    private int _iNumColumn = 1;
    private int _iNumRow = 1;
    private boolean[] _bNullCellInfo;
    private int[][] _iCellAlignInfo;
    private int[] _iCellStretchArry;
    private int[] _iCellX;
    private int[] _iCellY;
    private int[] _iCellWidth;
    private int[] _iCellHeight;
    private static final int UNIT_CELL_SIZE = 1;
    private int[][] mergeCells;

    public void initGrid(int numOfColumn, int numOfRow) {
        this._iNumColumn = Math.abs(numOfColumn);
        this._iNumRow = Math.abs(numOfRow);
        if (this._iNumColumn == 0 || this._iNumRow == 0) {
            return;
        }
        this.initializeGrids();
    }

    public int[][] getMergeCells() {
        return this.mergeCells;
    }

    public int[] getCellStretchArry() {
        return this._iCellStretchArry;
    }

    public boolean[] getNullCellInfo() {
        return this._bNullCellInfo;
    }

    public int[][] getCellAlignInfo() {
        return this._iCellAlignInfo;
    }

    public int getColumns() {
        return this._iNumColumn;
    }

    public int getRows() {
        return this._iNumRow;
    }

    public void setNullCellInfo(boolean[] nullCellInfo) {
        this._bNullCellInfo = nullCellInfo;
    }

    public void setAllignCellInfo(int[][] cellAlignInfo) {
        this._iCellAlignInfo = cellAlignInfo;
    }

    private boolean checkForCorrectCellId(int cellID) {
        int totalCell = this._iCellX.length;
        return cellID >= 0 && cellID <= totalCell;
    }

    public void setStretchCellInfo(int[] cellStretchArry) {
        this._iCellStretchArry = cellStretchArry;
    }

    public void resetGrid() {
        this.initializeGrids();
        this._iCellAlignInfo = null;
        this._bNullCellInfo = null;
        this._iCellStretchArry = null;
    }

    public void mergeCells(int[][] cells) {
        this.mergeCells = cells;
        if (cells == null) {
            return;
        }
        for (int i = 0; i < cells.length; ++i) {
            this.mergeCells(cells[i]);
        }
    }

    public boolean mergeCells(int[] cells) {
        int[] x_backup = new int[this._iCellX.length];
        int[] y_backup = new int[this._iCellY.length];
        int[] width_backup = new int[this._iCellWidth.length];
        int[] height_backup = new int[this._iCellHeight.length];
        System.arraycopy(this._iCellX, 0, x_backup, 0, this._iCellX.length);
        System.arraycopy(this._iCellY, 0, y_backup, 0, this._iCellY.length);
        System.arraycopy(this._iCellWidth, 0, width_backup, 0, this._iCellWidth.length);
        System.arraycopy(this._iCellHeight, 0, height_backup, 0, this._iCellHeight.length);
        boolean[] tmpNullCellInfo = null;
        if (this._bNullCellInfo != null) {
            tmpNullCellInfo = new boolean[this._bNullCellInfo.length];
            System.arraycopy(this._bNullCellInfo, 0, tmpNullCellInfo, 0, this._bNullCellInfo.length);
        }
        int[] tmpCellAllignInfo = null;
        if (this._iCellAlignInfo != null) {
            tmpCellAllignInfo = new int[this._iCellAlignInfo.length];
            System.arraycopy(this._iCellAlignInfo, 0, tmpCellAllignInfo, 0, this._iCellAlignInfo.length);
        }
        int[] tmpCellStretchInfo = null;
        if (this._iCellStretchArry != null) {
            tmpCellStretchInfo = new int[this._iCellStretchArry.length];
            System.arraycopy(this._iCellStretchArry, 0, tmpCellStretchInfo, 0, this._iCellStretchArry.length);
        }
        block0: for (int i = 0; i < cells.length; ++i) {
            for (int j = 0; j < cells.length; ++j) {
                if (!this.mergeCell(cells[i], cells[j])) continue;
                int delIndex = i;
                if (cells[j] > cells[i]) {
                    delIndex = j;
                }
                int maxVal = cells[delIndex];
                cells = this.deleteIteam(cells, delIndex);
                for (int k = 0; k < cells.length; ++k) {
                    if (maxVal >= cells[k]) continue;
                    int n = k;
                    cells[n] = cells[n] - 1;
                }
                i = 0;
                continue block0;
            }
        }
        if (cells.length != 1) {
            this._iCellX = new int[x_backup.length];
            this._iCellY = new int[x_backup.length];
            this._iCellWidth = new int[x_backup.length];
            this._iCellHeight = new int[x_backup.length];
            System.arraycopy(x_backup, 0, this._iCellX, 0, x_backup.length);
            System.arraycopy(y_backup, 0, this._iCellY, 0, x_backup.length);
            System.arraycopy(width_backup, 0, this._iCellWidth, 0, x_backup.length);
            System.arraycopy(height_backup, 0, this._iCellHeight, 0, x_backup.length);
            return false;
        }
        return true;
    }

    public boolean mergeCell(int cellId1, int cellId2) {
        boolean canMerge = false;
        int tmp = cellId1;
        if ((cellId1 = Math.min(cellId1, cellId2)) == (cellId2 = Math.max(tmp, cellId2)) || cellId1 >= this._iCellX.length || cellId2 >= this._iCellX.length) {
            return false;
        }
        if (this._iCellX[cellId1] + this._iCellWidth[cellId1] == this._iCellX[cellId2] && this._iCellY[cellId1] == this._iCellY[cellId2] && this._iCellY[cellId1] + this._iCellHeight[cellId1] == this._iCellY[cellId2] + this._iCellHeight[cellId2]) {
            canMerge = true;
        } else if (this._iCellY[cellId1] + this._iCellHeight[cellId1] == this._iCellY[cellId2] && this._iCellX[cellId1] == this._iCellX[cellId2] && this._iCellX[cellId1] + this._iCellWidth[cellId1] == this._iCellX[cellId2] + this._iCellWidth[cellId2]) {
            canMerge = true;
        }
        if (canMerge) {
            int delIndex = Math.max(cellId1, cellId2);
            int newIndex = Math.min(cellId1, cellId2);
            if (this._iCellX[cellId1] + this._iCellWidth[cellId1] == this._iCellX[cellId2] || this._iCellX[cellId2] + this._iCellWidth[cellId2] == this._iCellX[cellId1]) {
                this._iCellWidth[newIndex] = this._iCellWidth[cellId1] + this._iCellWidth[cellId2];
            }
            if (this._iCellY[cellId1] + this._iCellHeight[cellId1] == this._iCellY[cellId2] || this._iCellY[cellId2] + this._iCellHeight[cellId2] == this._iCellY[cellId1]) {
                this._iCellHeight[newIndex] = this._iCellHeight[cellId1] + this._iCellHeight[cellId2];
            }
            this._iCellX = this.deleteIteam(this._iCellX, delIndex);
            this._iCellY = this.deleteIteam(this._iCellY, delIndex);
            this._iCellWidth = this.deleteIteam(this._iCellWidth, delIndex);
            this._iCellHeight = this.deleteIteam(this._iCellHeight, delIndex);
            if (this._iCellStretchArry != null && this._iCellStretchArry.length > delIndex) {
                this._iCellStretchArry = this.deleteIteam(this._iCellStretchArry, delIndex);
            }
            if (this._bNullCellInfo != null && this._bNullCellInfo.length > delIndex) {
                this._bNullCellInfo = this.deleteIteam(this._bNullCellInfo, delIndex);
            }
        }
        return canMerge;
    }

    private int[] deleteIteam(int[] arry, int index) {
        int[] tmpArry = new int[arry.length - 1];
        System.arraycopy(arry, 0, tmpArry, 0, index);
        System.arraycopy(arry, index + 1, tmpArry, index, arry.length - index - 1);
        return tmpArry;
    }

    private boolean[] deleteIteam(boolean[] arry, int index) {
        boolean[] tmpArry = new boolean[arry.length - 1];
        System.arraycopy(arry, 0, tmpArry, 0, index);
        System.arraycopy(arry, index + 1, tmpArry, index, arry.length - index - 1);
        return tmpArry;
    }

    private void initializeGrids() {
        int tmpTotalCell = this._iNumColumn * this._iNumRow;
        if (this._iNumColumn == 0 || this._iNumRow == 0) {
            return;
        }
        this._iCellX = new int[tmpTotalCell];
        this._iCellY = new int[tmpTotalCell];
        this._iCellWidth = new int[tmpTotalCell];
        this._iCellHeight = new int[tmpTotalCell];
        for (int i = 0; i < tmpTotalCell; ++i) {
            this._iCellX[i] = 1 * (i % this._iNumColumn);
            this._iCellY[i] = 1 * (i / this._iNumColumn);
            this._iCellWidth[i] = 1;
            this._iCellHeight[i] = 1;
        }
    }

    public void applyLayout(Container parent, Control control) {
        if (this._iNumColumn == 0 || this._iNumRow == 0) {
            return;
        }
        Container sourceContainer = (Container)control;
        int sourceWidth = sourceContainer.getBoundWidth();
        int sourceHeight = sourceContainer.getBoundHeight();
        int tmpCellWidth = sourceWidth / this._iNumColumn;
        int tmpCellHeight = sourceHeight / this._iNumRow;
        int correctionX = 0;
        int correctionY = 0;
        int temp_x = 0;
        int temp_y = 0;
        int tmpTotalCell = this._iCellX.length;
        int tmpCellCnt = 0;
        for (int idx = 0; idx < sourceContainer.getSize(); ++idx) {
            if (sourceContainer.getChild(idx).getRelativeLocation() != null) continue;
            if (this._bNullCellInfo != null && this._bNullCellInfo.length > tmpCellCnt) {
                while (this._bNullCellInfo.length > tmpCellCnt && !this._bNullCellInfo[tmpCellCnt] && tmpCellCnt < tmpTotalCell) {
                    ++tmpCellCnt;
                }
            }
            temp_x = tmpCellWidth * (this._iCellX[tmpCellCnt] + this._iCellWidth[tmpCellCnt]) - (tmpCellWidth * this._iCellWidth[tmpCellCnt] >> 1);
            temp_y = tmpCellHeight * (this._iCellY[tmpCellCnt] + this._iCellHeight[tmpCellCnt]) - (this._iCellHeight[tmpCellCnt] * tmpCellHeight >> 1);
            if (this._iCellAlignInfo != null && this._iCellAlignInfo.length > tmpCellCnt) {
                if (this._iCellAlignInfo[tmpCellCnt][0] == 2) {
                    temp_x += (tmpCellWidth * this._iCellWidth[tmpCellCnt] >> 1) - (sourceContainer.getChild(idx).getWidth() >> 1);
                }
                if (this._iCellAlignInfo[tmpCellCnt][0] == 0) {
                    temp_x -= (tmpCellWidth * this._iCellWidth[tmpCellCnt] >> 1) - (sourceContainer.getChild(idx).getWidth() >> 1);
                }
                if (this._iCellAlignInfo[tmpCellCnt][1] == 0) {
                    temp_y -= (tmpCellHeight * this._iCellHeight[tmpCellCnt] >> 1) - (sourceContainer.getChild(idx).getHeight() >> 1);
                }
                if (this._iCellAlignInfo[tmpCellCnt][1] == 2) {
                    temp_y += (tmpCellHeight * this._iCellHeight[tmpCellCnt] >> 1) - (sourceContainer.getChild(idx).getHeight() >> 1);
                }
            }
            if (this._iCellStretchArry != null && this._iCellStretchArry.length > tmpCellCnt) {
                if (this._iCellStretchArry[tmpCellCnt] == 1) {
                    sourceContainer.getChild(idx).setWidth(tmpCellWidth * this._iCellWidth[tmpCellCnt] + correctionX);
                    temp_x = tmpCellWidth * (this._iCellX[tmpCellCnt] + this._iCellWidth[tmpCellCnt]) - (tmpCellWidth * this._iCellWidth[tmpCellCnt] >> 1);
                }
                if (this._iCellStretchArry[tmpCellCnt] == 2) {
                    sourceContainer.getChild(idx).setHeight(tmpCellHeight * this._iCellHeight[tmpCellCnt] + correctionY);
                    temp_y = tmpCellHeight * (this._iCellY[tmpCellCnt] + this._iCellHeight[tmpCellCnt]) - (this._iCellHeight[tmpCellCnt] * tmpCellHeight >> 1);
                }
                if (this._iCellStretchArry[tmpCellCnt] == 3) {
                    sourceContainer.getChild(idx).setWidth(tmpCellWidth * this._iCellWidth[tmpCellCnt] + correctionX);
                    sourceContainer.getChild(idx).setHeight(tmpCellHeight * this._iCellHeight[tmpCellCnt] + correctionY);
                    temp_x = tmpCellWidth * (this._iCellX[tmpCellCnt] + this._iCellWidth[tmpCellCnt]) - (tmpCellWidth * this._iCellWidth[tmpCellCnt] >> 1);
                    temp_y = tmpCellHeight * (this._iCellY[tmpCellCnt] + this._iCellHeight[tmpCellCnt]) - (this._iCellHeight[tmpCellCnt] * tmpCellHeight >> 1);
                }
            }
            Control base = sourceContainer.getChild(idx);
            base.setX(correctionX + temp_x - (base.getWidth() >> 1));
            base.setY(temp_y + correctionY - (base.getHeight() >> 1));
            if (tmpCellCnt >= tmpTotalCell - 1) continue;
            ++tmpCellCnt;
        }
    }

    public void cleanUp() {
        this._bNullCellInfo = null;
        this._iCellHeight = null;
        this._iCellWidth = null;
        this._iCellY = null;
        this._iCellX = null;
        this._iCellStretchArry = null;
    }

    public byte[] serialize() throws Exception {
        return null;
    }

    public ByteArrayInputStream deserialize(ByteArrayInputStream bis) throws Exception {
        this.initGrid(Util.readInt(bis, 1), Util.readInt(bis, 1));
        this.mergeCells(Util.read2DIntArray(bis));
        this.setStretchCellInfo(Util.readIntArray(bis));
        this.setNullCellInfo(Util.readBooleanArray(bis));
        this.setAllignCellInfo(Util.read2DIntArray(bis));
        bis.close();
        return null;
    }

    public int getClassCode() {
        return 1006;
    }

    public void port() {
    }

    private int getMaxWidth(Container parent) {
        int h = 0;
        for (int i = 0; i < parent.getSize(); ++i) {
            if (parent.getChild(i).getWidth() <= h || parent.getChild(i).isSkipParentWrapSizeCalc()) continue;
            h = parent.getChild(i).getWidth();
        }
        return h;
    }

    private int getMaxHeight(Container parent) {
        int h = 0;
        for (int i = 0; i < parent.getSize(); ++i) {
            if (parent.getChild(i).getHeight() <= h || parent.getChild(i).isSkipParentWrapSizeCalc()) continue;
            h = parent.getChild(i).getHeight();
        }
        return h;
    }

    public int getPreferedWidth(Container parent) {
        return this._iNumColumn * this.getMaxWidth(parent);
    }

    public int getPreferedHeight(Container parent) {
        return this._iNumRow * this.getMaxHeight(parent);
    }
}

