/*
 * Decompiled with CFR 0.152.
 */
package com.appon.miniframework;

import com.appon.miniframework.Container;
import com.appon.miniframework.Control;
import com.appon.miniframework.CustomSelector;
import com.appon.miniframework.Event;
import com.appon.miniframework.EventManager;
import com.appon.miniframework.EventQueue;
import com.appon.miniframework.MenuSerilize;
import com.appon.miniframework.Settings;
import com.appon.miniframework.Util;
import com.appon.miniframework.layout.PropotionLayout;
import java.io.ByteArrayInputStream;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public class ScrollableContainer
extends Container {
    private int totalHeight;
    private int barWidth;
    private int scrolledY = 0;
    private int totalWidth;
    private int scrolledX;
    private Vector childrens = new Vector();
    private static boolean selectChild = true;
    private int selectedChild = 0;
    public static final int SCROLL_BAR_MIN_WIDTH = 2;
    private int upperMostElement = -1;
    private int leftMostElement = -1;
    private CustomSelector selector;
    private static int diffrenceY = 0;
    private static int oldY = 0;
    private static int diffrenceX = 0;
    private static int oldX = 0;
    public static final int SMOOTH_SCROLL = 0;
    public static final int SELECT_COMPONENT_SCROLL = 1;
    private int scrollBarColor = 0;
    private int scrollType = 1;
    public static final int SCROLLBAR_ALWAYS_VISABLE = 0;
    public static final int SCROLLBAR_AUTO_HIDE = 1;
    public static final int SCROLLBAR_DISABLED = 2;
    private int verticalScrollBarVisabilityType = 0;
    private int widthPersent = 1;
    private int hideInterval = 5;
    private int visabilityTimer = 0;
    private int staticScrolledPos = 0;
    private int defaultSelection = -1;
    private boolean groupSelect = false;
    private static boolean unSelectChild = false;
    private static boolean isAnyChildSelected = false;
    private static int selectedChildSelectionDelay = 0;
    private int selectionDelayTimer = 0;
    public static boolean allStartAnimOver = false;
    private long velocityX;
    private long velocityY;
    private long lastTouchTime = -1L;
    private int lastTouchPressedX;
    private int lastTouchPressedY;
    private static boolean didScrolled = false;
    private static final int FPS_CONSIDERED = 15;
    private static final int MAX_SCROOLED_STEPS = 10;
    private int FRICTION = 20;
    private int MINIMUM_VELOCITY = 60;
    public static final int MINIMUM_SHIFT_TO_DRAG = 12;
    private int scrolledBackupY;
    private int scrolledBackupX;
    private Hashtable softkeyHashTable;
    private int oldScrollY = -1;
    private int oldScrollX = -1;
    private boolean takeEventIfNoScroll = false;
    public static boolean fromPointerDrag = false;
    public boolean doNotHandleRelease = false;
    private boolean singleSelectable = false;
    private int singleSelectableIndex = 0;
    private static int direction = 2;
    public static boolean isBringingToCenter = false;

    public ScrollableContainer(int id) {
        super(id);
    }

    public void setGroupSelect(boolean groupSelect) {
        this.groupSelect = groupSelect;
    }

    public void addSoftKeyEvent(int keyCode, Control control) {
        if (this.softkeyHashTable == null) {
            this.softkeyHashTable = new Hashtable();
        }
        this.softkeyHashTable.put("" + keyCode, control);
    }

    public boolean isGroupSelect() {
        return this.groupSelect;
    }

    public int getStaticScrolledPos() {
        return this.staticScrolledPos;
    }

    public int getDefaultSelection() {
        return this.defaultSelection;
    }

    public void setDefaultSelection(int defaultSelection) {
        this.defaultSelection = defaultSelection;
    }

    public void setStaticScrolledPos(int staticScrolledPos) {
        this.staticScrolledPos = staticScrolledPos;
    }

    public int getScrollType() {
        return this.scrollType;
    }

    public void setScrollBarColor(int scrollBarColor) {
        this.scrollBarColor = scrollBarColor;
    }

    public int getScrollBarColor() {
        return this.scrollBarColor;
    }

    public void setScrollBarVisabilityType(int scrollBarVisabilityType) {
        this.verticalScrollBarVisabilityType = scrollBarVisabilityType;
    }

    public int getScrollBarVisabilityType() {
        return this.verticalScrollBarVisabilityType;
    }

    public void setWidthPersent(int widthPersent) {
        this.widthPersent = widthPersent;
    }

    public int getWidthPersent() {
        return this.widthPersent;
    }

    public void setHideInterval(int hideInterval) {
        this.hideInterval = hideInterval;
    }

    public int getHideInterval() {
        return this.hideInterval;
    }

    public void setScrollType(int scrollType) {
        this.scrollType = scrollType;
    }

    public void setSelector(CustomSelector selector) {
        this.selector = selector;
    }

    public void resize() {
        super.resize();
        for (int i = 0; i < this.childrens.size(); ++i) {
            Control object = (Control)this.childrens.elementAt(i);
            object.resize();
        }
    }

    public int getPreferredHeight() {
        if (!(this.getLayout() instanceof PropotionLayout) && this.getLayout() != null) {
            return this.getLayout().getPreferedHeight(this) + this.getTopInBound() + this.getBottomInBound();
        }
        return Util.getWrappedHeight(this) + this.getTopInBound() + this.getBottomInBound();
    }

    public int getPreferredWidth() {
        if (!(this.getLayout() instanceof PropotionLayout) && this.getLayout() != null) {
            return this.getLayout().getPreferedWidth(this) + this.getLeftInBound() + this.getRightInBound();
        }
        return Util.getWrappedWidth(this) + this.getLeftInBound() + this.getRightInBound();
    }

    public void setEventManager(EventManager manager) {
        super.setEventManager(manager);
        for (int idx = 0; idx < this.childrens.size(); ++idx) {
            Control control = (Control)this.childrens.elementAt(idx);
            control.setEventManager(manager);
        }
    }

    public void restoreOriogionalXY() {
        super.restoreOriogionalXY();
        for (int idx = 0; idx < this.childrens.size(); ++idx) {
            Control control = (Control)this.childrens.elementAt(idx);
            control.restoreOriogionalXY();
        }
    }

    public void addChildren(Control control) {
        control.setParent(this);
        this.childrens.addElement(control);
        control.setEventManager(this.getEventListener());
    }

    public int getTotalHeight() {
        return this.totalHeight;
    }

    public void setTotalHeight(int totalHeight) {
        this.totalHeight = totalHeight;
    }

    public int getWidth() {
        return super.getWidth();
    }

    public int getChildrenIndex(Control control) {
        return this.childrens.indexOf(control);
    }

    public Control getChild(int index) {
        if (this.childrens.size() > index) {
            return (Control)this.childrens.elementAt(index);
        }
        return null;
    }

    public int getSize() {
        return this.childrens.size();
    }

    public void addChildrenAt(Control control, int index) {
        control.setParent(this);
        this.childrens.insertElementAt(control, index);
    }

    public void removeAll() {
        this.selectedChild = 0;
        this.childrens.removeAllElements();
        this.totalHeight = 0;
        this.scrolledY = 0;
    }

    public void removeChildren(Control children) {
        for (int i = 0; i < this.childrens.size(); ++i) {
            Control control = (Control)this.childrens.elementAt(i);
            if (!control.equals(children)) continue;
            this.childrens.removeElementAt(i);
        }
    }

    public void resetAnimations() {
        for (int i = 0; i < this.childrens.size(); ++i) {
            Control control = (Control)this.childrens.elementAt(i);
            control.resetAnimations();
        }
        super.resetAnimations();
    }

    public void init() {
        EventQueue.getInstance().reset();
        this.hideNotify();
        this.initShowNotify();
        this.showNotify();
        this.resetAnimations();
    }

    public int getSelectedChildIndex() {
        return this.selectedChild;
    }

    public Control getSelectedChild() {
        if (this.selectedChild >= 0 && this.selectedChild < this.childrens.size()) {
            Control control = (Control)this.childrens.elementAt(this.selectedChild);
            return control;
        }
        return null;
    }

    public synchronized void paint(Graphics g) {
        this.updateScrollFromVelocity();
        this.bringControlToCenter();
        if (this.oldScrollY != this.scrolledY && this.isVerticalScrollBarPresent()) {
            this.visabilityTimer = 0;
            this.oldScrollY = this.scrolledY;
        }
        if (this.oldScrollX != this.scrolledX && this.isHorizontalScrollBarPresent()) {
            this.visabilityTimer = 0;
            this.oldScrollX = this.scrolledX;
        }
        if (!allStartAnimOver) {
            allStartAnimOver = EventQueue.getInstance().allStartAnimOver(this);
        }
        if (Settings.TOUCH_DEVICE && unSelectChild && this.getParent() == null) {
            if (this.selectionDelayTimer >= selectedChildSelectionDelay + 1) {
                this.unselectChild();
            } else {
                ++this.selectionDelayTimer;
            }
        }
        ++this.visabilityTimer;
        if (this.getParent() == null) {
            EventQueue.getInstance().process(this);
        }
        g.translate(-this.scrolledX, -this.scrolledY);
        int transY = Settings.TRANSLATED_Y -= this.scrolledY;
        for (int idx = 0; idx < this.childrens.size(); ++idx) {
            Control control = (Control)this.childrens.elementAt(idx);
            if (transY + control.getY() + control.getHeight() < 0 || transY + control.getY() > Settings.SCREEN_HEIGHT || this.isClipData() && (control.getY() + control.getHeight() < this.scrolledY || control.getY() - this.scrolledY > this.getHeight())) continue;
            control.paintUI(g);
        }
        g.translate(this.scrolledX, this.scrolledY);
        Settings.TRANSLATED_Y += this.scrolledY;
    }

    protected void paintForground(Graphics g) {
        this.paintScrollBar(g);
        super.paintForground(g);
    }

    protected void paintScrollBar(Graphics g) {
        int percentage;
        int temp;
        if (this.totalHeight > this.getHeight() && this.verticalScrollBarVisabilityType != 2 && (this.verticalScrollBarVisabilityType == 0 || this.scrollType == 1 && this.visabilityTimer < this.hideInterval)) {
            int scrollBar_y = 0;
            this.barWidth = this.getWidth() * this.widthPersent / 100;
            if (this.barWidth < 2) {
                this.barWidth = 2;
            }
            temp = ((this.getBoundHeight() - 2) * 100 << 14) / this.totalHeight;
            int scrollSliderHeight = temp * (this.getBoundHeight() - 2) / 100 >> 14;
            percentage = (this.scrolledY + this.getBoundHeight() << 6) * 100 / this.totalHeight >> 6;
            scrollBar_y = (((this.getBoundHeight() - 1) * percentage << 14) / 100 >> 14) - scrollSliderHeight;
            if (this.scrolledY == 0) {
                scrollBar_y = 0;
            }
            g.setColor(Util.getColor(this.scrollBarColor));
            g.fillRect(this.getWidth() - this.barWidth - 2, scrollBar_y, this.barWidth, scrollSliderHeight);
        }
        if (this.totalWidth > this.getWidth() && this.verticalScrollBarVisabilityType != 2 && (this.verticalScrollBarVisabilityType == 0 || this.scrollType == 1 && this.visabilityTimer < this.hideInterval)) {
            int scrollBar_x = 0;
            this.barWidth = this.getHeight() * this.widthPersent / 100;
            if (this.barWidth < 2) {
                this.barWidth = 2;
            }
            temp = ((this.getBoundWidth() - 2) * 100 << 14) / this.totalWidth;
            int scrollSliderWidth = temp * (this.getBoundWidth() - 2) / 100 >> 14;
            percentage = (this.scrolledX + this.getBoundWidth() << 6) * 100 / this.totalWidth >> 6;
            scrollBar_x = (((this.getBoundWidth() - 1) * percentage << 14) / 100 >> 14) - scrollSliderWidth;
            if (this.scrolledX == 0) {
                scrollBar_x = 0;
            }
            g.setColor(Util.getColor(this.scrollBarColor));
            g.fillRect(scrollBar_x, this.getHeight() - this.barWidth - 2, scrollSliderWidth, this.barWidth);
        }
    }

    public void fourceSelect() {
        this.selected = true;
    }

    public boolean keyRepeated(int key, int gameKey) {
        Control control;
        if (this.selectedChild >= 0 && this.selectedChild < this.childrens.size() && (control = (Control)this.childrens.elementAt(this.selectedChild)).keyRepeated(key, gameKey)) {
            return true;
        }
        return super.keyRepeated(key, gameKey);
    }

    private boolean moveScrollBarHorizontal(int steps) {
        if (this.verticalScrollBarVisabilityType == 2) {
            return false;
        }
        int oldPos = this.scrolledX;
        if (steps > 0) {
            if (this.scrolledX + this.getBoundWidth() < this.totalWidth) {
                this.setScrolledX(this.scrolledX + steps);
            } else {
                this.setScrolledX(this.totalWidth - this.getBoundWidth());
            }
        } else if (steps < 0) {
            if (this.scrolledX > 0) {
                this.setScrolledX(this.scrolledX - Math.abs(steps));
            }
            if (this.scrolledX < 0) {
                this.setScrolledX(0);
            }
        }
        if (this.scrolledX != oldPos) {
            if (Settings.TOUCH_DEVICE && isAnyChildSelected) {
                unSelectChild = true;
            }
            return true;
        }
        return false;
    }

    private boolean moveScrollBarVertical(int steps) {
        if (this.verticalScrollBarVisabilityType == 2) {
            return false;
        }
        int oldPos = this.scrolledY;
        if (steps > 0) {
            if (this.scrolledY + this.getBoundHeight() < this.totalHeight) {
                this.setScrolledY(this.scrolledY + steps);
            } else {
                this.setScrolledY(this.totalHeight - this.getBoundHeight());
            }
        } else if (steps < 0) {
            if (this.scrolledY > 0) {
                this.setScrolledY(this.scrolledY - Math.abs(steps));
            }
            if (this.scrolledY < 0) {
                this.setScrolledY(0);
            }
        }
        if (this.scrolledY != oldPos) {
            if (Settings.TOUCH_DEVICE && isAnyChildSelected) {
                unSelectChild = true;
            }
            return true;
        }
        return false;
    }

    public boolean keyPressed(int keycode, int gameKey) {
        Control control;
        Settings.TOUCH_DEVICE = false;
        if (EventQueue.getInstance().isProcsseing() || !allStartAnimOver || isBringingToCenter) {
            return false;
        }
        if (this.softkeyHashTable != null && this.softkeyHashTable.get(keycode + "") != null) {
            Control c = (Control)this.softkeyHashTable.get(keycode + "");
            c.cutomKeyEventFired();
            return true;
        }
        if (this.singleSelectable) {
            switch (gameKey) {
                case 2: {
                    if (this.singleSelectableIndex > 0) {
                        --this.singleSelectableIndex;
                    }
                    return true;
                }
                case 5: {
                    if (this.singleSelectableIndex < this.getSize() - 1) {
                        ++this.singleSelectableIndex;
                    }
                    return true;
                }
            }
        }
        if (this.scrollType == 0) {
            if (this.totalHeight > this.getHeight() && (gameKey == 6 ? this.moveScrollBarVertical(15) : gameKey == 1 && this.moveScrollBarVertical(-15))) {
                return true;
            }
            if (this.totalWidth > this.getWidth() && (gameKey == 2 ? this.moveScrollBarHorizontal(-15) : gameKey == 5 && this.moveScrollBarHorizontal(15))) {
                return true;
            }
        }
        if (this.selectedChild >= 0 && this.selectedChild < this.childrens.size() && (control = (Control)this.childrens.elementAt(this.selectedChild)).keyPressed(keycode, gameKey)) {
            return true;
        }
        if (super.keyPressed(keycode, gameKey)) {
            return true;
        }
        int newIndex = -1;
        int findId = -1;
        if (this.selectedChild >= 0 && this.selectedChild < this.childrens.size() && ((Control)this.childrens.elementAt(this.selectedChild)).isSelected()) {
            Control control2 = (Control)this.childrens.elementAt(this.selectedChild);
            switch (gameKey) {
                case 2: {
                    findId = control2.leftChild;
                    break;
                }
                case 5: {
                    findId = control2.rightChild;
                    break;
                }
                case 1: {
                    findId = control2.upChild;
                    break;
                }
                case 6: {
                    findId = control2.downChild;
                }
            }
        }
        if (findId != -1) {
            return this.selectAnyChild(findId);
        }
        if (this.selector != null) {
            newIndex = this.selector.getNextChildIndex(gameKey, this.selectedChild, this);
        }
        if (newIndex == -1) {
            newIndex = this.getNextChildIndex(gameKey, this.selectedChild);
        }
        if (newIndex != -1 && newIndex != this.selectedChild) {
            this.selectChild(newIndex, false);
            return true;
        }
        if (this.totalHeight > this.getHeight()) {
            if (gameKey == 1) {
                this.setScrolledY(0);
            } else if (gameKey == 6) {
                this.setScrolledY(this.totalHeight - this.getBoundHeight());
            }
        }
        if (this.totalWidth > this.getWidth()) {
            if (gameKey == 2) {
                this.setScrolledX(0);
            } else if (gameKey == 5) {
                this.setScrolledX(this.totalWidth - this.getBoundWidth());
            }
        }
        return false;
    }

    public void setTakeEventIfNoScroll(boolean takeEventIfNoScroll) {
        this.takeEventIfNoScroll = takeEventIfNoScroll;
    }

    public void setScrolledX(int scrolledX) {
        if (this.scrolledX != scrolledX) {
            didScrolled = true;
        }
        this.scrolledX = scrolledX;
    }

    public void setScrolledY(int scrolledY) {
        if (this.scrolledY != scrolledY) {
            didScrolled = true;
        }
        this.scrolledY = scrolledY;
    }

    int getNextChildIndex(int gameKey, int index) {
        int oldIndex = -1;
        if (index >= 0 && index < this.childrens.size()) {
            Control currentChild = (Control)this.childrens.elementAt(index);
            int currentPosX = currentChild.getX();
            int currentPosY = currentChild.getY();
            switch (gameKey) {
                case 1: {
                    currentPosX += currentChild.getWidth() >> 1;
                    break;
                }
                case 6: {
                    currentPosY += currentChild.getHeight();
                    currentPosX += currentChild.getWidth() >> 1;
                    break;
                }
                case 2: {
                    currentPosY += currentChild.getHeight() >> 1;
                    break;
                }
                case 5: {
                    currentPosY += currentChild.getHeight() >> 1;
                    currentPosX += currentChild.getWidth();
                }
            }
            int oldDist = Integer.MAX_VALUE;
            for (int i = 0; i < this.childrens.size(); ++i) {
                int dist;
                Control control = (Control)this.childrens.elementAt(i);
                boolean shellSelect = this.shellSelectControl(control);
                if (!control.isVisible() || !control.isSelectable() || !shellSelect) continue;
                int controlX = control.getX() + (control.getWidth() >> 1);
                int controlY = control.getY() + (control.getHeight() >> 1);
                if (!(gameKey == 1 && controlY < currentPosY || gameKey == 6 && controlY > currentPosY || gameKey == 2 && controlX < currentPosX) && (gameKey != 5 || controlX <= currentPosX) || (dist = Util.getApproxDistance(controlX, controlY, currentPosX, currentPosY)) >= oldDist) continue;
                oldDist = dist;
                oldIndex = i;
            }
        }
        return oldIndex;
    }

    public void resetSelecton() {
        this.selectedChild = 0;
        for (int i = 0; i < this.childrens.size(); ++i) {
            if (!(this.childrens.elementAt(i) instanceof Container)) continue;
            ((Container)this.childrens.elementAt(i)).resetSelecton();
        }
    }

    public void setSelected(boolean selected, boolean isFromTouch) {
        System.out.println("this: " + this + " select: " + selected);
        super.setSelected(selected, isFromTouch);
        if (selected) {
            if (this.selectedChild >= 0 && this.selectedChild < this.childrens.size()) {
                Control control = (Control)this.childrens.elementAt(this.selectedChild);
                boolean shellSelect = this.shellSelectControl(control);
                if (!control.isSelectable() || !shellSelect) {
                    this.selectedChild = -1;
                    for (int i = 0; i < this.childrens.size(); ++i) {
                        Control object = (Control)this.childrens.elementAt(i);
                        shellSelect = this.shellSelectControl(object);
                        if (!object.isSelectable() || !shellSelect) continue;
                        this.selectedChild = i;
                        break;
                    }
                }
                if (this.selectedChild != -1) {
                    this.selectChild(this.selectedChild, isFromTouch);
                }
            }
        } else if (this.selectedChild >= 0 && this.selectedChild < this.childrens.size()) {
            Control control = (Control)this.childrens.elementAt(this.selectedChild);
            control.setSelected(false);
        }
    }

    public void setSelected(boolean selected) {
        this.setSelected(selected, false);
    }

    private boolean selectAnyChild(int id) {
        if (id == -1) {
            return false;
        }
        Container root = this;
        Container ownerParent = this;
        boolean success = false;
        while (root.getParent() != null) {
            root = root.getParent();
        }
        ownerParent = this.findAndSelectOwnChild(id);
        boolean bl = success = ownerParent != null;
        if (ownerParent != null) {
            while (ownerParent.getParent() != null) {
                int index = ownerParent.getParent().getChildrenIndex(ownerParent);
                ownerParent.getParent().selectChild(index, false);
                ownerParent = ownerParent.getParent();
            }
        }
        return success;
    }

    public void selectChild(Control child, boolean isFromTouch) {
        int index = this.childrens.indexOf(child);
        this.selectChild(index, isFromTouch);
    }

    public void selectChild(int index, boolean isFromTouch) {
        Control control;
        if (this.selectedChild >= 0 && this.selectedChild < this.childrens.size()) {
            control = (Control)this.childrens.elementAt(this.selectedChild);
            control.setSelected(false, isFromTouch);
        }
        if (index >= 0 && index < this.childrens.size()) {
            control = (Control)this.childrens.elementAt(index);
            if (Settings.TOUCH_DEVICE) {
                this.unselectChild();
                isAnyChildSelected = true;
                this.selectionDelayTimer = 0;
                selectedChildSelectionDelay = control.getDelayInSelection();
                if (control instanceof ScrollableContainer) {
                    ((ScrollableContainer)control).selectedChild = -1;
                }
            }
            control.setSelected(true, isFromTouch);
            if (this.selectedChild != index && this.getEventListener() != null) {
                this.getEventListener().event(new Event(1, control, new Integer(index)));
            }
            this.selectedChild = index;
            if (!isFromTouch) {
                if (this.scrollType == 1 && (Control)this.childrens.elementAt(this.selectedChild) instanceof Container) {
                    Control container = (Control)this.childrens.elementAt(this.selectedChild);
                    if (this.totalHeight > this.getHeight()) {
                        if (this.selectedChild == this.upperMostElement) {
                            this.setScrolledY(this.getScrolledY(container, 0));
                        } else {
                            this.setScrolledY(this.getScrolledY(container, this.scrolledY));
                        }
                    }
                    if (this.totalWidth > this.getWidth()) {
                        if (this.selectedChild == this.leftMostElement) {
                            this.setScrolledX(this.getScrolledX(container, 0));
                        } else {
                            this.setScrolledX(this.getScrolledX(container, this.scrolledX));
                        }
                    }
                } else {
                    this.setScrollBarPositionVertical(((Control)this.childrens.elementAt(this.selectedChild)).getY(), ((Control)this.childrens.elementAt(this.selectedChild)).getHeight());
                    this.setScrollBarPositionHorizontal(((Control)this.childrens.elementAt(this.selectedChild)).getX(), ((Control)this.childrens.elementAt(this.selectedChild)).getWidth());
                }
            }
        }
    }

    private int getScrolledY(Control base, int virtualScrollHeight) {
        int tmpHeight = 0;
        if (base instanceof ScrollableContainer && !((ScrollableContainer)base).groupSelect) {
            int _yPos = 0;
            Control component = base;
            while (component instanceof ScrollableContainer && !((ScrollableContainer)component).groupSelect) {
                _yPos += component.getY();
                Control tmp = ((ScrollableContainer)component).getSelectedChild();
                if (tmp == null) {
                    _yPos -= component.getY();
                    break;
                }
                component = tmp;
            }
            if (component != null) {
                if (_yPos + component.getY() + component.getHeight() >= this.getHeight() + virtualScrollHeight) {
                    tmpHeight = _yPos + component.getY() + component.getHeight() - this.getHeight();
                } else if (_yPos + component.getY() < virtualScrollHeight) {
                    tmpHeight = _yPos + component.getY();
                }
            }
        } else if (base.getY() + base.getHeight() >= this.getHeight() + virtualScrollHeight) {
            tmpHeight = base.getY() + base.getHeight() - this.getHeight();
        } else if (base.getY() < virtualScrollHeight) {
            tmpHeight = base.getY();
        }
        if (tmpHeight == 0) {
            return virtualScrollHeight;
        }
        return tmpHeight;
    }

    private int getScrolledX(Control base, int virtualScrollWidth) {
        int tmpWidth = 0;
        if (base instanceof ScrollableContainer && !((ScrollableContainer)base).groupSelect) {
            int _xPos = 0;
            Control component = base;
            while (component instanceof ScrollableContainer && !((ScrollableContainer)base).groupSelect) {
                _xPos += component.getX();
                Control tmp = ((ScrollableContainer)component).getSelectedChild();
                if (tmp == null) {
                    _xPos -= component.getX();
                    break;
                }
                component = tmp;
            }
            if (component != null) {
                if (_xPos + component.getX() + component.getWidth() >= this.getWidth() + virtualScrollWidth) {
                    tmpWidth = _xPos + component.getX() + component.getWidth() - this.getWidth();
                } else if (_xPos + component.getX() < virtualScrollWidth) {
                    tmpWidth = _xPos + component.getX();
                }
            }
        } else if (base.getX() + base.getWidth() >= this.getWidth() + virtualScrollWidth) {
            tmpWidth = base.getX() + base.getWidth() - this.getWidth();
        } else if (base.getX() < virtualScrollWidth) {
            tmpWidth = base.getX();
        }
        if (tmpWidth == 0) {
            return virtualScrollWidth;
        }
        return tmpWidth;
    }

    private static int getAvailableWidth(Control control, Container parent) {
        int widthAvailable = parent.getBoundWidth();
        for (int i = 0; i < parent.getSize(); ++i) {
            Control controlToCheck = parent.getChild(i);
            if (controlToCheck.getId() == control.getId() || controlToCheck.getWidthWeight() != 0 && controlToCheck.getWidthWeight() != -2) continue;
            widthAvailable -= controlToCheck.getWidth();
        }
        return widthAvailable;
    }

    private static int getAvailableHeight(Control control, Container parent) {
        int widthAvailable = parent.getBoundHeight();
        for (int i = 0; i < parent.getSize(); ++i) {
            Control controlToCheck = parent.getChild(i);
            if (controlToCheck.getId() == control.getId() || controlToCheck.getHeightWeight() != 0 && controlToCheck.getHeightWeight() != -2) continue;
            widthAvailable -= controlToCheck.getHeight();
        }
        return widthAvailable;
    }

    public void stretchDimentions() {
        for (int i = 0; i < this.childrens.size(); ++i) {
            int newW;
            Control control = (Control)this.childrens.elementAt(i);
            if (control.getWidthWeight() > 0) {
                newW = ScrollableContainer.getAvailableWidth(control, this);
                control.setWidth(newW * control.getWidthWeight() / 100);
            }
            if (control.getHeightWeight() > 0) {
                newW = ScrollableContainer.getAvailableHeight(control, this);
                control.setHeight(newW * control.getHeightWeight() / 100);
            }
            if (!(control instanceof Container)) continue;
            ((Container)control).stretchDimentions();
        }
    }

    private boolean isAnyChildSelectable() {
        for (int i = 0; i < this.childrens.size(); ++i) {
            Control object = (Control)this.childrens.elementAt(i);
            if (!object.isSelectable()) continue;
            return true;
        }
        return false;
    }

    public boolean shellSelectControl(Control c) {
        if (c instanceof ScrollableContainer) {
            boolean anyChildSelectable = true;
            anyChildSelectable = ((ScrollableContainer)c).isAnyChildSelectable();
            if (((ScrollableContainer)c).isGroupSelect()) {
                return true;
            }
            return anyChildSelectable;
        }
        return true;
    }

    private void calculateTotalHeight() {
        int actHeight = 0;
        int actWidth = 0;
        this.upperMostElement = -1;
        this.totalHeight = 0;
        this.barWidth = 0;
        this.totalWidth = 0;
        for (int i = 0; i < this.childrens.size(); ++i) {
            Control control = (Control)this.childrens.elementAt(i);
            if ((this.upperMostElement == -1 || ((Control)this.childrens.elementAt(i)).getY() < ((Control)this.childrens.elementAt(this.upperMostElement)).getY()) && ((Control)this.childrens.elementAt(i)).isSelectable()) {
                this.upperMostElement = i;
            }
            if ((this.leftMostElement == -1 || ((Control)this.childrens.elementAt(i)).getX() < ((Control)this.childrens.elementAt(this.leftMostElement)).getX()) && ((Control)this.childrens.elementAt(i)).isSelectable()) {
                this.leftMostElement = i;
            }
            if (control.getY() + control.getHeight() > actHeight && !control.isSkipParentWrapSizeCalc()) {
                actHeight = control.getY() + control.getHeight();
            }
            if (control.getX() + control.getWidth() > actWidth && !control.isSkipParentWrapSizeCalc()) {
                actWidth = control.getX() + control.getWidth();
            }
            if (Settings.TOUCH_DEVICE || !selectChild) continue;
            if (this.defaultSelection == -1) {
                boolean anyChildSelectable = this.shellSelectControl(control);
                if (control.isSelectable() && control.isVisible() && anyChildSelectable) {
                    selectChild = false;
                    this.selectChild(i, false);
                    continue;
                }
                control.setSelected(false);
                continue;
            }
            selectChild = false;
            this.selectDefaultChild();
        }
        if (actHeight > this.getHeight()) {
            this.totalHeight = actHeight;
            this.scrolledY = this.staticScrolledPos;
        }
        if (actWidth > this.getWidth()) {
            this.totalWidth = actWidth;
            this.scrolledX = this.staticScrolledPos;
        }
    }

    private void selectDefaultChild() {
        for (int j = 0; j < this.childrens.size(); ++j) {
            if (this.getChild(j).getId() != this.defaultSelection) continue;
            this.selectChild(j, false);
            if (!(this.getChild(j) instanceof ScrollableContainer) || ((ScrollableContainer)this.getChild(j)).getDefaultSelection() == -1) break;
            ((ScrollableContainer)this.getChild(j)).selectDefaultChild();
            break;
        }
    }

    public int getScrolledX() {
        return this.scrolledX;
    }

    public int getScrolledY() {
        return this.scrolledY;
    }

    public void initShowNotify() {
        this.restoreOriogionalXY();
        this.resize();
        this.stretchDimentions();
        this.showNotify();
        for (int i = 0; i < this.childrens.size(); ++i) {
            Control control = (Control)this.childrens.elementAt(i);
            control.showNotify();
        }
        this.resize();
        this.stretchDimentions();
        this.resize();
    }

    public void showNotify() {
        unSelectChild = false;
        isAnyChildSelected = false;
        allStartAnimOver = false;
        for (int i = 0; i < this.childrens.size(); ++i) {
            Control control = (Control)this.childrens.elementAt(i);
            control.showNotify();
        }
        super.showNotify();
        if (this.getParent() == null) {
            selectChild = true;
        }
        this.calculateTotalHeight();
    }

    public void setSelectChild(boolean value) {
        selectChild = value;
    }

    protected boolean isVerticalScrollBarPresent() {
        return this.totalHeight > this.getHeight();
    }

    protected boolean isHorizontalScrollBarPresent() {
        return this.totalWidth > this.getWidth();
    }

    public void hideNotify() {
        this.setScrolledX(0);
        this.setScrolledY(0);
        selectChild = true;
        super.hideNotify();
        for (int i = 0; i < this.childrens.size(); ++i) {
            Control control = (Control)this.childrens.elementAt(i);
            control.hideNotify();
        }
    }

    public void takeScrollBackup() {
        this.scrolledBackupX = this.scrolledX;
        this.scrolledBackupY = this.scrolledY;
        for (int i = 0; i < this.childrens.size(); ++i) {
            Control control = (Control)this.childrens.elementAt(i);
            if (!(control instanceof Container)) continue;
            ((Container)control).takeScrollBackup();
        }
    }

    public void restoreScrollBackup() {
        this.scrolledX = this.scrolledBackupX;
        this.scrolledY = this.scrolledBackupY;
        for (int i = 0; i < this.childrens.size(); ++i) {
            Control control = (Control)this.childrens.elementAt(i);
            if (!(control instanceof Container)) continue;
            ((Container)control).restoreScrollBackup();
        }
    }

    public void unselectChild() {
        for (int i = 0; i < this.childrens.size(); ++i) {
            ((Control)this.childrens.elementAt(i)).setSelected(false);
        }
        unSelectChild = false;
        isAnyChildSelected = false;
        this.selectionDelayTimer = 0;
        selectedChildSelectionDelay = 0;
    }

    public void scrollTillLast() {
        if (this.totalHeight > this.getHeight()) {
            this.setScrolledY(this.totalHeight - this.getHeight());
        }
    }

    public int getDrawingYPos() {
        return this.getY();
    }

    public int getDrawingXPos() {
        return this.getX();
    }

    public void setScrollBarPositionVertical(int yPos, int controlHeight) {
        if (this.totalHeight <= this.getHeight()) {
            if (this.getParent() != null && this.getParent() instanceof ScrollableContainer) {
                ((ScrollableContainer)this.getParent()).setScrollBarPositionVertical(this.getDrawingYPos() + yPos - this.totalHeight, controlHeight);
            }
        } else {
            if (this.selectedChild == this.upperMostElement) {
                this.setScrolledY(this.getScrolledY((Control)this.childrens.elementAt(this.selectedChild), 0));
            } else if (yPos + controlHeight >= this.getHeight() + this.scrolledY) {
                this.setScrolledY(yPos + controlHeight - this.getHeight());
            } else if (yPos < this.scrolledY) {
                this.setScrolledY(yPos);
            }
            if (this.getParent() != null && this.getParent() instanceof ScrollableContainer) {
                ((ScrollableContainer)this.getParent()).setScrollBarPositionVertical(this.getDrawingYPos() + yPos - this.scrolledY, controlHeight);
            }
        }
    }

    public void setScrollBarPositionHorizontal(int xPos, int controlWidth) {
        if (this.totalWidth <= this.getWidth()) {
            if (this.getParent() != null && this.getParent() instanceof ScrollableContainer) {
                ((ScrollableContainer)this.getParent()).setScrollBarPositionHorizontal(this.getDrawingXPos() + xPos - this.totalWidth, controlWidth);
            }
        } else {
            if (this.selectedChild == this.leftMostElement) {
                this.setScrolledX(this.getScrolledX((Control)this.childrens.elementAt(this.selectedChild), 0));
            } else if (xPos + controlWidth >= this.getWidth() + this.scrolledX) {
                this.setScrolledX(xPos + controlWidth - this.getWidth());
            } else if (xPos < this.scrolledX) {
                this.setScrolledX(xPos);
            }
            if (this.getParent() != null && this.getParent() instanceof ScrollableContainer) {
                ((ScrollableContainer)this.getParent()).setScrollBarPositionHorizontal(this.getDrawingXPos() + xPos - this.scrolledX, controlWidth);
            }
        }
    }

    public String toString() {
        return "Container- ID: " + this.getId();
    }

    private void updateScrollFromVelocity() {
        long newVel;
        if (this.totalWidth > this.getWidth() && this.velocityX != 0L) {
            this.setScrolledX(this.scrolledX + ((int)(this.velocityX * 15L) >> 7));
            if (this.scrolledX < 0) {
                this.setScrolledX(0);
                this.velocityX = 0L;
            } else if (this.scrolledX > this.totalWidth - this.getWidth()) {
                this.setScrolledX(this.totalWidth - this.getWidth());
                this.velocityX = 0L;
            } else {
                newVel = 0L;
                newVel = this.velocityX > 0L ? this.velocityX - (long)this.FRICTION : this.velocityX + (long)this.FRICTION;
                if (this.velocityX > 0L) {
                    this.velocityX = newVel < 0L ? 0L : newVel;
                }
                if (this.velocityX < 0L) {
                    this.velocityX = newVel > 0L ? 0L : newVel;
                }
            }
        }
        if (this.totalHeight > this.getHeight() && this.velocityY != 0L) {
            this.setScrolledY(this.scrolledY + (int)(this.velocityY * 15L >> 7));
            if (this.scrolledY < 0) {
                this.setScrolledY(0);
                this.velocityY = 0L;
            } else if (this.scrolledY > this.totalHeight - this.getHeight()) {
                this.setScrolledY(this.totalHeight - this.getHeight());
                this.velocityY = 0L;
            } else {
                newVel = 0L;
                newVel = this.velocityY > 0L ? this.velocityY - (long)this.FRICTION : this.velocityY + (long)this.FRICTION;
                if (this.velocityY > 0L) {
                    this.velocityY = newVel < 0L ? 0L : newVel;
                }
                if (this.velocityY < 0L) {
                    this.velocityY = newVel > 0L ? 0L : newVel;
                }
            }
        }
    }

    private void checkSingleSelectControlIndex() {
        if (!this.singleSelectable) {
            return;
        }
        int _index = -1;
        int centerX = this.getWidth() >> 1;
        int perCheck = 15;
        int dist = this.getWidth() * perCheck / 100;
        for (int i = 0; i < this.getSize(); ++i) {
            if (direction == 2) {
                if (!Util.isRectCollision(this.getWidth() - dist, 0, dist, this.getHeight(), this.getChild(i).getX() - this.scrolledX, 0, this.getChild(i).getWidth(), this.getHeight())) continue;
                _index = i;
                break;
            }
            if (!Util.isRectCollision(0, 0, dist, this.getHeight(), this.getChild(i).getX() - this.scrolledX, 0, this.getChild(i).getWidth(), this.getHeight())) continue;
            _index = i;
            break;
        }
        if (_index != -1) {
            this.singleSelectableIndex = _index;
        }
    }

    private void bringControlToCenter() {
        if (this.singleSelectable && !fromPointerDrag) {
            int speed = this.getWidth() * 10 / 100;
            int finalPos = this.getWidth() - this.getChild(this.singleSelectableIndex).getWidth() >> 1;
            if (this.scrolledX - this.getChild(this.singleSelectableIndex).getX() < finalPos) {
                isBringingToCenter = true;
                this.scrolledX += speed;
                if (this.scrolledX - this.getChild(this.singleSelectableIndex).getX() >= finalPos) {
                    isBringingToCenter = false;
                    this.scrolledX = Math.abs(finalPos - this.getChild(this.singleSelectableIndex).getX());
                    this.selectChild(this.singleSelectableIndex, true);
                }
            } else if (this.scrolledX - this.getChild(this.singleSelectableIndex).getX() > finalPos) {
                isBringingToCenter = true;
                this.scrolledX -= speed;
                if (this.scrolledX - this.getChild(this.singleSelectableIndex).getX() <= finalPos) {
                    isBringingToCenter = false;
                    this.scrolledX = Math.abs(finalPos - this.getChild(this.singleSelectableIndex).getX());
                    this.selectChild(this.singleSelectableIndex, true);
                }
            }
        }
    }

    public void setSingleSelectable(boolean singleSelectable) {
        this.singleSelectable = singleSelectable;
    }

    public boolean pointerPressed(int x, int y) {
        Settings.TOUCH_DEVICE = true;
        didScrolled = false;
        if (EventQueue.getInstance().isProcsseing() || !allStartAnimOver) {
            return false;
        }
        if (this.getParent() == null) {
            oldY = y;
            oldX = x;
        }
        if (this.velocityX > 0L || this.velocityY > 0L) {
            this.velocityX = 0L;
            this.velocityY = 0L;
            this.lastTouchTime = System.currentTimeMillis();
            this.lastTouchPressedX = x;
            this.lastTouchPressedY = y;
            this.doNotHandleRelease = true;
            return true;
        }
        this.velocityX = 0L;
        this.velocityY = 0L;
        this.lastTouchTime = System.currentTimeMillis();
        this.lastTouchPressedX = x;
        this.lastTouchPressedY = y;
        this.doNotHandleRelease = false;
        for (int idx = 0; idx < this.childrens.size(); ++idx) {
            boolean handle;
            Control control = (Control)this.childrens.elementAt(idx);
            if (!control.isSelectable() && !control.isTouchSelectable() || !control.isVisible() || !Util.isInRect(control, x - this.getX() - this.getLeftInBound() + this.scrolledX, y - this.getY() - this.getTopInBound() + this.scrolledY)) continue;
            if (!control.isSelected()) {
                this.selectChild(idx, true);
            }
            if (!(handle = control.pointerPressed(x - this.getX() - this.getLeftInBound() + this.scrolledX, y - this.getY() - this.getTopInBound() + this.scrolledY))) continue;
            return true;
        }
        return super.pointerPressed(x, y);
    }

    public synchronized boolean pointerReleased(int x, int y) {
        boolean handle;
        if (EventQueue.getInstance().isProcsseing() || !allStartAnimOver) {
            return false;
        }
        if (Settings.TOUCH_DEVICE) {
            if (this.getParent() == null && fromPointerDrag && !didScrolled && this.takeEventIfNoScroll) {
                fromPointerDrag = false;
            }
            if (isAnyChildSelected) {
                unSelectChild = true;
            }
        }
        didScrolled = false;
        if (this.doNotHandleRelease) {
            return true;
        }
        if (fromPointerDrag) {
            long timeDiff = System.currentTimeMillis() - this.lastTouchTime;
            if (timeDiff > 0L && !this.singleSelectable) {
                int maxVelocity;
                if (this.totalWidth > this.getWidth()) {
                    this.velocityX = (long)((this.lastTouchPressedX - x) * 2 << 7) / timeDiff;
                    maxVelocity = ((this.totalWidth - this.getWidth()) * 10 << 7) / 1500 + this.FRICTION * 10;
                    if (this.velocityX < 0L) {
                        maxVelocity = -maxVelocity;
                    }
                    if (Math.abs(this.velocityX) > (long)Math.abs(maxVelocity)) {
                        this.velocityX = maxVelocity;
                    }
                    if (Math.abs(this.velocityX) < (long)this.MINIMUM_VELOCITY) {
                        this.velocityX = 0L;
                        this.checkSingleSelectControlIndex();
                    }
                }
                if (this.totalHeight > this.getHeight()) {
                    this.velocityY = (long)((this.lastTouchPressedY - y) * 2 << 7) / timeDiff;
                    maxVelocity = ((this.getTotalHeight() - this.getHeight()) * 10 << 7) / 1500 + this.FRICTION * 10;
                    if (this.velocityY < 0L) {
                        maxVelocity = -maxVelocity;
                    }
                    if (Math.abs(this.velocityY) > (long)Math.abs(maxVelocity)) {
                        this.velocityY = maxVelocity;
                    }
                    if (Math.abs(this.velocityY) < (long)this.MINIMUM_VELOCITY) {
                        this.velocityY = 0L;
                    }
                }
            } else {
                this.checkSingleSelectControlIndex();
            }
            this.lastTouchPressedX = x;
            this.lastTouchPressedY = y;
        }
        for (int idx = 0; idx < this.childrens.size(); ++idx) {
            boolean handle2;
            Control control = (Control)this.childrens.elementAt(idx);
            if (!control.isTouchSelectable() && !control.isSelectable() || !control.isVisible() || !Util.isInRect(control, x - this.getX() - this.getLeftInBound() + this.scrolledX, y - this.getY() - this.getTopInBound() + this.scrolledY) || !(handle2 = control.pointerReleased(x - this.getX() - this.getLeftInBound() + this.scrolledX, y - this.getY() - this.getTopInBound() + this.scrolledY))) continue;
            return true;
        }
        boolean bl = handle = super.pointerReleased(x, y) && fromPointerDrag;
        if (fromPointerDrag && this.getParent() == null) {
            fromPointerDrag = false;
        }
        return handle;
    }

    public synchronized boolean pointerDragged(int x, int y) {
        if (EventQueue.getInstance().isProcsseing() || !allStartAnimOver) {
            return false;
        }
        if (this.getParent() == null) {
            diffrenceY = oldY - y;
            diffrenceX = oldX - x;
            direction = diffrenceX > 0 ? 2 : 5;
            if (!fromPointerDrag) {
                if (Math.abs(diffrenceX) >= 12 || Math.abs(diffrenceY) >= 12) {
                    fromPointerDrag = true;
                } else {
                    return false;
                }
            }
            oldY = y;
            oldX = x;
        }
        for (int idx = 0; idx < this.childrens.size(); ++idx) {
            Control control = (Control)this.childrens.elementAt(idx);
            if (!control.isSelectable() && !control.isTouchSelectable() || !control.isVisible() || !Util.isInRect(control, x - this.getX() - this.getLeftInBound() + this.scrolledX, y - this.getY() - this.getTopInBound() + this.scrolledY) || !control.pointerDragged(x - this.getX() - this.getLeftInBound() + this.scrolledX, y - this.getY() - this.getTopInBound() + this.scrolledY)) continue;
            return true;
        }
        if (this.totalHeight > this.getHeight() && this.moveScrollBarVertical(diffrenceY)) {
            return true;
        }
        return this.totalWidth > this.getWidth() && this.moveScrollBarHorizontal(diffrenceX);
    }

    public int getClassCode() {
        return 1005;
    }

    public byte[] serialize() throws Exception {
        return null;
    }

    public ByteArrayInputStream deserialize(ByteArrayInputStream bis) throws Exception {
        super.deserialize(bis);
        this.setScrollBarVisabilityType(Util.readInt(bis, 1));
        this.setScrollBarColor(Util.readColor(bis));
        this.setWidthPersent(Util.readInt(bis, 1));
        this.setHideInterval(Util.readInt(bis, 1));
        this.setScrollType(Util.readInt(bis, 1));
        this.setDefaultSelection(Util.readSignedInt(bis, 2));
        this.setGroupSelect(Util.readBoolean(bis));
        this.childrens = (Vector)MenuSerilize.deserialize(bis, MenuSerilize.getInstance());
        for (int i = 0; i < this.childrens.size(); ++i) {
            ((Control)this.childrens.elementAt(i)).setParent(this);
        }
        bis.close();
        return null;
    }

    public void port() {
        super.port();
        for (int i = 0; i < this.childrens.size(); ++i) {
            Control object = (Control)this.childrens.elementAt(i);
            object.port();
            if (object.getRelativeLocation() != null) {
                object.getRelativeLocation().port();
            }
            if (object.getLayout() != null) {
                object.getLayout().port();
            }
            if (object.getStartAnimation() != null) {
                object.getStartAnimation().port();
            }
            if (object.getEndAnimation() == null) continue;
            object.getEndAnimation().port();
        }
    }

    public void cleanup() {
        super.cleanup();
        for (int i = 0; i < this.getSize(); ++i) {
            ((Control)this.childrens.elementAt(i)).cleanup();
        }
        this.childrens.removeAllElements();
        this.selector = null;
    }
}

