/*
 * Decompiled with CFR 0.152.
 */
package com.appon.miniframework.controls;

import com.appon.miniframework.Control;
import com.appon.miniframework.ResourceManager;
import com.appon.miniframework.Util;
import java.io.ByteArrayInputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class ImageControl
extends Control {
    private Image icon;
    public static final int LEFT_ALLIGN = 0;
    public static final int CENTER_ALLIGN = 1;
    public static final int RIGHT_ALLIGN = 2;
    public static final int TOP_ALLIGN = 0;
    public static final int BOTTOM_ALLIGN = 2;
    private int xAllign = 0;
    private int yAllign = 0;
    private int iconResourceId = -1;

    public ImageControl() {
        super(-1);
    }

    public ImageControl(int id) {
        super(id);
    }

    public void setIcon(Image icon) {
        this.icon = icon;
    }

    public Image getIcon() {
        return this.icon;
    }

    public int getIconResourceId() {
        return this.iconResourceId;
    }

    public void setIconResourceId(int iconResourceId) {
        this.iconResourceId = iconResourceId;
    }

    public void setXAllign(int xAllign) {
        this.xAllign = xAllign;
    }

    public void setYAllign(int yAllign) {
        this.yAllign = yAllign;
    }

    public int getYAllign() {
        return this.yAllign;
    }

    public int getXAllign() {
        return this.xAllign;
    }

    public void paint(Graphics g) {
        if (this.icon == null) {
            return;
        }
        int _x = 0;
        int _y = 0;
        if (this.xAllign == 2) {
            _x = this.getBoundWidth() - Util.getImageWidth(this.icon);
        } else if (this.xAllign == 1) {
            _x = this.getBoundWidth() - Util.getImageWidth(this.icon) >> 1;
        }
        if (this.yAllign == 2) {
            _y = this.getBoundHeight() - Util.getImageHeight(this.icon);
        } else if (this.yAllign == 1) {
            _y = this.getBoundHeight() - Util.getImageHeight(this.icon) >> 1;
        }
        Util.drawImage(g, this.icon, _x, _y);
    }

    public int getPreferredWidth() {
        if (this.icon == null) {
            return 20;
        }
        return Util.getImageWidth(this.icon) + this.getLeftInBound() + this.getRightInBound();
    }

    public int getPreferredHeight() {
        if (this.icon == null) {
            return 20;
        }
        return Util.getImageHeight(this.icon) + this.getTopInBound() + this.getBottomInBound();
    }

    public String toString() {
        return "ImageControl-" + this.getId();
    }

    public int getClassCode() {
        return 1001;
    }

    public byte[] serialize() throws Exception {
        return null;
    }

    public ByteArrayInputStream deserialize(ByteArrayInputStream bis) throws Exception {
        super.deserialize(bis);
        this.setIconResourceId(Util.readInt(bis, 1));
        this.setIcon(ResourceManager.getInstance().getImageResource(this.getIconResourceId()));
        this.setXAllign(Util.readInt(bis, 1));
        this.setYAllign(Util.readInt(bis, 1));
        bis.close();
        return null;
    }

    public void cleanup() {
        super.cleanup();
        this.icon = null;
    }
}

