/*
 * Decompiled with CFR 0.152.
 */
package com.indiagames.arjunprince;

import com.appon.gtantra.GAnim;
import com.appon.gtantra.GTantra;
import com.appon.util.Util;
import com.indiagames.arjunprince.Constant;
import com.indiagames.arjunprince.FightSystem;
import com.indiagames.arjunprince.FighterCharactor;

public class FighterHero
extends FighterCharactor {
    private static int attackIdGenerator;
    private int currentHitId;
    FightSystem system;
    private int heroHelth;
    private int heroDamage;

    public FighterHero(GTantra tantra, int screenWidth, FightSystem system, int heroHelth, int heroDamage) {
        super(tantra, screenWidth, 0, heroHelth, heroDamage);
        this.system = system;
        this.heroHelth = heroHelth;
        this.heroDamage = heroDamage;
    }

    public int generateAttackId() {
        return attackIdGenerator++;
    }

    public int getHeroHelth() {
        return this.heroHelth;
    }

    public void init() {
        this.attackRight = new GAnim[2];
        this.attackLeft = new GAnim[2];
        this.runRight = new GAnim(this.tantra, 0);
        this.runLeft = new GAnim(this.tantra, 20);
        this.attackRight[0] = new GAnim(this.tantra, 16);
        this.attackRight[1] = new GAnim(this.tantra, 17);
        this.attackLeft[0] = new GAnim(this.tantra, 21);
        this.attackLeft[1] = new GAnim(this.tantra, 22);
        this.standLeft = new GAnim(this.tantra, 25);
        this.standRight = new GAnim(this.tantra, 24);
        this.heroX = Constant.HERO_X_POS;
        this.jumpAttackRight = new GAnim(this.tantra, 18);
        this.jumpAttackLeft = new GAnim(this.tantra, 23);
        this.bloodRight = new GAnim(Constant.effectsTantra, 3);
        this.bloodLeft = new GAnim(Constant.effectsTantra, 8);
    }

    public void keyPressed(int gameKey) {
        if (!this.isHitting()) {
            if (Util.isUpPressed(gameKey)) {
                this.setState(3);
                this.jumpAttackLeft.reset();
                this.jumpAttackRight.reset();
                this.leftAttack_Jump_Effect.reset();
                this.rightAttack_Jump_Effect.reset();
                this.movedSoFar = 0;
            } else if (Util.isLeftPressed(gameKey)) {
                if (this.getDirection() == 0) {
                    this.movedSoFar = 0;
                    this.setState(1);
                }
                this.setDirection(0);
            } else if (Util.isRightPressed(gameKey)) {
                if (this.getDirection() == 1) {
                    this.movedSoFar = 0;
                    this.setState(1);
                }
                this.setDirection(1);
            } else if (Util.isFirePressed(gameKey)) {
                this.hittingAnimId = FighterHero.getRandomNumber(0, 2);
                this.attackRight[this.hittingAnimId].reset();
                this.attackLeft[this.hittingAnimId].reset();
                this.leftAttackEffect[this.hittingAnimId].reset();
                this.rightAttackEffect[this.hittingAnimId].reset();
                this.setState(2);
                this.currentHitId = this.generateAttackId();
            }
        }
    }

    public void pointerPress(int x, int y) {
        if (!this.isHitting()) {
            // empty if block
        }
    }

    public void update() {
        if (this.isHitting() && this.getCurrentGAnim().getAnimationCurrentCycle() != 0) {
            this.collisionRect = this.getCurrentSwordCollsionRect();
            this.system.heroAttacked(this.collisionRect[0], this.collisionRect[1], this.collisionRect[2], this.collisionRect[3], this.currentHitId, this.getHeroDamage());
        }
        switch (this.state) {
            case 3: {
                boolean over = false;
                if (this.direction == 0) {
                    over = this.jumpAttackLeft.isAnimationOver();
                    this.heroX -= 5;
                    if (this.heroX - this.getCurrentGAnim().getCurrentFrameWidth() < 0) {
                        this.heroX = this.getCurrentGAnim().getCurrentFrameWidth();
                    }
                } else {
                    over = this.jumpAttackRight.isAnimationOver();
                    this.heroX += 5;
                    if (this.heroX + this.getCurrentGAnim().getCurrentFrameWidth() > SCREEN_WIDTH) {
                        this.heroX = SCREEN_WIDTH - this.getCurrentGAnim().getCurrentFrameWidth();
                    }
                }
                this.movedSoFar += 5;
                if (!over) break;
                this.movedSoFar = 0;
                this.setState(0);
                break;
            }
            case 1: {
                if (this.direction == 0) {
                    this.heroX -= 5;
                    if (this.heroX - this.getCurrentGAnim().getCurrentFrameWidth() < 0) {
                        this.heroX = this.getCurrentGAnim().getCurrentFrameWidth();
                        this.movedSoFar = 0;
                        this.setState(0);
                        return;
                    }
                } else {
                    this.heroX += 5;
                    if (this.heroX + this.getCurrentGAnim().getCurrentFrameWidth() > SCREEN_WIDTH) {
                        this.heroX = SCREEN_WIDTH - this.getCurrentGAnim().getCurrentFrameWidth();
                        this.movedSoFar = 0;
                        this.setState(0);
                        return;
                    }
                }
                this.movedSoFar += 5;
                if (this.movedSoFar < 25) break;
                this.movedSoFar = 0;
                this.setState(0);
                break;
            }
            case 2: {
                if (this.direction == 0) {
                    if (!this.attackLeft[this.hittingAnimId].isAnimationOver()) break;
                    this.setState(0);
                    break;
                }
                if (!this.attackRight[this.hittingAnimId].isAnimationOver()) break;
                this.setState(0);
            }
        }
    }

    public boolean gotAttacked(int damage) {
        this.setHeroHelth(this.heroHelth - damage);
        return this.getHeroHelth() <= 0;
    }

    public int getHeroX() {
        return this.heroX;
    }

    public void setHeroHelth(int heroHelth) {
        this.heroHelth = heroHelth;
    }

    public int getHeroDamage() {
        return this.heroDamage;
    }

    public void setHeroDamage(int heroDamage) {
        this.heroDamage = heroDamage;
    }
}

