/*
 * Decompiled with CFR 0.152.
 */
package com.appon.effectengine;

import com.appon.effectengine.EShape;
import com.appon.effectengine.Effect;
import com.appon.effectengine.EffectUtil;
import com.appon.effectengine.Point;
import com.appon.miniframework.ResourceManager;
import com.appon.miniframework.Util;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class EImage
extends EShape {
    private Image image;
    private int imageId;
    private int fillType;

    public EImage(int id) {
        super(id);
    }

    public EShape clone() {
        EImage arc = new EImage(-1);
        this.copyProperties(arc);
        arc.setImage(this.getImage());
        arc.setImageId(this.getImageId());
        arc.setFillType(this.getFillType());
        return arc;
    }

    public int getImageId() {
        return this.imageId;
    }

    public int getWidth() {
        if (this.image == null) {
            return 50;
        }
        return Util.getImageWidth(this.image);
    }

    public int getHeight() {
        if (this.image == null) {
            return 50;
        }
        return Util.getImageHeight(this.image);
    }

    public void setImage(Image image) {
        this.image = image;
    }

    public Image getImage() {
        return this.image;
    }

    public void setImageId(int imageId) {
        this.imageId = imageId;
    }

    public int getFillType() {
        return this.fillType;
    }

    public void setFillType(int fillType) {
        this.fillType = fillType;
    }

    public void PAINT(Graphics g, int _x, int _y, int theta, int zoom, int anchorX, int anchorY, Effect parent) {
        if (this.image == null) {
            return;
        }
        Point p = EffectUtil.pointToRotate;
        p.setPoints(this.getX(), this.getY());
        EffectUtil.rotatePoint(p, anchorX, anchorY, theta, zoom, this);
        Util.drawImage(g, this.image, p.getX() + _x, p.getY() + _y);
        if (this.getFillType() == 1 && this.getBgColor() != -1) {
            g.setColor(EffectUtil.getColor(this.getBgColor()));
            g.fillRect(p.getX() + _x, p.getY() + _y, Util.getImageWidth(this.image), Util.getImageHeight(this.image));
        }
        if (this.getBorderColor() != -1) {
            g.setColor(EffectUtil.getColor(this.getBorderColor()));
            EffectUtil.drawRectangle(g, p.getX() + _x, p.getY() + _y, Util.getImageWidth(this.image), Util.getImageHeight(this.image), this.getBorderThickness());
        }
    }

    public String toString() {
        return "Image: " + this.getId();
    }

    public byte[] serialize() throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        bos.write(super.serialize());
        Util.writeSignedInt(bos, this.imageId, 1);
        Util.writeInt(bos, this.fillType, 1);
        bos.flush();
        byte[] data = bos.toByteArray();
        bos.close();
        bos = null;
        return data;
    }

    public ByteArrayInputStream deserialize(ByteArrayInputStream bis) throws Exception {
        super.deserialize(bis);
        this.imageId = Util.readSignedInt(bis, 1);
        this.setImage(ResourceManager.getInstance().getImageResource(this.imageId));
        this.fillType = Util.readInt(bis, 1);
        bis.close();
        return null;
    }

    public int getClassCode() {
        return 2015;
    }
}

