/*
 * Decompiled with CFR 0.152.
 */
package com.appon.effectengine;

import com.appon.effectengine.EPolygon;
import com.appon.effectengine.ERect;
import com.appon.effectengine.EffectLayer;
import com.appon.effectengine.EffectListener;
import com.appon.effectengine.EffectUtil;
import com.appon.effectengine.EffectsSerilize;
import com.appon.effectengine.TimeFrame;
import com.appon.util.Serilizable;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public class Effect
implements Serilizable {
    private Vector effectLayers = new Vector();
    private int timeFrameId;
    private int maxTimeFrame;
    EffectListener listener;

    public Effect clone() {
        Effect tf = new Effect();
        for (int i = 0; i < this.effectLayers.size(); ++i) {
            Object object = this.effectLayers.elementAt(i);
            tf.getEffectLayers().addElement(((EffectLayer)object).clone());
        }
        tf.reset();
        tf.setListener(this.listener);
        return tf;
    }

    public void setBgColor(int color) {
        for (int i = 0; i < this.effectLayers.size(); ++i) {
            EffectLayer object = (EffectLayer)this.effectLayers.elementAt(i);
            object.setBgColor(color);
        }
    }

    public boolean isEffectOver() {
        return this.getTimeFrameId() >= this.maxTimeFrame;
    }

    public void paintFrame(Graphics g, int x, int y, int frameIndex) {
        for (int i = 0; i < this.effectLayers.size(); ++i) {
            TimeFrame tframe;
            EffectLayer object = (EffectLayer)this.effectLayers.elementAt(i);
            if (!object.isVisibility() || (tframe = object.getTimeFrame(frameIndex)) == null || !tframe.isVisibility()) continue;
            tframe.PAINT(g, x, y, true, 0, 0, 0, 0, this, false);
        }
    }

    public void paintFrame(Graphics g, int x, int y, int frameIndex, int theta, int zoom, int anchorX, int anchorY) {
        for (int i = 0; i < this.effectLayers.size(); ++i) {
            TimeFrame tframe;
            EffectLayer object = (EffectLayer)this.effectLayers.elementAt(i);
            if (!object.isVisibility() || (tframe = object.getTimeFrame(frameIndex)) == null || !tframe.isVisibility()) continue;
            tframe.PAINT(g, x, y, true, theta, zoom, anchorX, anchorY, this, false);
        }
    }

    public int[] getCollisionRect(int layerId, int frameId, int shapeIndex, int[] rect, int zoom) {
        EffectLayer object = (EffectLayer)this.effectLayers.elementAt(layerId);
        TimeFrame tframe = object.getTimeFrame(frameId);
        if (tframe != null && tframe.getShapes().elementAt(shapeIndex) instanceof ERect) {
            ERect efrect = (ERect)tframe.getShapes().elementAt(shapeIndex);
            rect[0] = EffectUtil.getScaleValue(efrect.getX(), zoom);
            rect[1] = EffectUtil.getScaleValue(efrect.getY(), zoom);
            rect[2] = EffectUtil.getScaleValue(efrect.getWidth(), zoom);
            rect[3] = EffectUtil.getScaleValue(efrect.getHeight(), zoom);
        }
        return rect;
    }

    public int[] getCollisionPolyX(int layerId, int frameId, int shapeIndex) {
        EffectLayer object = (EffectLayer)this.effectLayers.elementAt(layerId);
        TimeFrame tframe = object.getTimeFrame(frameId);
        if (tframe != null && tframe.getShapes().elementAt(shapeIndex) instanceof EPolygon) {
            EPolygon efrect = (EPolygon)tframe.getShapes().elementAt(shapeIndex);
            return efrect.getTmpXPoints();
        }
        return null;
    }

    public int[] getCollisionPolyY(int layerId, int frameId, int shapeIndex) {
        EffectLayer object = (EffectLayer)this.effectLayers.elementAt(layerId);
        TimeFrame tframe = object.getTimeFrame(frameId);
        if (tframe != null && tframe.getShapes().elementAt(shapeIndex) instanceof EPolygon) {
            EPolygon efrect = (EPolygon)tframe.getShapes().elementAt(shapeIndex);
            return efrect.getTmpYPoints();
        }
        return null;
    }

    public void PAINT(Graphics g, int x, int y, boolean loop) {
        for (int i = 0; i < this.effectLayers.size(); ++i) {
            EffectLayer object = (EffectLayer)this.effectLayers.elementAt(i);
            object.PAINT(g, x, y, this.getTimeFrameId(), true, this);
        }
        this.updateEffect(loop);
    }

    private void updateEffect(boolean loop) {
        ++this.timeFrameId;
        if (this.listener != null) {
            this.listener.effectTimeFrameChanged(this.getTimeFrameId());
        }
        if (this.getTimeFrameId() > this.maxTimeFrame) {
            if (loop) {
                this.timeFrameId = 0;
            } else {
                this.timeFrameId = this.maxTimeFrame;
                if (this.listener != null) {
                    this.listener.effectOver();
                }
            }
        }
    }

    public void PAINT(Graphics g, int x, int y, boolean loop, int theta, int zoom, int anchorX, int anchorY) {
        for (int i = 0; i < this.effectLayers.size(); ++i) {
            EffectLayer object = (EffectLayer)this.effectLayers.elementAt(i);
            object.PAINT(g, x, y, this.getTimeFrameId(), true, theta, zoom, anchorX, anchorY, this);
        }
        this.updateEffect(loop);
    }

    public void setListener(EffectListener listener) {
        this.listener = listener;
    }

    public int getMaxTimeFrame() {
        Vector vector = this.effectLayers;
        int maxTimeFrame = 0;
        for (int i = 0; i < vector.size(); ++i) {
            EffectLayer effectLayer = (EffectLayer)vector.elementAt(i);
            Vector timeFrames = effectLayer.getTimeFrames();
            for (int j = 0; j < timeFrames.size(); ++j) {
                TimeFrame object = (TimeFrame)timeFrames.elementAt(j);
                if (object.getTimeFrameId() <= maxTimeFrame) continue;
                maxTimeFrame = object.getTimeFrameId();
            }
        }
        return maxTimeFrame;
    }

    public void reset() {
        this.timeFrameId = 0;
        this.maxTimeFrame = this.getMaxTimeFrame();
    }

    public Vector getEffectLayers() {
        return this.effectLayers;
    }

    public byte[] serialize() throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        EffectsSerilize.serialize(this.effectLayers, bos);
        bos.flush();
        byte[] data = bos.toByteArray();
        bos.close();
        bos = null;
        return data;
    }

    public ByteArrayInputStream deserialize(ByteArrayInputStream bis) throws Exception {
        this.effectLayers = (Vector)EffectsSerilize.deserialize(bis, EffectsSerilize.getInstance());
        bis.close();
        return null;
    }

    public int getClassCode() {
        return 2000;
    }

    public int getTimeFrameId() {
        return this.timeFrameId;
    }
}

