/*
 * Decompiled with CFR 0.152.
 */
package com.appon.effectengine;

import com.appon.effectengine.Effect;
import com.appon.effectengine.EffectUtil;
import com.appon.effectengine.EffectsSerilize;
import com.appon.effectengine.TimeFrame;
import com.appon.util.Serilizable;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public class EffectLayer
implements Serilizable {
    private Vector timeFrames = new Vector();
    private boolean visibility = true;

    public Vector getTimeFrames() {
        return this.timeFrames;
    }

    public EffectLayer clone() {
        EffectLayer tf = new EffectLayer();
        for (int i = 0; i < this.timeFrames.size(); ++i) {
            Object object = this.timeFrames.elementAt(i);
            tf.getTimeFrames().addElement(((TimeFrame)object).clone());
        }
        tf.setVisibility(this.isVisibility());
        return tf;
    }

    public void setBgColor(int color) {
        for (int i = 0; i < this.timeFrames.size(); ++i) {
            TimeFrame object = (TimeFrame)this.timeFrames.elementAt(i);
            object.setBgColor(color);
        }
    }

    public void setVisibility(boolean visibility) {
        this.visibility = visibility;
    }

    public boolean isVisibility() {
        return this.visibility;
    }

    public void PAINT(Graphics g, int x, int y, int timeFrame, boolean considerVisability, Effect parent) {
        if (considerVisability && !this.isVisibility()) {
            return;
        }
        for (int i = 0; i < this.timeFrames.size(); ++i) {
            TimeFrame object = (TimeFrame)this.timeFrames.elementAt(i);
            if (object.getTimeFrameId() != timeFrame) continue;
            object.PAINT(g, x, y, considerVisability, parent, false);
            break;
        }
    }

    public void PAINT(Graphics g, int x, int y, int timeFrame, boolean considerVisability, int theta, int zoom, int anchorX, int anchorY, Effect parent) {
        if (considerVisability && !this.isVisibility()) {
            return;
        }
        for (int i = 0; i < this.timeFrames.size(); ++i) {
            TimeFrame object = (TimeFrame)this.timeFrames.elementAt(i);
            if (object.getTimeFrameId() != timeFrame) continue;
            object.PAINT(g, x, y, considerVisability, theta, zoom, anchorX, anchorY, parent, false);
            break;
        }
    }

    public TimeFrame getTimeFrame(int frameId) {
        for (int i = 0; i < this.timeFrames.size(); ++i) {
            TimeFrame object = (TimeFrame)this.timeFrames.elementAt(i);
            if (object.getTimeFrameId() != frameId) continue;
            return object;
        }
        return null;
    }

    public byte[] serialize() throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        EffectsSerilize.serialize(this.timeFrames, bos);
        EffectsSerilize.serialize(new Boolean(this.isVisibility()), bos);
        bos.flush();
        byte[] data = bos.toByteArray();
        bos.close();
        bos = null;
        return data;
    }

    public ByteArrayInputStream deserialize(ByteArrayInputStream bis) throws Exception {
        this.timeFrames = (Vector)EffectsSerilize.deserialize(bis, EffectsSerilize.getInstance());
        if (EffectUtil.LOADING_VERSION > 0) {
            this.setVisibility((Boolean)EffectsSerilize.deserialize(bis, EffectsSerilize.getInstance()));
        }
        bis.close();
        return null;
    }

    public int getClassCode() {
        return 2001;
    }
}

