/*
 * Decompiled with CFR 0.152.
 */
package com.appon.miniframework.animation;

import com.appon.miniframework.Control;
import com.appon.miniframework.Event;
import com.appon.miniframework.Util;
import com.appon.miniframework.animation.EndAnimation;
import com.appon.util.Serilizable;
import javax.microedition.lcdui.Graphics;

public abstract class Animation
implements Serilizable {
    int origionalX;
    int origionalY;
    int origionalRotation;
    int actualX;
    int actualY;
    private boolean isAnimationOver;
    Control control;
    private boolean initiated = false;
    private boolean goForRestore = false;
    private boolean animationApplied = false;

    public void registerControl(Control control) {
        this.control = control;
    }

    public boolean isAnimationOver() {
        return this.isAnimationOver;
    }

    public int getOrigionalX() {
        return this.origionalX;
    }

    public int getOrigionalY() {
        return this.origionalY;
    }

    public int getOrigionalRotation() {
        return this.origionalRotation;
    }

    public boolean restore() {
        if (this.initiated && this.control != null && this.goForRestore) {
            this.control.setX(this.origionalX);
            this.control.setY(this.origionalY);
            this.control.setRotation(this.origionalRotation);
            this.goForRestore = false;
            return true;
        }
        return false;
    }

    public void setIsAnimationOver(boolean isAnimationOver) {
        this.isAnimationOver = isAnimationOver;
        if (isAnimationOver && !(this instanceof EndAnimation)) {
            this.restore();
        }
        if (isAnimationOver && this.control != null && this.control.getEventListener() != null) {
            if (this instanceof EndAnimation) {
                this.control.getEventListener().event(new Event(6, this.control, null));
            } else {
                this.control.getEventListener().event(new Event(5, this.control, null));
            }
        }
    }

    public void reset() {
        this.animationApplied = false;
        this.setIsAnimationOver(false);
        this.origionalX = this.control.getX();
        this.origionalY = this.control.getY();
        this.actualX = Util.getActualX(this.control);
        this.actualY = Util.getActualY(this.control);
        this.origionalRotation = this.control.getRotation();
        this.initiated = true;
        this.goForRestore = true;
    }

    public Object restoreAnimationEffect() {
        return null;
    }

    public int getActualX() {
        return this.actualX;
    }

    public int getActualY() {
        return this.actualY;
    }

    public Control getControl() {
        return this.control;
    }

    public final Object doAnimation(Graphics g) {
        if (this.isAnimationOver()) {
            return null;
        }
        Object object = this.applyAnimation(g);
        this.animationApplied = true;
        return object;
    }

    public boolean isAnimationApplied() {
        boolean value = this.animationApplied;
        this.animationApplied = false;
        return value;
    }

    public abstract Object applyAnimation(Graphics var1);

    public void port() {
    }
}

