/*
 * Decompiled with CFR 0.152.
 */
package com.appon.miniframework.layout;

import com.appon.miniframework.Container;
import com.appon.miniframework.Control;
import com.appon.miniframework.Layout;
import com.appon.miniframework.Util;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;

public class GridArrangerLayout
implements Layout {
    private int numberOfColumns = -1;
    private int horizontalPadding;
    private int verticalPadding;
    public static final int LEFT_ALLIGNMENT = 0;
    public static final int RIGHT_ALLIGNMENT = 1;
    public static final int CENTER_ALLIGNMENT = 2;
    public static final int CENTER_WITH_EQUAL_PADDING_ALLIGNMENT = 3;
    private int allignment = 0;
    private boolean isPortHorizontalPadding;
    private boolean isPortVerticalPadding;
    private int maxChildrenWidth;
    private int maxChildrenHeight;
    private int actualPadding;
    private int actualColumns;

    public void applyLayout(Container parentControl, Control currentControl) {
        if (!(currentControl instanceof Container)) {
            throw new RuntimeException("GridArrangerLayout can be applied only on Container");
        }
        if (this.numberOfColumns == 0) {
            this.numberOfColumns = 1;
        }
        Container container = (Container)currentControl;
        this.doBackgroundCalculations(container);
        int startX = 0;
        int startY = this.verticalPadding;
        int counter = 0;
        int initX = 0;
        if (this.actualColumns > container.getSize()) {
            this.actualColumns = container.getSize();
        }
        if (this.allignment == 3) {
            this.actualPadding = (container.getBoundWidth() - this.maxChildrenWidth * this.actualColumns) / (this.actualColumns + 1);
            initX = startX = container.getBoundWidth() - this.maxChildrenWidth * this.actualColumns - (this.actualColumns - 1) * this.actualPadding >> 1;
        } else if (this.allignment == 0) {
            initX = startX = this.actualPadding;
        } else if (this.allignment == 1) {
            initX = startX = container.getBoundWidth() - this.actualPadding;
        } else if (this.allignment == 2) {
            initX = startX = container.getBoundWidth() - this.maxChildrenWidth * this.actualColumns - (this.actualColumns - 1) * this.actualPadding >> 1;
        }
        for (int i = 0; i < container.getSize(); ++i) {
            Control c = container.getChild(i);
            if (c.getRelativeLocation() != null) continue;
            if (this.allignment == 1) {
                startX -= this.maxChildrenWidth;
            }
            c.setPoistion(startX, startY);
            startX = this.allignment == 1 ? (startX -= this.actualPadding) : (startX += this.maxChildrenWidth + this.actualPadding);
            if (counter == this.actualColumns - 1) {
                startX = initX;
                startY += this.verticalPadding + this.maxChildrenHeight;
                counter = 0;
                continue;
            }
            ++counter;
        }
    }

    public void port() {
        int scaleX = Util.getScaleX();
        int scaleY = Util.getScaleY();
        if (this.isPortHorizontalPadding()) {
            this.setHorizontalPadding(Util.getScaleValue(this.getHorizontalPadding(), scaleX));
        }
        if (this.isPortVerticalPadding()) {
            this.setVerticalPadding(Util.getScaleValue(this.getVerticalPadding(), scaleY));
        }
    }

    public int getAllignment() {
        return this.allignment;
    }

    public void setAllignment(int allignment) {
        this.allignment = allignment;
    }

    public boolean isPortVerticalPadding() {
        return this.isPortVerticalPadding;
    }

    public boolean isPortHorizontalPadding() {
        return this.isPortHorizontalPadding;
    }

    public void setPortVerticalPadding(boolean isPortVerticalPadding) {
        this.isPortVerticalPadding = isPortVerticalPadding;
    }

    public void setPortHorizontalPadding(boolean isPortHorizontalPadding) {
        this.isPortHorizontalPadding = isPortHorizontalPadding;
    }

    private void setMaxChildrenSize(Container parent) {
        this.maxChildrenWidth = 0;
        this.maxChildrenHeight = 0;
        for (int i = 0; i < parent.getSize(); ++i) {
            int w = Util.getChildernLayoutWrapWidth(parent.getChild(i));
            int h = Util.getChildernLayoutWrapHeight(parent.getChild(i));
            if (parent.getChild(i).isSkipParentWrapSizeCalc()) continue;
            if (w > this.maxChildrenWidth) {
                this.maxChildrenWidth = w;
            }
            if (h <= this.maxChildrenHeight) continue;
            this.maxChildrenHeight = h;
        }
    }

    public int getPreferedWidth(Container parent) {
        return parent.getBoundWidth();
    }

    private void doBackgroundCalculations(Container parent) {
        this.setMaxChildrenSize(parent);
        if (this.numberOfColumns == -1) {
            int div = this.maxChildrenWidth + this.horizontalPadding;
            if (div == 0) {
                div = 1;
            }
            this.actualColumns = (Util.getWrappedWidth(parent) - this.horizontalPadding) / div;
            this.actualPadding = this.horizontalPadding;
        } else {
            this.actualColumns = this.numberOfColumns;
            this.actualPadding = this.horizontalPadding;
        }
        if (this.actualColumns == 0) {
            this.actualColumns = 1;
        }
    }

    public int getPreferedHeight(Container parent) {
        this.doBackgroundCalculations(parent);
        int numberOfRows = parent.getSize() / this.actualColumns;
        if (parent.getSize() % this.actualColumns != 0) {
            ++numberOfRows;
        }
        return numberOfRows * this.maxChildrenHeight + (numberOfRows + 1) * this.verticalPadding;
    }

    public int getNumberOfColumns() {
        return this.numberOfColumns;
    }

    public int getHorizontalPadding() {
        return this.horizontalPadding;
    }

    public int getVerticalPadding() {
        return this.verticalPadding;
    }

    public byte[] serialize() throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        Util.writeSignedInt(bos, this.getNumberOfColumns(), 2);
        Util.writeInt(bos, this.getAllignment(), 1);
        Util.writeSignedInt(bos, this.getHorizontalPadding(), 2);
        Util.writeSignedInt(bos, this.getVerticalPadding(), 2);
        Util.writeBoolean(bos, this.isPortHorizontalPadding());
        Util.writeBoolean(bos, this.isPortVerticalPadding());
        bos.flush();
        byte[] data = bos.toByteArray();
        bos.close();
        bos = null;
        return data;
    }

    public void setNumberOfColumns(int numberOfColumns) {
        this.numberOfColumns = numberOfColumns;
    }

    public void setHorizontalPadding(int horizontalPadding) {
        this.horizontalPadding = horizontalPadding;
    }

    public void setVerticalPadding(int verticalPadding) {
        this.verticalPadding = verticalPadding;
    }

    public ByteArrayInputStream deserialize(ByteArrayInputStream bis) throws Exception {
        this.setNumberOfColumns(Util.readSignedInt(bis, 2));
        this.setAllignment(Util.readInt(bis, 1));
        this.setHorizontalPadding(Util.readSignedInt(bis, 2));
        this.setVerticalPadding(Util.readSignedInt(bis, 2));
        this.setPortHorizontalPadding(Util.readBoolean(bis));
        this.setPortVerticalPadding(Util.readBoolean(bis));
        bis.close();
        return null;
    }

    public int getClassCode() {
        return 1018;
    }
}

