/*
 * Decompiled with CFR 0.152.
 */
package com.appon.knighttestgame.customShapes;

import com.appon.camera.CameraLockable;
import com.appon.runner.RunnerManager;
import com.appon.runner.model.AddedShape;
import com.appon.runner.model.CustomShape;
import com.appon.runner.util.Util;
import com.appon.util.BoxUtil;
import com.indiagames.arjunprince.Constant;
import javax.microedition.lcdui.Graphics;

public class Log
extends CustomShape
implements CameraLockable {
    private boolean logNear = false;
    private int ctr = 0;

    public void paint(Graphics g, int x, int y) {
        ++this.ctr;
        g.drawImage(Constant.IMG_WOOD_LOG.getImage(), x, y, 0);
        if (!this.isLogNear() && this.ctr % 2 == 0) {
            g.drawImage(Constant.IMG_HURDLE_ALERT.getImage(), x + (this.getWidth() - Constant.IMG_HURDLE_ALERT.getWidth() >> 1), y + this.getHeight(), 0);
        }
    }

    public int getHeight() {
        return Constant.IMG_WOOD_LOG.getHeight();
    }

    public void update(AddedShape addedShape) {
        if (addedShape.getX() - RunnerManager.getManager().getCurrentCamX() < (Constant.SCREEN_WIDTH >> 1) - Constant.MIN_GAME_SPEED) {
            this.logNear = true;
        }
        if (this.isLogNear() && !BoxUtil.isCollisionAtBottom(addedShape.getX() - RunnerManager.getManager().getCurrentCamX(), addedShape.getY() + this.getHeight(), this)) {
            addedShape.setY(addedShape.getY() + Constant.FALL_DOWN_SPEED);
        }
    }

    public int getWidth() {
        return Constant.IMG_WOOD_LOG.getWidth();
    }

    public void reset() {
        this.logNear = false;
        this.ctr = 0;
    }

    public AddedShape checkCollision(int rectX, int rectY, int rectWidth, int rectHeight, AddedShape addedShape) {
        if (Util.isRectCollision(addedShape.getX() + addedShape.getAdditionalX(), addedShape.getY() + addedShape.getAdditionalY(), this.getWidth(), this.getHeight(), rectX, rectY, rectWidth, rectHeight)) {
            return addedShape;
        }
        return null;
    }

    public int getX() {
        return 0;
    }

    public int getY() {
        return 0;
    }

    public int getAllignment() {
        return -1;
    }

    public int lockedObjectIsOf() {
        return 2;
    }

    public boolean isLogNear() {
        return this.logNear;
    }
}

