/*
 * Decompiled with CFR 0.152.
 */
package com.distinctive;

import com.distinctive.DDDebug;
import com.distinctive.DDFile;
import com.distinctive.DDLUtility;
import com.distinctive.DDMath;
import com.distinctive.GameLogic;
import com.distinctive.MainFrame;
import com.distinctive.XMLMenuSystem;

class Match {
    public static final int MIN_NUM_PENALTY_ROUNDS = 5;
    private static final int PENALTIES_SCORE_MAX = 8;
    private static final int MAX_NUM_PENALTY_ROUNDS = 8;
    public static final int MATCH_STATE_ENDOF_PERIOD = 0;
    public static final int MATCH_STATE_START_NEXT_PERIOD = 1;
    public static final int MATCH_STATE_INPLAY = 2;
    public static final int MATCH_MESSAGE_HEADER_NUM_ENTRIES = 0;
    public static final int MATCH_MESSAGE_HEADER_NEXT_TIME = 1;
    public static final int MATCH_MESSAGE_HEADER_CURRENT_POSSESSION = 2;
    public static final int MATCH_MESSAGE_HEADER_SIZE = 3;
    public static final int MATCH_MESSAGE_TIME = 0;
    public static final int MATCH_MESSAGE_TEXT = 1;
    public static final int MATCH_MESSAGE_BALL_POSITION = 2;
    public static final int MATCH_MESSAGE_EVENT_HI = 3;
    public static final int MATCH_MESSAGE_EVENT_LO = 4;
    public static final int MATCH_MESSAGE_EVENT_PLAYERS = 5;
    public static final int MATCH_MESSAGE_POSSESSION = 6;
    public static final int MATCH_MESSAGE_DATA_1 = 7;
    public static final int MATCH_MESSAGE_ENTRY_LENGTH = 8;
    public static final int MATCH_EVENT_FULL_TIME = 1;
    public static final int MATCH_EVENT_END_OF_PERIOD = 2;
    public static final int MATCH_EVENT_GOAL_T1 = 4;
    public static final int MATCH_EVENT_GOAL_T2 = 8;
    public static final int MATCH_EVENT_SUBSTITUTION = 16;
    public static final int MATCH_EVENT_INJURY = 32;
    public static final int MATCH_EVENT_GAVE_POSSESSION_T1 = 64;
    public static final int MATCH_EVENT_GAVE_POSSESSION_T2 = 128;
    public static final int MATCH_EVENT_FLASHING_TEXT = 256;
    public static final int MATCH_EVENT_BOOKING = 512;
    public static final int MATCH_EVENT_FORCE_SUBSTITUTION = 1024;
    public static final int MATCH_EVENT_SHOT_ON_TARGET = 2048;
    public static final int MATCH_EVENT_CORNER = 4096;
    public static final int MATCH_EVENT_SHOT = 8192;
    public static final int MATCH_EVENT_FOUL = 16384;
    public static final int MATCH_EVENT_OFFSIDE = 32768;
    public static final int MATCH_EVENT_SET_UP_OFFENDER = 65536;
    public static final int MATCH_EVENT_ASSIGN_YELLOW = 131072;
    public static final int MATCH_EVENT_ASSIGN_RED = 262144;
    public static final int MATCH_EVENT_RESET_LINEUP_SELECTION = 524288;
    public static final int MATCH_EVENT_LOAD_PEN_TAKERS = 0x100000;
    public static final int MATCH_EVENT_OWN_GOAL_FLAG = 0x200000;
    public static final int MATCH_EVENT_DISPLAY_OFF = 0x400000;
    public static final int MATCH_EVENT_DISPLAY_ON = 0x800000;
    public static final int MATCH_EVENT_HIGHLIGHT_START = 0x1000000;
    public static final int MATCH_EVENT_HIGHLIGHT_GOAL = 0x2000000;
    public static final int MATCH_EVENT_HIGHLIGHT_CORNER = 0x4000000;
    public static final int MATCH_EVENT_HIGHLIGHT_SAVED = 0x8000000;
    public static final int MATCH_EVENT_HIGHLIGHT_OUTCOMES = 0xE000000;
    public static final int MATCH_EVENT_HIGHLIGHT_TRIGGER = 0x10000000;
    public static final int MATCH_EVENT_RECALCULATE_TABLE = 0x20000000;
    public static final int NODE_CHOICE_MIN_NUM_ENTRYS = 2;
    public static final int MAX_ROOT_NODES = 40;
    public static final int COMMENTARY_SPEED_SLOW = 1700;
    public static final int COMMENTARY_SPEED_MEDIUM = 1000;
    public static final int COMMENTARY_SPEED_FAST = 300;
    public static final int COMMENTARY_LENGTH_GOAL = 2000;
    public static final int MINUTE_SPEED_SLOW = 400;
    public static final int MINUTE_SPEED_MEDIUM = 200;
    public static final int MINUTE_SPEED_FAST = 100;
    public static final int FLASHING_MILLISECONDS = 300;
    public static final int MAX_PLAYERS_ON_PITCH = 11;
    public static final int CONVERT_STAT_TO_1000 = 10;
    public static final int MAX_PLAYER_RATING = 1000;
    public static final int MIN_PLAYER_RATING = 400;
    public static final int RATING_MATCH_START_LEVEL = 600;
    public static final int RATING_GOOD_INCREMENT = 150;
    public static final int RATING_BAD_DECREMENT = -150;
    public static final int SITUATION_NEXT = 0;
    public static final int SITUATION_FLAGS = 1;
    public static final int SITUATION_ENTRY_SIZE = 2;
    public static final int SITUATION_FLAG_RESET_COMMENTARY_LIST = 1;
    public static final int FOUL_PERCENT = 100;
    public static final int YELLOW_CARD_PERCENT_CRITERIA = 60;
    public static final int RED_CARD_PERCENT_CRITERIA = 75;
    public static final short GOOD_STAT_VALUE = 80;
    public static final int CLOSE_LEAGUE_POSITION = 3;
    public static final int MATCH_FULL_LENGTH = 90;
    public static final int START_RATING = 600;
    public static final int DECREMENT_FATIGUE_LEVEL_PER_MINUTE = 51;
    public static final int MAX_FATIGUE_LOSS_PER_MINUTE = 86;
    public static final int ROLE_FREEKICK_TAKER = 0;
    public static final int ROLE_CORNER_TAKER = 1;
    public static final int ROLE_PENALTY_TAKER = 2;
    public static final int ROLE_CAPTAIN = 3;
    public static final int PLRINFO_RATING = 0;
    public static final int PLRINFO_RATING_TARGET = 1;
    public static final int PLRINFO_FATIGUE = 2;
    public static final int PLRINFO_FATIGUE_TARGET = 3;
    public static final int PLRINFO_GOALS = 4;
    public static final int PLRINFO_CARDS = 5;
    public static final int PLRINFO_GOALS_PREV = 6;
    public static final int PLRINFO_CARDS_PREV = 7;
    public static final int PLRINFO_DATA_SIZE = 8;
    public static final int PLRINFO_FLAG_RED_CARD = 256;
    public static short[][] m_matchPlayerInfo;
    public static final int NEXTSITUATIONTABLE_LEN = 18;
    public static int[] nextsituationtable;
    private static byte[] m_matchPeriodTimeList;
    private static byte[] m_matchPeriodStartTimeList;
    public static byte[] m_ballpositionLookUp;
    public static byte[][] m_formationLineup;
    public static final int NO_COMMENTARY_POSITIONS = 50;
    public static byte[][] m_commentaryPositions;
    public static byte[][] m_commentaryUsedPositionList;
    public static byte[] m_commentaryPositionsMappedToPlayerType;
    public static int[] m_commentarytimearray;
    public static int[] m_matchminutetimearray;
    public static int m_commentaryPositionsNum;
    public static final int FAIROMETER_NUM_NODES = 100;
    public static short[] m_fairometer;
    public static short[] m_matchMessagesQueue;
    public static int m_matchMessagesDispatchCounter;
    public static int m_possession;
    public static int m_gameMode;
    public static int m_commentaryTreeNumNodes;
    public static int m_commentaryTreeRootNodeId;
    public static int m_lastTouchPlayerFromTeamInPossession;
    public static int m_lastTouchPlayerFromTeamWithOutPossession;
    public static int m_matchCommentaryString;
    public static short[] m_matchCommentaryTable;
    public static short[][] m_commentaryTree;
    public static int m_matchState;
    public static int m_matchClock;
    public static int m_matchPeriod;
    public static int m_matchPeriodClock;
    public static long m_matchMinuteTimer;
    public static int m_matchEvent;
    public static int m_matchPossessionPosition;
    public static int m_matchIdealPossessionPosition;
    public static byte[] m_matchCountryInfo;
    public static byte m_matchCountryNumCountries;
    private static int m_currentChunkStart;
    private static long m_matchTextCounter;
    public static byte m_flashingText;
    public static long m_flashingTextTimer;
    public static int m_currentEventData;
    public static int m_highlightPitchPos;
    public static int m_highlightStartPlayer;
    public static int m_highlightSituation;
    private static boolean m_shotTaken;
    public static int m_matchNumEvents;
    public static byte m_matchTeamWithPossession;
    public static int m_matchEventPlayers;
    public static short[] m_matchEvents;
    public static byte m_penaltyround;
    public static byte m_matchTeam1Pentaker;
    public static byte m_matchTeam2Pentaker;
    public static int m_playersperfile;
    public static int m_currentBufferFileId;
    public static byte[] m_currentBufferFile;
    public static short m_tempballposition;
    public static int m_userTeam;
    public static short[][] m_matchRoles;
    public static boolean m_matchEnded;
    private static boolean m_crowdPlayed;
    private static int[] m_tacklingCardModifier;
    private static short[] m_tacklingStatModifier;
    private static byte[][] m_penaltyTakers;
    public static int lastplayerpos1;
    public static int lastplayerpos2;
    public static int m_offenderindex;
    public static boolean m_hideEvents;
    public static final int NOT_USED = -1;
    private static int[] m_trainingIndex;
    public static byte[][] m_formationTrainingEffects;
    public static byte[][] m_strategyTrainingEffects;
    private static byte[][] m_strategyVsPassing;

    Match() {
    }

    public static void init() {
        m_matchRoles = new short[2][4];
        m_highlightPitchPos = 0;
        m_highlightStartPlayer = 0;
        m_matchEnded = false;
    }

    public static int getNextSituationFlagFromOutcome(int n) {
        int n2 = nextsituationtable[n * 2 + 0];
        if (n == 6) {
            int n3 = 0;
            if (m_matchTeamWithPossession == m_userTeam) {
                n3 = m_tacklingCardModifier[GameLogic.m_tacticsTackling];
            }
            if (m_tempballposition > 80) {
                n2 = 32;
            } else if ((DDMath.getRandom() & 0xFFFF) % 100 < 60 + n3) {
                byte by = (byte)(m_matchTeamWithPossession ^ 1);
                n2 = 1024;
                if ((Match.getTeamsBuffer(by)[m_offenderindex][30] & 1) != 0) {
                    DDDebug.msg("!!!!!!!!!!!!!!!!!!!!!!!!!RED CARD1!!!!!!!!!!!!!!!!!!!!!!!!!");
                    n2 = 2048;
                }
            } else if (m_gameMode == 1 || GameLogic.m_gameCurrentMatchMessage[5] == 0) {
                n2 = 1024;
            } else {
                DDDebug.msg("!!!!!!!!!!!!!!!!!!!!!!!!!RED CARD2!!!!!!!!!!!!!!!!!!!!!!!!!");
                n2 = 2048;
            }
        }
        if ((nextsituationtable[n * 2 + 1] & 1) != 0) {
            Match.resetCommentaryPlayerList();
        }
        return n2;
    }

    public static int getMatchEventFromOutcome(int n, int n2) {
        int n3 = 0;
        boolean bl = false;
        switch (n) {
            case 13: {
                n3 |= 0x2000;
                break;
            }
            case 0: {
                n3 = n2 == 0 ? (n3 |= 4) : (n3 |= 8);
                n3 |= 0x800;
                n3 |= 0x80000;
                n3 |= 0x1000000;
                n3 |= 0x2000000;
                bl = true;
                break;
            }
            case 1: {
                n3 = n2 == 0 ? (n3 |= 4) : (n3 |= 8);
                bl = true;
                n3 |= 0x80000;
                n3 |= 0x200000;
                break;
            }
            case 2: {
                n3 |= 0x800;
                n3 |= 0x2000;
                n3 |= 0x80000;
                n3 |= 0x1000000;
                n3 |= 0x8000000;
                bl = true;
                break;
            }
            case 3: {
                bl = true;
                n3 |= 0x80000;
                if (!m_shotTaken) break;
                n3 |= 0x1000000;
                m_shotTaken = false;
                break;
            }
            case 5: {
                DDDebug.msg("!!!!!!!!!!!!!!!CommentaryTreeFormat.NODE_OUTCOME_INJURY!!!!!!!!!!!!!!!");
                n3 |= 0x20;
                break;
            }
            case 6: {
                n3 |= 0x4000;
                n3 |= 0x10000;
                break;
            }
            case 7: {
                n3 |= 0x4000;
                bl = true;
                break;
            }
            case 15: {
                n3 |= 0x200;
                n3 |= 0x20000;
                n3 |= 0x10000;
                break;
            }
            case 16: {
                n3 |= 0x200;
                n3 |= 0x40000;
                if (GameLogic.cheatActive[8]) break;
                n3 |= 0x10000;
                break;
            }
            case 14: {
                n3 |= 0x8000;
                n3 |= 0x80000;
                bl = true;
                break;
            }
            case 8: {
                bl = true;
                n3 |= 0x80000;
                break;
            }
            case 9: {
                n3 |= 0x1000;
                n3 |= 0x80000;
                if (!m_shotTaken) break;
                n3 |= 0x1000000;
                n3 |= 0x4000000;
                m_shotTaken = false;
                break;
            }
            case 12: {
                bl = true;
                n3 |= 0x80000;
            }
        }
        if (bl) {
            n3 = n2 == 0 ? (n3 |= 0x80) : (n3 |= 0x40);
        }
        return n3;
    }

    public static void matchLoadCommentaryTreeData(String string) {
        int n = 0;
        int n2 = 0;
        byte[] byArray = DDFile.loadFileBytes(string);
        m_commentaryTreeNumNodes = DDLUtility.MAKE_INT_LITTLE_ENDIAN(byArray, n);
        m_commentaryTreeRootNodeId = DDLUtility.MAKE_INT_LITTLE_ENDIAN(byArray, n += 4);
        n += 4;
        m_commentaryTree = new short[m_commentaryTreeNumNodes][12];
        for (n2 = 0; n2 < m_commentaryTreeNumNodes; ++n2) {
            int n3 = DDLUtility.MAKE_INT_LITTLE_ENDIAN(byArray, n);
            n += 4;
            if ((n3 & Integer.MIN_VALUE) != 0) {
                Match.m_commentaryTree[n2][0] = 1;
                Match.m_commentaryTree[n2][2] = (short)(n3 & 0x3FF);
                Match.m_commentaryTree[n2][1] = (short)(n3 >> 10 & 0x3FF);
                Match.m_commentaryTree[n2][3] = (short)(n3 >> 20 & 0x3F);
                n3 = DDLUtility.MAKE_INT_LITTLE_ENDIAN(byArray, n);
                n += 4;
                Match.m_commentaryTree[n2][4] = (short)(n3 >> 0 & 0xFFFF);
                Match.m_commentaryTree[n2][5] = (short)(n3 >> 16 & 0xFFFF);
            } else {
                Match.m_commentaryTree[n2][0] = 0;
                Match.m_commentaryTree[n2][4] = (short)(n3 >> 0 & 0x3F);
                Match.m_commentaryTree[n2][9] = (short)(n3 >> 6 & 0x7F);
                Match.m_commentaryTree[n2][7] = (short)(n3 >> 13 & 0x1F);
                Match.m_commentaryTree[n2][10] = (short)(n3 >> 18 & 0x3F);
                Match.m_commentaryTree[n2][11] = (short)(n3 >> 24 & 0x3F);
                n3 = DDLUtility.MAKE_INT_LITTLE_ENDIAN(byArray, n);
                Match.m_commentaryTree[n2][2] = (short)(n3 >> 0 & 0x3FF);
                Match.m_commentaryTree[n2][1] = (short)(n3 >> 10 & 0x3FF);
                Match.m_commentaryTree[n2][5] = (short)(n3 >> 20 & 0xFFF);
                n3 = DDLUtility.MAKE_SHORT_LITTLE_ENDIAN(byArray, n += 4);
                n += 2;
                Match.m_commentaryTree[n2][8] = (short)(n3 >> 0 & 0x1F);
                Match.m_commentaryTree[n2][6] = (short)(n3 >> 5 & 0x1F);
                Match.m_commentaryTree[n2][3] = (short)(n3 >> 10 & 7);
                if (m_commentaryTree[n2][5] == 1023) {
                    Match.m_commentaryTree[n2][5] = -1;
                }
                if (m_commentaryTree[n2][10] == 63) {
                    Match.m_commentaryTree[n2][10] = -1;
                }
                if (m_commentaryTree[n2][11] == 63) {
                    Match.m_commentaryTree[n2][11] = -1;
                }
            }
            if (m_commentaryTree[n2][2] == 1023) {
                Match.m_commentaryTree[n2][2] = -1;
            }
            if (m_commentaryTree[n2][1] != 1023) continue;
            Match.m_commentaryTree[n2][1] = -1;
        }
        byArray = null;
        System.gc();
    }

    public static void matchStoreEvent(int n, int n2, int n3, int n4) {
        int n5 = m_matchNumEvents * 5;
        Match.m_matchEvents[n5 + 0] = (byte)n;
        Match.m_matchEvents[n5 + 1] = (byte)(n2 >> 8 & 0xFF);
        Match.m_matchEvents[n5 + 2] = (byte)(n2 & 0xFF);
        Match.m_matchEvents[n5 + 3] = (byte)n3;
        Match.m_matchEvents[n5 + 4] = (byte)n4;
        ++m_matchNumEvents;
    }

    public static short[] matchCreateMatchCommentaryTable(byte[][] byArray, byte[][] byArray2, short s, int n, short s2, short s3, int n2, int n3) {
        short s4 = m_matchPeriodTimeList[m_matchPeriod];
        short s5 = (short)(s4 + (DDMath.getRandom() & 0xFF) % 3);
        Match.m_matchCommentaryTable[0] = 0;
        Match.m_matchCommentaryTable[1] = s;
        Match.m_matchCommentaryTable[2] = s2;
        int n4 = n;
        do {
            n4 = Match.addChunkToTable(m_matchCommentaryTable, byArray, byArray2, n4, n2, n3);
        } while (m_matchCommentaryTable[1] < s4 && n4 != -1);
        DDDebug.msg("Add end of period chunk");
        n4 = Match.addChunkToTable(m_matchCommentaryTable, byArray, byArray2, Match.getEndOfPeriodSituation(m_matchCommentaryTable, s3), n2, n3);
        int n5 = 3 + (m_matchCommentaryTable[0] - 1) * 8;
        int n6 = n5 + 3;
        m_matchCommentaryTable[n6] = (short)(m_matchCommentaryTable[n6] | 0);
        int n7 = n5 + 4;
        m_matchCommentaryTable[n7] = (short)(m_matchCommentaryTable[n7] | 2);
        m_matchCommentaryString = m_matchCommentaryTable[4];
        m_matchEventPlayers = m_matchCommentaryTable[8];
        m_matchEvent = 0;
        m_flashingText = 0;
        DDDebug.msg("Table length:" + m_matchCommentaryTable[0]);
        Match.resetCommentaryPlayerList();
        return m_matchCommentaryTable;
    }

    public static byte[] getScoreFromMatchTable(short[] sArray, byte[] byArray) {
        byArray[0] = GameLogic.m_matchStatistics[0];
        byArray[1] = GameLogic.m_matchStatistics[1];
        for (int i = 0; i < sArray[0]; ++i) {
            short s = sArray[3 + i * 8 + 6];
            int n = (sArray[3 + i * 8 + 3] & 0xFFFF) << 16 | sArray[3 + i * 8 + 4] & 0xFFFF;
            if ((n & 4) != 0) {
                byArray[0] = (byte)(byArray[0] + 1);
                continue;
            }
            if ((n & 8) == 0) continue;
            byArray[1] = (byte)(byArray[1] + 1);
        }
        return byArray;
    }

    public static int getEndOfPeriodSituation(short[] sArray, int n) {
        byte[] byArray = new byte[]{GameLogic.m_matchStatistics[0], GameLogic.m_matchStatistics[1]};
        int n2 = 0;
        byArray = Match.getScoreFromMatchTable(sArray, byArray);
        if (m_matchPeriod == 0 || m_matchPeriod == 2) {
            n2 = 0x10000000;
        } else if (m_matchPeriod == 1) {
            n2 = 0x20000000;
        }
        return n2;
    }

    public static int addChunkToTable(short[] sArray, byte[][] byArray, byte[][] byArray2, int n, int n2, int n3) {
        int n4;
        short s;
        short s2 = s = sArray[0];
        m_possession = sArray[2];
        short s3 = sArray[1];
        for (n4 = 1; (n >> n4 & 1) == 0 && n4 < 31; n4 = (int)((short)(n4 + 1))) {
        }
        int n5 = 2;
        short s4 = (short)Match.matchCreatorFindChunk(n);
        do {
            int n6;
            int n7;
            byte[] byArray3;
            int n8 = 1;
            if (m_possession == m_userTeam) {
                n8 = 0;
            }
            int n9 = 3 + s * 8;
            if (m_lastTouchPlayerFromTeamInPossession < 0) {
                DDDebug.msg("Invalid player id in addChunkToTable()");
                m_lastTouchPlayerFromTeamInPossession = 0;
            }
            if (m_possession == 0) {
                byArray3 = byArray[GameLogic.m_matchLineUp[n8][m_lastTouchPlayerFromTeamInPossession]];
                n7 = n2;
                n6 = n3;
            } else {
                byArray3 = byArray2[GameLogic.m_matchLineUp[n8][m_lastTouchPlayerFromTeamInPossession]];
                n7 = n3;
                n6 = n2;
            }
            if (m_commentaryTree[s4][2] >= 0) {
                s4 = (short)Match.matchCreatorChooseChild(s4, byArray3, n7);
                sArray[n9 + 0] = s3;
                sArray[n9 + 1] = m_commentaryTree[s4][5];
                sArray[n9 + 2] = m_tempballposition = (short)m_ballpositionLookUp[m_commentaryTree[s4][9]];
                sArray[n9 + 5] = 0;
                sArray[n9 + 6] = (short)m_possession;
                int n10 = Match.getMatchEventFromOutcome(m_commentaryTree[s4][4], m_possession);
                s3 = (short)(s3 + m_commentaryTree[s4][6]);
                if ((m_commentaryTree[s4][3] & 3) != 0) {
                    n10 |= 0x100;
                }
                sArray[n9 + 3] = 0;
                sArray[n9 + 4] = 0;
                int n11 = n9 + 3;
                sArray[n11] = (short)(sArray[n11] | (short)(n10 >> 16 & 0xFFFF));
                int n12 = n9 + 4;
                sArray[n12] = (short)(sArray[n12] | (short)(n10 >> 0 & 0xFFFF));
                if (m_commentaryTree[s4][10] >= 0) {
                    lastplayerpos1 = m_commentaryTree[s4][10];
                    m_lastTouchPlayerFromTeamInPossession = Match.getPlayerFromCommentaryPosition(m_commentaryTree[s4][10] & 0xFF, m_possession, n7, true);
                }
                if (m_commentaryTree[s4][11] >= 0) {
                    lastplayerpos2 = m_commentaryTree[s4][11];
                    m_lastTouchPlayerFromTeamWithOutPossession = Match.getPlayerFromCommentaryPosition(m_commentaryTree[s4][11] & 0xFF, m_possession ^ 1, n6, true);
                }
                int n13 = n9 + 5;
                sArray[n13] = (short)(sArray[n13] | lastplayerpos1 & 0xFF);
                int n14 = n9 + 5;
                sArray[n14] = (short)(sArray[n14] | (lastplayerpos2 & 0xFF) << 8);
                if (m_possession == 1) {
                    sArray[n9 + 2] = (short)(100 - sArray[3 + (s * 8 + 2)]);
                }
                if (m_matchPeriod != 4) {
                    if ((n10 & 0x40) != 0) {
                        m_possession = 0;
                    } else if ((n10 & 0x80) != 0) {
                        m_possession = 1;
                    }
                }
                n = Match.getNextSituationFlagFromOutcome(m_commentaryTree[s4][4]);
                if ((s = (short)(s + 1)) < 70) continue;
                n9 = 3 + s2 * 8;
                sArray[n9 + 3] = 8192;
                sArray[n9 + 4] = 0;
                sArray[n9 + 7] = n4;
                s = (short)(s2 + 1);
                s3 = sArray[n9 + 0];
                m_possession = sArray[n9 + 6];
                n = -1;
                break;
            }
            s4 = m_commentaryTree[s4][2];
        } while (s4 >= 0);
        sArray[0] = s;
        sArray[1] = s3;
        sArray[2] = (short)m_possession;
        return n;
    }

    public static void debugPrintTextString(int n) {
    }

    public static void interruptMatchAndRecalculateMatchTable(int n) {
        byte by = GameLogic.m_leagueInfo[GameLogic.m_matchTeam1LeagueId][18 + 88 * GameLogic.m_matchTeam1 + 36];
        byte by2 = GameLogic.m_leagueInfo[GameLogic.m_matchTeam2LeagueId][18 + 88 * GameLogic.m_matchTeam2 + 36];
        m_matchMessagesQueue = Match.matchCreateMatchCommentaryTable(Match.getTeamsBuffer(0), Match.getTeamsBuffer(1), (short)m_matchPeriodClock, n, m_matchTeamWithPossession, (short)GameLogic.m_matchType, by, by2);
        m_matchMessagesDispatchCounter = 0;
    }

    private static int matchCreatorFindChunk(int n) {
        int n2;
        int n3 = m_commentaryTreeRootNodeId;
        int[] nArray = new int[40];
        int n4 = 0;
        for (n2 = 0; n2 < 40; ++n2) {
            nArray[n2] = 0;
        }
        n2 = 0;
        while (n3 >= 0) {
            n4 = (m_commentaryTree[n3][5] & 0xFFFF) << 16 | (m_commentaryTree[n3][4] & 0xFFFF) << 0;
            if ((n4 & n) != 0 && m_commentaryTree[n3][2] >= 0) {
                nArray[n2++] = n3;
            }
            n3 = m_commentaryTree[n3][1];
        }
        return nArray[(DDMath.getRandom() & 0xFFFF) % n2];
    }

    private static int matchCreatorChooseChild(short s, byte[] byArray, int n) {
        int n2;
        int n3;
        short s2 = m_commentaryTree[s][2];
        int n4 = 0;
        int n5 = 0;
        if (m_commentaryTree[s2][1] < 0) {
            return s2;
        }
        for (n3 = 0; n3 < 100; ++n3) {
            Match.m_fairometer[n3] = 0;
        }
        short s3 = 0;
        short s4 = 0;
        if (m_possession == m_userTeam) {
            n2 = 0;
            short s5 = 0;
            short s6 = 0;
            int n6 = GameLogic.getPlayerTypeFromTeamFormation(n, m_lastTouchPlayerFromTeamInPossession);
            if (n6 == 4) {
                n6 = GameLogic.getPlayerTypeFromPositionId(byArray);
            }
            n2 = GameLogic.m_trainingBonus[n6 * 10 + GameLogic.m_trainingInfo[n6 * 4 + 0]];
            n2 = (short)(n2 + GameLogic.m_trainingBonus[n6 * 10 + GameLogic.m_trainingInfo[n6 * 4 + 2 + 0]]);
            n5 = Match.calculateStrategyBias(n, n6);
            s5 = (short)(byArray[32] - 50 >> 2);
            s6 = (short)(100 - byArray[28] >> 4);
            s3 = (short)(n2 + s5 + s6);
            s4 = m_tacklingStatModifier[GameLogic.m_tacticsTackling];
        }
        do {
            int n7 = 5;
            short s7 = byArray[16 + m_commentaryTree[s2][8]];
            if (m_commentaryTree[s2][8] == 19 && m_lastTouchPlayerFromTeamInPossession != 0) {
                s7 = (short)(s7 + s4);
            }
            s7 = (short)(s7 + s3);
            s7 = (short)(s7 - 80);
            short s8 = m_commentaryTree[s2][7];
            if (s8 > 5) {
                n7 = s7 >= 0 ? (int)((short)(n7 + (s7 >> 2))) : (int)((short)(n7 + s7 / 16));
                n7 = (short)(n7 + n5);
            } else if (s8 < 5) {
                n7 = s7 >= 0 ? (int)((short)(n7 - (s7 >> 2))) : (int)((short)(n7 - s7 / 16));
                n7 = (short)(n7 - n5);
            }
            n7 = (short)DDLUtility.CAP_NUMBER_LOW(n7, 2);
            for (n3 = 0; n3 < n7 && n4 < 100; n4 = (int)((short)(n4 + 1)), ++n3) {
                Match.m_fairometer[n4] = s2;
            }
            if (n4 < 100) continue;
            DDDebug.msg("Fairometer overflow, node id " + s2);
        } while ((s2 = m_commentaryTree[s2][1]) >= 0);
        n2 = (DDMath.getRandom() & 0xFFFF) % n4;
        return m_fairometer[n2];
    }

    private static int matchGetPreMatchCommentaryTypes() {
        int n = 524288;
        block0 : switch (GameLogic.m_gameCurrentMatchMessage[5]) {
            case 1: {
                int n2 = GameLogic.gameGenerateResultMessages(true);
                switch (n2) {
                    case 9: {
                        n |= 0x400000;
                        break block0;
                    }
                    case 10: {
                        n |= 0x800000;
                        n |= 0x4000000;
                        break block0;
                    }
                }
                break;
            }
            case 2: 
            case 3: {
                n |= 0x1000000;
                break;
            }
            case 0: {
                n |= 0x8000000;
            }
        }
        return n;
    }

    private static int matchInitPeriod() {
        int n;
        m_matchTeamWithPossession = 0;
        m_matchPeriodClock = 0;
        m_matchClock = m_matchPeriodStartTimeList[m_matchPeriod];
        m_matchEvent = 0;
        byte by = GameLogic.m_leagueInfo[GameLogic.m_matchTeam1LeagueId][18 + 88 * GameLogic.m_matchTeam1 + 36];
        byte by2 = GameLogic.m_leagueInfo[GameLogic.m_matchTeam2LeagueId][18 + 88 * GameLogic.m_matchTeam2 + 36];
        if (m_matchPeriod == 0) {
            m_matchTeamWithPossession = 0;
            n = Match.matchGetPreMatchCommentaryTypes();
        } else {
            m_matchTeamWithPossession = 1;
            n = 256;
        }
        DDDebug.msg("Create commentary table");
        m_matchMessagesQueue = Match.matchCreateMatchCommentaryTable(Match.getTeamsBuffer(0), Match.getTeamsBuffer(1), (short)0, n, (short)(m_matchPeriod % 2), (short)GameLogic.m_matchType, by, by2);
        DDDebug.msg("Set up player names");
        XMLMenuSystem.setUpCodedTextArrayWithPlayerLineUp(Match.getTeamsBuffer(0), Match.getTeamsBuffer(1), 1);
        Match.resetCommentaryPlayerList();
        m_matchPossessionPosition = 50;
        m_matchIdealPossessionPosition = 50;
        m_matchMessagesDispatchCounter = 0;
        if (XMLMenuSystem.m_currMenu == 29) {
            XMLMenuSystem.setMenu(29, false);
        }
        for (int i = 0; i < 20; ++i) {
            Match.m_matchPlayerInfo[i][6] = m_matchPlayerInfo[i][4];
            Match.m_matchPlayerInfo[i][7] = m_matchPlayerInfo[i][5];
        }
        DDDebug.msg("Set to in-play");
        Match.matchSetState(2);
        return 0;
    }

    public static short[] getSetPieceTakers(short s, short s2) {
        short[] sArray = new short[4];
        int n = 18 + 88 * s2;
        sArray[0] = (short)((GameLogic.m_leagueInfo[s][n + 80] & 0xFF) << 8 | (GameLogic.m_leagueInfo[s][n + 81] & 0xFF) << 0);
        sArray[1] = (short)((GameLogic.m_leagueInfo[s][n + 82] & 0xFF) << 8 | (GameLogic.m_leagueInfo[s][n + 83] & 0xFF) << 0);
        sArray[2] = (short)((GameLogic.m_leagueInfo[s][n + 84] & 0xFF) << 8 | (GameLogic.m_leagueInfo[s][n + 85] & 0xFF) << 0);
        sArray[3] = (short)((GameLogic.m_leagueInfo[s][n + 86] & 0xFF) << 8 | (GameLogic.m_leagueInfo[s][n + 87] & 0xFF) << 0);
        return sArray;
    }

    public static void initialisePlayerData() {
        int n;
        int n2 = 0;
        byte[] byArray = Match.LoadBufferedPlayerFile(0);
        GameLogic.m_gameTotalPlayers = DDLUtility.MAKE_SHORT_BIG_ENDIAN(byArray, n2);
        m_playersperfile = DDLUtility.MAKE_SHORT_BIG_ENDIAN(byArray, n2 += 2);
        n2 += 2;
        GameLogic.m_loadedPlayer = new byte[34];
        GameLogic.m_usersTeamBuffer = new byte[20][34];
        for (n = 0; n < 20; ++n) {
            for (int i = 0; i < 34; ++i) {
                GameLogic.m_usersTeamBuffer[n][i] = 0;
            }
        }
        GameLogic.m_otherTeamBuffer = new byte[20][34];
        for (n = 0; n < 20; ++n) {
            GameLogic.m_otherTeamBuffer[n][32] = 50;
            GameLogic.m_otherTeamBuffer[n][28] = 100;
        }
        GameLogic.m_playersInfo = new byte[GameLogic.m_gameTotalPlayers];
        GameLogic.m_playerSearchViewData = new byte[20][20];
        GameLogic.m_playerSearchResults = new short[GameLogic.m_gameTotalPlayers];
        System.gc();
    }

    public static void loadTeamPlayers(byte[][] byArray, byte[][] byArray2, int n, int n2) {
        int n3 = 18 + n2 * 88 + 40;
        for (int i = 0; i < 20; ++i) {
            short s = DDLUtility.MAKE_SHORT_BIG_ENDIAN(byArray2[n], n3);
            if (s >= 0) {
                byArray[i] = Match.getPlayer(s, byArray[i]);
            }
            n3 += 2;
        }
    }

    public static byte[] getPlayer(int n, byte[] byArray) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = n / m_playersperfile;
        int n7 = n % m_playersperfile;
        byte[] byArray2 = Match.LoadBufferedPlayerFile(n6);
        if (byArray == null) {
            byArray = new byte[34];
        } else {
            for (n5 = 0; n5 < 28; ++n5) {
                byArray[n5] = 0;
            }
        }
        n5 = 0;
        n5 = 4;
        for (n4 = 0; n4 < n7; ++n4) {
            n3 = byArray2[n5++] & 0xFF;
            n2 = n3 & 0x1F;
            n5 += n2 + 8;
        }
        n3 = byArray2[n5++];
        n2 = n3 & 0x1F;
        boolean bl = false;
        for (n4 = 0; n4 < n2; ++n4) {
            if (bl) {
                byArray[n4] = 46;
                ++n2;
                bl = false;
            } else {
                byArray[n4] = byArray2[n5++];
                if (n4 == 0 && byArray[n4] > 0 && (n3 & 0x20) != 0) {
                    bl = true;
                } else if (n4 == 1 && byArray[0] < 0 && (n3 & 0x20) != 0) {
                    bl = true;
                }
            }
            if (byArray[n4] < 97 || byArray[n4] > 122) continue;
            if (n4 == 0) {
                int n8 = n4;
                byArray[n8] = (byte)(byArray[n8] - 32);
                continue;
            }
            if (byArray[n4 - 1] != 32 && byArray[n4 - 1] != 46 && byArray[n4 - 1] != 45) continue;
            int n9 = n4;
            byArray[n9] = (byte)(byArray[n9] - 32);
        }
        n4 = byArray2[n5++] & 0xFF;
        int n10 = n4 >> 0 & 0xF;
        int n11 = n4 >> 4 & 0xF;
        byArray[16] = (byte)((n10 + 5) * 5 + 2 - (n11 & 3));
        byArray[17] = (byte)((n11 + 5) * 5 + 2 - (n10 & 3));
        n4 = byArray2[n5++] & 0xFF;
        n10 = n4 >> 0 & 0xF;
        n11 = n4 >> 4 & 0xF;
        byArray[18] = (byte)((n10 + 5) * 5 + 2 - (n11 & 3));
        byArray[19] = (byte)((n11 + 5) * 5 + 2 - (n10 & 3));
        n4 = byArray2[n5++] & 0xFF;
        n10 = n4 >> 0 & 0xF;
        n11 = n4 >> 4 & 0xF;
        byArray[20] = (byte)((n10 + 5) * 5 + 2 - (n11 & 3));
        byArray[21] = (byte)((n11 + 5) * 5 + 2 - (n10 & 3));
        n4 = byArray2[n5++] & 0xFF;
        n10 = n4 >> 0 & 0xF;
        n11 = n4 >> 4 & 0xF;
        byArray[22] = (byte)((n10 + 5) * 5 + 2 - (n11 & 3));
        byArray[23] = (byte)((n11 + 5) * 5 + 2 - (n10 & 3));
        byArray[24] = byArray2[n5++];
        byArray[25] = byArray2[n5++];
        byArray[26] = (byte)(byArray2[n5++] + GameLogic.m_gameNumSeason);
        byArray[27] = byArray2[n5++];
        return byArray;
    }

    public static byte[] LoadBufferedPlayerFile(int n) {
        if (m_currentBufferFileId != n) {
            m_currentBufferFile = null;
            System.gc();
            m_currentBufferFileId = n;
            DDDebug.msg("try to load /pd" + n + ".bin");
            m_currentBufferFile = DDFile.loadFileBytes("/pd" + n + ".bin");
        }
        return m_currentBufferFile;
    }

    public static void matchLoadMiscData(String string) {
        int n;
        int n2;
        int n3 = 0;
        byte[] byArray = DDFile.loadFileBytes(string);
        GameLogic.m_preSeasonFixtureDates = new short[3];
        for (n2 = 0; n2 < 3; ++n2) {
            GameLogic.m_preSeasonFixtureDates[n2] = (short)((byArray[n3++] & 0xFF) << 8 | (byArray[n3++] & 0xFF) << 0);
        }
        GameLogic.m_leagueFixtureDates = new short[46];
        for (n2 = 0; n2 < 46; ++n2) {
            GameLogic.m_leagueFixtureDates[n2] = (short)((byArray[n3++] & 0xFF) << 8 | (byArray[n3++] & 0xFF) << 0);
        }
        GameLogic.m_initialFunds = new byte[3];
        n3 = Match.matchPopulateByteArray(GameLogic.m_initialFunds, byArray, n3, 3);
        GameLogic.m_initialSponsorship = new byte[3];
        n3 = Match.matchPopulateByteArray(GameLogic.m_initialSponsorship, byArray, n3, 3);
        GameLogic.m_gameYearlyCalendar = new byte[12];
        n3 = Match.matchPopulateByteArray(GameLogic.m_gameYearlyCalendar, byArray, n3, 12);
        XMLMenuSystem.m_gameDayPrefix = new byte[10];
        n3 = Match.matchPopulateByteArray(XMLMenuSystem.m_gameDayPrefix, byArray, n3, 10);
        GameLogic.m_teamColourList = new int[64];
        for (n2 = 0; n2 < 64; ++n2) {
            GameLogic.m_teamColourList[n2] = (byArray[n3++] & 0xFF) << 0 | (byArray[n3++] & 0xFF) << 8 | (byArray[n3++] & 0xFF) << 16;
            ++n3;
        }
        m_matchPeriodTimeList = new byte[5];
        n3 = Match.matchPopulateByteArray(m_matchPeriodTimeList, byArray, n3, 5);
        m_matchPeriodStartTimeList = new byte[5];
        n3 = Match.matchPopulateByteArray(m_matchPeriodStartTimeList, byArray, n3, 5);
        m_ballpositionLookUp = new byte[54];
        n3 = Match.matchPopulateByteArray(m_ballpositionLookUp, byArray, n3, 54);
        GameLogic.playerTypeMap = new byte[11];
        n3 = Match.matchPopulateByteArray(GameLogic.playerTypeMap, byArray, n3, 11);
        m_formationLineup = new byte[12][20];
        for (n2 = 0; n2 < 12; ++n2) {
            for (n = 0; n < 20; ++n) {
                Match.m_formationLineup[n2][n] = n < 11 ? byArray[n3++] : 10;
            }
        }
        GameLogic.formations = new byte[12][6];
        for (n2 = 0; n2 < 12; ++n2) {
            n3 = Match.matchPopulateByteArray(GameLogic.formations[n2], byArray, n3, 6);
        }
        m_commentaryPositions = new byte[50][];
        for (n2 = 0; n2 < 50; ++n2) {
            byte by = byArray[n3++];
            Match.m_commentaryPositions[n2] = new byte[by];
            n3 = Match.matchPopulateByteArray(m_commentaryPositions[n2], byArray, n3, by);
        }
        nextsituationtable = new int[36];
        for (n2 = 0; n2 < 18; ++n2) {
            n = (byArray[n3++] & 0xFF) << 24 | (byArray[n3++] & 0xFF) << 16 | (byArray[n3++] & 0xFF) << 8 | (byArray[n3++] & 0xFF) << 0;
            Match.nextsituationtable[n2 * 2 + 0] = n & Integer.MAX_VALUE;
            Match.nextsituationtable[n2 * 2 + 1] = n >> 31 & 1;
        }
        byArray = null;
        System.gc();
    }

    public static int matchPopulateByteArray(byte[] byArray, byte[] byArray2, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            byArray[i] = byArray2[n + i];
        }
        return n + n2;
    }

    public static void matchLoadCountryData(String string) {
        byte[] byArray = DDFile.loadFileBytes(string);
        int n = byArray.length;
        m_matchCountryNumCountries = byArray[0];
        m_matchCountryInfo = new byte[n - 1];
        System.arraycopy(byArray, 1, m_matchCountryInfo, 0, n - 1);
        byArray = null;
        System.gc();
    }

    public static int matchGetCountryOffsetByID(int n) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 += m_matchCountryInfo[n2] + 1;
        }
        return n2;
    }

    public static int matchUpdate() {
        long l = MainFrame.m_gameTime;
        long l2 = m_commentarytimearray[XMLMenuSystem.m_globalArray[3]];
        long l3 = m_matchminutetimearray[XMLMenuSystem.m_globalArray[3]];
        if ((m_matchEvent & 0xC) != 0) {
            l2 = 2000L;
        }
        GameLogic.m_matchTeam1Formation = GameLogic.m_leagueInfo[GameLogic.m_matchTeam1LeagueId][18 + 88 * GameLogic.m_matchTeam1 + 36];
        GameLogic.m_matchTeam2Formation = GameLogic.m_leagueInfo[GameLogic.m_matchTeam2LeagueId][18 + 88 * GameLogic.m_matchTeam2 + 36];
        int n = m_matchIdealPossessionPosition - m_matchPossessionPosition;
        n = n < 0 ? (n -= 4) : (n += 4);
        m_matchPossessionPosition += n >> 3;
        n = 0;
        switch (m_matchState) {
            case 2: {
                do {
                    if (n == 0 && (long)DDLUtility.ELAPSED_TIME(l, m_matchTextCounter) <= l2) continue;
                    if (Match.matchMessageDispatcher() > 0) {
                        if (n != 0 && !m_hideEvents) {
                            n = 0;
                            --m_matchMessagesDispatchCounter;
                            continue;
                        }
                        XMLMenuSystem.setMenu(XMLMenuSystem.m_currMenu, false);
                        if (m_matchEvent > 0) {
                            Match.matchHandleEvent(m_matchEvent, GameLogic.MATCH_MESSAGE_PLAYER_TEAM1(m_matchEventPlayers), GameLogic.MATCH_MESSAGE_PLAYER_TEAM2(m_matchEventPlayers));
                        }
                        m_matchTextCounter = l;
                        XMLMenuSystem.m_menuRefreshCount = 1;
                        if (!m_hideEvents) continue;
                        n = 1;
                        continue;
                    }
                    if (n == 0 && (long)DDLUtility.ELAPSED_TIME(l, m_matchMinuteTimer) <= l3) continue;
                    Match.onMatchMinute();
                    ++m_matchPeriodClock;
                    m_matchMinuteTimer = l;
                    XMLMenuSystem.m_menuRefreshCount = 1;
                } while (n != 0 || m_hideEvents);
                if ((m_matchEvent & 0x100) != 0) {
                    if (DDLUtility.ELAPSED_TIME(l, m_flashingTextTimer) > 300) {
                        m_flashingText = (byte)(m_flashingText ^ 1);
                        m_flashingTextTimer = l;
                    }
                } else {
                    m_flashingText = 0;
                }
                XMLMenuSystem.m_workArray[7] = m_matchClock + m_matchPeriodClock;
                XMLMenuSystem.addNumberToCodedTextArray(XMLMenuSystem.m_workArray[7], 0, 27);
                break;
            }
        }
        return 0;
    }

    public static int matchMessageDispatcher() {
        int n = m_matchMessagesDispatchCounter;
        if (m_matchMessagesDispatchCounter < m_matchCommentaryTable[0] && m_matchMessagesQueue[3 + (n * 8 + 0)] == m_matchPeriodClock) {
            m_matchCommentaryString = m_matchMessagesQueue[3 + (n * 8 + 1)];
            m_matchIdealPossessionPosition = m_matchMessagesQueue[3 + (n * 8 + 2)];
            m_matchEvent = (m_matchMessagesQueue[3 + (n * 8 + 3)] & 0xFFFF) << 16 | m_matchMessagesQueue[3 + (n * 8 + 4)] & 0xFFFF;
            m_matchTeamWithPossession = (byte)m_matchMessagesQueue[3 + (n * 8 + 6)];
            m_matchEventPlayers = m_matchMessagesQueue[3 + (n * 8 + 5)];
            m_currentEventData = m_matchMessagesQueue[3 + (n * 8 + 7)];
            ++m_matchMessagesDispatchCounter;
            return 1;
        }
        return 0;
    }

    public static void onMatchMinute() {
        if (m_matchPossessionPosition < 33) {
            int n = 12 + m_matchTeamWithPossession;
            GameLogic.m_matchStatistics[n] = (byte)(GameLogic.m_matchStatistics[n] + 1);
        } else if (m_matchPossessionPosition < 66) {
            int n = 14 + m_matchTeamWithPossession;
            GameLogic.m_matchStatistics[n] = (byte)(GameLogic.m_matchStatistics[n] + 1);
        } else {
            int n = 16 + m_matchTeamWithPossession;
            GameLogic.m_matchStatistics[n] = (byte)(GameLogic.m_matchStatistics[n] + 1);
        }
        for (int i = 0; i < 11; ++i) {
            if (GameLogic.m_usersTeamBuffer[i][31] != 0) continue;
            byte by = GameLogic.m_matchLineUp[0][i];
            Match.m_matchPlayerInfo[by][0] = (short)((m_matchPlayerInfo[by][0] << 8) + (m_matchPlayerInfo[by][1] - m_matchPlayerInfo[by][0] << 8) / 90 >> 8);
            short[] sArray = m_matchPlayerInfo[by];
            sArray[2] = (short)(sArray[2] - (86 - (GameLogic.m_usersTeamBuffer[i][23] >> 1)));
        }
    }

    private static void matchHandleEvent(int n, int n2, int n3) {
        byte by;
        byte by2;
        short s;
        int n4;
        byte by3;
        boolean bl = false;
        int n5 = 0;
        n2 = Match.getPlayerFromCommentaryPosition(n2, m_matchTeamWithPossession, m_matchTeamWithPossession == 0 ? GameLogic.m_matchTeam1Formation : GameLogic.m_matchTeam2Formation, false);
        n3 = Match.getPlayerFromCommentaryPosition(n3, m_matchTeamWithPossession ^ 1, (m_matchTeamWithPossession ^ 1) == 0 ? GameLogic.m_matchTeam1Formation : GameLogic.m_matchTeam2Formation, false);
        if ((n & 2) != 0) {
            Match.matchSetState(0);
            if (m_hideEvents) {
                m_hideEvents = false;
            }
        }
        if ((n & 4) != 0) {
            GameLogic.m_matchStatistics[0] = (byte)(GameLogic.m_matchStatistics[0] + 1);
            n5 = 0;
            by3 = n5 == m_userTeam ? GameLogic.m_matchLineUp[0][n2] : GameLogic.m_matchLineUp[1][n2];
            if ((n & 0x200000) == 0 && n5 == m_userTeam) {
                short[] sArray = m_matchPlayerInfo[by3];
                sArray[1] = (short)(sArray[1] + 150);
                short[] sArray2 = m_matchPlayerInfo[by3];
                sArray2[0] = (short)(sArray2[0] + 150);
                Match.m_matchPlayerInfo[by3][1] = (short)DDLUtility.CAP_NUMBER_HIGH(m_matchPlayerInfo[by3][1], 1000);
                Match.m_matchPlayerInfo[by3][0] = (short)DDLUtility.CAP_NUMBER_HIGH(m_matchPlayerInfo[by3][0], 1000);
                short[] sArray3 = m_matchPlayerInfo[by3];
                sArray3[4] = (short)(sArray3[4] + 1);
            }
            if ((n & 0x200000) == 0) {
                n4 = 18 + GameLogic.m_matchTeam1 * 88 + 40;
                s = DDLUtility.MAKE_SHORT_BIG_ENDIAN(GameLogic.m_leagueInfo[GameLogic.m_matchTeam1LeagueId], n4 + (by3 << 1));
            } else {
                n4 = 18 + GameLogic.m_matchTeam2 * 88 + 40;
                n5 = 1;
                by3 = n5 == m_userTeam ? GameLogic.m_matchLineUp[0][n3] : GameLogic.m_matchLineUp[1][n3];
                s = DDLUtility.MAKE_SHORT_BIG_ENDIAN(GameLogic.m_leagueInfo[GameLogic.m_matchTeam2LeagueId], n4 + (by3 << 1));
            }
            Match.matchStoreEvent(0, s, n5, m_matchClock + m_matchPeriodClock);
        }
        if ((n & 8) != 0) {
            GameLogic.m_matchStatistics[1] = (byte)(GameLogic.m_matchStatistics[1] + 1);
            n5 = 1;
            by3 = n5 == m_userTeam ? GameLogic.m_matchLineUp[0][n2] : GameLogic.m_matchLineUp[1][n2];
            if ((n & 0x200000) == 0 && n5 == m_userTeam) {
                short[] sArray = m_matchPlayerInfo[by3];
                sArray[1] = (short)(sArray[1] + 150);
                short[] sArray4 = m_matchPlayerInfo[by3];
                sArray4[0] = (short)(sArray4[0] + 150);
                Match.m_matchPlayerInfo[by3][1] = (short)DDLUtility.CAP_NUMBER_HIGH(m_matchPlayerInfo[by3][1], 1000);
                Match.m_matchPlayerInfo[by3][0] = (short)DDLUtility.CAP_NUMBER_HIGH(m_matchPlayerInfo[by3][0], 1000);
                short[] sArray5 = m_matchPlayerInfo[by3];
                sArray5[4] = (short)(sArray5[4] + 1);
            }
            if ((n & 0x200000) == 0) {
                n4 = 18 + GameLogic.m_matchTeam2 * 88 + 40;
                s = DDLUtility.MAKE_SHORT_BIG_ENDIAN(GameLogic.m_leagueInfo[GameLogic.m_matchTeam2LeagueId], n4 + (by3 << 1));
            } else {
                n4 = 18 + GameLogic.m_matchTeam1 * 88 + 40;
                n5 = 0;
                by3 = n5 == m_userTeam ? GameLogic.m_matchLineUp[0][n3] : GameLogic.m_matchLineUp[1][n3];
                s = DDLUtility.MAKE_SHORT_BIG_ENDIAN(GameLogic.m_leagueInfo[GameLogic.m_matchTeam1LeagueId], n4 + (by3 << 1));
            }
            Match.matchStoreEvent(0, s, n5, m_matchClock + m_matchPeriodClock);
        }
        if ((n & 0x2000) != 0) {
            int n6 = 2 + m_matchTeamWithPossession;
            GameLogic.m_matchStatistics[n6] = (byte)(GameLogic.m_matchStatistics[n6] + 1);
        }
        if ((n & 0x800) != 0) {
            int n7 = 4 + m_matchTeamWithPossession;
            GameLogic.m_matchStatistics[n7] = (byte)(GameLogic.m_matchStatistics[n7] + 1);
        }
        if ((n & 0x8000) != 0) {
            if (!m_hideEvents) {
                MainFrame.soundPlay(1);
            }
            int n8 = 18 + m_matchTeamWithPossession;
            GameLogic.m_matchStatistics[n8] = (byte)(GameLogic.m_matchStatistics[n8] + 1);
        }
        if ((n & 0x200) != 0) {
            int n9 = 8 + (m_matchTeamWithPossession ^ 1);
            GameLogic.m_matchStatistics[n9] = (byte)(GameLogic.m_matchStatistics[n9] + 1);
        }
        if ((n & 0x10000) != 0) {
            m_offenderindex = n3;
            XMLMenuSystem.m_menuRefreshCount = 1;
        }
        if ((n & 0x20000) != 0) {
            n5 = (byte)(m_matchTeamWithPossession ^ 1);
            by3 = n5 == m_userTeam ? GameLogic.m_matchLineUp[0][m_offenderindex] : GameLogic.m_matchLineUp[1][m_offenderindex];
            if (n5 == m_userTeam) {
                short[] sArray = m_matchPlayerInfo[by3];
                sArray[1] = (short)(sArray[1] + -150);
                short[] sArray6 = m_matchPlayerInfo[by3];
                sArray6[0] = (short)(sArray6[0] + -150);
                Match.m_matchPlayerInfo[by3][1] = (short)DDLUtility.CAP_NUMBER_LOW(m_matchPlayerInfo[by3][1], 400);
                Match.m_matchPlayerInfo[by3][0] = (short)DDLUtility.CAP_NUMBER_LOW(m_matchPlayerInfo[by3][0], 400);
                short[] sArray7 = m_matchPlayerInfo[by3];
                sArray7[5] = (short)(sArray7[5] + 1);
            }
            if (n5 == 0) {
                by2 = GameLogic.m_matchTeam1LeagueId;
                by = GameLogic.m_matchTeam1;
            } else {
                by2 = GameLogic.m_matchTeam2LeagueId;
                by = GameLogic.m_matchTeam2;
            }
            if ((Match.getTeamsBuffer(n5)[by3][30] & 1) != 0) {
                Match.getTeamsBuffer((int)n5)[by3][30] = 4;
                Match.getTeamsBuffer((int)n5)[by3][31] = 4;
                s = GameLogic.getTeamPlayerId(by2, by, m_offenderindex);
                Match.matchStoreEvent(2, s, n5, m_matchClock + m_matchPeriodClock);
            } else {
                byte[] byArray = Match.getTeamsBuffer(n5)[by3];
                byArray[30] = (byte)(byArray[30] | 1);
                s = GameLogic.getTeamPlayerId(by2, by, m_offenderindex);
                Match.matchStoreEvent(1, s, n5, m_matchClock + m_matchPeriodClock);
            }
        }
        if ((n & 0x40000) != 0) {
            n5 = (byte)(m_matchTeamWithPossession ^ 1);
            by3 = n5 == m_userTeam ? GameLogic.m_matchLineUp[0][m_offenderindex] : GameLogic.m_matchLineUp[1][m_offenderindex];
            if (n5 == 0) {
                by2 = GameLogic.m_matchTeam1LeagueId;
                by = GameLogic.m_matchTeam1;
            } else {
                by2 = GameLogic.m_matchTeam2LeagueId;
                by = GameLogic.m_matchTeam2;
            }
            byte[] byArray = Match.getTeamsBuffer(n5)[by3];
            byArray[30] = (byte)(byArray[30] | 4);
            Match.getTeamsBuffer((int)n5)[by3][31] = 4;
            s = GameLogic.getTeamPlayerId(by2, by, m_offenderindex);
            Match.matchStoreEvent(2, s, n5, m_matchClock + m_matchPeriodClock);
        }
        if ((n & 0x4000) != 0) {
            if (!m_hideEvents) {
                MainFrame.soundPlay(1);
            }
            int n10 = 6 + (m_matchTeamWithPossession ^ 1);
            GameLogic.m_matchStatistics[n10] = (byte)(GameLogic.m_matchStatistics[n10] + 1);
        }
        if ((n & 0x1000) != 0) {
            int n11 = 10 + m_matchTeamWithPossession;
            GameLogic.m_matchStatistics[n11] = (byte)(GameLogic.m_matchStatistics[n11] + 1);
        }
        if ((n & 0x80000) != 0) {
            Match.resetCommentaryPlayerList();
        }
        if ((n & 0x20000000) != 0) {
            DDDebug.msg("**** Recalculate match table " + m_currentEventData);
            Match.interruptMatchAndRecalculateMatchTable(1 << m_currentEventData);
            Match.matchMessageDispatcher();
        }
    }

    public static int matchSetState(int n) {
        int n2 = m_matchState;
        m_matchState = n;
        switch (n) {
            case 0: {
                MainFrame.soundPlay(2);
                XMLMenuSystem.setMenu(29, false);
                Match.matchEndPeriod(m_matchPeriod);
                m_crowdPlayed = false;
                m_flashingTextTimer = MainFrame.m_gameTime;
                break;
            }
            case 1: {
                DDDebug.msg("Begin period " + (m_matchPeriod + 1));
                ++m_matchPeriod;
                if (!MainFrame.m_interrupted) {
                    MainFrame.soundPlay(1);
                }
                Match.matchInitPeriod();
                break;
            }
            case 2: {
                m_flashingTextTimer = m_matchMinuteTimer = (m_matchTextCounter = MainFrame.m_gameTime);
            }
        }
        return 0;
    }

    public static int matchEndPeriod(int n) {
        m_matchEnded = false;
        block0 : switch (n) {
            case 0: {
                if (XMLMenuSystem.m_currMenu == 30 || XMLMenuSystem.m_currMenu == 29 || XMLMenuSystem.m_currMenu == 28) {
                    XMLMenuSystem.m_gameReturnMenu = XMLMenuSystem.m_currMenu;
                }
                if (m_gameMode != 0) break;
                if (GameLogic.m_gameCurrentMatchMessage[5] == 1) {
                    GameLogic.gameCalculateCurrentWeeklyFixtureResults(GameLogic.m_gameLeagueID, false);
                    break;
                }
                if (GameLogic.m_gameCurrentMatchMessage[5] == 2 || GameLogic.m_gameCurrentMatchMessage[5] == 3 || GameLogic.m_gameCurrentMatchMessage[5] != 0) break;
                for (int i = 0; i < 3; ++i) {
                    if (GameLogic.gameCompareDates(GameLogic.m_gamePreSeasonFriendly[i][2], GameLogic.m_gameCurrentDate) != 1) continue;
                    GameLogic.m_gamePreSeasonFriendly[i][3] = GameLogic.m_matchStatistics[0];
                    GameLogic.m_gamePreSeasonFriendly[i][4] = GameLogic.m_matchStatistics[1];
                    break block0;
                }
                break;
            }
            case 1: {
                m_matchEnded = true;
                if (m_gameMode == 0) {
                    if (XMLMenuSystem.m_currMenu == 30 || XMLMenuSystem.m_currMenu == 29 || XMLMenuSystem.m_currMenu == 28) {
                        XMLMenuSystem.m_gameReturnMenu = XMLMenuSystem.m_currMenu;
                    }
                    if (GameLogic.m_gameCurrentMatchMessage[5] == 1) {
                        GameLogic.gameCalculateCurrentWeeklyFixtureResults(GameLogic.m_gameLeagueID, true);
                        break;
                    }
                    if (GameLogic.m_gameCurrentMatchMessage[5] != 0) break;
                    for (int i = 0; i < 3; ++i) {
                        if (GameLogic.m_gamePreSeasonFriendly[i][2] != GameLogic.m_gameCurrentDate) continue;
                        GameLogic.m_gamePreSeasonFriendly[i][3] = GameLogic.m_matchStatistics[0];
                        GameLogic.m_gamePreSeasonFriendly[i][4] = GameLogic.m_matchStatistics[1];
                        break block0;
                    }
                    break;
                }
                if (m_gameMode != 2 || GameLogic.m_gameCurrentMatchMessage[5] != 2 && GameLogic.m_gameCurrentMatchMessage[5] != 3 || GameLogic.m_matchStatistics[0] != GameLogic.m_matchStatistics[1]) break;
                m_matchEnded = false;
                break;
            }
            case 2: {
                if (m_gameMode != 0) break;
                break;
            }
            case 3: {
                m_matchEnded = true;
                if (m_gameMode == 0) {
                    // empty if block
                }
                if (GameLogic.m_matchStatistics[0] != GameLogic.m_matchStatistics[1]) {
                    if (m_gameMode != 0) break;
                    break;
                }
                m_matchEnded = false;
                break;
            }
            case 4: {
                m_matchEnded = true;
                if (m_gameMode != 0) break;
            }
        }
        return 0;
    }

    public static int playerCalculateTargetRating(byte[] byArray, int n) {
        int n2 = 0;
        switch (GameLogic.getPlayerTypeFromPositionId(byArray)) {
            case 0: {
                int n3 = byArray[17] * 10;
                int n4 = byArray[18] * 10;
                int n5 = byArray[16] * 10;
                int n6 = byArray[19] * 10;
                n2 = (n3 + n4 + n5 + n6) / 4;
                if (n == 0) break;
                n2 = n2 * 3 / 4;
                break;
            }
            case 1: {
                int n7 = byArray[22] * 10;
                int n8 = byArray[19] * 10;
                int n9 = byArray[17] * 10;
                int n10 = byArray[18] * 10;
                n2 = (n7 + n8 + n9 + n10) / 4;
                if (n == 0) {
                    n2 = n2 * 3 / 4;
                    break;
                }
                if (n == 2) {
                    n2 = n2 * 3 / 4;
                    break;
                }
                if (n != 3) break;
                n2 = n2 * 2 / 4;
                break;
            }
            case 2: {
                int n11 = byArray[18] * 10;
                int n12 = byArray[19] * 10;
                int n13 = byArray[21] * 10;
                int n14 = byArray[20] * 10;
                n2 = (n11 + n12 + n13 + n14) / 4;
                if (n == 0) {
                    n2 = n2 * 2 / 4;
                    break;
                }
                if (n == 1) {
                    n2 = n2 * 3 / 4;
                    break;
                }
                if (n != 3) break;
                n2 = n2 * 3 / 4;
                break;
            }
            case 3: {
                int n15 = byArray[22] * 10;
                int n16 = byArray[16] * 10;
                int n17 = byArray[21] * 10;
                int n18 = byArray[20] * 10;
                n2 = (n15 + n16 + n17 + n18) / 4;
                if (n == 0) {
                    n2 = n2 * 1 / 4;
                    break;
                }
                if (n == 1) {
                    n2 = n2 * 2 / 4;
                    break;
                }
                if (n != 2) break;
                n2 = n2 * 9 / 10;
                break;
            }
        }
        return n2;
    }

    public static void resetCommentaryPlayerList() {
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 50; ++j) {
                Match.m_commentaryUsedPositionList[i][j] = -1;
            }
        }
    }

    private static boolean checkPlayerIsntAlreadyUsedInCommentaryPlayerList(int n, int n2) {
        for (int i = 0; i < 50; ++i) {
            if (m_commentaryUsedPositionList[n2][i] != n) continue;
            return false;
        }
        return true;
    }

    public static int getPlayerFromCommentaryPosition(int n, int n2, int n3, boolean bl) {
        int n4;
        int n5;
        int n6;
        byte by;
        int n7 = -1;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        byte by2 = GameLogic.formations[n3][0];
        byte[] byArray = GameLogic.m_matchLineUp[0];
        if (n2 != m_userTeam) {
            byArray = GameLogic.m_matchLineUp[1];
        }
        if (m_commentaryUsedPositionList[n2][n] != -1 && n < 41) {
            by = byArray[m_commentaryUsedPositionList[n2][n]];
            if (Match.getTeamsBuffer(n2)[by][31] == 0) {
                return m_commentaryUsedPositionList[n2][n];
            }
        }
        if (by2 == 3) {
            n8 = GameLogic.formations[n3][1];
            n9 = GameLogic.formations[n3][2];
            n10 = GameLogic.formations[n3][3];
        } else if (by2 == 4) {
            n8 = GameLogic.formations[n3][1];
            n9 = GameLogic.formations[n3][2];
            n10 = GameLogic.formations[n3][3] + GameLogic.formations[n3][4];
        } else if (by2 == 5) {
            n8 = GameLogic.formations[n3][1];
            n9 = GameLogic.formations[n3][2] + GameLogic.formations[n3][3] + GameLogic.formations[n3][4];
            n10 = GameLogic.formations[n3][5];
        }
        if (n == 41) {
            n7 = m_offenderindex;
        } else if (n == 48) {
            n7 = XMLMenuSystem.subplayeridoff;
        } else if (n == 49) {
            n7 = XMLMenuSystem.subplayeridon;
        } else {
            block0 : switch (m_commentaryPositionsMappedToPlayerType[n]) {
                case -1: {
                    break;
                }
                case 0: {
                    n7 = 0;
                    break;
                }
                case 1: {
                    n6 = (DDMath.getRandom() & 0xFFFF) % n8;
                    for (n5 = 0; n5 < n8; ++n5) {
                        n4 = 1 + (n6 + n5) % n8;
                        if (!Match.checkPlayerIsntAlreadyUsedInCommentaryPlayerList(n4, n2)) continue;
                        by = byArray[n4];
                        if (Match.getTeamsBuffer(n2)[by][31] != 0) continue;
                        n7 = n4;
                        break block0;
                    }
                    break;
                }
                case 2: {
                    n6 = (DDMath.getRandom() & 0xFFFF) % n9;
                    for (n5 = 0; n5 < n9; ++n5) {
                        n4 = 1 + n8 + (n6 + n5) % n9;
                        if (!Match.checkPlayerIsntAlreadyUsedInCommentaryPlayerList(n4, n2)) continue;
                        by = byArray[n4];
                        if (Match.getTeamsBuffer(n2)[by][31] != 0) continue;
                        n7 = n4;
                        break block0;
                    }
                    break;
                }
                case 3: {
                    n6 = (DDMath.getRandom() & 0xFFFF) % n10;
                    for (n5 = 0; n5 < n10; ++n5) {
                        n4 = 1 + n8 + n9 + (n6 + n5) % n10;
                        if (!Match.checkPlayerIsntAlreadyUsedInCommentaryPlayerList(n4, n2)) continue;
                        by = byArray[n4];
                        if (Match.getTeamsBuffer(n2)[by][31] != 0) continue;
                        n7 = n4;
                        break block0;
                    }
                    break;
                }
                case 5: {
                    if (n2 == 0) {
                        n7 = GameLogic.getTeamPlayerIndex(GameLogic.m_matchTeam1LeagueId, GameLogic.m_matchTeam1, m_matchRoles[n2][2]);
                        break;
                    }
                    n7 = GameLogic.getTeamPlayerIndex(GameLogic.m_matchTeam2LeagueId, GameLogic.m_matchTeam2, m_matchRoles[n2][2]);
                    break;
                }
            }
        }
        if (n7 < 0) {
            n6 = (DDMath.getRandom() & 0xFFFF) % 10;
            for (n5 = 1; n5 < 11; ++n5) {
                n4 = 1 + (n6 + n5) % 10;
                if (!Match.checkPlayerIsntAlreadyUsedInCommentaryPlayerList(n4, n2)) continue;
                by = byArray[n4];
                if (Match.getTeamsBuffer(n2)[by][31] != 0) continue;
                n7 = n4;
                break;
            }
        }
        if (n7 < 0) {
            DDDebug.msg("error no players could be found for " + n + "  ARRRRGGGGHHHH!");
        }
        Match.m_commentaryUsedPositionList[n2][n] = (byte)n7;
        return n7;
    }

    public static byte[][] getTeamsBuffer(int n) {
        if (m_userTeam == n) {
            return GameLogic.m_usersTeamBuffer;
        }
        return GameLogic.m_otherTeamBuffer;
    }

    private static void setHighlightTrigger(short[] sArray, short s, int n, short s2, int n2) {
    }

    public static int calculateStrategyBias(int n, int n2) {
        int n3 = 0;
        n3 += m_formationTrainingEffects[n][m_trainingIndex[GameLogic.m_trainingInfo[n2 * 4 + 0]]];
        n3 += m_strategyTrainingEffects[GameLogic.m_strategy][m_trainingIndex[GameLogic.m_trainingInfo[n2 * 4 + 0]]];
        return n3 += m_strategyVsPassing[GameLogic.m_strategy][GameLogic.m_tacticsPassing + 1 & 3];
    }

    static {
        m_commentaryPositionsMappedToPlayerType = new byte[]{0, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 5, 6, 6, 6, 7, 7, 8, -1, -1, -1, -1, -1, -1, -1, -1, -1};
        m_commentarytimearray = new int[]{1700, 1000, 300};
        m_matchminutetimearray = new int[]{400, 200, 100};
        m_commentaryPositionsNum = 50;
        m_matchMessagesDispatchCounter = 0;
        m_matchCommentaryString = 0;
        m_matchEvent = 0;
        m_matchPossessionPosition = 0;
        m_matchIdealPossessionPosition = 0;
        m_matchTextCounter = 0L;
        m_flashingText = 0;
        m_matchEventPlayers = 0;
        m_penaltyround = 0;
        m_currentBufferFileId = -1;
        m_tacklingCardModifier = new int[]{10, -10, 0};
        m_tacklingStatModifier = new short[]{-10, 10, 0};
        m_penaltyTakers = new byte[][]{{10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0}, {10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0}};
        m_offenderindex = 0;
        m_hideEvents = false;
        m_trainingIndex = new int[]{6, 8, 5, 4, 3, 2, 1, 0, 9, 7};
        m_formationTrainingEffects = new byte[][]{{2, 0, 2, 2, 3, 1, 2, 2, 1, 3}, {2, 0, 2, 2, 3, 1, -1, 2, 1, -3}, {-4, 5, 2, 3, 0, 0, -2, 1, 4, -3}, {-2, 3, 2, -2, 1, -2, -2, 3, 1, -3}, {-5, 4, 2, 3, 0, -1, 0, 3, -2, 2}, {5, 2, 2, 1, 5, 4, 3, -3, 0, 3}, {1, 2, 2, 3, 2, 1, 0, 1, -3, 1}, {3, 2, 2, 1, 4, 4, 2, 0, -1, -2}, {3, 1, 2, -1, 1, 3, -2, -2, 1, 2}, {3, 1, 2, -1, 1, 3, -2, 2, 1, -3}, {3, 1, 2, -1, 1, 3, 0, -2, 1, 1}, {1, 1, 2, -2, 1, 1, -4, 3, -1, 1}};
        m_strategyTrainingEffects = new byte[][]{{-5, 5, 2, -5, 0, -3, -3, 3, 3, 2}, {1, 0, 4, 0, 2, 2, 0, 1, 1, 2}, {3, 3, 2, -3, 0, 3, 3, -3, -2, 2}, {3, 2, 2, 4, 2, 0, -3, 2, 1, 3}, {0, 1, 2, 5, 2, 0, -1, -2, 1, 2}, {-5, 5, 2, -1, 3, -3, 2, 2, 1, -1}};
        m_strategyVsPassing = new byte[][]{{2, -3, -1, 3}, {1, 1, 1, 1}, {3, -1, 1, -1}, {3, 1, 0, -2}, {1, 2, 1, -1}, {1, -2, -1, 3}};
    }
}

