/*
 * Decompiled with CFR 0.152.
 */
package com.lemonquest.juegohorca;

import com.lemonquest.juegohorca.GameCanvas;
import com.lemonquest.juegohorca.GameMIDlet;
import com.lemonquest.utils.SSFunctions;
import com.lemonquest.utils.SSKeyboard;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Random;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;

public class GameEngine
extends javax.microedition.lcdui.game.GameCanvas {
    private boolean running;
    public long lastProcessTime;
    private long pauseTime;
    public static final int MAX_PROCESS = 40;
    public boolean bSound = true;
    public int state;
    public int prestate;
    public static final int STATE_SPLASH = 0;
    public static final int STATE_COVER = 1;
    public static final int STATE_MAIN_MENU = 2;
    public static final int STATE_GAME = 3;
    public static final int STATE_WIN = 4;
    public static final int STATE_LOSE = 5;
    public static final int STATE_HELP = 6;
    public static final int STATE_ABOUT = 7;
    public static final int STATE_SOUND_QUESTION = 8;
    public static final int STATE_IN_GAME_MENU = 9;
    public static final int STATE_LANGUAGE = 10;
    public static final int STATE_NEW_GAME = 11;
    public static final int STATE_WAITING_CLIENT = 12;
    public static final int STATE_SEARCHING = 13;
    public static final int STATE_CHOOSE_SERVER = 14;
    public static final int STATE_NO_SERVER = 15;
    public static final int STATE_CLIENT_CHOOSE = 16;
    public static final int STATE_ERROR = 17;
    public static final int STATE_CFG_PARTIDA = 18;
    public static final int STATE_WAIT_START = 19;
    public static final int STATE_LOADING = 20;
    public static final int STATE_OPONENT_LOSE = 21;
    public static final int STATE_OPONENT_WIN = 22;
    public static final int STATE_WE_LOSE = 23;
    public static final int STATE_WE_WIN = 24;
    public static final int STATE_PLAY_AGAIN = 25;
    public static final int STATE_WAIT_OPONENT = 26;
    public static final int STATE_OPONENT_DISCONECT = 27;
    public static final int STATE_WRITE_WORD = 28;
    public static final int STATE_MORE_GAMES = 29;
    public int stateGame;
    public static final int STATE_LETTER = 0;
    private static final int MENU_MAIN_MENU = 0;
    private static final int MENU_CHOOSE_PLAYERS = 1;
    private static final int MENU_2PLAYERS = 2;
    public static final int MENU_IN_GAME = 3;
    private static final int MENU_SERVERS_FOUND = 4;
    private static final int MENU_SIZE_WORD = 5;
    private static final int MENU_HELP = 6;
    private static final int MENU_ABOUT = 7;
    private static final int MENU_LANGUAJE = 8;
    public static final int MENU_CHOOSE_CATEGORY = 9;
    private static final int MAXWORDS4FILE = 25;
    public static final boolean MOREGAMES_ENABLED = false;
    public String moreGamesURL = null;
    private static final int[] WORDSPERFILE = new int[]{199, 199, 199, 199};
    public SSKeyboard keyboard;
    private GameCanvas gc;
    private GameMIDlet gm;
    public Random random;
    public int iconLeft = -1;
    public int iconRight = -1;
    public String[] lang;
    public String[] words;
    public String[] optionsMenu;
    public long timeFinish = 0L;
    private static final int TIME_SPLASH = 2000;
    private static final int TIME_COVER = 3000;
    private static final int TIME_MOVE_TITLE = 50;
    public int optionActual = 0;
    public int maxOptions;
    public int maxItemMenuLength;
    private int lastState;
    private long timeScrollText;
    private boolean loading;
    private boolean downPressed = false;
    private boolean upPressed = false;
    private static final int TIME_SCROLL_TEXT = 200;
    public short[][] lineData;
    public int maxLines = 0;
    public int lineActual;
    public int language;
    public int lastMenu;
    public int menuActual;
    private boolean hasLoadGame;
    private Command left;
    private Command right;
    private final String cheatCode;
    private int cheatState = 0;
    public static final int MODE_1PLAYER = 0;
    public static final int MODE_2PLAYER = 1;
    public int modeGame;
    public byte lettersGameRows = (byte)3;
    public byte lettersGameColumns = (byte)9;
    public char[][] lettersGame = null;
    public char[][] letters = null;
    public int posLetter;
    public int posSymbol;
    public char actualChar;
    public long timeHangman;
    public int hangmanState;
    public int actualCategory = 0;
    public int actualWordIndex;
    public int actualWordLength;
    public String actualWord;
    public String message;
    public boolean[] actualWordOpenLetter;
    public boolean[][] lettersClosed;
    public int cursorX;
    public int cursorY;
    public static final int TIME_HANGMAN_ERROR = 1000;
    public String[] serversName;
    public int maxServers;
    public static final byte PKT_SEND_PALABRA = 0;
    public static final byte PKT_FIN_PARTIDA = 2;
    public static final byte PKT_PLAY_AGAIN = 3;
    public static final byte PKT_DISCONECT = 4;
    public static boolean modoBlueTooth;
    public static int numLetters;
    public static int indexWriteWord;
    public static int[] writeWord;
    public static final int NUMCHAR = 32;
    int loadIndex;

    public GameEngine(GameMIDlet gm) {
        super(false);
        this.cheatCode = "125239076";
        this.setFullScreenMode(true);
        this.gm = gm;
        this.gc = new GameCanvas(this);
        this.keyboard = new SSKeyboard();
        this.random = new Random(System.currentTimeMillis());
        this.gc.loadResource(0);
        this.gc.loadResource(1);
        this.language = -1;
        this.loadOptions();
        this.language = 0;
        this.timeFinish = System.currentTimeMillis() + 2000L;
        this.state = 0;
    }

    public void loadLanguage() {
        System.out.println("loadLanguage()");
        this.lang = null;
        System.gc();
        this.lang = SSFunctions.loadLangUnicode(SSFunctions.getResourceAsStream("/lang.dat"), 53);
        this.lang[10] = SSFunctions.replace(this.lang[10], "$SRL$", "LQSAD5001");
        String auxString = "";
        this.lettersGameRows = (byte)3;
        this.lettersGameColumns = (byte)11;
        this.lettersGame = new char[this.lettersGameRows][];
        this.letters = new char[8][];
        auxString = this.lang[52].substring(0, 4);
        this.letters[0] = auxString.toCharArray();
        auxString = this.lang[52].substring(4, 9);
        this.letters[1] = auxString.toCharArray();
        auxString = this.lang[52].substring(9, 13);
        this.letters[2] = auxString.toCharArray();
        auxString = this.lang[52].substring(13, 17);
        this.letters[3] = auxString.toCharArray();
        auxString = this.lang[52].substring(17, 21);
        this.letters[4] = auxString.toCharArray();
        auxString = this.lang[52].substring(21, 25);
        this.letters[5] = auxString.toCharArray();
        auxString = this.lang[52].substring(25, 29);
        this.letters[6] = auxString.toCharArray();
        auxString = this.lang[52].substring(29);
        this.letters[7] = auxString.toCharArray();
        for (int i = 0; i < this.lettersGameRows - 1; ++i) {
            auxString = this.lang[52].substring(i * this.lettersGameColumns, (i + 1) * this.lettersGameColumns);
            this.lettersGame[i] = auxString.toCharArray();
        }
        auxString = this.lang[52].substring((this.lettersGameRows - 1) * this.lettersGameColumns);
        this.lettersGame[this.lettersGameRows - 1] = auxString.toCharArray();
        System.out.println("   loadLanguage() OK");
    }

    private void saveOptions() {
        StringBuffer sb = new StringBuffer("");
        sb.append(this.language);
        GameEngine.store("hangoptions", sb.toString());
    }

    public static void store(String recordStoreName, String content) {
        try {
            RecordStore db = RecordStore.openRecordStore((String)recordStoreName, (boolean)true);
            RecordEnumeration re = db.enumerateRecords(null, null, false);
            while (re.hasNextElement()) {
                db.deleteRecord(re.nextRecordId());
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            dos.writeUTF(content);
            byte[] b = baos.toByteArray();
            db.addRecord(b, 0, b.length);
            dos.close();
            db.closeRecordStore();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean loadOptions() {
        try {
            DataInputStream dis = this.load("hangoptions");
            if (dis != null) {
                String s = dis.readUTF();
                this.language = Integer.parseInt(s);
                dis.close();
            }
            return true;
        }
        catch (Exception e) {
            this.language = -1;
            return false;
        }
    }

    private DataInputStream load(String recordStoreName) {
        try {
            RecordStore db = RecordStore.openRecordStore((String)recordStoreName, (boolean)false);
            RecordEnumeration re = db.enumerateRecords(null, null, false);
            ByteArrayInputStream bais = new ByteArrayInputStream(re.nextRecord());
            DataInputStream dis = new DataInputStream(bais);
            db.closeRecordStore();
            return dis;
        }
        catch (Exception e) {
            return null;
        }
    }

    public void commandAction(Command cmd, Displayable d) {
        if (cmd.equals(this.left)) {
            this.keyPressed(-6);
        } else if (cmd.equals(this.right)) {
            this.keyPressed(-7);
        }
    }

    private void saveGame() {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            StringBuffer sb = new StringBuffer();
            dos.writeUTF(sb.toString());
            SSFunctions.store("HangGame", baos);
            dos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String parseRecord(String s) {
        if (s == null) {
            return "0";
        }
        String sParser = "";
        while (s.charAt(this.loadIndex) != '#') {
            sParser = sParser + s.charAt(this.loadIndex);
            ++this.loadIndex;
        }
        ++this.loadIndex;
        return sParser;
    }

    private void checkLoadGame() {
        DataInputStream dis = SSFunctions.load("HangGame");
        if (dis != null) {
            this.hasLoadGame = true;
            try {
                dis.close();
            }
            catch (IOException iOException) {}
        } else {
            this.hasLoadGame = false;
        }
    }

    private void loadGame() {
        try {
            DataInputStream dis = SSFunctions.load("HangGame");
            String s = dis.readUTF();
            dis.close();
            this.loadIndex = 0;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private int nextInt(int max) {
        return Math.abs(this.random.nextInt() % max);
    }

    private void sleep(int time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void loadTextsMenu(int menu) {
        switch (menu) {
            case 0: {
                this.optionsMenu = new String[]{this.lang[1], this.lang[2], this.lang[3], this.lang[4]};
                this.iconLeft = 2;
                this.iconRight = -1;
                if (this.gc.coverY != 0) break;
                this.gc.calculatePosYCover();
                break;
            }
            case 1: {
                this.optionsMenu = new String[]{this.lang[18]};
                this.iconLeft = 2;
                this.iconRight = 3;
                break;
            }
            case 2: {
                this.optionsMenu = new String[]{this.lang[20], this.lang[21]};
                this.iconLeft = 2;
                this.iconRight = 3;
                break;
            }
            case 3: {
                this.optionsMenu = new String[]{this.lang[26], this.lang[4]};
                this.iconLeft = 2;
                this.iconRight = 3;
                break;
            }
            case 4: {
                int i;
                int num = 0;
                for (i = 0; i < this.maxServers && this.serversName[i] != null; ++i) {
                    ++num;
                }
                this.optionsMenu = new String[num];
                for (i = 0; i < num; ++i) {
                    this.optionsMenu[i] = this.serversName[i];
                }
                break;
            }
            case 5: {
                this.optionsMenu = new String[]{this.lang[49], this.lang[38], this.lang[39], this.lang[40]};
                this.iconLeft = 2;
                this.iconRight = -1;
                break;
            }
            case 6: {
                this.lineData = this.gc.fntMenu.getLineData(this.lang[9].toCharArray(), 176 - (this.gc.fntMenu.getLineSpacing() + this.gc.fntMenu.getFontHeight()) * 2);
                this.optionsMenu = new String[]{this.lang[2]};
                this.lineActual = 0;
                break;
            }
            case 7: {
                this.lineData = this.gc.fntMenu.getLineData(this.lang[10].toCharArray(), 176 - (this.gc.fntMenu.getLineSpacing() + this.gc.fntMenu.getFontHeight()) * 2);
                this.optionsMenu = new String[]{this.lang[3]};
                this.lineActual = 0;
                break;
            }
            case 8: {
                this.optionsMenu = GameCanvas.LANGUAGES;
                break;
            }
            case 9: {
                this.optionsMenu = new String[]{this.lang[45], this.lang[46], this.lang[47], this.lang[48]};
                this.iconLeft = 2;
                this.iconRight = 3;
            }
        }
        this.optionActual = 0;
        this.lastMenu = this.menuActual;
        this.menuActual = menu;
        this.maxOptions = this.optionsMenu.length;
        this.maxItemMenuLength = Math.max(this.maxItemMenuLength, this.maxOptions);
    }

    private int addLetter(char letter) {
        int count = 0;
        for (int i = 0; i < this.actualWordLength; ++i) {
            char c = this.actualWord.charAt(i);
            if (c != letter) continue;
            this.actualWordOpenLetter[i] = true;
            ++count;
        }
        return count;
    }

    public int searchOption(String option) {
        for (int i = 0; i < this.maxOptions; ++i) {
            if (this.optionsMenu[i].indexOf(option) == -1) continue;
            return i;
        }
        return 0;
    }

    private void toMainMenu() {
        this.setLoading(true);
        this.gc.setMaxLoadResources(1);
        this.gc.loadResource(2);
        this.loadTextsMenu(0);
        this.setLoading(false);
        this.iconLeft = 2;
        this.iconRight = -1;
        this.optionActual = 0;
        this.state = 2;
    }

    private void processKeysGame() {
        while (this.keyboard.getHasMoreKeys()) {
            char key = this.keyboard.nextChar();
            if (this.keyboard.getLastEvent() == 1) continue;
            switch (this.state) {
                case 3: {
                    if (key == '\u0001' && this.keyboard.getLastEvent() == 0) {
                        this.loadTextsMenu(3);
                        this.iconLeft = 2;
                        this.iconRight = 3;
                        this.state = 9;
                        break;
                    }
                    if (this.lastProcessTime < this.timeHangman + 1000L) break;
                    this.processKeysCursor(key, this.keyboard.getLastEvent());
                    break;
                }
                case 4: 
                case 5: {
                    String wordsFile;
                    if (key != '5' && key != '\u0000' && key != '\u0002') break;
                    if (this.actualWordIndex < this.words.length - 1) {
                        this.iconLeft = 0;
                        this.iconRight = 1;
                        this.state = 11;
                        this.posLetter = 0;
                        this.posSymbol = 0;
                        if (this.actualWordIndex % 25 != 0) break;
                        this.words = null;
                        System.gc();
                        wordsFile = "/words" + this.actualCategory + ".dat";
                        System.out.println("----------->" + wordsFile + "\n");
                        this.words = SSFunctions.loadLangUnicode(SSFunctions.getResourceAsStream(wordsFile), WORDSPERFILE[this.actualCategory]);
                        break;
                    }
                    this.toMainMenu();
                    break;
                }
                case 11: {
                    String wordsFile;
                    if (key == '5' || key == '\u0000' || key == '\u0002') {
                        this.newGame();
                        this.state = 3;
                        this.posLetter = 0;
                        this.posSymbol = 0;
                        if (this.actualWordIndex % 25 != 0) break;
                        this.words = null;
                        System.gc();
                        wordsFile = "/words" + this.actualCategory + ".dat";
                        System.out.println("----------->" + wordsFile + "\n");
                        this.words = SSFunctions.loadLangUnicode(SSFunctions.getResourceAsStream(wordsFile), WORDSPERFILE[this.actualCategory]);
                        break;
                    }
                    if (key != '\u0001') break;
                    this.toMainMenu();
                }
            }
        }
    }

    public int nextPart(int posPart, int maxPart) {
        if (++posPart == maxPart) {
            posPart = 0;
        }
        return posPart;
    }

    private void processKeysCursor(char key, int event) {
        block30: {
            block31: {
                block29: {
                    if (key < '2' || key > '9') break block29;
                    int posNewLetter = key - 50;
                    if (posNewLetter != this.posLetter) {
                        this.posSymbol = 0;
                        this.posLetter = posNewLetter;
                    } else {
                        this.posSymbol = this.nextPart(this.posSymbol, this.letters[this.posLetter].length);
                    }
                    char caracter = this.actualChar = this.letters[this.posLetter][this.posSymbol];
                    block0: for (byte i = 0; i < this.lettersGameRows; i = (byte)(i + 1)) {
                        for (byte j = 0; j < this.lettersGameColumns; j = (byte)(j + 1)) {
                            if (caracter != this.lettersGame[i][j]) continue;
                            this.cursorX = j;
                            this.cursorY = i;
                            continue block0;
                        }
                    }
                    break block30;
                }
                if (key != '\u0000' && key != '\u0002') break block31;
                if (this.lettersClosed[this.cursorY][this.cursorX]) break block30;
                int count = this.addLetter(this.lettersGame[this.cursorY][this.cursorX]);
                this.lettersClosed[this.cursorY][this.cursorX] = true;
                if (count <= 0) {
                    this.timeHangman = this.lastProcessTime;
                    ++this.hangmanState;
                }
                this.checkWinner();
                break block30;
            }
            if (key == '\u0005' || key == '\u0006') {
                if (key == '\u0005') {
                    --this.cursorY;
                    if (this.cursorY < 0) {
                        this.cursorY = this.lettersGame.length - 1;
                    }
                    if (this.lettersGame[this.cursorY][this.cursorX] == ' ') {
                        --this.cursorY;
                    }
                } else if (key == '\u0006') {
                    this.cursorY = (this.cursorY + 1) % this.lettersGame.length;
                    if (this.lettersGame[this.cursorY][this.cursorX] == ' ') {
                        this.cursorY = (this.cursorY + 1) % this.lettersGame.length;
                    }
                }
                char caracter = this.actualChar = this.lettersGame[this.cursorY][this.cursorX];
                for (int i = 0; i < this.letters.length; i = (int)((byte)(i + 1))) {
                    for (int j = 0; j < this.letters[i].length; j = (int)((byte)(j + 1))) {
                        if (caracter != this.letters[i][j]) continue;
                        this.posLetter = i;
                        this.posSymbol = j;
                    }
                }
            } else if (key == '\u0003' || key == '\u0004') {
                if (key == '\u0003') {
                    if (this.posSymbol > 0) {
                        --this.posSymbol;
                    } else {
                        do {
                            if (this.posLetter > 0) {
                                --this.posLetter;
                                continue;
                            }
                            this.posLetter = this.letters.length - 1;
                        } while (this.letters[this.posLetter].length == 0);
                        this.posSymbol = this.letters[this.posLetter].length - 1;
                    }
                } else if (key == '\u0004') {
                    if (this.posSymbol < this.letters[this.posLetter].length - 1) {
                        ++this.posSymbol;
                    } else {
                        do {
                            if (this.posLetter < this.letters.length - 1) {
                                ++this.posLetter;
                                continue;
                            }
                            this.posLetter = 0;
                        } while (this.letters[this.posLetter].length == 0);
                        this.posSymbol = 0;
                    }
                }
                char caracter = this.actualChar = this.letters[this.posLetter][this.posSymbol];
                for (byte i = 0; i < this.lettersGameRows; i = (byte)(i + 1)) {
                    for (byte j = 0; j < this.lettersGameColumns; j = (byte)(j + 1)) {
                        if (caracter != this.lettersGame[i][j]) continue;
                        this.cursorX = j;
                        this.cursorY = i;
                    }
                }
            }
        }
    }

    private void launchGame(int modeGame) {
        this.setLoading(true);
        this.gc.setMaxLoadResources(3);
        this.gc.unloadResource(2);
        this.gc.unloadResource(6);
        this.gc.loadResource(5);
        String wordsFile = "/words" + this.actualCategory + ".dat";
        System.out.println("----------->" + wordsFile + "\n");
        this.words = SSFunctions.loadLangUnicode(SSFunctions.getResourceAsStream(wordsFile), WORDSPERFILE[this.actualCategory]);
        this.gc.resourceLoaded();
        this.randomWords();
        this.actualWordIndex = 0;
        this.modeGame = modeGame;
        if (modeGame == 0) {
            this.newGame();
        } else {
            indexWriteWord = 0;
            writeWord = new int[numLetters];
            for (int i = 0; i < numLetters; ++i) {
                GameEngine.writeWord[i] = 0;
            }
            this.iconLeft = 2;
            this.iconRight = 5;
        }
        this.setLoading(false);
        this.state = 3;
    }

    private void newGame() {
        ++this.actualWordIndex;
        this.actualWordLength = this.words[this.actualWordIndex].length();
        this.actualWord = this.words[this.actualWordIndex];
        this.actualWordOpenLetter = new boolean[this.actualWordLength];
        this.lettersClosed = new boolean[this.lettersGame.length][this.lettersGame[0].length];
        this.hangmanState = 0;
        this.timeHangman = 0L;
        this.message = this.lang[22];
        this.cursorX = 0;
        this.cursorY = 0;
        this.iconLeft = 2;
        this.iconRight = 4;
    }

    private void randomWords() {
        for (int i = 0; i < this.words.length; ++i) {
            int pos1 = Math.abs(this.random.nextInt()) % this.words.length;
            int pos2 = Math.abs(this.random.nextInt()) % this.words.length;
            String wordTemp = this.words[pos1];
            this.words[pos1] = this.words[pos2];
            this.words[pos2] = wordTemp;
        }
    }

    private void setLoading(boolean isLoading) {
        if (isLoading) {
            this.state = 20;
        }
    }

    private void processSplash() {
        if (this.timeFinish < this.lastProcessTime) {
            if (this.language != -1) {
                this.loadLanguage();
                this.setLoading(true);
                this.gc.setMaxLoadResources(5);
                this.gc.unloadResource(0);
                this.gc.loadResource(6);
                this.gc.loadResource(4);
                this.gc.loadResource(2);
                this.keyboard.removeAllEvents();
                this.state = 1;
            } else {
                this.setLoading(true);
                this.gc.setMaxLoadResources(5);
                this.gc.loadResource(6);
                this.gc.loadResource(4);
                this.iconRight = -1;
                this.optionActual = 0;
                this.state = 10;
            }
            this.checkLoadGame();
            if (this.hasLoadGame) {
                this.loadGame();
            }
        }
    }

    private void processKeysInGameMenu() {
        while (this.keyboard.getHasMoreKeys()) {
            char key = this.keyboard.nextChar();
            if (this.keyboard.getLastEvent() == 1) continue;
            switch (key) {
                case '\u0003': 
                case '4': {
                    --this.optionActual;
                    if (this.optionActual >= 0) break;
                    this.optionActual = this.maxOptions - 1;
                    break;
                }
                case '\u0004': 
                case '6': {
                    ++this.optionActual;
                    if (this.optionActual < this.maxOptions) break;
                    this.optionActual = 0;
                    break;
                }
                case '\u0005': 
                case '2': {
                    --this.optionActual;
                    if (this.optionActual >= 0) break;
                    this.optionActual = this.maxOptions - 1;
                    break;
                }
                case '\u0006': 
                case '8': {
                    ++this.optionActual;
                    if (this.optionActual < this.maxOptions) break;
                    this.optionActual = 0;
                    break;
                }
                case '\u0000': 
                case '\u0002': 
                case '5': {
                    String option = this.optionsMenu[this.optionActual];
                    if (option.equals(this.lang[26])) {
                        this.iconLeft = 2;
                        this.iconRight = 4;
                        this.state = 3;
                        break;
                    }
                    if (option.indexOf(this.lang[6]) != -1 || !option.equals(this.lang[4])) break;
                    this.toMainMenu();
                    break;
                }
                case '\u0001': {
                    this.iconLeft = 2;
                    this.iconRight = 4;
                    this.state = 3;
                }
            }
        }
    }

    private void processKeysSoundQuestion() {
        while (this.keyboard.getHasMoreKeys()) {
            char key = this.keyboard.nextChar();
            if (this.keyboard.getLastEvent() == 1) continue;
            switch (key) {
                case '\u0000': 
                case '\u0002': 
                case '5': {
                    this.bSound = true;
                    this.toCoverMenu();
                    break;
                }
                case '\u0001': {
                    this.bSound = false;
                    this.toCoverMenu();
                }
            }
        }
    }

    private void toCoverMenu() {
        this.iconLeft = 2;
        this.iconRight = -1;
        this.timeFinish = this.lastProcessTime + 3000L;
        this.keyboard.removeAllEvents();
        this.state = 1;
    }

    private void processGame() {
        this.processKeysGame();
        if (this.state == 3) {
            this.checkGameOver();
        }
    }

    private void checkGameOver() {
        if (this.hangmanState == 7) {
            this.iconLeft = 2;
            this.message = this.lang[24];
            if (!modoBlueTooth) {
                for (int i = 0; i < this.actualWordOpenLetter.length; ++i) {
                    this.actualWordOpenLetter[i] = true;
                }
                this.iconRight = -1;
                this.state = 5;
            }
        }
    }

    private boolean isWordCompleted(boolean[] actualWordOpenLetter) {
        for (int i = 0; i < actualWordOpenLetter.length; ++i) {
            if (actualWordOpenLetter[i]) continue;
            return false;
        }
        return true;
    }

    private void checkWinner() {
        if (this.isWordCompleted(this.actualWordOpenLetter)) {
            this.iconLeft = 2;
            this.message = this.lang[23];
            this.timeHangman = this.lastProcessTime;
            this.hangmanState = 8;
            if (!modoBlueTooth) {
                this.iconRight = -1;
                this.state = 4;
            }
        }
    }

    private void cheat(char key) {
        this.cheatState = key == "125239076".charAt(this.cheatState) ? ++this.cheatState : 0;
        if (this.cheatState == "125239076".length()) {
            this.cheatState = 0;
        }
    }

    private void chooseWordRandom() {
        do {
            ++this.actualWordIndex;
            if (this.actualWordIndex < this.words.length) continue;
            this.actualWordIndex = 0;
        } while (this.words[this.actualWordIndex].length() != numLetters);
        String allLetters = this.lang[52];
        for (int i = 0; i < numLetters; ++i) {
            GameEngine.writeWord[i] = allLetters.lastIndexOf(this.words[this.actualWordIndex].charAt(i));
        }
    }

    private void processKeysMenu() {
        while (this.keyboard.getHasMoreKeys()) {
            char key = this.keyboard.nextChar();
            if (this.keyboard.getLastEvent() != 0) {
                this.upPressed = false;
                this.downPressed = false;
                continue;
            }
            switch (key) {
                case '\u0003': 
                case '4': {
                    this.lineActual = 0;
                    --this.optionActual;
                    if (this.optionActual >= 0) break;
                    this.optionActual = this.maxOptions - 1;
                    break;
                }
                case '\u0004': 
                case '6': {
                    this.lineActual = 0;
                    ++this.optionActual;
                    if (this.optionActual < this.maxOptions) break;
                    this.optionActual = 0;
                    break;
                }
                case '\u0005': 
                case '2': {
                    if (this.state == 2) {
                        --this.optionActual;
                        if (this.optionActual < 0) {
                            this.optionActual = this.maxOptions - 1;
                        }
                    }
                    if (this.lineActual > 0) {
                        --this.lineActual;
                    }
                    this.downPressed = false;
                    this.upPressed = true;
                    this.timeScrollText = this.lastProcessTime + 200L;
                    break;
                }
                case '\u0006': 
                case '8': {
                    if (this.state == 2) {
                        ++this.optionActual;
                        if (this.optionActual >= this.maxOptions) {
                            this.optionActual = 0;
                        }
                    }
                    if (this.lineActual < this.maxLines) {
                        ++this.lineActual;
                    }
                    this.downPressed = true;
                    this.upPressed = false;
                    this.timeScrollText = this.lastProcessTime + 200L;
                }
            }
            if (this.state == 1) {
                this.keyboard.removeAllEvents();
                this.loadTextsMenu(0);
                this.timeHangman = System.currentTimeMillis();
                this.state = 2;
            } else {
                String option = this.optionsMenu[this.optionActual];
                block7 : switch (key) {
                    case '\u0000': 
                    case '\u0002': 
                    case '5': {
                        if (option.indexOf(this.lang[6]) != -1) break;
                        if (option.equals(this.lang[5])) {
                            this.loadTextsMenu(8);
                            this.prestate = 1;
                            this.state = 10;
                            break;
                        }
                        if (option.equals(this.lang[1])) {
                            this.loadTextsMenu(9);
                            break;
                        }
                        if (option.equals(this.lang[18])) {
                            this.loadTextsMenu(9);
                            break;
                        }
                        if (option.equals(this.lang[45]) || option.equals(this.lang[46]) || option.equals(this.lang[47]) || option.equals(this.lang[48])) {
                            if (option.equals(this.lang[45])) {
                                this.actualCategory = 0;
                            }
                            if (option.equals(this.lang[46])) {
                                this.actualCategory = 1;
                            }
                            if (option.equals(this.lang[47])) {
                                this.actualCategory = 2;
                            }
                            if (option.equals(this.lang[48])) {
                                this.actualCategory = 3;
                            }
                            this.launchGame(0);
                            modoBlueTooth = false;
                            this.keyboard.removeAllEvents();
                            break;
                        }
                        if (option.equals(this.lang[19])) {
                            this.loadTextsMenu(2);
                            break;
                        }
                        if (option.equals(this.lang[4])) {
                            this.gm.running = false;
                            this.running = false;
                            break;
                        }
                        if (option.equals(this.lang[21]) || option.equals(this.lang[20])) break;
                        if (option.equals(this.lang[2])) {
                            this.loadTextsMenu(6);
                            this.state = 6;
                            this.iconLeft = -1;
                            this.iconRight = 3;
                            break;
                        }
                        if (option.equals(this.lang[3])) {
                            this.loadTextsMenu(7);
                            this.state = 7;
                            this.iconLeft = -1;
                            this.iconRight = 3;
                            break;
                        }
                        if (!option.equals(this.lang[42])) break;
                        try {
                            this.moreGamesURL = this.gm.getAppProperty("URL_ECAP_GMG");
                            if (this.moreGamesURL == null) break;
                            this.gm.platformRequest(this.moreGamesURL);
                        }
                        catch (Exception e) {
                            this.loadTextsMenu(0);
                            this.iconLeft = 2;
                            this.iconRight = -1;
                            this.optionActual = this.searchOption(this.lang[42]);
                            this.state = 2;
                        }
                        break;
                    }
                    case '\u0001': {
                        if (this.state == 6 || this.state == 7 || this.state == 29) {
                            this.loadTextsMenu(0);
                            this.iconLeft = 2;
                            this.iconRight = -1;
                            if (this.state == 6) {
                                this.optionActual = this.searchOption(this.lang[2]);
                            } else if (this.state == 7) {
                                this.optionActual = this.searchOption(this.lang[3]);
                            } else if (this.state == 29) {
                                this.optionActual = this.searchOption(this.lang[42]);
                            }
                            this.state = 2;
                            break;
                        }
                        if (this.state != 2) break;
                        boolean menu = false;
                        switch (this.menuActual) {
                            case 1: {
                                this.loadTextsMenu(0);
                                break block7;
                            }
                            case 9: {
                                this.loadTextsMenu(0);
                                break block7;
                            }
                            case 0: {
                                break block7;
                            }
                        }
                        this.loadTextsMenu(1);
                        this.optionActual = this.searchOption(this.lang[19]);
                    }
                }
            }
            this.cheat(key);
        }
    }

    private void processMenu() {
        this.processKeysMenu();
        switch (this.state) {
            case 2: {
                this.gc.coverY = this.gc.coverPosY + (this.gc.coverY - this.gc.coverPosY) / 2;
                break;
            }
            case 1: {
                if (this.lastProcessTime < this.timeFinish) break;
                this.loadTextsMenu(0);
                this.state = 2;
                break;
            }
            case 6: 
            case 7: {
                if (this.timeScrollText < this.lastProcessTime) break;
                if (this.upPressed) {
                    if (this.lineActual > 0) {
                        --this.lineActual;
                    }
                } else if (this.downPressed && this.lineActual < this.maxLines) {
                    ++this.lineActual;
                }
                this.timeScrollText = this.lastProcessTime + 200L;
            }
        }
    }

    private void processKeysLanguage() {
        while (this.keyboard.getHasMoreKeys()) {
            char key = this.keyboard.nextChar();
            if (this.keyboard.getLastEvent() == 1) continue;
            switch (key) {
                case '\u0003': 
                case '\u0005': 
                case '2': 
                case '4': {
                    --this.optionActual;
                    if (this.optionActual >= 0) break;
                    this.optionActual = 3;
                    break;
                }
                case '\u0004': 
                case '\u0006': 
                case '6': 
                case '8': {
                    this.optionActual = (this.optionActual + 1) % 4;
                    break;
                }
                case '\u0000': 
                case '\u0002': 
                case '5': {
                    this.language = this.optionActual;
                    this.saveOptions();
                    this.loadLanguage();
                    this.setLoading(true);
                    this.gc.setMaxLoadResources(5);
                    this.gc.unloadResource(0);
                    this.gc.loadResource(2);
                    this.state = 1;
                }
            }
        }
    }

    private void process() {
        switch (this.state) {
            case 10: {
                this.processKeysLanguage();
                break;
            }
            case 0: {
                this.processSplash();
                break;
            }
            case 8: {
                this.processKeysSoundQuestion();
                break;
            }
            case 9: {
                this.processKeysInGameMenu();
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 14: 
            case 29: {
                this.processMenu();
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 11: {
                this.processGame();
            }
        }
    }

    public void keyPressed(int keyCode) {
        this.keyboard.keyPressed(keyCode);
    }

    public void keyReleased(int keyCode) {
        this.keyboard.keyReleased(keyCode);
    }

    public void paint(Graphics g) {
        this.setFullScreenMode(true);
        switch (this.state) {
            case 27: {
                this.gc.paintQuestion(g, this.lang[30]);
                this.gc.paintIconsBottom(g);
                break;
            }
            case 26: {
                this.gc.paintQuestion(g, this.lang[31]);
                this.gc.paintIconsBottom(g);
                break;
            }
            case 21: {
                this.gc.paintQuestion(g, this.lang[32]);
                this.gc.paintIconsBottom(g);
                break;
            }
            case 22: {
                this.gc.paintQuestion(g, this.lang[33]);
                this.gc.paintIconsBottom(g);
                break;
            }
            case 23: {
                this.gc.paintQuestion(g, this.lang[34]);
                this.gc.paintIconsBottom(g);
                break;
            }
            case 24: {
                this.gc.paintQuestion(g, this.lang[35]);
                this.gc.paintIconsBottom(g);
                break;
            }
            case 28: {
                this.gc.paintWriteWord(g);
                this.gc.paintIconsBottom(g);
                break;
            }
            case 18: {
                this.gc.paintCFGGame(g);
                this.gc.paintIconsBottom(g);
                break;
            }
            case 19: {
                this.gc.paintQuestion(g, this.lang[31]);
                this.gc.paintIconsBottom(g);
                break;
            }
            case 16: {
                this.gc.paintMainMenu(g);
                this.gc.paintIconsBottom(g);
                break;
            }
            case 17: {
                this.gc.paintQuestion(g, this.lang[36]);
                this.gc.paintIconsBottom(g);
                break;
            }
            case 9: {
                this.gc.paintInGameMenu(g);
                this.gc.paintIconsBottom(g);
                break;
            }
            case 0: {
                this.gc.paintSplash(g);
                break;
            }
            case 10: {
                this.gc.paintLanguageMenu(g, this.optionActual);
                this.gc.paintLanguageIconsBottom(g);
                break;
            }
            case 11: 
            case 25: {
                this.gc.paintQuestion(g, this.lang[25]);
                this.gc.paintIconsBottom(g);
                break;
            }
            case 8: {
                this.gc.paintQuestion(g, this.lang[11]);
                this.gc.paintIconsBottom(g);
                break;
            }
            case 1: {
                this.gc.paintCover(g);
                break;
            }
            case 2: {
                this.gc.paintMainMenu(g);
                this.gc.paintIconsBottom(g);
                break;
            }
            case 6: {
                this.gc.paintHelp(g);
                this.gc.paintIconsBottom(g);
                break;
            }
            case 7: {
                this.gc.paintAbout(g);
                this.gc.paintIconsBottom(g);
                break;
            }
            case 29: {
                this.gc.paintMoreGames(g, this.lang[43]);
                this.gc.paintIconsBottom(g);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                this.gc.paintGame(g);
                this.gc.paintIconsBottom(g);
                break;
            }
            case 20: {
                this.gc.paintLoading(g);
            }
        }
    }

    public void run() {
        this.running = true;
        while (this.running) {
            this.lastProcessTime = System.currentTimeMillis() - this.pauseTime;
            this.process();
            this.repaint();
            this.serviceRepaints();
            long time = System.currentTimeMillis() - this.pauseTime;
            if (time - this.lastProcessTime < 40L) {
                this.sleep(40 - (int)(time - this.lastProcessTime));
                continue;
            }
            this.sleep(5);
        }
    }
}

