/*
 * Decompiled with CFR 0.152.
 */
package de.mef.state.concrete;

import de.mef.menu.BasicMenu;
import de.mef.menu.Frame;
import de.mef.menu.MenuListener;
import de.mef.menu.Pad;
import de.mef.menu.TextBlock;
import de.mef.menu.TextItem;
import de.mef.menu.Widget;
import de.mef.state.State;
import de.mef.state.concrete.GameState;
import de.mef.util.Handset;
import de.mef.util.KeyListener;
import de.mef.util.Locale;
import de.mef.util.Refreshable;
import de.mef.util.Updateable;
import javax.microedition.lcdui.Graphics;

public final class ChooseDifficultyState
extends State
implements KeyListener,
MenuListener,
Updateable,
Refreshable {
    private BasicMenu menu;
    private Widget easy;
    private Widget medium;
    private Widget hard;
    private TextBlock header = new TextBlock("menu-difficulty", TextItem.DEFAULT_FONT, State.canvas.getWidth(), TextItem.DEFAULT_FOCUS_COLOR, 1);

    public final void update() {
        State.repaint();
    }

    public final void menuAction(Widget widget, int n) {
        if (n == 1) {
            if (widget == this.easy) {
                GameState.difficulty = 0;
            }
            if (widget == this.medium) {
                GameState.difficulty = 1;
            }
            if (widget == this.hard) {
                GameState.difficulty = 2;
            }
            State.setNamedState("options");
        }
    }

    public ChooseDifficultyState() {
        this.header.outline = 0;
        this.menu = new BasicMenu(State.canvas.getHeight() / 4 * 3);
        this.menu.setAlignment(3);
    }

    public final void enter() {
        TextItem textItem = new TextItem("menu-easy");
        TextItem textItem2 = new TextItem("menu-medium");
        TextItem textItem3 = new TextItem("menu-hard");
        int n = Math.max(textItem2.getWidth(), textItem.getWidth());
        n = Math.max(n, textItem3.getWidth()) + 6;
        this.easy = new Frame(new Pad(textItem, n, 0, 3));
        this.medium = new Frame(new Pad(textItem2, n, 0, 3));
        this.hard = new Frame(new Pad(textItem3, n, 0, 3));
        this.easy.setMenuListener(this, 1);
        this.medium.setMenuListener(this, 1);
        this.hard.setMenuListener(this, 1);
        this.menu.addElement(this.easy);
        this.menu.addElement(this.medium);
        this.menu.addElement(this.hard);
        this.menu.setCursor(GameState.difficulty);
        State.right = Locale.string("command-back");
        State.left = Locale.string("command-ok");
        this.refresh();
        State.repaint();
    }

    public final void paint(Graphics graphics) {
        State.menuBackground(graphics, false);
        this.header.paint(graphics, State.canvas.getWidth() / 2, 0, 17);
        this.menu.paint(graphics, State.canvas.getWidth() / 2, State.canvas.getHeight() / 2, 3);
    }

    public final void leave() {
        this.menu.removeAllElements();
    }

    public final void keyPressed(int n) {
        if (n == Handset.MENU_RIGHT) {
            State.setNamedState("options");
            return;
        }
        this.menu.keyPressed(n);
    }

    public final void keyRepeated(int n) {
        this.menu.keyRepeated(n);
    }

    public final void keyReleased(int n) {
        this.menu.keyReleased(n);
    }

    public final void refresh() {
        this.menu.refresh();
        this.header.refresh();
    }
}

