/*
 * Decompiled with CFR 0.152.
 */
package de.mef.state.concrete;

import de.mef.menu.Frame;
import de.mef.menu.Pair;
import de.mef.menu.ScrollBar;
import de.mef.menu.ScrollBox;
import de.mef.menu.Space;
import de.mef.menu.TextBlock;
import de.mef.menu.TextItem;
import de.mef.state.State;
import de.mef.util.Handset;
import de.mef.util.KeyListener;
import de.mef.util.Locale;
import de.mef.util.Refreshable;
import de.mef.util.Updateable;
import javax.microedition.lcdui.Graphics;

public final class ManualState
extends State
implements KeyListener,
Updateable,
Refreshable {
    private Frame frame;
    private ScrollBox scrollbox;
    private TextItem header = new TextItem("menu-manual");

    public final void update() {
        State.repaint();
    }

    public ManualState() {
        this.header.enabled_color = TextItem.DEFAULT_FOCUS_COLOR;
        this.header.enabled_outline = TextItem.DEFAULT_FOCUS_OUTLINE;
        this.scrollbox = new ScrollBox(State.canvas.getWidth() * 8 / 10, State.canvas.getHeight() - 3 * Handset.fnt_bold.getHeight());
        this.scrollbox.setAlignment(17);
        this.scrollbox.addElement(new Space(8));
        this.scrollbox.addElement(new TextBlock("epilogue0", Handset.fnt_mediumbold, this.scrollbox.getWidth(), TextItem.DEFAULT_FOCUS_COLOR, 4));
        this.scrollbox.addElement(new TextBlock("epilogue1", Handset.fnt_small, this.scrollbox.getWidth(), TextBlock.DEFAULT_COLOR, 4));
        this.scrollbox.addElement(new Space(8));
        this.scrollbox.addElement(new TextBlock("epilogue2", Handset.fnt_small, this.scrollbox.getWidth(), TextBlock.DEFAULT_COLOR, 4));
        this.scrollbox.addElement(new Space(16));
        this.scrollbox.addElement(new TextBlock("manual0", Handset.fnt_mediumbold, this.scrollbox.getWidth(), TextItem.DEFAULT_FOCUS_COLOR, 4));
        this.scrollbox.addElement(new TextBlock("manual1", Handset.fnt_small, this.scrollbox.getWidth(), TextBlock.DEFAULT_COLOR, 4));
        this.scrollbox.addElement(new Space(8));
        this.scrollbox.addElement(new TextBlock("manual2", Handset.fnt_small, this.scrollbox.getWidth(), TextBlock.DEFAULT_COLOR, 4));
        this.scrollbox.addElement(new Space(8));
        this.scrollbox.addElement(new TextBlock("manual3", Handset.fnt_small, this.scrollbox.getWidth(), TextBlock.DEFAULT_COLOR, 4));
        this.scrollbox.addElement(new Space(16));
        ScrollBar scrollBar = new ScrollBar(this.scrollbox, State.canvas.getWidth() / 40, this.scrollbox.getHeight(), 0);
        this.frame = new Frame(new Pair(this.scrollbox, scrollBar));
        this.frame.enabled_background = 1125953;
        this.frame.enabled_color = 0;
    }

    public final void enter() {
        State.right = Locale.string("command-menu");
        this.refresh();
        State.repaint();
    }

    public final void paint(Graphics graphics) {
        State.menuBackground(graphics, false);
        this.header.paint(graphics, State.canvas.getWidth() / 2, 0, 17);
        this.frame.paint(graphics, State.canvas.getWidth() / 2, State.canvas.getHeight() / 2, 3);
    }

    public final void leave() {
        this.scrollbox.scrollTo(0, 0);
    }

    public final void keyPressed(int n) {
        if (n == Handset.MENU_RIGHT) {
            State.setNamedState("mainmenu");
            return;
        }
        this.scrollbox.keyPressed(n);
    }

    public final void keyRepeated(int n) {
        this.scrollbox.keyRepeated(n);
    }

    public final void keyReleased(int n) {
        this.scrollbox.keyReleased(n);
    }

    public final void refresh() {
        this.scrollbox.refresh();
        this.header.refresh();
    }
}

