/*
 * Decompiled with CFR 0.152.
 */
package de.mef.state.concrete;

import de.mef.sound.SoundPlayer;
import de.mef.state.State;
import de.mef.state.concrete.MainMenu;
import de.mef.util.Console;
import de.mef.util.Handset;
import de.mef.util.KeyListener;
import de.mef.util.Locale;
import de.mef.util.MeshFactory;
import de.mef.util.Random;
import de.mef.util.Refreshable;
import de.mef.util.Updateable;
import de.mef.util.Utility;
import java.io.DataInputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.m3g.Background;
import javax.microedition.m3g.Camera;
import javax.microedition.m3g.Graphics3D;
import javax.microedition.m3g.Image2D;
import javax.microedition.m3g.Loader;
import javax.microedition.m3g.Mesh;
import javax.microedition.m3g.Node;
import javax.microedition.m3g.Object3D;
import javax.microedition.m3g.PolygonMode;
import javax.microedition.m3g.Texture2D;
import javax.microedition.m3g.Transform;
import javax.microedition.m3g.World;

public final class GameState
extends State
implements KeyListener,
Updateable,
Refreshable {
    Graphics3D g3d;
    Transform modelview;
    Transform campos;
    Mesh[] balls = new Mesh[6];
    int[] counts = new int[6];
    Texture2D balltexture;
    Texture2D texture;
    Mesh spark;
    World world;
    Camera camera;
    float camera_x;
    float camera_y;
    float camera_z;
    float camera_pitch;
    float camera_yaw;
    Background back;
    Image2D backimage;
    int back_x;
    int back_y;
    int[][] playfield = new int[9][9];
    int[][] fxfield = new int[9][9];
    Mesh cursor;
    int cursor_x;
    int cursor_y;
    int currentframe;
    long scm;
    long start;
    long limit;
    long solvetime;
    public static int difficulty = 1;
    public static int result;
    public static int level;
    public static int maxlevel;
    private static int[][][] levels;
    public static int gametype;
    private String gametypestring = null;
    private boolean do_render = true;
    private Random rnd = new Random();
    private long lastpanic = 0L;
    private boolean solved = false;

    public GameState() {
        this.loadLevels();
        Object3D[] object3DArray = null;
        try {
            object3DArray = Loader.load((String)"/balls.m3g");
            int n = 0;
            for (n = 0; n < object3DArray.length && !(object3DArray[n] instanceof World); ++n) {
            }
            this.world = (World)object3DArray[n];
            PolygonMode polygonMode = new PolygonMode();
            polygonMode.setCulling(160);
            polygonMode.setPerspectiveCorrectionEnable(false);
            polygonMode.setShading(165);
            polygonMode.setTwoSidedLightingEnable(false);
            polygonMode.setLocalCameraLightingEnable(false);
            for (n = 0; n < this.balls.length; ++n) {
                this.balls[n] = (Mesh)this.world.find(n + 1);
                this.balls[n].getAppearance(0).setPolygonMode(polygonMode);
            }
            this.balltexture = (Texture2D)this.world.find(777);
            this.world.find(666);
            this.balltexture.setBlending(228);
            this.balltexture.setFiltering(208, 210);
        }
        catch (IOException iOException) {}
        MeshFactory.createPlane("/box.png", 160, MeshFactory.SQUARE);
        this.modelview = new Transform();
        this.g3d = Graphics3D.getInstance();
        this.back = new Background();
        this.back.setColor(0);
        try {
            this.backimage = new Image2D(99, (Object)Utility.cacheImage("/background.png"));
            this.back.setImage(this.backimage);
            this.back.setImageMode(33, 33);
            this.back.setCrop(0, 0, this.backimage.getWidth(), this.backimage.getHeight());
        }
        catch (IOException iOException) {}
        this.campos = new Transform();
        this.camera = new Camera();
        this.camera.setPerspective(45.0f, (float)State.canvas.getWidth() / (float)State.canvas.getHeight(), 0.1f, 50.0f);
        this.cursor = MeshFactory.createPlane("/box.png", 160, MeshFactory.SQUARE);
        this.texture = this.cursor.getAppearance(0).getTexture(0);
        this.spark = (Mesh)this.world.find(7);
        Transform transform = new Transform();
        transform.setIdentity();
        this.spark.setTransform(transform);
        this.spark.setTranslation(0.0f, 0.0f, 0.0f);
        this.spark.getAppearance(0).setTexture(0, this.texture);
    }

    private void loadLevels() {
        DataInputStream dataInputStream = new DataInputStream(this.getClass().getResourceAsStream("/levels.txt"));
        try {
            dataInputStream.readInt();
            int n = dataInputStream.readInt() / 10;
            levels = new int[n][9][9];
            for (int i = 0; i < n; ++i) {
                dataInputStream.readUTF();
                for (int j = 0; j < 9; ++j) {
                    char[] cArray = dataInputStream.readUTF().toCharArray();
                    for (int k = 0; k < 9; ++k) {
                        GameState.levels[i][j][k] = cArray[k] - 48;
                    }
                }
            }
            return;
        }
        catch (IOException iOException) {
            IOException iOException2 = iOException;
            Console.write(iOException);
            return;
        }
    }

    public final synchronized void update() {
        this.scm = System.currentTimeMillis();
        this.solved = true;
        for (int i = 0; i < this.counts.length; ++i) {
            if (this.counts[i] <= 0) continue;
            this.solved = false;
        }
        if (this.solved) {
            if (this.solvetime == 0L) {
                this.solvetime = this.scm;
            }
            if (this.scm - this.solvetime > 1000L) {
                result = 2;
                ++level;
                State.setNamedState("eval");
                return;
            }
        }
        if (!this.solved && gametype == 1 && this.scm - this.lastpanic > 5000L) {
            this.lastpanic = this.scm;
            this.addPanicBalls();
        }
        if (!this.solved && this.scm - this.start > this.limit) {
            result = 1;
            State.setNamedState("eval");
            return;
        }
        try {
            this.camera_x += ((float)this.cursor_x - this.camera_x) / 3.0f;
            this.camera_y += ((float)this.cursor_y - this.camera_y) / 3.0f;
            this.camera_z += (0.1f - this.camera_z) / 4.0f;
            this.camera_pitch += ((float)(this.cursor_x * 10 - 45) - this.camera_pitch) / 3.0f;
            this.camera_yaw += ((float)(this.cursor_y * 10 - 45) - this.camera_yaw) / 3.0f;
            this.campos.setIdentity();
            this.campos.postTranslate(this.camera_x, this.camera_y, this.camera_z);
            this.campos.postRotate(-this.camera_yaw, 1.0f, 0.0f, 0.0f);
            this.campos.postRotate(this.camera_pitch, 0.0f, 1.0f, 0.0f);
            this.campos.postTranslate(0.0f, 0.0f, 7.0f);
            this.g3d.setCamera(this.camera, this.campos);
        }
        catch (ArithmeticException arithmeticException) {}
        State.repaint();
    }

    /*
     * Unable to fully structure code
     */
    public final void enter() {
        MainMenu.fresh = true;
        State.left = null;
        State.right = Locale.string("command-menu");
        this.currentframe = 0;
        for (var1_1 = 0; var1_1 < this.playfield.length; ++var1_1) {
            for (var2_2 = 0; var2_2 < this.playfield[var1_1].length; ++var2_2) {
                this.playfield[var1_1][var2_2] = GameState.levels[GameState.level][var1_1][var2_2];
                this.fxfield[var1_1][var2_2] = 0;
            }
        }
        switch (GameState.gametype) {
            case 2: {
                switch (GameState.difficulty) {
                    case 0: {
                        v0 = this;
                        v1 = 9000L;
                        ** GOTO lbl25
                    }
                    case 1: {
                        v0 = this;
                        v1 = 7000L;
                        ** GOTO lbl25
                    }
                    case 2: {
                        v0 = this;
                        v1 = 5000L;
lbl25:
                        // 3 sources

                        v0.limit = v1;
                    }
                }
                v2 = "/45sec.mid";
                ** GOTO lbl46
            }
            case 0: {
                switch (GameState.difficulty) {
                    case 0: {
                        this.limit = 45000L;
                        v3 = "/45sec.mid";
                        ** GOTO lbl41
                    }
                    case 1: {
                        this.limit = 30000L;
                        v3 = "/30sec.mid";
                        ** GOTO lbl41
                    }
                    case 2: {
                        this.limit = 20900L;
                        v3 = "/20sec.mid";
lbl41:
                        // 3 sources

                        SoundPlayer.playSound(v3, 1);
                    }
                }
                break;
            }
            case 1: {
                this.limit = 45000L;
                v2 = "/45sec.mid";
lbl46:
                // 2 sources

                SoundPlayer.playSound(v2, 1);
            }
        }
        this.solvetime = 0L;
        switch (GameState.gametype) {
            case 2: {
                v4 = this;
                v5 = Locale.string("menu-survivor");
                break;
            }
            case 1: {
                v4 = this;
                v5 = Locale.string("menu-panic");
                break;
            }
            default: {
                v4 = this;
                v5 = null;
            }
        }
        v4.gametypestring = v5;
        for (var1_1 = 0; var1_1 < this.counts.length; ++var1_1) {
            this.counts[var1_1] = 0;
        }
        for (var1_1 = 0; var1_1 < this.playfield.length; ++var1_1) {
            for (var2_2 = 0; var2_2 < this.playfield[var1_1].length; ++var2_2) {
                if (this.playfield[var1_1][var2_2] <= 0) continue;
                v6 = this.playfield[var1_1][var2_2] - 1;
                this.counts[v6] = this.counts[v6] + 1;
            }
        }
        this.cursor_x = 4;
        this.cursor_y = 4;
        this.camera_x = 4.0f;
        this.camera_y = 4.0f;
        this.camera_z = 20.0f;
        this.camera_pitch = 20.0f;
        this.camera_yaw = 20.0f;
        this.back_x = -200;
        this.back_y = -200;
        GameState.result = 0;
        this.start = System.currentTimeMillis();
        this.lastpanic = this.start + 500L;
        this.do_render = true;
    }

    private void renderPlayfield(Graphics3D graphics3D) {
        this.modelview.setIdentity();
        this.modelview.postTranslate((float)this.cursor_x, (float)this.cursor_y, 0.0f);
        this.modelview.postScale(0.5f, 0.5f, 0.5f);
        this.modelview.postRotate((float)(this.scm / 30L % 360L), 0.0f, 0.0f, -1.0f);
        graphics3D.render((Node)this.cursor, this.modelview);
        this.modelview.postRotate(45.0f, 0.0f, 0.0f, -1.0f);
        graphics3D.render((Node)this.cursor, this.modelview);
        if (this.camera_x < 4.0f) {
            if (this.camera_y > 4.0f) {
                for (int i = 8; i >= 0; --i) {
                    for (int j = 0; j < 9; ++j) {
                        this.drawSquare(graphics3D, i, j);
                    }
                }
                return;
            }
            for (int i = 8; i >= 0; --i) {
                for (int j = 8; j >= 0; --j) {
                    this.drawSquare(graphics3D, i, j);
                }
            }
            return;
        }
        if (this.camera_y > 4.0f) {
            for (int i = 0; i < 9; ++i) {
                for (int j = 0; j < 9; ++j) {
                    this.drawSquare(graphics3D, i, j);
                }
            }
            return;
        }
        for (int i = 0; i < 9; ++i) {
            for (int j = 8; j >= 0; --j) {
                this.drawSquare(graphics3D, i, j);
            }
        }
    }

    private void drawSquare(Graphics3D graphics3D, int n, int n2) {
        int n3 = this.playfield[n][n2];
        if (n3 > 0) {
            this.modelview.setIdentity();
            this.modelview.postTranslate((float)n, (float)n2, 0.0f);
            this.modelview.postScale(0.1f, 0.1f, 0.1f);
            this.modelview.postRotate((float)(this.scm / 10L % 360L), (float)(n - 4), (float)(n2 - 4), 1.0f);
            graphics3D.render((Node)this.balls[n3 - 1], this.modelview);
        }
    }

    private void addPanicBalls() {
        int n;
        int n2;
        int n3 = Math.abs(this.rnd.nextInt()) % this.balls.length + 1;
        int n4 = 0;
        block0: for (n2 = 2; n2 < 7; ++n2) {
            for (n = 2; n < 7; ++n) {
                if (this.playfield[n2][n] == 0) {
                    ++n4;
                }
                if (n4 >= difficulty + 2) continue block0;
            }
        }
        if (n4 < difficulty + 2) {
            return;
        }
        for (n2 = 0; n2 < difficulty + 2; ++n2) {
            int n5;
            while (this.playfield[n = Math.abs(this.rnd.nextInt() % 5) + 2][n5 = Math.abs(this.rnd.nextInt() % 5) + 2] != 0) {
            }
            this.playfield[n][n5] = n3;
            int n6 = n3 - 1;
            this.counts[n6] = this.counts[n6] + 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void paint(Graphics graphics) {
        try {
            int n;
            if (!this.do_render) {
                return;
            }
            try {
                this.g3d.bindTarget((Object)State.canvas.graphics, false, 0);
                this.back_x += (this.cursor_x * 20 - this.back_x) / 3;
                this.back_y += (this.cursor_y * 20 - this.back_y) / 3;
                this.back.setCrop(-this.back_x, this.back_y, this.backimage.getWidth(), this.backimage.getHeight());
                this.g3d.clear(this.back);
                n = (int)(System.currentTimeMillis() & 0x7FFFFFL);
                this.texture.setBlendColor(Utility.interpolateColor(0xFFFF00, 1125953, State.triangle(n, 500, 256)));
                this.renderPlayfield(this.g3d);
            }
            catch (Throwable throwable) {
            }
            finally {
                this.g3d.releaseTarget();
            }
            ++this.currentframe;
            State.canvas.graphics.setFont(Handset.fnt_small);
            State.canvas.graphics.setColor(0xCCCCCC);
            if (this.gametypestring != null) {
                State.canvas.graphics.drawString(this.gametypestring, State.canvas.getWidth(), 0, 24);
            }
            if (!this.solved) {
                int n2;
                Graphics graphics2;
                State.canvas.graphics.setFont(Handset.fnt_bold);
                n = (int)((this.limit - (this.scm - this.start)) / 1000L);
                if (n <= 10) {
                    graphics2 = State.canvas.graphics;
                    n2 = Utility.interpolateColor(0xFFFF00, 0xFF0000, State.triangle((int)this.scm & 0x7FFFFFF, 500, 256));
                } else {
                    graphics2 = State.canvas.graphics;
                    n2 = 0xFFFFFF;
                }
                graphics2.setColor(n2);
                State.canvas.graphics.drawChar((char)(n / 10 + 48), State.canvas.getWidth() / 2, 0, 24);
                State.canvas.graphics.drawChar((char)(n % 10 + 48), State.canvas.getWidth() / 2, 0, 20);
            }
            State.paintCommands(State.canvas.graphics);
            return;
        }
        catch (Throwable throwable) {
            return;
        }
    }

    public final void leave() {
        maxlevel = Math.max(maxlevel, level);
    }

    public final void keyPressed(int n) {
        if (n == Handset.MENU_RIGHT) {
            this.do_render = false;
            State.setNamedState("mainmenu");
            return;
        }
        this.moveCursor(n);
    }

    private void moveToHorizontalEnd(boolean bl) {
        int n;
        GameState gameState;
        if (bl) {
            int n2;
            for (n2 = this.cursor_x; n2 < 9 && this.playfield[n2][this.cursor_y] > 0; ++n2) {
            }
            gameState = this;
            n = n2 - 1;
        } else {
            int n3;
            for (n3 = this.cursor_x; n3 >= 0 && this.playfield[n3][this.cursor_y] > 0; --n3) {
            }
            gameState = this;
            n = n3 + 1;
        }
        gameState.cursor_x = n;
    }

    private void moveToVerticalEnd(boolean bl) {
        int n;
        GameState gameState;
        if (bl) {
            int n2;
            for (n2 = this.cursor_y; n2 < 9 && this.playfield[this.cursor_x][n2] > 0; ++n2) {
            }
            gameState = this;
            n = n2 - 1;
        } else {
            int n3;
            for (n3 = this.cursor_y; n3 >= 0 && this.playfield[this.cursor_x][n3] > 0; --n3) {
            }
            gameState = this;
            n = n3 + 1;
        }
        gameState.cursor_y = n;
    }

    /*
     * Unable to fully structure code
     */
    private void attemptMove(int var1_1, int var2_2) {
        block11: {
            block12: {
                var1_1 += this.cursor_x;
                var2_2 += this.cursor_y;
                if (this.playfield[this.cursor_x][this.cursor_y] == 0) {
                    this.cursor_x = var1_1;
                    this.cursor_y = var2_2;
                    return;
                }
                if (this.playfield[var1_1][var2_2] == 0) {
                    this.playfield[var1_1][var2_2] = this.playfield[this.cursor_x][this.cursor_y];
                    this.playfield[this.cursor_x][this.cursor_y] = 0;
                    this.cursor_x = var1_1;
                    this.cursor_y = var2_2;
                    return;
                }
                if (this.playfield[var1_1][var2_2] != this.playfield[this.cursor_x][this.cursor_y]) break block11;
                this.playfield[this.cursor_x][this.cursor_y] = 0;
                this.cursor_x = var1_1;
                this.cursor_y = var2_2;
                v0 = this.playfield[this.cursor_x][this.cursor_y] - 1;
                this.counts[v0] = this.counts[v0] - 1;
                if (this.counts[this.playfield[this.cursor_x][this.cursor_y] - 1] <= 1) {
                    v1 = this.playfield[this.cursor_x][this.cursor_y] - 1;
                    this.counts[v1] = this.counts[v1] - 1;
                    this.playfield[this.cursor_x][this.cursor_y] = 0;
                }
                if (GameState.gametype != 2) break block12;
                switch (GameState.difficulty) {
                    case 0: {
                        v2 = this;
                        v3 = v2;
                        v4 = v2.limit;
                        v5 = 1500L;
                        ** GOTO lbl42
                    }
                    case 1: {
                        v6 = this;
                        v3 = v6;
                        v4 = v6.limit;
                        v5 = 1000L;
                        ** GOTO lbl42
                    }
                    case 2: {
                        v7 = this;
                        v3 = v7;
                        v4 = v7.limit;
                        v5 = 750L;
lbl42:
                        // 3 sources

                        v3.limit = v4 + v5;
                    }
                }
            }
            return;
        }
        if (this.playfield[var1_1][var2_2] != this.playfield[this.cursor_x][this.cursor_y]) {
            if (var1_1 != this.cursor_x) {
                this.moveToHorizontalEnd(var1_1 > this.cursor_x);
                return;
            }
            if (var2_2 != this.cursor_y) {
                this.moveToVerticalEnd(var2_2 > this.cursor_y);
            }
        }
    }

    private void moveCursor(int n) {
        int n2 = 0;
        int n3 = 0;
        if (n == Handset.DOWN || n == Handset.NUM8 || n == Handset.NUM0) {
            if (this.cursor_y == 0) {
                return;
            }
            n3 = -1;
        }
        if (n == Handset.UP || n == Handset.NUM2) {
            if (this.cursor_y == 8) {
                return;
            }
            n3 = 1;
        }
        if (n == Handset.LEFT || n == Handset.NUM4) {
            if (this.cursor_x == 0) {
                return;
            }
            n2 = -1;
        }
        if (n == Handset.RIGHT || n == Handset.NUM6) {
            if (this.cursor_x == 8) {
                return;
            }
            n2 = 1;
        }
        if (n2 == n3) {
            return;
        }
        this.attemptMove(n2, n3);
    }

    public final void keyRepeated(int n) {
        this.keyPressed(n);
    }

    public final void keyReleased(int n) {
    }

    public final void refresh() {
    }

    static {
        level = 0;
        maxlevel = 0;
        levels = null;
        gametype = 0;
    }
}

