/*
 * Decompiled with CFR 0.152.
 */
package de.mef.state.concrete;

import de.mef.menu.BasicMenu;
import de.mef.menu.Frame;
import de.mef.menu.MenuListener;
import de.mef.menu.Pad;
import de.mef.menu.ScrollArrow;
import de.mef.menu.TextItem;
import de.mef.menu.Widget;
import de.mef.sound.SoundPlayer;
import de.mef.state.State;
import de.mef.util.Handset;
import de.mef.util.KeyListener;
import de.mef.util.Locale;
import de.mef.util.Refreshable;
import de.mef.util.Updateable;
import de.mef.util.Utility;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;

public final class MainMenu
extends State
implements KeyListener,
MenuListener,
Updateable,
Refreshable {
    private BasicMenu menu;
    private TextItem start;
    private TextItem options;
    private TextItem manual;
    private TextItem about;
    public static boolean fresh = true;
    private ScrollArrow up;
    private ScrollArrow down;

    public final void update() {
        State.repaint();
    }

    public final void menuAction(Widget widget, int n) {
        if (widget == this.start) {
            State.setNamedState("chooselevel");
        }
        if (widget == this.options) {
            State.setNamedState("options");
        }
        if (widget == this.manual) {
            State.setNamedState("manual");
        }
        if (widget == this.about) {
            State.setNamedState("info");
        }
    }

    public MainMenu() {
        try {
            if (State.logo == null) {
                State.logo = Utility.cacheImage("/logo.png");
            }
        }
        catch (IOException iOException) {}
        this.menu = new BasicMenu(State.canvas.getHeight() - State.logo.getHeight() - Handset.fnt_small.getHeight());
        this.menu.setAlignment(3);
        try {
            this.up = new ScrollArrow(this.menu, 0);
            this.down = new ScrollArrow(this.menu, 1);
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    public final void enter() {
        this.menu.setCursor(0);
        this.start = new TextItem("menu-start");
        this.start.setMenuListener(this, 1);
        this.options = new TextItem("menu-options");
        this.options.setMenuListener(this, 1);
        this.manual = new TextItem("menu-manual");
        this.manual.setMenuListener(this, 1);
        this.about = new TextItem("menu-about");
        this.about.setMenuListener(this, 1);
        int n = Math.max(this.start.getWidth(), this.options.getWidth());
        n = Math.max(n, this.manual.getWidth());
        n = Math.max(n, this.about.getWidth());
        this.menu.addElement(new Frame(new Pad(this.start, n += 6, 0, 1)));
        this.menu.addElement(new Frame(new Pad(this.options, n, 0, 1)));
        this.menu.addElement(new Frame(new Pad(this.manual, n, 0, 1)));
        this.menu.addElement(new Frame(new Pad(this.about, n, 0, 1)));
        this.refresh();
        State.right = Locale.string("command-quit");
        State.left = Locale.string("command-ok");
        System.currentTimeMillis();
        State.repaint();
        if (fresh) {
            SoundPlayer.playSound("/menu.mid", -1);
            fresh = false;
        }
    }

    public final void paint(Graphics graphics) {
        State.menuBackground(graphics, true);
        this.menu.paint(graphics, State.canvas.getWidth() / 2, State.logo.getHeight() + (State.canvas.getHeight() - State.logo.getHeight()) / 2, 3);
        this.up.paint(graphics, State.canvas.getWidth() / 2, State.canvas.getHeight() - this.down.getHeight(), 33);
        this.down.paint(graphics, State.canvas.getWidth() / 2, State.canvas.getHeight(), 33);
    }

    public final void leave() {
        this.menu.removeAllElements();
    }

    public final void keyPressed(int n) {
        if (n == Handset.MENU_RIGHT) {
            State.host.destroy();
            State.host.notifyDestroyed();
        }
        this.menu.keyPressed(n);
    }

    public final void keyRepeated(int n) {
        this.menu.keyRepeated(n);
    }

    public final void keyReleased(int n) {
        this.menu.keyReleased(n);
    }

    public final void refresh() {
        this.menu.refresh();
    }
}

