/*
 * Decompiled with CFR 0.152.
 */
package de.mef.state;

import de.mef.canvas.MIDP2Canvas;
import de.mef.state.StateMIDlet;
import de.mef.state.concrete.ErrorState;
import de.mef.util.Console;
import de.mef.util.Handset;
import de.mef.util.KeyListener;
import de.mef.util.Updateable;
import de.mef.util.Utility;
import java.io.IOException;
import java.util.Hashtable;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public abstract class State {
    public static StateMIDlet host;
    protected static Display display;
    protected static MIDP2Canvas canvas;
    private static Hashtable states;
    private static State current;
    public static State error;
    protected static String left;
    protected static String right;
    public static Image background;
    public static Image logo;
    public static boolean dirty;

    public abstract void enter() throws Exception;

    public abstract void leave() throws Exception;

    public abstract void paint(Graphics var1) throws Exception;

    public static void repaint() {
        dirty = true;
    }

    public static void updateCurrent() {
        try {
            if (current instanceof Updateable) {
                ((Updateable)((Object)current)).update();
            }
            return;
        }
        catch (Exception exception) {
            if (error != null) {
                current = null;
                State.setCurrentState(error);
            }
            return;
        }
    }

    public static void paintCurrent() {
        try {
            if (dirty) {
                if (current != null) {
                    canvas.paint(State.canvas.graphics);
                }
                dirty = false;
            }
            return;
        }
        catch (Exception exception) {
            if (error != null) {
                current = null;
                State.setCurrentState(error);
            }
            return;
        }
    }

    public static void registerState(Object object, State state) {
        states.put(object, state);
    }

    public static State getState(Object object) {
        return (State)states.get(object);
    }

    protected static void clearScreen(Graphics graphics, int n) {
        graphics.setColor(n);
        graphics.fillRect(0, 0, canvas.getWidth(), canvas.getHeight());
    }

    public static void display(Graphics graphics) {
        if (current != null) {
            try {
                current.paint(graphics);
                State.paintCommands(graphics);
                return;
            }
            catch (Exception exception) {
                if (error != null) {
                    current = null;
                    State.setCurrentState(error);
                }
                return;
            }
        }
        graphics.setColor(0);
        graphics.fillRect(0, 0, canvas.getWidth(), canvas.getHeight());
    }

    public static void paintCommands(Graphics graphics) {
        int n;
        if (left != null) {
            n = (int)(System.currentTimeMillis() & 0x7FFFFFL);
            graphics.setFont(Handset.fnt_smallbold);
            graphics.setColor(0);
            graphics.drawString(left, 3, canvas.getHeight(), 36);
            graphics.setColor(Utility.interpolateColor(0xCCCCCC, 0x404040, State.triangle(n, 500, 256)));
            graphics.drawString(left, 2, canvas.getHeight() - 1, 36);
        }
        if (right != null) {
            n = (int)(System.currentTimeMillis() & 0x7FFFFFL);
            graphics.setFont(Handset.fnt_smallbold);
            graphics.setColor(0);
            graphics.drawString(right, canvas.getWidth() - 2, canvas.getHeight(), 40);
            graphics.setColor(Utility.interpolateColor(0xCCCCCC, 0x404040, State.triangle(n + 500, 500, 256)));
            graphics.drawString(right, canvas.getWidth() - 3, canvas.getHeight() - 1, 40);
        }
    }

    public static final void setCurrentState(State state) {
        block4: {
            try {
                State state2 = current;
                right = null;
                left = null;
                current = null;
                if (state2 != null) {
                    state2.leave();
                }
                if (state == null) {
                    host.destroy();
                    return;
                }
                state.enter();
                current = state;
            }
            catch (Throwable throwable) {
                if (error == null) break block4;
                current = null;
                State.setCurrentState(error);
            }
        }
    }

    public static final void setNamedState(String string) {
        State state = State.getState(string);
        State.setCurrentState(state == null ? error : state);
    }

    public static void delegateKeyPressed(int n) {
        try {
            if (current instanceof KeyListener) {
                ((KeyListener)((Object)current)).keyPressed(n);
                return;
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Console.write(throwable);
            State.setCurrentState(error);
            return;
        }
    }

    public static void delegateKeyRepeated(int n) {
        try {
            if (current instanceof KeyListener) {
                ((KeyListener)((Object)current)).keyRepeated(n);
                return;
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Console.write(throwable);
            State.setCurrentState(error);
            return;
        }
    }

    public static void delegateKeyReleased(int n) {
        try {
            if (current instanceof KeyListener) {
                ((KeyListener)((Object)current)).keyReleased(n);
                return;
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Console.write(throwable);
            State.setCurrentState(error);
            return;
        }
    }

    public static void menuBackground(Graphics graphics, boolean bl) {
        try {
            int n;
            if (background == null) {
                background = Utility.cacheImage("/background.png");
            }
            int n2 = (int)(System.currentTimeMillis() / 40L % (long)background.getWidth());
            int n3 = (int)(System.currentTimeMillis() / 80L % (long)background.getHeight());
            int n4 = n = -n2;
            while (n4 < canvas.getWidth()) {
                int n5;
                int n6 = n5 = -n3;
                while (n6 < canvas.getHeight()) {
                    graphics.drawImage(background, n, n5, 20);
                    n6 = n5 + background.getHeight();
                }
                n4 = n + background.getWidth();
            }
            if (bl) {
                if (logo == null) {
                    logo = Utility.cacheImage("/logo.png");
                }
                graphics.drawImage(logo, canvas.getWidth() / 2, 0, 17);
            }
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    public static int triangle(int n, int n2, int n3) {
        int n4 = (n + n2) % (n2 << 1) - n2;
        int n5 = n4 * n3 / n2;
        return Math.abs(n5);
    }

    static {
        states = new Hashtable();
        current = null;
        error = new ErrorState();
        background = null;
        logo = null;
        dirty = false;
    }
}

