/*
 * Decompiled with CFR 0.152.
 */
package de.mef.menu;

import de.mef.menu.Captioned;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public final class TextItem
extends Captioned {
    Font font = DEFAULT_FONT;
    public int disabled_color = DEFAULT_DISABLED_COLOR;
    public int disabled_outline = DEFAULT_DISABLED_OUTLINE;
    public int disabled_shadow = DEFAULT_DISABLED_SHADOW;
    public int enabled_color = DEFAULT_ENABLED_COLOR;
    public int enabled_outline = DEFAULT_ENABLED_OUTLINE;
    public int enabled_shadow = DEFAULT_ENABLED_SHADOW;
    public int focus_color = DEFAULT_FOCUS_COLOR;
    public int focus_outline = DEFAULT_FOCUS_OUTLINE;
    public int focus_shadow = DEFAULT_FOCUS_SHADOW;
    public int shadow_x = DEFAULT_SHADOW_X;
    public int shadow_y = DEFAULT_SHADOW_Y;
    public static Font DEFAULT_FONT = Font.getDefaultFont();
    public static int DEFAULT_DISABLED_COLOR = 0x808080;
    public static int DEFAULT_DISABLED_OUTLINE = 0x404040;
    public static int DEFAULT_DISABLED_SHADOW = -1;
    public static int DEFAULT_ENABLED_COLOR = 0xC0C0C0;
    public static int DEFAULT_ENABLED_OUTLINE = -1;
    public static int DEFAULT_ENABLED_SHADOW = -1;
    public static int DEFAULT_FOCUS_COLOR = 0xFFFF00;
    public static int DEFAULT_FOCUS_OUTLINE = 0xC00000;
    public static int DEFAULT_FOCUS_SHADOW = -1;
    public static int DEFAULT_SHADOW_X = 2;
    public static int DEFAULT_SHADOW_Y = 2;

    private TextItem() {
        super(null);
    }

    public TextItem(String string) {
        super(string);
        this.refresh();
    }

    public final void refresh() {
        super.refresh();
        this.width = this.font.stringWidth(this.caption) + 2;
        this.height = this.font.getHeight() + 2;
    }

    private void drawOutline(Graphics graphics, int n) {
        graphics.setColor(n);
        graphics.drawString(this.caption, 1, 0, 0);
        graphics.drawString(this.caption, 1, 2, 0);
        graphics.drawString(this.caption, 2, 0, 0);
        graphics.drawString(this.caption, 2, 2, 0);
        graphics.drawString(this.caption, 2, 1, 0);
        graphics.drawString(this.caption, 0, 0, 0);
        graphics.drawString(this.caption, 0, 2, 0);
        graphics.drawString(this.caption, 0, 1, 0);
    }

    private void drawShadow(Graphics graphics, int n) {
        graphics.setColor(n);
        graphics.drawString(this.caption, 1 + this.shadow_x, 1 + this.shadow_y, 0);
    }

    public final void display(Graphics graphics) {
        int n;
        Graphics graphics2;
        graphics.setFont(this.font);
        if (this.enabled) {
            if (this.focus) {
                if (this.focus_shadow != -1) {
                    this.drawShadow(graphics, this.focus_shadow);
                }
                if (this.focus_outline != -1) {
                    this.drawOutline(graphics, this.focus_outline);
                }
                graphics2 = graphics;
                n = this.focus_color;
            } else {
                if (this.enabled_shadow != -1) {
                    this.drawShadow(graphics, this.enabled_shadow);
                }
                if (this.enabled_outline != -1) {
                    this.drawOutline(graphics, this.enabled_outline);
                }
                graphics2 = graphics;
                n = this.enabled_color;
            }
        } else {
            if (this.disabled_shadow != -1) {
                this.drawShadow(graphics, this.disabled_shadow);
            }
            if (this.disabled_outline != -1) {
                this.drawOutline(graphics, this.disabled_outline);
            }
            graphics2 = graphics;
            n = this.disabled_color;
        }
        graphics2.setColor(n);
        graphics.drawString(this.caption, 1, 1, 0);
    }
}

