/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;

public final class Sound {
    private final int TYPE_AMR;
    private final int TYPE_MIDI;
    private final int TYPE_WAVE;
    private Player[] p;
    private InputStream sound;
    private VolumeControl[] synth;
    private int currentSound;
    private String soundType;
    private String soundRes;
    private int soundNum;
    public int[] soundon = new int[]{-1, -1};

    public Sound(int n, int n2) {
        this.TYPE_AMR = 0;
        this.TYPE_MIDI = 1;
        this.TYPE_WAVE = 2;
        try {
            this.soundNum = n2;
            this.setType(n);
            this.currentSound = 0;
            this.p = new Player[n2];
            this.synth = new VolumeControl[n2];
            for (int i = 0; i < n2; ++i) {
                this.sound = this.getClass().getResourceAsStream(i + "." + this.soundType);
                this.p[i] = Manager.createPlayer((InputStream)this.sound, (String)("audio/" + this.soundRes));
                this.p[i].realize();
                this.synth[i] = (VolumeControl)this.p[i].getControl("VolumeControl");
            }
            this.sound = null;
            System.gc();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void soundOpen(int n) {
        if (n >= 0 && n < this.p.length) {
            if (this.currentSound != n) {
                this.soundStop();
                this.currentSound = n;
            }
        } else {
            System.out.println("soundOpen Error!");
        }
    }

    public void soundPlay(int n, int n2) {
        this.soundOpen(n);
        if (this.currentSound < 0 || this.currentSound >= this.p.length) {
            return;
        }
        if (this.p[this.currentSound] == null || this.p[this.currentSound].getState() == 400) {
            return;
        }
        try {
            this.soundon[0] = this.currentSound;
            this.soundon[1] = n2;
            if (n2 != 0) {
                this.p[this.currentSound].setLoopCount(n2);
            }
            this.p[this.currentSound].start();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void soundPause() {
        try {
            if (this.p[this.currentSound] == null) {
                return;
            }
            if (this.p[this.currentSound].getState() == 400) {
                this.p[this.currentSound].stop();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void soundStop() {
        try {
            if (this.p[this.currentSound] == null) {
                return;
            }
            if (this.p[this.currentSound].getState() == 400) {
                this.soundon[0] = -1;
                this.soundon[1] = -1;
                this.p[this.currentSound].stop();
                this.p[this.currentSound].setMediaTime(0L);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void soundLevel(int n) {
        try {
            for (int i = 0; i < this.soundNum; ++i) {
                if (this.synth[i] == null) continue;
                this.synth[i].setLevel(n * 40);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void close() {
        this.p = null;
        this.sound = null;
        System.gc();
    }

    public void soundReset(long l) {
        try {
            this.p[this.currentSound].setMediaTime(l);
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
    }

    private void setType(int n) {
        switch (n) {
            case 0: {
                this.soundType = "amr";
                this.soundRes = "amr";
                break;
            }
            case 1: {
                this.soundType = "mid";
                this.soundRes = "midi";
                break;
            }
            case 2: {
                this.soundType = "wav";
                this.soundRes = "x-wav";
            }
        }
    }
}

