/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.rms.RecordStore;

public class GameCanvas
extends Canvas
implements Runnable {
    public static Display display;
    private Chicktris midlet;
    private Menu menu;
    private Game game;
    private static GameCanvas instance;
    public static int WIDTH;
    public static int HEIGHT;
    public static long frameTime;
    public static final int FRAME_DURATION_FOR_PAUSE = 1500;
    public static final int KEY_SOFTKEY1 = -6;
    public static final int KEY_SOFTKEY2 = -7;
    public static final int KEY_RED_BUTTON = -123654;
    public static int pointerX;
    public static int pointerY;
    public static boolean isPointerPressed;
    public static boolean isTouchHandled;
    private static final byte STATE_GAME = 1;
    private static final byte STATE_MENU = 2;
    private static final byte STATE_EXIT = 3;
    private static final byte STATE_LOAD = 4;
    public static final byte TRANSITION_NONE = 0;
    public static final byte TRANSITION_MENU_MAIN = 1;
    public static final byte TRANSITION_MENU_HI_SCORES = 2;
    public static final byte TRANSITION_GAME_NEW = 3;
    public static final byte TRANSITION_GAME_CONTINUE = 4;
    public static final byte TRANSITION_EXIT = 5;
    public static final byte TRANSITION_MENU_NAME = 6;
    private static int state;
    private boolean paused = true;
    private boolean isLoading = false;
    private boolean showFPS = false;
    private int loadingPercent = 0;
    private int exitingCounter = 0;
    private boolean painted = false;
    private static final int FRAME_DURATION = 100;
    private static final int keyQueueSize = 10;
    private int[] keyCodeQueue = new int[10];
    private boolean[] keyActionQueue = new boolean[10];
    private int keyCodeQueueMarker = 0;
    private int counter = 0;
    private static final String RS_NAME_SETTINGS = "Chicktris_Settings";
    private static final String RS_NAME_GAME = "Chicktris_Game";
    private static int maxLoadingTime;
    private static int postLoadingProgressDelay;
    public static boolean wasPaused;
    private byte cheatCode = (byte)-3;

    public GameCanvas(Display d, Chicktris m) {
        instance = this;
        display = d;
        this.midlet = m;
        this.setFullScreenMode(true);
        new Thread(this).start();
    }

    private void init() {
        try {
            GraphicFont.loadFont(GraphicFont.getFile("/fonts/ex_ft1.def"), "/fonts/ex_ft1.png", 1);
            GraphicFont.loadFont(GraphicFont.getFile("/fonts/font_s.def"), "/fonts/font_s.png", 0);
            GraphicFont.loadFont(GraphicFont.getFile("/fonts/ex_ft2.def"), "/fonts/ex_ft2.png", 2);
            GraphicFont.loadFont(GraphicFont.getFile("/fonts/font_n.def"), "/fonts/font_n.png", 3);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        Chicktris.loadLanguages();
        this.loadSettings();
        this.menu = new Menu();
    }

    public void keyPressed(int aKeyCode) {
        this.cheatsControl(aKeyCode);
        if (state == 3 || this.isLoading) {
            return;
        }
        if (this.keyCodeQueueMarker < 10) {
            this.keyCodeQueue[this.keyCodeQueueMarker] = aKeyCode;
            this.keyActionQueue[this.keyCodeQueueMarker] = true;
            ++this.keyCodeQueueMarker;
        }
    }

    public void keyReleased(int aKeyCode) {
        if (state == 3 || this.isLoading) {
            return;
        }
        if (this.keyCodeQueueMarker < 10) {
            this.keyCodeQueue[this.keyCodeQueueMarker] = aKeyCode;
            this.keyActionQueue[this.keyCodeQueueMarker] = false;
            ++this.keyCodeQueueMarker;
        }
    }

    private void keyReaction(int keyCode, boolean isPressed) {
        if (state == 3) {
            return;
        }
        int gameAction = 0;
        try {
            gameAction = this.getGameAction(keyCode);
            if (!(gameAction != 8 && gameAction != 2 && gameAction != 5 || keyCode != -7 && keyCode != -6)) {
                gameAction = 0;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        int transition = 0;
        switch (state) {
            case 2: {
                transition = this.menu.processKey(keyCode, gameAction, isPressed);
                break;
            }
            case 1: {
                transition = this.game.processKey(keyCode, gameAction, isPressed);
            }
        }
        if (transition != 0) {
            this.makeTransition(transition);
        }
    }

    private void makeTransition(int transition) {
        switch (transition) {
            case 4: {
                this.menu = null;
                System.gc();
                if (this.game == null) {
                    this.game = new Game(Settings.getGameParameters());
                    this.loadGame();
                }
                state = 1;
                this.game.resume();
                break;
            }
            case 3: {
                this.menu = null;
                this.game = null;
                System.gc();
                this.game = new Game(Settings.getGameParameters());
                Settings.isGameHasContinue = true;
                state = 1;
                this.game.resume();
                break;
            }
            case 1: {
                this.menu = new Menu();
                state = 2;
                break;
            }
            case 2: {
                this.game = null;
                System.gc();
                this.menu = new Menu();
                this.menu.setHiScoresState();
                state = 2;
                break;
            }
            case 6: {
                this.game = null;
                System.gc();
                this.menu = new Menu();
                this.menu.setNameState();
                state = 2;
                break;
            }
            case 5: {
                state = 3;
                this.saveDataBeforeExit();
                this.menu = null;
                this.game = null;
                System.gc();
            }
        }
    }

    private void process() {
        try {
            if (state == 3) {
                ++this.exitingCounter;
                if (this.exitingCounter == 2) {
                    this.midlet.notifyDestroyed();
                }
                return;
            }
            if (state == 2 && this.menu != null) {
                this.menu.process();
            }
            if (state == 1 && this.game != null) {
                this.game.process();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void paint(Graphics g) {
        GraphicFont.grActive = g;
        if (this.painted) {
            return;
        }
        try {
            if (state == 3) {
                this.painted = true;
                return;
            }
            if (WIDTH == 0) {
                WIDTH = this.getWidth();
                HEIGHT = this.getHeight();
            }
            if (this.isLoading) {
                Settings.drawLoadingProgress(g, this.loadingPercent);
                this.painted = true;
                return;
            }
            ++this.counter;
            switch (state) {
                case 2: {
                    this.menu.draw(g);
                    break;
                }
                case 1: {
                    this.game.draw(g);
                    break;
                }
                case 4: {
                    this.init();
                    state = 2;
                }
            }
            if (this.showFPS) {
                g.setFont(Font.getFont((int)0, (int)0, (int)8));
                g.setColor(0xFFFFFF);
                if (frameTime > 0L) {
                    g.drawString("FPS = " + 1000L / frameTime + "." + 1000000L / frameTime % 1000L, 5, 5, 0);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.painted = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void savePreparing(String rsName, boolean isGameSaving) {
        RecordStore rs = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        byte[] data = null;
        try {
            RecordStore.deleteRecordStore((String)rsName);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            rs = RecordStore.openRecordStore((String)rsName, (boolean)true);
            if (isGameSaving) {
                this.game.save(dos);
            } else {
                Settings.save(dos);
            }
            data = baos.toByteArray();
            rs.addRecord(data, 0, data.length);
            baos.close();
            dos.close();
            rs.closeRecordStore();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            rs = null;
            data = null;
            baos = null;
            dos = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPreparing(String rsName, boolean isGameLoading) {
        RecordStore rs = null;
        ByteArrayInputStream bais = null;
        FilterInputStream dis = null;
        byte[] data = null;
        try {
            rs = RecordStore.openRecordStore((String)rsName, (boolean)false);
            data = rs.getRecord(1);
            bais = new ByteArrayInputStream(data);
            dis = new DataInputStream(bais);
            if (isGameLoading) {
                this.game.load((DataInputStream)dis);
            } else {
                Settings.load((DataInputStream)dis);
            }
            rs.closeRecordStore();
            bais.close();
            dis.close();
        }
        catch (Exception ex) {
            try {
                rs.closeRecordStore();
            }
            catch (Exception e1) {
                // empty catch block
            }
            try {
                bais.close();
            }
            catch (Exception e1) {
                // empty catch block
            }
            try {
                dis.close();
            }
            catch (Exception e1) {
                // empty catch block
            }
            if (isGameLoading) {
                Settings.isGameHasContinue = false;
            } else {
                Settings.resetSettings();
                GameCanvas.saveSettings();
            }
        }
        finally {
            rs = null;
            data = null;
            bais = null;
            dis = null;
        }
    }

    public static void saveGame() {
        instance.savePreparing(RS_NAME_GAME, true);
    }

    private void loadGame() {
        this.loadPreparing(RS_NAME_GAME, true);
    }

    public static void saveSettings() {
        instance.savePreparing(RS_NAME_SETTINGS, false);
    }

    private void loadSettings() {
        this.loadPreparing(RS_NAME_SETTINGS, false);
    }

    public static void drawSoftkeys(Graphics g, String softkey1, String softkey2) {
        Settings.representSoftkeys(g, softkey1, softkey2);
    }

    public static void drawSoftkeys(int a_SoftKey1, int a_SoftKey2) {
        Settings.representSoftkeys(a_SoftKey1, a_SoftKey2);
    }

    public static void setLoadingProgress(int loadingPercent) {
        Settings.drawLoadingProgress(GraphicFont.grActive, loadingPercent);
        postLoadingProgressDelay += maxLoadingTime;
    }

    public static void setTimeBetweenLoadingPoints(int mLoadingTime) {
        maxLoadingTime = mLoadingTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        long time = System.currentTimeMillis();
        try {
            while (true) {
                long timeBuf = System.currentTimeMillis();
                frameTime = timeBuf - time;
                time = timeBuf;
                if (frameTime < 100L) {
                    time += 100L - frameTime;
                    Thread.sleep(100L - frameTime);
                    frameTime = 100L;
                }
                for (int i = 0; i < this.keyCodeQueueMarker; ++i) {
                    this.keyReaction(this.keyCodeQueue[i], this.keyActionQueue[i]);
                    if (state == 3) break;
                }
                this.keyCodeQueueMarker = 0;
                this.process();
                this.painted = false;
                this.repaint();
                GameCanvas gameCanvas = this;
                synchronized (gameCanvas) {
                    this.repaint();
                    this.serviceRepaints();
                }
            }
        }
        catch (Exception exception) {
            new Thread(this).start();
            return;
        }
    }

    public void saveDataBeforeExit() {
        if (this.game != null && !this.game.isGameFinished()) {
            this.game.pause();
            GameCanvas.saveGame();
        }
        GameCanvas.saveSettings();
    }

    public void hideNotify() {
        this.devicePause();
    }

    public void showNotify() {
        this.deviceStart();
    }

    public void devicePause() {
        if (this.paused) {
            return;
        }
        this.paused = true;
        if (this.menu != null) {
            this.menu.pause();
        }
        if (this.game != null) {
            this.game.pause();
        }
    }

    public void deviceStart() {
        if (!this.paused) {
            return;
        }
        this.paused = false;
    }

    private void cheatsControl(int keyCode) {
        if (this.cheatCode == -2) {
            return;
        }
        if (this.cheatCode == -3) {
            this.cheatCode = (byte)(this.midlet.getAppProperty("CheatsEnable") == null ? -2 : -1);
            if (this.cheatCode == -2) {
                return;
            }
        }
        if (keyCode == 35) {
            this.cheatCode = 0;
        } else if (keyCode >= 49 && keyCode <= 57) {
            if (this.cheatCode == 0) {
                this.cheatCode = (byte)(10 * (keyCode - 49 + 1));
                return;
            }
            if (this.cheatCode > 0) {
                this.cheatCode = (byte)(this.cheatCode + (keyCode - 49 + 1));
            }
        } else {
            this.cheatCode = (byte)-1;
        }
        if (this.cheatCode > 10) {
            System.out.println("Cheat: #" + this.cheatCode);
            switch (this.cheatCode) {
                case 21: {
                    this.deviceStart();
                    break;
                }
                case 22: {
                    this.devicePause();
                    break;
                }
                case 23: {
                    this.showNotify();
                    break;
                }
                case 24: {
                    this.hideNotify();
                    break;
                }
                case 25: {
                    try {
                        this.midlet.startApp();
                    }
                    catch (Exception e) {}
                    break;
                }
                case 26: {
                    try {
                        this.midlet.pauseApp();
                    }
                    catch (Exception e) {}
                    break;
                }
                case 27: {
                    try {
                        this.midlet.destroyApp(true);
                    }
                    catch (Exception e) {}
                    break;
                }
                case 28: {
                    try {
                        this.midlet.destroyApp(false);
                    }
                    catch (Exception exception) {}
                    break;
                }
                case 77: {
                    if (this.game == null) break;
                    this.game.isGameCompetedByCheat = true;
                    break;
                }
                case 88: {
                    this.showFPS = !this.showFPS;
                    break;
                }
                default: {
                    Settings.cheatProcess(this.cheatCode);
                }
            }
            this.cheatCode = (byte)-1;
        }
    }

    static {
        WIDTH = 0;
        HEIGHT = 0;
        frameTime = 0L;
        pointerX = 0;
        pointerY = 0;
        isPointerPressed = false;
        isTouchHandled = true;
        state = 4;
        maxLoadingTime = 0;
        postLoadingProgressDelay = 0;
        wasPaused = false;
    }
}

