/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class GraphicFont {
    public static final byte FONT_SMALL = 0;
    public static final byte FONT_MEDIUM = 1;
    public static final byte FONT_BIG = 2;
    public static final byte FONT_NUMBER = 3;
    public static final byte FONT_DEFAULT = 2;
    public static final byte FONT_TEXT = 1;
    public static final byte FONT_COUNT = 4;
    public static byte LANGUAGE_COUNT = (byte)2;
    public static final int AA_TOPLEFT = 0;
    public static final int AA_LEFT = 4;
    public static final int AA_BOTTOMLEFT = 8;
    public static final int AA_TOP = 1;
    public static final int AA_CENTER = 5;
    public static final int AA_BOTTOM = 9;
    public static final int AA_TOPRIGHT = 2;
    public static final int AA_RIGHT = 6;
    public static final int AA_BOTTOMRIGHT = 10;
    public static final int ANC_TOPLEFT = 20;
    public static final int ANC_TOP = 17;
    public static final int ANC_TOPRIGHT = 24;
    public static final int ANC_LEFT = 6;
    public static final int ANC_CENTER = 3;
    public static final int ANC_RIGHT = 10;
    public static final int ANC_BOTTOMLEFT = 36;
    public static final int ANC_BOTTOM = 33;
    public static final int ANC_BOTTOMRIGHT = 40;
    public static Graphics grActive;
    private static final int[] __anchorShift;
    private static int iClipX1;
    private static int iClipY1;
    private static int iClipX2;
    private static int iClipY2;
    private static int iClipW;
    private static int iClipH;
    public static int iFont;
    public static int iNumItems;
    public static int iNumFitting;
    public static String[] wrap_arrText;
    public static int wrap_iIndex;
    private static final int[] wrap_arrBreaks;
    private static final int[] wrap_arrPicLine;
    private static int wrap_Number;
    private static int wrap_Code;
    private static int wrap_iPicCount;
    private static int menuViewWidth;
    public static short[][] _TextIndexes;
    public static String[] _TextsStr;
    public static byte currentLanguage;
    public static final int CHAR_SPACE = -1;
    public static final int CHAR_CR = -2;
    public static final int CHAR_TAB = -3;
    public static final int CHAR_USER_0 = -4;
    public static final int CHAR_USER_1 = -5;
    public static final int CHAR_USER_2 = -6;
    public static final int CHAR_USER_3 = -7;
    public static final int CHAR_USER_4 = -8;
    public static final int CHAR_USER_5 = -9;
    public static final int CHAR_USER_6 = -10;
    public static final int CHAR_USER_7 = -11;
    public static final int CHAR_USER_8 = -12;
    public static final int CHAR_USER_9 = -13;
    public static final int CHAR_LAST = -13;
    public static final int LANG_DELAY = 3;
    public static String[] shortLang;
    private static final short[][] _FontX;
    private static final short[][] _FontY;
    private static final byte[][] _FontW;
    private static final byte[] _FontH;
    private static final byte[] _FontSpace;
    private static final byte[] _FontInterChar;
    public static final Image[] _FontImage;

    public static final int __anchorOffset(int a_iAnchor, int a_iSize) {
        return -(a_iSize >>> __anchorShift[a_iAnchor]);
    }

    public static final void setClip(int x, int y, int w, int h) {
        iClipX1 = x;
        iClipY1 = y;
        iClipW = w;
        iClipH = h;
        iClipX2 = x + w;
        iClipY2 = y + h;
    }

    private static final boolean clipBool(int x, int y, int w, int h) {
        if (w + x < iClipX1) {
            return false;
        }
        if (h + y < iClipY1) {
            return false;
        }
        if (x >= iClipX2) {
            return false;
        }
        if (y >= iClipY2) {
            return false;
        }
        grActive.setClip(x, y, w, h);
        grActive.clipRect(iClipX1, iClipY1, iClipW, iClipH);
        return true;
    }

    public static void initTextLanguages(int a_iLangCount) {
        _TextIndexes = new short[a_iLangCount][];
    }

    public static void initText(int size) {
        _TextsStr = new String[size];
    }

    public static final String[] copyNumber(int a_iNumber) {
        int charnum = 0;
        int n = a_iNumber;
        do {
            ++charnum;
        } while ((n /= 10) != 0);
        int i = charnum;
        String[] aText = new String[charnum];
        n = a_iNumber;
        do {
            aText[--i] = Integer.toString((byte)(n % 10));
            n /= 10;
        } while (i > 0);
        return aText;
    }

    public static final int replaceWithText(byte[] aText, int a_iTextLength, byte a_bSource, byte[] aDest, int a_iDestStart, int a_iDestLength) {
        for (int i = 0; i < a_iTextLength; ++i) {
            if (aText[i] != a_bSource) continue;
            System.arraycopy(aText, i + 1, aText, i + a_iDestLength, a_iTextLength - 1 - i);
            System.arraycopy(aDest, a_iDestStart, aText, i, a_iDestLength);
            return a_iTextLength + a_iDestLength - 1;
        }
        return a_iTextLength;
    }

    public static final void wrapText() {
        int linew = 0;
        int spacew = 0;
        int lastspace = -1;
        iNumItems = 0;
        wrap_iPicCount = 0;
        GraphicFont.wrap_arrBreaks[0] = 0;
        block5: for (int i = 0; i < wrap_arrText[wrap_iIndex].length(); ++i) {
            byte b = GraphicFont.getCharId(wrap_arrText[wrap_iIndex].charAt(i));
            switch (b) {
                case -6: 
                case -5: {
                    GraphicFont.wrap_arrPicLine[GraphicFont.wrap_iPicCount++] = iNumItems + 1;
                }
                case -2: {
                    GraphicFont.wrap_arrBreaks[++GraphicFont.iNumItems] = i + 1;
                    if (wrap_Number == 0) {
                        wrap_Number = wrap_arrBreaks[iNumItems];
                    } else if (wrap_Number != 0 && wrap_Code == 0 && wrap_arrText[wrap_iIndex].charAt(i - 1) != '\ufffffffe') {
                        wrap_Code = wrap_arrBreaks[iNumItems];
                    }
                    lastspace = -1;
                    linew = 0;
                    spacew = 0;
                    continue block5;
                }
                case -1: {
                    lastspace = i;
                    spacew = linew += GraphicFont.charWidthAdvance(iFont, wrap_arrText[wrap_iIndex].charAt(i));
                    continue block5;
                }
                default: {
                    if ((linew += GraphicFont.charWidthAdvance(iFont, wrap_arrText[wrap_iIndex].charAt(i))) <= menuViewWidth || lastspace < 0) continue block5;
                    GraphicFont.wrap_arrBreaks[++GraphicFont.iNumItems] = lastspace + 1;
                    lastspace = -1;
                    linew -= spacew;
                }
            }
        }
        GraphicFont.wrap_arrBreaks[++GraphicFont.iNumItems] = wrap_arrText[wrap_iIndex].length();
    }

    public static final int getNumFitting(int a_iY1, int a_iY2, int a_iHeight) {
        return (a_iY2 - a_iY1 - 6) / a_iHeight;
    }

    public static void prepareWrapText(int a_idText, int a_idFont, int a_iViewWidth) {
        menuViewWidth = a_iViewWidth;
        wrap_arrText = _TextsStr;
        wrap_iIndex = a_idText;
        wrap_Code = 0;
        wrap_Number = 0;
        iFont = a_idFont;
        GraphicFont.wrapText();
    }

    public static final void loadFont(DataInputStream f, String a_sImageFile, int a_iFontId) throws Exception {
        if (_FontImage[a_iFontId] == null) {
            int num = f.readUnsignedByte();
            GraphicFont._FontX[a_iFontId] = GraphicFont.readShortArray(f, num);
            GraphicFont._FontY[a_iFontId] = GraphicFont.readShortArray(f, num);
            GraphicFont._FontW[a_iFontId] = GraphicFont.readByteArray(f, num);
            GraphicFont._FontH[a_iFontId] = f.readByte();
            GraphicFont._FontSpace[a_iFontId] = f.readByte();
            GraphicFont._FontInterChar[a_iFontId] = (byte)(1 - f.readByte());
            GraphicFont._FontImage[a_iFontId] = GraphicFont.getImage(a_sImageFile);
        }
    }

    public static final void unloadFont(int a_iFontId) {
        GraphicFont._FontX[a_iFontId] = null;
        GraphicFont._FontY[a_iFontId] = null;
        GraphicFont._FontW[a_iFontId] = null;
        GraphicFont._FontImage[a_iFontId] = null;
        System.gc();
    }

    public static final int charWidthAdvance(int a_iFntId, char a_iChar) {
        int a_iCharId = GraphicFont.getCharId(a_iChar);
        if (a_iCharId <= -13) {
            a_iCharId &= 0xFF;
        }
        int flag = 0;
        try {
            flag = (a_iCharId < 0 ? _FontSpace[a_iFntId] : _FontW[a_iFntId][a_iCharId]) + _FontInterChar[a_iFntId];
        }
        catch (Exception exception) {
            System.out.println("error in font + " + a_iChar + " " + a_iCharId);
        }
        return flag;
    }

    private static final byte getCharId(char a_iChar) {
        switch (a_iChar) {
            case '|': {
                return -2;
            }
            case ' ': {
                return -1;
            }
            case '!': {
                return 68;
            }
            case '#': {
                return 69;
            }
            case '$': {
                return 70;
            }
            case ':': {
                return 71;
            }
            case '*': {
                return 72;
            }
            case '[': {
                return 73;
            }
            case ']': {
                return 74;
            }
            case '-': {
                return 75;
            }
            case '+': {
                return 76;
            }
            case '.': {
                return 77;
            }
            case ',': {
                return 78;
            }
            case '/': {
                return 79;
            }
            case '\'': {
                return 80;
            }
            case '\"': {
                return 82;
            }
            case '?': {
                return 83;
            }
            case '\u00bf': {
                return 84;
            }
            case '\u00a1': {
                return 85;
            }
        }
        if (a_iChar >= '\u00c0' & a_iChar <= '\u00df') {
            return (byte)(a_iChar - 156);
        }
        if (a_iChar >= 'A' & a_iChar <= 'Z') {
            return (byte)(a_iChar - 55);
        }
        return (byte)(a_iChar - 48);
    }

    private static final int drawChar(int a_iFntId, char a_iChar, int a_iX, int a_iY) {
        byte a_iCharId = GraphicFont.getCharId(a_iChar);
        if (a_iCharId <= -13) {
            a_iCharId = (byte)(a_iCharId & 0xFF);
        }
        if (a_iCharId >= 0 && GraphicFont.clipBool(a_iX, a_iY, _FontW[a_iFntId][a_iCharId], _FontH[a_iFntId])) {
            grActive.drawImage(_FontImage[a_iFntId], a_iX - _FontX[a_iFntId][a_iCharId], a_iY - _FontY[a_iFntId][a_iCharId], 20);
        }
        return GraphicFont.charWidthAdvance(a_iFntId, a_iChar);
    }

    public static final int textWidthAdvance(int a_iFntId, int a_iTextId) {
        return GraphicFont.textWidthAdvance(a_iFntId, _TextsStr, a_iTextId, 0, _TextsStr[a_iTextId].length());
    }

    public static int textWidthAdvance(int a_iFntId, String[] a_iText, int a_iIndex, int a_iStart, int a_iEnd) {
        int result = 0;
        for (int i = a_iStart; i < a_iEnd; ++i) {
            result += GraphicFont.charWidthAdvance(a_iFntId, a_iText[a_iIndex].charAt(i));
        }
        return result;
    }

    public static int textWidthAdvance(int a_iFntId, String a_iText) {
        int result = 0;
        for (int i = 0; i < a_iText.length(); ++i) {
            result += GraphicFont.charWidthAdvance(a_iFntId, a_iText.charAt(i));
        }
        return result;
    }

    public static int textWidthTotal(int a_iFntId, String[] aText, int a_iIndex, int a_iStart, int a_iEnd) {
        return GraphicFont.textWidthAdvance(a_iFntId, aText, a_iIndex, a_iStart, a_iEnd) - _FontInterChar[a_iFntId];
    }

    public static int textWidthTotal(int a_iFntId, int a_iTextId) {
        return GraphicFont.textWidthTotal(a_iFntId, _TextsStr, a_iTextId, 0, _TextsStr[a_iTextId].length());
    }

    public static int textHeight(int a_iFntId) {
        return _FontH[a_iFntId];
    }

    public static void drawText(int a_iTextId, int a_iX, int a_iY, int a_iAkimAnchor) {
        GraphicFont.drawText(2, a_iTextId, a_iX, a_iY, a_iAkimAnchor);
    }

    public static void drawText(int a_iFntId, int a_iTextId, int a_iX, int a_iY, int a_iAkimAnchor) {
        GraphicFont.drawText(a_iFntId, _TextsStr, a_iTextId, a_iX, a_iY, a_iAkimAnchor);
    }

    public static void drawText(int a_iFntId, String[] a_Text, int a_iIndex, int a_iX, int a_iY, int a_iAkimAnchor) {
        if ((a_iAkimAnchor & 3) != 0) {
            a_iX += GraphicFont.__anchorOffset(a_iAkimAnchor & 3, GraphicFont.textWidthTotal(a_iFntId, a_Text, a_iIndex, 0, a_Text[a_iIndex].length()));
        }
        if (a_iAkimAnchor > 3) {
            a_iY += GraphicFont.__anchorOffset(a_iAkimAnchor >>> 2, _FontH[a_iFntId]);
        }
        for (int i = 0; i < a_Text[a_iIndex].length(); ++i) {
            a_iX += GraphicFont.drawChar(a_iFntId, a_Text[a_iIndex].charAt(i), a_iX, a_iY);
        }
        grActive.setClip(0, 0, GameCanvas.WIDTH, GameCanvas.HEIGHT);
    }

    public static void drawText(int a_iFntId, String[] a_Text, int a_iIndex, int a_iStart, int a_iEnd, int a_iX, int a_iY, int a_iAkimAnchor) {
        if ((a_iAkimAnchor & 3) != 0) {
            a_iX += GraphicFont.__anchorOffset(a_iAkimAnchor & 3, GraphicFont.textWidthTotal(a_iFntId, a_Text, a_iIndex, a_iStart, a_iEnd));
        }
        if (a_iAkimAnchor > 3) {
            a_iY += GraphicFont.__anchorOffset(a_iAkimAnchor >>> 2, _FontH[a_iFntId]);
        }
        for (int i = a_iStart; i < a_iEnd; ++i) {
            a_iX += GraphicFont.drawChar(a_iFntId, a_Text[a_iIndex].charAt(i), a_iX, a_iY);
        }
        grActive.setClip(0, 0, GameCanvas.WIDTH, GameCanvas.HEIGHT);
    }

    public static final void drawNumber(int a_Number, int a_iX, int a_iY, int a_iAkimAnchor) {
        GraphicFont.drawNumber(3, a_Number, a_iX, a_iY, a_iAkimAnchor);
    }

    public static final void drawNumber(int a_iFontId, int aNumber, int a_iX, int a_iY, int a_iAkimAnchor) {
        int i;
        String[] b = GraphicFont.copyNumber(aNumber);
        StringBuffer sb = new StringBuffer(b.length);
        int x = a_iX;
        for (i = 0; i < b.length; ++i) {
            sb.append(b[i]);
        }
        if ((a_iAkimAnchor & 3) != 0) {
            a_iX += GraphicFont.__anchorOffset(a_iAkimAnchor & 3, GraphicFont.textWidthAdvance(a_iFontId, sb.toString()));
        }
        if (a_iAkimAnchor > 3) {
            a_iY += GraphicFont.__anchorOffset(a_iAkimAnchor >>> 2, _FontH[a_iFontId]);
        }
        for (i = 0; i < b.length; ++i) {
            a_iX += GraphicFont.drawChar(a_iFontId, b[i].charAt(0), a_iX, a_iY);
        }
        grActive.setClip(0, 0, GameCanvas.WIDTH, GameCanvas.HEIGHT);
    }

    public static void drawWrapedText(int a_iX, int a_iY, boolean a_isCenter, int a_iFontId, int iStart) {
        int iFontHeight = GraphicFont.textHeight(a_iFontId);
        iNumFitting = GraphicFont.getNumFitting(1, GameCanvas.HEIGHT - 1 - 70 - iFontHeight, iFontHeight);
        int iNumOnscreen = Math.min(iNumItems, iNumFitting) + iStart;
        int iAnchor = 1;
        int x = a_iX;
        if (a_isCenter) {
            x = GameCanvas.WIDTH >> 1;
            iAnchor = 5;
        }
        int y = 0;
        for (int i = iStart; i < iNumOnscreen; ++i) {
            y = a_iY + i % iNumOnscreen * iFontHeight;
            GraphicFont.drawText(a_iFontId, _TextsStr, wrap_iIndex, wrap_arrBreaks[i], wrap_arrBreaks[i + 1], x, y, iAnchor);
        }
    }

    public static final Image getImage(String a_sName) {
        try {
            return Image.createImage((String)a_sName);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static final DataInputStream getFile(String a_sName) {
        return new DataInputStream(((Object)((Object)Chicktris.instance)).getClass().getResourceAsStream(a_sName));
    }

    public static final byte[] readByteArray(DataInputStream a_dis, int a_iSize) throws Exception {
        byte[] result = new byte[a_iSize];
        a_dis.read(result);
        return result;
    }

    public static final short[] readByteArrayAsShort(DataInputStream a_dis, int a_iSize) throws Exception {
        short[] result = new short[a_iSize];
        for (int i = 0; i < a_iSize; ++i) {
            result[i] = (short)a_dis.readUnsignedByte();
        }
        return result;
    }

    public static final short[] readShortArray(DataInputStream a_dis, int a_iSize) throws Exception {
        short[] result = new short[a_iSize];
        for (int i = 0; i < a_iSize; ++i) {
            result[i] = a_dis.readShort();
        }
        return result;
    }

    public static final boolean[] readBoolArray(DataInputStream a_dis, int a_iSize) throws Exception {
        boolean[] result = new boolean[a_iSize];
        for (int i = 0; i < a_iSize; ++i) {
            result[i] = a_dis.readBoolean();
        }
        return result;
    }

    static {
        __anchorShift = new int[]{31, 1, 0};
        wrap_arrBreaks = new int[100];
        wrap_arrPicLine = new int[10];
        wrap_Number = 0;
        wrap_Code = 0;
        _FontX = new short[4][];
        _FontY = new short[4][];
        _FontW = new byte[4][];
        _FontH = new byte[4];
        _FontSpace = new byte[4];
        _FontInterChar = new byte[4];
        _FontImage = new Image[4];
    }
}

