/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

class Menu {
    private static final byte STATE_SETTINGS = 12;
    private static final byte STATE_HI_SCORES = 13;
    private static final byte STATE_HELP = 14;
    private static final byte STATE_ABOUT = 15;
    private static final byte STATE_CHOICE_LEVEL = 16;
    private static final byte STATE_CONFIRM_EXIT = 17;
    private static final byte STATE_MAIN_MENU = 18;
    private static final byte STATE_CONFIRM_RESET = 19;
    private static final byte STATE_CONFIRM_SOUND = 20;
    private static final byte STATE_SELECT_LANG = 21;
    private static final byte STATE_NAME = 22;
    private static final byte INTRO_LOGO2 = 1;
    private static final byte INTRO_SPLASH = 2;
    public static SoundPlayer themeSound = null;
    private boolean isPlayingSound;
    private static byte menuState = (byte)20;
    private boolean isAfterGameHS;
    public static boolean isIntroShown;
    public static byte introState;
    private int linesOnScreen;
    private static int currentSelection;
    private int currentHiScoresPage;
    private static int counter;
    private static int logoColor;
    private boolean hasContinue;
    private int shiftNum;
    private int maxShift;
    private int shiftLevel;
    private Image imageBackground;
    private Image imagePointer;
    private Image imageSplash;
    private boolean bWrapText;
    private Image arrowUp;
    private Image arrowDown;
    private Image logo_small;
    private boolean isArrowUp;
    private boolean isArrowDown;
    private static boolean _isLoadSet;
    private static int runningCounter;
    private static int runningDirection;
    private static String runningString;
    private static int lastSelection;

    public Menu() {
        currentSelection = 0;
        this.hasContinue = Settings.isGameHasContinue;
        if (menuState != 20) {
            menuState = (byte)18;
        }
        themeSound = new SoundPlayer("/sound/theme.mid");
        this.isPlayingSound = false;
        this.currentHiScoresPage = 0;
        this.isAfterGameHS = false;
        try {
            Skin.loadImages();
            this.imageBackground = Skin.createSkin((byte)0, GameCanvas.WIDTH, GameCanvas.HEIGHT);
            if (!isIntroShown) {
                this.imageSplash = Image.createImage((String)"/skin/logo_mm.png");
            }
            this.imagePointer = Image.createImage((String)"/skin/pl.png");
            this.arrowUp = Image.createImage((String)"/skin/arrow_up.png");
            this.arrowDown = Image.createImage((String)"/skin/arrow_down.png");
            this.logo_small = Image.createImage((String)"/skin/Logo_mm_small.png");
            logoColor = 0;
            introState = 1;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setIsLoadSet(boolean aIsLoadSet) {
        _isLoadSet = aIsLoadSet;
    }

    public static boolean getIsLoadSet() {
        return _isLoadSet;
    }

    public void setHiScoresState() {
        this.currentHiScoresPage = Settings.optionsGameType;
        this.isAfterGameHS = true;
        menuState = (byte)13;
    }

    public void setNameState() {
        menuState = (byte)22;
    }

    public void process() {
        ++counter;
    }

    public void draw(Graphics g) {
        if (!isIntroShown) {
            this.showIntro(g);
            return;
        }
        g.drawImage(this.imageBackground, 0, 0, 20);
        switch (menuState) {
            case 21: {
                this.showLangSelect(g);
                break;
            }
            case 20: {
                this.showConfirmSound(g);
                break;
            }
            case 12: 
            case 16: 
            case 18: {
                this.showMainMenu(g);
                break;
            }
            case 13: {
                this.showHiScores(g);
                break;
            }
            case 14: 
            case 15: {
                this.showHelp(g);
                break;
            }
            case 19: {
                this.showConfirmReset(g);
                break;
            }
            case 17: {
                this.showConfirmExit(g);
            }
        }
    }

    private void showLangSelect(Graphics g) {
        int dy = (Skin.panelBottomY - Skin.panelTopY) / (GraphicFont.LANGUAGE_COUNT * GraphicFont.textHeight(2)) * (GraphicFont.LANGUAGE_COUNT * 2);
        int y = Skin.panelTopY + (Skin.panelBottomY - Skin.panelTopY - dy * GraphicFont.LANGUAGE_COUNT) / 2;
        int rightSoftkey = 0;
        int leftSoftkey = 2;
        for (int i = 0; i < GraphicFont.LANGUAGE_COUNT; ++i) {
            if (currentSelection == i) {
                g.drawImage(this.imagePointer, GameCanvas.WIDTH / 2, y + dy * i, 17);
            }
            int cur = i + 3;
            this.drawCurrentString(GraphicFont._TextsStr, cur, y + dy * i - 3, true);
        }
        GameCanvas.drawSoftkeys(leftSoftkey, rightSoftkey);
    }

    private void showConfirmSound(Graphics g) {
        GraphicFont.prepareWrapText(28, 1, Skin.panelFieldW);
        GraphicFont.drawWrapedText(GameCanvas.WIDTH / 2, GameCanvas.HEIGHT / 2, false, 2, 0);
        GameCanvas.drawSoftkeys(19, 20);
        g.setColor(0xFFFFFF);
    }

    private void showIntro(Graphics g) {
        g.setColor(logoColor);
        g.fillRect(0, 0, GameCanvas.WIDTH, GameCanvas.HEIGHT);
        try {
            g.drawImage(this.imageSplash, GameCanvas.WIDTH >> 1, GameCanvas.HEIGHT >> 1, 3);
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (counter >= 20) {
            switch (introState) {
                case 1: {
                    counter = 0;
                    logoColor = 0;
                    try {
                        this.imageSplash = Image.createImage((String)"/skin/splash.png");
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    introState = (byte)2;
                    break;
                }
                case 2: {
                    isIntroShown = true;
                    this.imageSplash = null;
                    menuState = !_isLoadSet ? (byte)21 : (byte)20;
                    System.gc();
                }
            }
        }
    }

    private void showMainMenu(Graphics g) {
        if (!this.isPlayingSound) {
            this.soundPlay(themeSound);
            this.isPlayingSound = true;
        }
        int dy = 10 + (Skin.panelBottomY - Skin.panelTopY) / (5 * GraphicFont.textHeight(2)) * 10;
        int y = Skin.panelTopY + (Skin.panelBottomY - Skin.panelTopY - dy * 5) / 2 - 3;
        int rightSoftkey = 0;
        int leftSoftkey = 0;
        switch (menuState) {
            case 18: {
                for (int i = 0; i < 5 + (this.hasContinue ? 1 : 0); ++i) {
                    int str = this.currentString(i);
                    if (currentSelection == i) {
                        g.drawImage(this.imagePointer, GameCanvas.WIDTH / 2, y + 3 + dy * i, 17);
                    }
                    this.drawCurrentString(GraphicFont._TextsStr, str, y + dy * i, true);
                }
                leftSoftkey = 13;
                rightSoftkey = 12;
                break;
            }
            case 16: {
                GraphicFont.drawText(2, GameCanvas.WIDTH / 2, Skin.panelTopY + GraphicFont.textHeight(1), 5);
                int visibleLevel = Settings.getMaxLevel() < 5 ? Settings.getMaxLevel() : 5;
                y = Skin.panelTopY + (Skin.panelBottomY - Skin.panelTopY - dy * 5) / 2 - 2;
                dy = 2 * (Skin.panelBottomY - Skin.panelTopY) / GraphicFont.textHeight(2);
                y += dy;
                for (int i = this.shiftLevel; i < visibleLevel + this.shiftLevel; ++i) {
                    int str = this.currentString(i);
                    if (i == currentSelection) {
                        g.drawImage(this.imagePointer, GameCanvas.WIDTH / 2, y + dy * (currentSelection - this.shiftLevel), 17);
                    }
                    this.drawCurrentString(GraphicFont._TextsStr, str, y + -4 + dy * (i - this.shiftLevel), true);
                    int numY = y + dy * (i - this.shiftLevel) + 0;
                    GraphicFont.drawNumber(2, i + 1, (GameCanvas.WIDTH >> 1) + GraphicFont.textWidthTotal(2, str), numY += GraphicFont.textHeight(2) >> 1, 5);
                }
                this.drawScroll(g, Settings.getMaxLevel() - 1, currentSelection);
                leftSoftkey = 13;
                rightSoftkey = 14;
                break;
            }
            case 12: {
                dy = 10 + (Skin.panelBottomY - Skin.panelTopY) / (2 * GraphicFont.textHeight(2)) * 4;
                GraphicFont.drawText(7, GameCanvas.WIDTH / 2, Skin.panelTopY + GraphicFont.textHeight(1), 5);
                y += dy;
                for (int i = 0; i < 2; ++i) {
                    int str = this.currentString(i);
                    if (currentSelection == i) {
                        g.drawImage(this.imagePointer, GameCanvas.WIDTH / 2, y + 3 + dy * i, 17);
                    }
                    this.drawCurrentString(GraphicFont._TextsStr, str, y + dy * i, false);
                    int iX = 0;
                    int iY = y + dy * i;
                    int iSwitcher = 0;
                    if (str == 39) {
                        iSwitcher = Settings.optionsSoundOn ? 22 : 23;
                        iX = GameCanvas.WIDTH - ((GameCanvas.WIDTH - this.imagePointer.getWidth() >> 1) + 3) - GraphicFont.textWidthTotal(2, iSwitcher) + (GraphicFont.textWidthTotal(2, iSwitcher) >> 1);
                        GraphicFont.drawText(2, GraphicFont._TextsStr, iSwitcher, iX, iY += (GraphicFont.textHeight(2) >> 1) + 4, 5);
                        continue;
                    }
                    if (str != 40) continue;
                    iSwitcher = GraphicFont.currentLanguage;
                    iX = GameCanvas.WIDTH - ((GameCanvas.WIDTH - this.imagePointer.getWidth() >> 1) + 3) - GraphicFont.textWidthTotal(2, iSwitcher) + (GraphicFont.textWidthTotal(2, iSwitcher) >> 1);
                    String[] s = new String[]{GraphicFont.shortLang[iSwitcher]};
                    GraphicFont.drawText(2, s, 0, iX, iY += (GraphicFont.textHeight(2) >> 1) + 4, 6);
                }
                leftSoftkey = 21;
                rightSoftkey = 18;
            }
        }
        GameCanvas.drawSoftkeys(leftSoftkey, rightSoftkey);
    }

    private void showHiScores(Graphics g) {
        GraphicFont.drawText(6, GameCanvas.WIDTH / 2, Skin.panelTopY + GraphicFont.textHeight(1), 5);
        int dy = 4 + (Skin.panelBottomY - Skin.panelTopY) / (5 * GraphicFont.textHeight(2)) * 10;
        int y = Skin.panelTopY + dy + 12;
        int res = 0;
        for (int i = 0; i < 5; ++i) {
            res = i + 1;
            GraphicFont.drawNumber(1, res, 22, y, 0);
            if (Settings.playerNames[this.currentHiScoresPage][i] != 0) {
                res = Settings.playerNames[this.currentHiScoresPage][i];
                GraphicFont.drawNumber(1, res, 42, y, 0);
            }
            res = Settings.scores[this.currentHiScoresPage][i];
            GraphicFont.drawNumber(1, res, GameCanvas.WIDTH - 10 - 12, y, 2);
            y += dy;
        }
        res = 9;
        GraphicFont.drawText(1, res, 22, y, 0);
        res = Settings.lastGame[this.currentHiScoresPage];
        GraphicFont.drawNumber(1, res, GameCanvas.WIDTH - 10 - 12, y, 2);
        GameCanvas.drawSoftkeys(24, this.isAfterGameHS ? 15 : 14);
    }

    private void showHelp(Graphics g) {
        int yHead = Skin.panelTopY + GraphicFont.textHeight(2);
        int arrowY = Skin.panelTopY + GraphicFont.textHeight(2) + 13;
        int drawStr = menuState == 14 ? 8 : 5;
        GraphicFont.drawText(drawStr, GameCanvas.WIDTH / 2, yHead, 5);
        int pos = arrowY - this.shiftNum * GraphicFont.textHeight(1) + 3;
        g.setClip(0, yHead - 1, GameCanvas.WIDTH, GraphicFont.textHeight(1) * (this.linesOnScreen - 3) + 5);
        if (menuState == 14) {
            GraphicFont.prepareWrapText(10, 1, GameCanvas.WIDTH - 6);
        } else {
            GraphicFont.prepareWrapText(11, 1, GameCanvas.WIDTH - 6);
            pos += this.logo_small.getHeight() + 6;
        }
        GraphicFont.drawWrapedText(GameCanvas.WIDTH / 2 + 3, pos, false, 1, this.shiftNum);
        if (menuState == 15) {
            g.drawImage(this.logo_small, GameCanvas.WIDTH / 2, arrowY + this.arrowUp.getHeight(), 17);
        }
        this.maxShift = GraphicFont.iNumItems - GraphicFont.getNumFitting(arrowY, GameCanvas.HEIGHT - 25, GraphicFont.textHeight(1));
        this.drawScroll(g, this.maxShift, this.shiftNum);
        GameCanvas.drawSoftkeys(0, 14);
    }

    private void drawScroll(Graphics g, int maxShift, int shiftNum) {
        if (maxShift > 0) {
            if (shiftNum == 0) {
                this.isArrowDown = true;
                this.isArrowUp = false;
            } else if (shiftNum < maxShift & shiftNum != maxShift) {
                this.isArrowDown = true;
                this.isArrowUp = true;
            } else {
                this.isArrowDown = false;
                this.isArrowUp = true;
            }
        }
        if (this.isArrowUp) {
            g.drawImage(this.arrowUp, GameCanvas.WIDTH / 2, Skin.panelTopY + GraphicFont.textHeight(2) + 13, 3);
        }
        if (this.isArrowDown) {
            g.drawImage(this.arrowDown, GameCanvas.WIDTH / 2, GameCanvas.HEIGHT - 25, 3);
        }
    }

    private void showConfirmExit(Graphics g) {
        if (this.bWrapText) {
            GraphicFont.prepareWrapText(37, 2, Skin.panelFieldW);
            this.bWrapText = false;
        }
        GraphicFont.drawWrapedText(GameCanvas.WIDTH / 2, GameCanvas.HEIGHT / 2, true, 2, 0);
        GameCanvas.drawSoftkeys(19, 20);
    }

    private void showConfirmReset(Graphics g) {
        if (this.bWrapText) {
            GraphicFont.prepareWrapText(36, 2, Skin.panelFieldW);
            this.bWrapText = false;
        }
        GraphicFont.drawWrapedText(GameCanvas.WIDTH / 2, GameCanvas.HEIGHT / 2, true, 2, 0);
        GameCanvas.drawSoftkeys(19, 20);
    }

    private int currentString(int index) {
        int str = 0;
        switch (menuState) {
            case 18: {
                switch (index + (this.hasContinue ? 0 : 1)) {
                    case 0: {
                        str = 3;
                        break;
                    }
                    case 1: {
                        str = 2;
                        break;
                    }
                    case 2: {
                        str = 7;
                        break;
                    }
                    case 4: {
                        str = 8;
                        break;
                    }
                    case 3: {
                        str = 6;
                        break;
                    }
                    case 5: {
                        str = 5;
                    }
                }
                break;
            }
            case 12: {
                switch (index) {
                    case 0: {
                        str = 39;
                        break;
                    }
                    case 1: {
                        str = 40;
                    }
                }
                break;
            }
            case 16: {
                str = 4;
            }
        }
        return str;
    }

    private void drawCurrentString(String[] a_Text, int a_TextId, int aY, boolean isCenter) {
        int anc = 5;
        int w = GraphicFont.textWidthTotal(2, a_Text, a_TextId, 0, a_Text[a_TextId].length());
        int x = GameCanvas.WIDTH >> 1;
        if (!isCenter) {
            x = (GameCanvas.WIDTH - this.imagePointer.getWidth() >> 1) + 5 + (w >> 1);
        }
        int l = 100;
        GraphicFont.drawText(2, a_TextId, x, aY += (GraphicFont.textHeight(2) >> 1) + 4, anc);
    }

    public static void drawRunningString(Graphics g, String string, int x, int y, int length, int anc, boolean needRun) {
        int stringWidth = g.getFont().stringWidth(string);
        g.setClip(x, 0, length, GameCanvas.HEIGHT);
        if (!needRun) {
            g.drawString(string, x, y, anc);
            g.setClip(0, 0, GameCanvas.WIDTH, GameCanvas.HEIGHT);
            return;
        }
        if (!runningString.equals(string)) {
            runningString = new String(string);
            if (currentSelection != lastSelection) {
                runningCounter = 0;
                runningDirection = 1;
            } else {
                runningCounter = stringWidth - length + 1;
                runningDirection = -1;
            }
        }
        lastSelection = currentSelection;
        runningCounter += runningDirection;
        if (runningDirection == 1) {
            if (stringWidth - runningCounter < length - 1) {
                runningDirection = -1;
            }
        } else if (runningCounter < 0) {
            runningDirection = 1;
        }
        g.drawString(string, x - runningCounter, y, anc);
        g.setClip(0, 0, GameCanvas.WIDTH, GameCanvas.HEIGHT);
    }

    public static void drawRunningString(int a_TextId, int a_X, int a_Y, int a_Length, int a_Anc, boolean a_NeedRun) {
        int stringWidth = GraphicFont.textWidthTotal(2, a_TextId);
        GraphicFont.grActive.setClip(a_X, 0, a_Length, GameCanvas.HEIGHT);
        if (!a_NeedRun) {
            GraphicFont.drawText(a_TextId, a_X, a_Y, a_Anc);
            GraphicFont.grActive.setClip(0, 0, GameCanvas.WIDTH, GameCanvas.HEIGHT);
            return;
        }
        lastSelection = currentSelection;
        runningCounter += runningDirection;
        if (runningDirection == 1) {
            if (stringWidth - runningCounter < a_Length - 1) {
                runningDirection = -1;
            }
        } else if (runningCounter < 0) {
            runningDirection = 1;
        }
        GraphicFont.grActive.setClip(0, 0, GameCanvas.WIDTH, GameCanvas.HEIGHT);
    }

    public int processKey(int keyCode, int gameAction, boolean isPressed) {
        if (keyCode == 42 && isPressed) {
            return 0;
        }
        if (!isPressed || !isIntroShown) {
            return 0;
        }
        switch (menuState) {
            case 18: {
                if (keyCode == -6 || keyCode == 53 || gameAction == 8) {
                    switch (currentSelection + (this.hasContinue ? 0 : 1)) {
                        case 0: {
                            themeSound.stopSound();
                            return 4;
                        }
                        case 1: {
                            this.shiftLevel = 0;
                            currentSelection = Settings.getMaxLevel() - 1;
                            if (currentSelection >= 5) {
                                this.shiftLevel = currentSelection - 5 + 1;
                            }
                            menuState = (byte)16;
                            break;
                        }
                        case 2: {
                            currentSelection = 0;
                            menuState = (byte)12;
                            break;
                        }
                        case 3: {
                            this.isAfterGameHS = false;
                            this.currentHiScoresPage = Settings.optionsGameType;
                            menuState = (byte)13;
                            break;
                        }
                        case 4: {
                            menuState = (byte)14;
                            break;
                        }
                        case 5: {
                            menuState = (byte)15;
                        }
                    }
                }
                if ((keyCode == 50 || gameAction == 1) && --currentSelection < 0) {
                    currentSelection = 4 + (this.hasContinue ? 1 : 0);
                }
                if ((keyCode == 56 || gameAction == 6) && ++currentSelection >= 5 + (this.hasContinue ? 1 : 0)) {
                    currentSelection = 0;
                }
                if (keyCode != -7) break;
                menuState = (byte)17;
                this.bWrapText = true;
                break;
            }
            case 16: {
                if (keyCode == -6 || keyCode == 53 || gameAction == 8) {
                    Settings.optionsGameLevel = currentSelection;
                    themeSound.stopSound();
                    return 3;
                }
                if ((keyCode == 50 || gameAction == 1) && --currentSelection < 0) {
                    currentSelection = Settings.getMaxLevel() - 1;
                }
                if ((keyCode == 56 || gameAction == 6) && ++currentSelection >= Settings.getMaxLevel()) {
                    currentSelection = 0;
                }
                if (keyCode == -7) {
                    currentSelection = this.hasContinue ? 1 : 0;
                    menuState = (byte)18;
                }
                if (Settings.getMaxLevel() <= 5) break;
                if (currentSelection < this.shiftLevel) {
                    this.shiftLevel = currentSelection;
                    break;
                }
                if (currentSelection < this.shiftLevel + 5) break;
                this.shiftLevel = currentSelection - 5 + 1;
                break;
            }
            case 12: {
                switch (currentSelection) {
                    case 0: {
                        if (keyCode != 52 && gameAction != 2 && keyCode != 54 && keyCode != -6 && keyCode != 53 && gameAction != 8 && gameAction != 5 || keyCode == -7) break;
                        if (!Settings.optionsSoundOn) {
                            if (!themeSound.isInit()) {
                                themeSound.initSound();
                            }
                            themeSound.playSound(5);
                        } else {
                            themeSound.stopSound();
                        }
                        Settings.optionsSoundOn = !Settings.optionsSoundOn;
                        break;
                    }
                    case 1: {
                        if (keyCode == 54 || keyCode == -6 || gameAction == 8 || gameAction == 5) {
                            if (GraphicFont.currentLanguage < GraphicFont.LANGUAGE_COUNT - 1) {
                                GraphicFont.currentLanguage = (byte)(GraphicFont.currentLanguage + 1);
                                Chicktris.setLanguage(GraphicFont.currentLanguage);
                            } else {
                                Chicktris.setLanguage(0);
                            }
                        }
                        if (keyCode != 52 && gameAction != 2) break;
                        if (GraphicFont.currentLanguage > 0) {
                            GraphicFont.currentLanguage = (byte)(GraphicFont.currentLanguage - 1);
                            Chicktris.setLanguage(GraphicFont.currentLanguage);
                            break;
                        }
                        Chicktris.setLanguage(GraphicFont.LANGUAGE_COUNT - 1);
                    }
                }
                if ((keyCode == 50 || gameAction == 1) && --currentSelection < 0) {
                    currentSelection = 1;
                }
                if ((keyCode == 56 || gameAction == 6) && ++currentSelection >= 2) {
                    currentSelection = 0;
                }
                if (keyCode != -7) break;
                currentSelection = this.hasContinue ? 2 : 1;
                GameCanvas.saveSettings();
                menuState = (byte)18;
                break;
            }
            case 13: {
                if (keyCode == 54 || gameAction == 5) {
                    ++this.currentHiScoresPage;
                    if (this.currentHiScoresPage >= 1) {
                        this.currentHiScoresPage = 0;
                    }
                }
                if (keyCode == 52 || gameAction == 2) {
                    --this.currentHiScoresPage;
                    if (this.currentHiScoresPage < 0) {
                        this.currentHiScoresPage = 0;
                    }
                }
                if (keyCode == -6) {
                    menuState = (byte)19;
                    this.bWrapText = true;
                }
                if (keyCode != -7) break;
                currentSelection = this.isAfterGameHS ? 0 : (this.hasContinue ? 3 : 2);
                menuState = (byte)18;
                break;
            }
            case 14: 
            case 15: {
                if (keyCode == -7) {
                    currentSelection = (this.hasContinue ? 4 : 3) + (menuState == 15 ? 1 : 0);
                    this.shiftNum = 0;
                    menuState = (byte)18;
                    this.isArrowDown = false;
                    this.isArrowUp = false;
                }
                if ((keyCode == 56 || gameAction == 6) && this.maxShift > 0 && this.shiftNum < this.maxShift) {
                    ++this.shiftNum;
                }
                if (keyCode != 50 && gameAction != 1 || this.shiftNum == 0) break;
                --this.shiftNum;
                break;
            }
            case 17: {
                if (keyCode == -6) {
                    if (Settings.optionsSoundOn) {
                        themeSound.stopSound();
                    }
                    return 5;
                }
                if (keyCode != -7) break;
                menuState = (byte)18;
                break;
            }
            case 19: {
                if (keyCode == -6) {
                    Settings.resetScores();
                    menuState = (byte)13;
                }
                if (keyCode != -7) break;
                menuState = (byte)13;
                break;
            }
            case 21: {
                if ((keyCode == 50 || gameAction == 1) && --currentSelection < 0) {
                    currentSelection = GraphicFont.LANGUAGE_COUNT - 1;
                }
                if ((keyCode == 56 || gameAction == 6) && ++currentSelection >= GraphicFont.LANGUAGE_COUNT) {
                    currentSelection = 0;
                }
                if (keyCode != -6 && keyCode != 53 && gameAction != 8) break;
                Chicktris.setLanguage(currentSelection);
                Settings.startSelectLanguage = false;
                menuState = (byte)20;
                break;
            }
            case 20: {
                if (keyCode == -6) {
                    Settings.optionsSoundOn = true;
                    themeSound.initSound();
                    menuState = (byte)18;
                }
                if (keyCode == -7) {
                    Settings.optionsSoundOn = false;
                    menuState = (byte)18;
                }
                GameCanvas.saveSettings();
            }
        }
        return 0;
    }

    public void pause() {
    }

    public void resume() {
    }

    private void soundPlay(SoundPlayer soundPlayer) {
        if (Settings.optionsSoundOn) {
            if (!soundPlayer.isInit()) {
                soundPlayer.initSound();
            }
            soundPlayer.playSound(5);
        }
    }

    static {
        runningCounter = 0;
        runningDirection = 1;
        runningString = "";
        lastSelection = -1;
    }
}

