/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Random;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class World {
    private int counter;
    private int fadeCounter;
    private Field field;
    private Figure figure;
    private byte nextFigureKind;
    private Random generate;
    private Image background;
    private Image preview;
    private boolean gameOver;
    private boolean pause;
    private byte movement;
    private int lineNum;
    public int allScores;
    public int gameLevel;
    private int gameSpeed;
    private boolean gameComplete;
    private boolean levelComplete;
    private boolean rowFade;
    private boolean lock;
    private int curLang;
    private static SoundPlayer rotateSound = null;
    private static SoundPlayer fadeSound = null;
    private static SoundPlayer fallSound = null;
    Image scoreIm;
    Image levelIm;

    public void load(DataInputStream dis) {
        try {
            int j;
            int i;
            for (i = 0; i < 12; ++i) {
                for (j = 0; j < 15; ++j) {
                    this.field.gameField[i][j] = dis.readBoolean();
                }
            }
            for (i = 0; i < 12; ++i) {
                for (j = 0; j < 15; ++j) {
                    this.field.imageField[i][j] = dis.readByte();
                }
            }
            for (i = 0; i < 12; ++i) {
                for (j = 0; j < 15; ++j) {
                    this.field.kindImageField[i][j] = dis.readByte();
                }
            }
            this.figure.currLogX = dis.readByte();
            this.figure.currLogY = dis.readByte();
            this.figure.pos = dis.readByte();
            this.figure.kind = dis.readByte();
            this.nextFigureKind = dis.readByte();
            this.lineNum = dis.readInt();
            this.allScores = dis.readInt();
            this.gameLevel = dis.readInt();
            this.gameSpeed = dis.readInt();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void save(DataOutputStream dos) {
        try {
            int j;
            int i;
            for (i = 0; i < 12; ++i) {
                for (j = 0; j < 15; ++j) {
                    dos.writeBoolean(this.field.gameField[i][j]);
                }
            }
            for (i = 0; i < 12; ++i) {
                for (j = 0; j < 15; ++j) {
                    dos.writeByte(this.field.imageField[i][j]);
                }
            }
            for (i = 0; i < 12; ++i) {
                for (j = 0; j < 15; ++j) {
                    dos.writeByte(this.field.kindImageField[i][j]);
                }
            }
            dos.writeByte(this.figure.currLogX);
            dos.writeByte(this.figure.currLogY);
            dos.writeByte(this.figure.pos);
            dos.writeByte(this.figure.kind);
            dos.writeByte(this.nextFigureKind);
            dos.writeInt(this.lineNum);
            dos.writeInt(this.allScores);
            dos.writeInt(this.gameLevel);
            dos.writeInt(this.gameSpeed);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public World(int startLevel) {
        if (Settings.optionsSoundOn && fadeSound == null) {
            rotateSound = new SoundPlayer("/sound/rotate.mid");
            fallSound = new SoundPlayer("/sound/fall.mid");
            fadeSound = new SoundPlayer("/sound/clear_line.mid");
        }
        if (Settings.optionsSoundOn) {
            this.initSounds();
        }
        try {
            this.loadScoreImage();
            this.levelIm = Image.createImage((String)"/fonts/level.png");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.nextFigureKind = (byte)-1;
        this.gameLevel = startLevel;
        this.background = Settings.getBackground();
        this.generate = new Random();
        this.field = new Field();
        this.figure = new Figure();
        this.restart();
    }

    private void loadScoreImage() throws IOException {
        this.curLang = GraphicFont.currentLanguage;
        String suf = GraphicFont.shortLang[this.curLang].substring(0, 2);
        this.scoreIm = Image.createImage((String)("/fonts/" + suf + "_score.png"));
    }

    private void soundPlay(SoundPlayer soundPlayer) {
        if (Settings.optionsSoundOn) {
            soundPlayer.initSound();
            soundPlayer.playSound(1);
        }
    }

    public boolean isGameOver() {
        return this.gameOver;
    }

    public boolean isGameComplite() {
        return this.gameComplete;
    }

    public boolean isLevelComplite() {
        return this.levelComplete;
    }

    public void restart() {
        if (this.gameLevel + 1 > 10) {
            this.gameComplete = true;
        } else {
            this.levelComplete = false;
            this.gameSpeed = PortingConst.GAME_SPEED[++this.gameLevel - 1];
            this.preview = Settings.getPreview(this.gameLevel);
            this.field.clearFields();
            this.lineNum = 0;
            this.figure.addNew((byte)this.generateFigure());
            if (this.allScores == 0) {
                this.allScores = 500 * (this.gameLevel - 1);
            }
        }
    }

    public void draw(Graphics g) {
        g.drawImage(this.background, 0, 0, 20);
        if (!this.levelComplete) {
            this.figure.showFigurePicture(g, this.nextFigureKind, PortingConst.SHOW_NEXT_POS[this.nextFigureKind], Skin.gameNextFigureX + PortingConst.SHOW_NEXT_X[this.nextFigureKind], Skin.gameNextFigureY + PortingConst.SHOW_NEXT_Y[this.nextFigureKind]);
            if (!this.rowFade) {
                this.field.draw(g);
                if (!this.lock) {
                    this.figure.draw(g);
                }
            } else {
                this.field.draw(g, this.fadeCounter);
            }
        }
        g.setColor(0);
        g.setFont(PortingConst.LABEL_FONT);
        int curScore = this.allScores - PortingConst.LEVELS_SCORES[this.gameLevel - 1];
        int curHeight = curScore * this.preview.getHeight() / 500;
        g.setClip(Skin.gameImageReviewX, Skin.gameImageReviewY + 2, this.preview.getWidth() + 3, curHeight);
        g.drawImage(this.preview, Skin.gameImageReviewX + Skin.gameImageReviewW / 2, Skin.gameImageReviewY + Skin.gameImageReviewH / 2, 3);
        g.setClip(0, 0, GameCanvas.WIDTH, GameCanvas.HEIGHT);
        GraphicFont.drawNumber(this.allScores, Skin.gameScoreX, Skin.gameScoreY + GraphicFont.textHeight(3) - 3, 5);
        g.drawImage(this.scoreIm, Skin.gameScoreX, Skin.gameScoreY + (Skin.gameScoreH - GraphicFont.textHeight(3)) + 10, 1 | 0x20);
        GraphicFont.drawNumber(this.gameLevel, Skin.gameLinesX, Skin.gameLinesY + GraphicFont.textHeight(3) - 3, 5);
        g.drawImage(this.levelIm, Skin.gameScoreX, Skin.gameScoreY + (Skin.gameScoreH - GraphicFont.textHeight(3)) + 10 + 35, 1 | 0x20);
    }

    public void process() {
        ++this.counter;
        if (this.pause || this.levelComplete || this.gameOver || this.gameComplete) {
            return;
        }
        if (this.rowFade) {
            if (--this.fadeCounter == 0) {
                this.allScores += PortingConst.LEVELS_SCORE[this.gameLevel - 1] * this.field.rowFadeNum * PortingConst.LINES_KOEF[this.field.rowFadeNum - 1] / 10;
                this.lineNum += this.field.rowFadeNum;
                this.field.replaceFields();
                this.rowFade = false;
            } else {
                return;
            }
        }
        if (this.counter % this.gameSpeed == 0) {
            if (this.field.isDownMove(this.figure)) {
                this.figure.currLogY = (byte)(this.figure.currLogY + 1);
            } else {
                if (!this.lock) {
                    this.field.setToLogicalField(this.figure);
                    this.field.setToColorField(this.figure);
                    this.soundPlay(fallSound);
                    if (this.field.isReplaceFields()) {
                        this.lock = true;
                        this.rowFade = true;
                        this.fadeCounter = 12;
                        this.soundPlay(fadeSound);
                        return;
                    }
                }
                if (this.allScores >= PortingConst.LEVELS_SCORES[this.gameLevel]) {
                    this.levelComplete = true;
                    return;
                }
                this.figure.addNew((byte)this.generateFigure());
                if (!this.field.isDownMove(this.figure)) {
                    this.figure.currLogY = (byte)this.field.downMove(this.figure);
                    this.gameOver = true;
                }
            }
        }
        if (this.counter % 1 == 0) {
            if (this.movement == -1 && this.field.isLeftMove(this.figure)) {
                this.figure.currLogX = (byte)(this.figure.currLogX - 1);
            }
            if (this.movement == 1 && this.field.isRightMove(this.figure)) {
                this.figure.currLogX = (byte)(this.figure.currLogX + 1);
            }
        }
    }

    private int generateFigure() {
        if (this.nextFigureKind == -1) {
            this.nextFigureKind = (byte)((this.generate.nextInt() >>> 1) % 7);
        }
        byte tmp = this.nextFigureKind;
        this.nextFigureKind = (byte)((this.generate.nextInt() >>> 1) % 7);
        this.lock = false;
        return tmp;
    }

    public static int xLToR(int logical) {
        return Skin.gameFieldX + 10 * logical;
    }

    public static int yLToR(int logical) {
        return Skin.gameFieldY + 10 * logical;
    }

    public void Up() {
        if (this.field.isRotate(this.figure)) {
            this.figure.rotate();
            this.soundPlay(rotateSound);
        }
    }

    public void Left(boolean isPress) {
        this.movement = (byte)(isPress ? -1 : 0);
    }

    public void Right(boolean isPress) {
        this.movement = (byte)(isPress ? 1 : 0);
    }

    public void Down() {
        this.figure.currLogY = (byte)this.field.downMove(this.figure);
    }

    public void pause() {
        this.pause = true;
    }

    public void resume() {
        if (Settings.optionsSoundOn) {
            this.initSounds();
        }
        this.pause = false;
        if (this.curLang != GraphicFont.currentLanguage) {
            try {
                this.loadScoreImage();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void initSounds() {
        fallSound.initSound();
        rotateSound.initSound();
        fadeSound.initSound();
    }
}

