/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

class Settings {
    private static final int OPTIONS_POS_NUM = 5;
    public static final int GAME_LEVELS_NUM = 10;
    public static final int GAME_TYPES_NUM = 1;
    public static final int LANGUAGES_NUM = 1;
    public static final int HI_SCORES_POS_NUM = 5;
    public static final byte BLOCK_SIZE_NORMAL = 0;
    public static final byte BLOCK_SIZE_SMALL = 1;
    public static int[][] scores = new int[1][5];
    public static int[][] playerNames = new int[1][5];
    public static int[] lastGame = new int[1];
    public static final int PLAYERNAME_LENGTH = 0;
    private static char[] lastPlayerName = new char[0];
    public static int[] maxLevelAvailable = new int[1];
    public static int optionsGameLevel = 0;
    public static int optionsGameType = 0;
    public static int optionsLanguage = 0;
    public static boolean optionsMusicOn = true;
    public static boolean optionsSoundOn = true;
    public static boolean isGameHasContinue = false;
    public static int currentGameType = 0;
    public static int currentGameLevel = 1;
    private static final int checkSumSettings = 6;
    private static final int checkSumScores = 14;
    public static boolean startSelectLanguage = true;

    public static byte[] getGameParameters() {
        byte[] parameters = new byte[2];
        currentGameType = optionsGameType;
        currentGameLevel = optionsGameLevel;
        parameters[0] = (byte)currentGameType;
        parameters[1] = (byte)currentGameLevel;
        return parameters;
    }

    public static void save(DataOutputStream dos) throws Exception {
        int i;
        dos.writeInt(20);
        dos.writeByte((byte)optionsGameType);
        dos.writeByte((byte)optionsGameLevel);
        dos.writeByte(optionsLanguage);
        dos.writeBoolean(optionsMusicOn);
        dos.writeBoolean(optionsSoundOn);
        dos.writeBoolean(startSelectLanguage);
        dos.writeBoolean(isGameHasContinue);
        char[] playerName = new char[]{};
        for (i = 0; i < 1; ++i) {
            for (int j = 0; j < 5; ++j) {
                dos.writeShort((short)scores[i][j]);
                for (int k = 0; k < 0; ++k) {
                    dos.writeChar(playerName[k]);
                }
            }
            dos.writeShort((short)lastGame[i]);
            dos.writeShort((short)maxLevelAvailable[i]);
        }
        for (i = 0; i < 0; ++i) {
            dos.writeChar(lastPlayerName[i]);
        }
    }

    public static void load(DataInputStream dis) throws Exception {
        int i;
        if (dis.readInt() != 20) {
            throw new Exception("Exception : Menu.load(). CheckSum not correct");
        }
        optionsGameType = dis.readByte();
        optionsGameLevel = dis.readByte();
        optionsLanguage = dis.readByte();
        Chicktris.setLanguage(optionsLanguage);
        Menu.setIsLoadSet(true);
        optionsMusicOn = dis.readBoolean();
        optionsSoundOn = dis.readBoolean();
        startSelectLanguage = dis.readBoolean();
        isGameHasContinue = dis.readBoolean();
        for (i = 0; i < 1; ++i) {
            for (int j = 0; j < 5; ++j) {
                Settings.scores[i][j] = dis.readShort();
            }
            Settings.lastGame[i] = dis.readShort();
            Settings.maxLevelAvailable[i] = dis.readShort();
        }
        for (i = 0; i < 0; ++i) {
            Settings.lastPlayerName[i] = dis.readChar();
        }
    }

    public static void resetSettings() {
        optionsGameType = 0;
        optionsGameLevel = 0;
        optionsLanguage = 0;
        optionsMusicOn = true;
        optionsSoundOn = true;
        isGameHasContinue = false;
        optionsLanguage = 0;
        Settings.resetScores();
    }

    public static int getMaxLevel() {
        return maxLevelAvailable[optionsGameType];
    }

    public static void setMaxLevel(int maxLevel) {
        if (maxLevelAvailable[optionsGameType] < maxLevel && maxLevel <= 10) {
            Settings.maxLevelAvailable[Settings.optionsGameType] = maxLevel;
        }
    }

    public static void changeLanguage() {
        Chicktris.setLanguage(optionsLanguage);
    }

    public static char[] getLastPlayerName() {
        return lastPlayerName;
    }

    public static boolean canBeAdded(int score, int gameType) {
        return score > scores[gameType][4];
    }

    public static void resetScores() {
        for (int i = 0; i < 1; ++i) {
            for (int j = 0; j < 5; ++j) {
                Settings.scores[i][j] = 0;
            }
            Settings.lastGame[i] = 0;
            Settings.maxLevelAvailable[i] = 1;
        }
        try {
            Settings.lastPlayerName[0] = 80;
            Settings.lastPlayerName[1] = 76;
            Settings.lastPlayerName[2] = 65;
            Settings.lastPlayerName[3] = 89;
            Settings.lastPlayerName[4] = 69;
            Settings.lastPlayerName[5] = 82;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void addScore(int score, int gameType) {
        isGameHasContinue = false;
        Settings.lastGame[gameType] = score;
        if (score > scores[gameType][4]) {
            for (int i = 0; i < 5; ++i) {
                if (score <= scores[gameType][i]) continue;
                int tmp = scores[gameType][i];
                Settings.scores[gameType][i] = score;
                score = tmp;
            }
        }
        GameCanvas.saveSettings();
    }

    public static void addScore(int playerName, int score, int gameType) {
        isGameHasContinue = false;
        Settings.lastGame[gameType] = score;
        if (score > scores[gameType][4]) {
            for (int i = 0; i < 5; ++i) {
                if (score <= scores[gameType][i]) continue;
                int tmp = scores[gameType][i];
                Settings.scores[gameType][i] = score;
                score = tmp;
                int tmpString = playerNames[gameType][i];
                Settings.playerNames[gameType][i] = playerName;
                playerName = tmpString;
            }
        }
        GameCanvas.saveSettings();
    }

    public static void drawLoadingProgress(Graphics g, int loadingPercent) {
        int l = loadingPercent * (GameCanvas.WIDTH / 2) / 100;
        int h = 10;
        int dy = 10;
        g.setColor(0);
        g.fillRect(0, 0, GameCanvas.WIDTH, GameCanvas.HEIGHT);
        g.setColor(4, 7, 255);
        g.drawRect(GameCanvas.WIDTH / 4, GameCanvas.HEIGHT / 2 - dy + h, GameCanvas.WIDTH / 2, h);
        g.fillRect(GameCanvas.WIDTH / 4, GameCanvas.HEIGHT / 2 - dy + h, l, h);
        GameCanvas.drawSoftkeys(0, 0);
    }

    public static void representSoftkeys(Graphics g, String softkey1, String softkey2) {
        int dx = 3;
        int dy = 1;
        Font font = Font.getFont((int)0, (int)1, (int)8);
        g.setFont(font);
        g.setColor(0);
        g.drawString(softkey1, dx, GameCanvas.HEIGHT - dy, 8);
        g.drawString(softkey2, GameCanvas.WIDTH - dx, GameCanvas.HEIGHT - dy, 10);
    }

    public static void representSoftkeys(int softkey1, int softkey2) {
        int dx = 3;
        int dy = 1;
        GraphicFont.drawText(softkey1, dx, GameCanvas.HEIGHT - dy, 8);
        GraphicFont.drawText(softkey2, GameCanvas.WIDTH - dx, GameCanvas.HEIGHT - dy, 10);
    }

    public static boolean cheatProcess(byte cheatCode) {
        return false;
    }

    private static final Image getImageRegion(Image source, int x, int y, int width, int heigth) {
        Image result = Image.createImage((int)width, (int)heigth);
        try {
            if (x + width > source.getWidth() || y + heigth > source.getHeight()) {
                System.out.println("Size source image...Warning");
                throw new Exception();
            }
            result.getGraphics().drawImage(source, -x, -y, 20);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private static final Image[] extractFrames(Image srcImage, int srcX, int srcY, int frmWide, int frmHigh, int frmWidth, int frmHeight) {
        Image[] result = new Image[frmWide * frmHigh];
        int frameCount = 0;
        try {
            for (int j = 0; j < frmHigh; ++j) {
                for (int i = 0; i < frmWide; ++i) {
                    result[frameCount++] = Settings.getImageRegion(srcImage, srcX + i * frmWidth, srcY + j * frmHeight, frmWidth, frmHeight);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static Image[][] getBlockImages(int a_iBlockSize) {
        Image[][] result = new Image[5][];
        String sImage = "/skin/btn.png";
        int iBlockSize = 10;
        if (a_iBlockSize == 1) {
            sImage = "/skin/btn2.png";
            iBlockSize = 7;
        }
        try {
            Image src = Image.createImage((String)sImage);
            for (int ii = 0; ii < 5; ++ii) {
                result[ii] = Settings.extractFrames(src, 0, iBlockSize * ii, 4, 1, iBlockSize, iBlockSize);
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return result;
    }

    public static Image getBackground() {
        Image result = null;
        Skin.loadImages();
        result = Skin.createSkin((byte)1, GameCanvas.WIDTH, GameCanvas.HEIGHT);
        return result;
    }

    public static Image getFadeBlocks() {
        Image result = null;
        try {
            result = Image.createImage((String)"/skin/btn_g.png");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static Image getPreview(int level) {
        Image result = null;
        try {
            result = Image.createImage((String)("/picture/girl_p" + level + ".png"));
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return result;
    }
}

