/*
 * Decompiled with CFR 0.152.
 */
package sudoku;

import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import sudoku.SuDokuCanvas;
import sudoku.SuDokuData;

public class SuDokuMain {
    private int _$407 = 0;
    public static Image Background = null;
    public static Image Foreground = null;
    public static Image Sprites = null;
    public static int[] MapArray = null;
    public static int[] SolveArray = null;
    public static int Mx;
    public static int My;
    public static int MapPosX;
    public static int MapPosY;
    public static int TileX;
    public static int TileY;
    public static int Tile;
    public static boolean ErrorMessage01Flag;
    public static boolean NewLevelFlag;
    public static boolean GameOverFlag;
    public static boolean GameCompletedFlag;
    public static int BoardOriginX;
    public static int BoardOriginY;
    public static int CursorXPos;
    public static int CursorYPos;
    public static int CursorFrame;
    public static int a;
    public static int b;
    public static int c;
    public static int d;
    public static int e;
    public static int t;
    public static int x;
    public static int y;
    public static int z;

    public static void InitLevel() {
        SuDokuCanvas.SetTimes();
        if (SuDokuCanvas.GameState == 2) {
            SuDokuMain.LoadBackgroundAndForeground();
            SuDokuMain.SetupMap();
            ErrorMessage01Flag = false;
            BoardOriginX = 7;
            BoardOriginY = 7;
            CursorXPos = BoardOriginX + 72;
            CursorYPos = BoardOriginY + 72;
            GameCompletedFlag = false;
            SuDokuCanvas.PauseFlag = false;
            SuDokuCanvas.QuitFlag = false;
            SuDokuCanvas.QuitAgainFlag = false;
            SuDokuCanvas.MessageDelay = SuDokuCanvas.MessageTime;
            SuDokuCanvas.Solved = false;
            SuDokuCanvas.IncorrectFlag = false;
            SuDokuCanvas.PuzzleSolvedAndPlayerPressedKey = false;
            SuDokuCanvas.ShowTime = true;
            GameOverFlag = false;
        }
    }

    public static void LoadBackgroundAndForeground() {
        Background = null;
        try {
            Background = Image.createImage((String)"/Backdrop.png");
        }
        catch (IOException e) {
            System.out.println("Background Load Error!");
        }
        Foreground = null;
        try {
            Foreground = Image.createImage((String)"/Solved.png");
        }
        catch (IOException e) {
            System.out.println("Foreground Load Error!");
        }
    }

    public static void SetupMap() {
        switch (SuDokuCanvas.Level) {
            case 1: {
                MapArray = SuDokuData.Puzzle01;
                SolveArray = SuDokuData.Puzzle01Solved;
                break;
            }
            case 2: {
                MapArray = SuDokuData.Puzzle02;
                SolveArray = SuDokuData.Puzzle02Solved;
                break;
            }
            case 3: {
                MapArray = SuDokuData.Puzzle03;
                SolveArray = SuDokuData.Puzzle03Solved;
                break;
            }
            case 4: {
                MapArray = SuDokuData.Puzzle04;
                SolveArray = SuDokuData.Puzzle04Solved;
                break;
            }
            case 5: {
                MapArray = SuDokuData.Puzzle05;
                SolveArray = SuDokuData.Puzzle05Solved;
                break;
            }
            case 6: {
                MapArray = SuDokuData.Puzzle06;
                SolveArray = SuDokuData.Puzzle06Solved;
                break;
            }
            case 7: {
                MapArray = SuDokuData.Puzzle07;
                SolveArray = SuDokuData.Puzzle07Solved;
                break;
            }
            case 8: {
                MapArray = SuDokuData.Puzzle08;
                SolveArray = SuDokuData.Puzzle08Solved;
                break;
            }
            case 9: {
                MapArray = SuDokuData.Puzzle09;
                SolveArray = SuDokuData.Puzzle09Solved;
                break;
            }
            case 10: {
                MapArray = SuDokuData.Puzzle10;
                SolveArray = SuDokuData.Puzzle10Solved;
                break;
            }
            case 11: {
                MapArray = SuDokuData.Puzzle11;
                SolveArray = SuDokuData.Puzzle11Solved;
                break;
            }
            case 12: {
                MapArray = SuDokuData.Puzzle12;
                SolveArray = SuDokuData.Puzzle12Solved;
                break;
            }
            case 13: {
                MapArray = SuDokuData.Puzzle13;
                SolveArray = SuDokuData.Puzzle13Solved;
                break;
            }
            case 14: {
                MapArray = SuDokuData.Puzzle14;
                SolveArray = SuDokuData.Puzzle14Solved;
                break;
            }
            case 15: {
                MapArray = SuDokuData.Puzzle15;
                SolveArray = SuDokuData.Puzzle15Solved;
                break;
            }
            case 16: {
                MapArray = SuDokuData.Puzzle16;
                SolveArray = SuDokuData.Puzzle16Solved;
                break;
            }
            case 17: {
                MapArray = SuDokuData.Puzzle17;
                SolveArray = SuDokuData.Puzzle17Solved;
                break;
            }
            case 18: {
                MapArray = SuDokuData.Puzzle18;
                SolveArray = SuDokuData.Puzzle18Solved;
                break;
            }
            case 19: {
                MapArray = SuDokuData.Puzzle19;
                SolveArray = SuDokuData.Puzzle19Solved;
                break;
            }
            case 20: {
                MapArray = SuDokuData.Puzzle20;
                SolveArray = SuDokuData.Puzzle20Solved;
                break;
            }
            case 21: {
                MapArray = SuDokuData.Puzzle21;
                SolveArray = SuDokuData.Puzzle21Solved;
                break;
            }
            case 22: {
                MapArray = SuDokuData.Puzzle22;
                SolveArray = SuDokuData.Puzzle22Solved;
                break;
            }
            case 23: {
                MapArray = SuDokuData.Puzzle23;
                SolveArray = SuDokuData.Puzzle23Solved;
                break;
            }
            case 24: {
                MapArray = SuDokuData.Puzzle24;
                SolveArray = SuDokuData.Puzzle24Solved;
                break;
            }
            case 25: {
                MapArray = SuDokuData.Puzzle25;
                SolveArray = SuDokuData.Puzzle25Solved;
            }
        }
        int Mx = 0;
        while (Mx < 81) {
            SuDokuData.MapArray[Mx] = MapArray[Mx];
            ++Mx;
        }
        int Tile = 0;
        int Mx2 = 0;
        while (Mx2 < 81) {
            Tile = SolveArray[Mx2];
            if (SuDokuData.MapArray[Mx2] == 0) {
                switch (Tile) {
                    case 1: {
                        Tile = 10;
                        break;
                    }
                    case 2: {
                        Tile = 11;
                        break;
                    }
                    case 3: {
                        Tile = 12;
                        break;
                    }
                    case 4: {
                        Tile = 13;
                        break;
                    }
                    case 5: {
                        Tile = 14;
                        break;
                    }
                    case 6: {
                        Tile = 15;
                        break;
                    }
                    case 7: {
                        Tile = 16;
                        break;
                    }
                    case 8: {
                        Tile = 17;
                        break;
                    }
                    case 9: {
                        Tile = 18;
                    }
                }
                SuDokuData.SolveArray[Mx2] = Tile;
            } else {
                SuDokuData.SolveArray[Mx2] = Tile;
            }
            ++Mx2;
        }
    }

    public static void ScanBoard() {
        int TileCount = 0;
        int TilesCorrect = 0;
        int MapPosY = 0;
        while (MapPosY < 9) {
            int MapPosX = 0;
            while (MapPosX < 9) {
                if (SuDokuData.MapArray[MapPosY * 9 + MapPosX] == SuDokuData.SolveArray[MapPosY * 9 + MapPosX]) {
                    ++TilesCorrect;
                }
                if (SuDokuData.MapArray[MapPosY * 9 + MapPosX] > 0) {
                    ++TileCount;
                }
                ++MapPosX;
            }
            ++MapPosY;
        }
        if (TileCount == 81 && TilesCorrect == 81) {
            SuDokuCanvas.Solved = true;
            TileCount = 0;
            SuDokuCanvas.IncorrectFlag = false;
        } else if (TileCount == 81 && TilesCorrect != 81) {
            SuDokuCanvas.IncorrectFlag = true;
            SuDokuCanvas.MessageDelay = SuDokuCanvas.MessageTime;
        } else {
            SuDokuCanvas.IncorrectFlag = false;
        }
    }

    public void draw(Graphics g) {
        if (SuDokuCanvas.GameState == 2 && Sprites != null) {
            int MapPosY = 0;
            while (MapPosY < 9) {
                int MapPosX = 0;
                while (MapPosX < 9) {
                    if (SuDokuData.MapArray[MapPosY * 9 + MapPosX] != 0) {
                        this.DrawTile(g, MapPosX, MapPosY, SuDokuData.MapArray[MapPosY * 9 + MapPosX]);
                    }
                    ++MapPosX;
                }
                ++MapPosY;
            }
            g.setClip(CursorXPos, CursorYPos, 18, 18);
            g.drawImage(Sprites, CursorXPos - CursorFrame * 18, CursorYPos, 4 | 0x10);
            g.setClip(0, 0, 176, 220);
            if (SuDokuCanvas.Solved) {
                g.drawImage(Foreground, 0, 0, 4 | 0x10);
            }
        } else {
            ErrorMessage01Flag = true;
            g.setColor(0xFF0000);
            g.fillRect(0, 0, 176, 220);
        }
    }

    public void DrawTile(Graphics g, int TileX, int TileY, int Tile) {
        g.setClip(BoardOriginX + TileX * 18, BoardOriginY + TileY * 18, 18, BoardOriginY + 18);
        g.drawImage(Sprites, BoardOriginX + (TileX * 18 - Tile * 18), BoardOriginY + TileY * 18, 4 | 0x10);
    }

    public static void NextLevel() {
        if (++SuDokuCanvas.Level > 25) {
            SuDokuCanvas.Level = 25;
        } else {
            SuDokuMain.InitLevel();
            NewLevelFlag = true;
            SuDokuCanvas.MessageDelay = SuDokuCanvas.MessageTime;
        }
    }

    static {
        MapPosX = 0;
        MapPosY = 0;
        TileX = 0;
        TileY = 0;
        Tile = 0;
        ErrorMessage01Flag = false;
        NewLevelFlag = false;
        GameOverFlag = false;
        GameCompletedFlag = false;
        BoardOriginX = 0;
        BoardOriginY = 0;
        CursorXPos = 0;
        CursorYPos = 0;
        CursorFrame = 0;
        try {
            Sprites = Image.createImage((String)"/Sprites.png");
        }
        catch (IOException e) {
            System.out.println("Sprite Load Error!");
        }
    }
}

