/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Image;

public class GVInputPacket {
    public byte[] data;
    public int curPosition = 0;

    public GVInputPacket(byte[] data) {
        this.data = data;
    }

    public boolean nextBoolean() {
        return this.data[this.curPosition++] == 1;
    }

    public byte nextByte() {
        return this.data[this.curPosition++];
    }

    public short nextShort() {
        short b1 = this.data[this.curPosition++];
        short b2 = this.data[this.curPosition++];
        return (short)((b1 & 0xFF) << 0 | (b2 & 0xFF) << 8);
    }

    public int nextInt() {
        byte b1 = this.data[this.curPosition++];
        byte b2 = this.data[this.curPosition++];
        byte b3 = this.data[this.curPosition++];
        byte b4 = this.data[this.curPosition++];
        return (b1 & 0xFF) << 0 | (b2 & 0xFF) << 8 | (b3 & 0xFF) << 16 | (b4 & 0xFF) << 24;
    }

    public long nextLong() {
        long v1 = this.nextInt();
        long v2 = this.nextInt();
        return (v1 & 0xFFFFFFFFFFFFFFFFL) << 32 | v2 & 0xFFFFFFFFL;
    }

    public String nextString() {
        int len = this.nextInt();
        String str = null;
        try {
            str = new String(this.data, this.curPosition, len);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.curPosition += len;
        return str;
    }

    public String nextString(int len) {
        String str = null;
        try {
            str = new String(this.data, this.curPosition, len);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.curPosition += len;
        return str.trim();
    }

    public byte[] nextData(int size) {
        byte[] ret = new byte[size];
        System.arraycopy(this.data, this.curPosition, ret, 0, size);
        this.curPosition += size;
        return ret;
    }

    public Image nextImage() {
        short len = this.nextShort();
        Image img = Image.createImage((byte[])this.data, (int)this.curPosition, (int)len);
        this.curPosition += len;
        return img;
    }

    public Image nextImage(int len) {
        Image img = Image.createImage((byte[])this.data, (int)this.curPosition, (int)len);
        this.curPosition += len;
        return img;
    }

    public boolean readBoolean(int pos) {
        return this.data[pos] == 1;
    }

    public byte readByte(int pos) {
        return this.data[pos];
    }

    public short readShort(int pos) {
        byte s1 = this.data[pos];
        byte s2 = this.data[++pos];
        return (short)((s1 & 0xFF) << 0 | (s2 & 0xFF) << 8);
    }

    public int readInt(int pos) {
        byte ch1 = this.data[pos];
        byte ch2 = this.data[++pos];
        byte ch3 = this.data[++pos];
        byte ch4 = this.data[++pos];
        return (ch1 & 0xFF) << 0 | (ch2 & 0xFF) << 8 | (ch3 & 0xFF) << 16 | (ch4 & 0xFF) << 24;
    }

    public int readBigInt(int pos) {
        byte ch4 = this.data[pos];
        byte ch3 = this.data[++pos];
        byte ch2 = this.data[++pos];
        byte ch1 = this.data[++pos];
        return (ch1 & 0xFF) << 0 | (ch2 & 0xFF) << 8 | (ch3 & 0xFF) << 16 | (ch4 & 0xFF) << 24;
    }

    public long readLong(int pos) {
        long v1 = this.readInt(pos);
        long v2 = this.readInt(pos + 4);
        return v1 & 0xFFFFFFFFL | (v2 & 0xFFFFFFFFL) << 32;
    }

    public String readString(int pos, int len) {
        String str = null;
        try {
            str = new String(this.data, pos, len);
            System.out.println("str : " + str + ":" + len);
            for (int i = pos; i < pos + len; ++i) {
                System.out.print(this.data[i] + ".");
            }
            System.out.println();
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace();
        }
        return str.trim();
    }

    public void printPacket() {
        System.out.print("packet = ");
        for (int i = 0; i < this.data.length; ++i) {
            System.out.print("[" + i + "]" + this.data[i] + " ");
        }
    }
}

