/*
 * Decompiled with CFR 0.152.
 */
package bomba;

import bomba.AnimatedElements;
import bomba.Bomba;
import bomba.CanvasDisplayable;
import bomba.Clock;
import bomba.Config;
import bomba.GameScrollField;
import bomba.Level;
import bomba.Player;
import bomba.PlayerDisplay;
import de.tuttas.GameAPI.BlendRaster;
import de.tuttas.GameAPI.Menu;
import de.tuttas.GameAPI.MenuItem;
import de.tuttas.GameAPI.MenuListener;
import de.tuttas.GameAPI.RasterListener;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class GameDisplayable
extends CanvasDisplayable
implements MenuListener,
RasterListener {
    public static boolean repaint;
    private static final char INIT = '\u0001';
    public static final char PLAY = '\u0002';
    private static final char EXIT = '\u0003';
    private static final char MENU = '\u0004';
    private static final char NEXTLEVEL_FADE_IN = '\u0005';
    private static final char NEXTLEVEL_COUNTBONUS = '\u0006';
    private static final char NEXTLEVEL_COUNTBONUS_WAIT = '\u0007';
    private static final char NEXTLEVEL_CARD = '\b';
    private static final char NEXTLEVEL_CARD_WAIT = '\t';
    private static final char NEXTLEVEL_FADE_OUT = '\n';
    private static final char LOSTLIVE_FADE_IN = '\u000b';
    private static final char LOSTLIVE_CARD = '\f';
    private static final char LOSTLIVE_CARD_WAIT = '\r';
    private static final char LOSTLIVE_FADE_OUT = '\u000e';
    private static final char GAMEOVER = '\u000f';
    private static final char TELEPORT_FADE_IN = '\u0010';
    private static final char TELEPORT_FADE_OUT = '\u0011';
    public final Player player;
    private BlendRaster br;
    private Image bgImage;
    private final PlayerDisplay playerDisplay;
    private final Menu menu;
    private final MenuItem cont;
    private final MenuItem exit;
    private GameScrollField gsf;
    private Clock clock;
    private boolean fire;
    private int state;
    private int bombX;
    private int bombY;
    private int moveCount;
    private int score;
    private int lives;
    private int bonus;
    private int level;
    private int timeBonus;
    private int action;
    private boolean pressed;
    private int divX;
    private int divY;
    private int xMin;
    private int xMax;
    private int yMin;
    private int yMax;
    private int oldBombs;
    private int oldLives;

    public GameDisplayable(int level, int score, int lives) throws Exception {
        repaint = true;
        this.playerDisplay = new PlayerDisplay();
        this.gsf = new GameScrollField(this);
        Bomba.animated = new AnimatedElements();
        this.player = new Player(this);
        this.score = score;
        this.lives = lives;
        this.level = level;
        this.cont = new MenuItem("Continue", 0xFFFF00, 0x555555, 16);
        this.exit = new MenuItem("Exit", 0xFFFF00, 0x555555, 16);
        this.menu = Bomba.isSmallScreen() ? new Menu(12, 104) : new Menu(134);
        this.menu.add(this.cont);
        this.menu.add(this.exit);
        this.menu.setListener(this);
        this.newGame();
    }

    private void initGame() {
        try {
            this.bgImage = Image.createImage((String)"/bg.png");
            repaint = false;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void newGame() {
        if (repaint) {
            this.initGame();
        }
        this.state = 1;
        this.action = -1;
        this.pressed = false;
        this.fire = false;
        this.divX = 0;
        this.divY = 0;
        this.moveCount = 0;
        this.bonus = 0;
        this.oldBombs = 0;
        this.oldLives = 0;
        if (this.level > Level.BONUS.length) {
            this.level %= Level.BONUS.length;
        }
        this.gsf.reset(this.level);
        Bomba.level.setLevel(this.level - 1);
        this.player.reset();
        this.gsf.setPlayerPos(Bomba.level.getStartX(), Bomba.level.getStartY(), this.player);
        this.gsf.paint();
        this.xMin = 3;
        this.xMax = Bomba.level.getWidth() - this.xMin - 3;
        this.yMin = 3;
        this.yMax = Bomba.level.getHeight() - this.yMin - 3;
        this.clock = new Clock(Bomba.level.getTime());
        this.clock.start();
        this.menu.setVisible(false);
        this.playerDisplay.reset();
    }

    private void exitGame() {
        Bomba.storeGame(this.score, this.lives);
        GameDisplayable.sleep(2000L);
        Player.anim = null;
        this.gsf.actualLevel = null;
        this.gsf.gImage = null;
        this.gsf.image = null;
        this.playerDisplay.image = null;
        Bomba.animated.free();
        System.gc();
        Config.playTitleSound();
        Bomba.showMenu();
        this.stopThread();
        Bomba.gameDisplayable = null;
    }

    private void handleMenu(int keyCode) {
        switch (this.getGameAction(keyCode)) {
            case 1: 
            case 2: {
                this.menu.up();
                this.repaint();
                break;
            }
            case 5: 
            case 6: {
                this.menu.down();
                this.repaint();
                break;
            }
            case 8: {
                this.menu.select();
            }
        }
    }

    private void stop() {
        this.divX = 0;
        this.divY = 0;
        this.action = -1;
        this.player.setState(5);
        this.setPlayerAnimation(5);
        this.setPlayerDisplay(0);
    }

    private void checkField() {
        if (this.moveCount > 0) {
            return;
        }
        char tileID = this.gsf.getId(this.player.levelX, this.player.levelY);
        switch (tileID) {
            case 'o': {
                this.player.setState(6);
                if (this.setPlayerMovement(this.divX, this.divY)) {
                    this.setPlayerDisplay(6);
                }
                return;
            }
            case 'u': {
                this.player.setState(7);
                if (this.setPlayerMovement(0, -1)) {
                    this.setPlayerAnimation(0);
                    this.setPlayerDisplay(7);
                }
                return;
            }
            case 'd': {
                this.player.setState(7);
                if (this.setPlayerMovement(0, 1)) {
                    this.setPlayerAnimation(2);
                    this.setPlayerDisplay(7);
                }
                return;
            }
            case 'l': {
                this.player.setState(7);
                if (this.setPlayerMovement(-1, 0)) {
                    this.setPlayerAnimation(3);
                    this.setPlayerDisplay(7);
                }
                return;
            }
            case 'r': {
                this.player.setState(7);
                if (this.setPlayerMovement(1, 0)) {
                    this.setPlayerAnimation(1);
                    this.setPlayerDisplay(7);
                }
                return;
            }
            case ' ': 
            case '!': 
            case '#': 
            case '*': 
            case '+': 
            case '-': {
                this.divX = 0;
                this.divY = 0;
                this.player.setState(5);
                this.setPlayerAnimation(4);
                return;
            }
            case 't': {
                if (this.player.teleporting) break;
                Config.playTeleportSound();
                this.state = 16;
                this.setPlayerDisplay(4);
                this.createFader(255);
                return;
            }
            case 'm': {
                this.bombX = this.player.levelX;
                this.bombY = this.player.levelY;
                this.fire = true;
                break;
            }
            default: {
                this.player.setState(5);
            }
        }
        switch (this.action) {
            case 0: {
                this.stop();
                return;
            }
            case 1: {
                if (this.setPlayerMovement(0, -1)) {
                    this.setPlayerAnimation(0);
                    this.setPlayerDisplay(1);
                }
                return;
            }
            case 6: {
                if (this.setPlayerMovement(0, 1)) {
                    this.setPlayerAnimation(2);
                    this.setPlayerDisplay(1);
                }
                return;
            }
            case 2: {
                if (this.setPlayerMovement(-1, 0)) {
                    this.setPlayerAnimation(3);
                    this.setPlayerDisplay(1);
                }
                return;
            }
            case 5: {
                if (this.setPlayerMovement(1, 0)) {
                    this.setPlayerAnimation(1);
                    this.setPlayerDisplay(1);
                }
                return;
            }
            case 8: {
                this.player.setState(5);
                this.setPlayerAnimation(5);
                boolean bl = this.fire = !this.fire;
                if (this.fire) {
                    this.setPlayerDisplay(5);
                    this.bombX = this.player.levelX;
                    this.bombY = this.player.levelY;
                } else {
                    this.setPlayerDisplay(0);
                }
                this.action = -1;
                return;
            }
        }
        if (this.playerDisplay.state == 2 && this.gsf.getNumExplosions() == 0) {
            this.setPlayerDisplay(0);
        }
    }

    private void checkMove() {
        if (this.moveCount <= 0) {
            return;
        }
        if (this.moveCount == 8) {
            if (this.fire) {
                this.gsf.explodeBomb(this.bombX, this.bombY);
                this.setPlayerDisplay(2);
                this.fire = false;
            } else {
                char tileID = this.gsf.getId(this.player.levelX, this.player.levelY);
                if (tileID == '1') {
                    this.gsf.changeTile(this.player.levelX, this.player.levelY, '-');
                }
            }
        }
        this.move();
        if (!this.pressed) {
            this.action = 0;
        }
    }

    private boolean setPlayerMovement(int dx, int dy) {
        this.divX = dx;
        this.divY = dy;
        switch (this.gsf.getId(this.player.levelX + this.divX, this.player.levelY + this.divY)) {
            case 'N': 
            case 'P': 
            case 'W': 
            case 'n': {
                if (this.player.getState() == 7) {
                    this.divX = 0;
                    this.divY = 0;
                    this.gsf.changeTile(this.player.levelX, this.player.levelY, '-');
                    this.setPlayerAnimation(4);
                    return false;
                }
                if (this.player.getState() == 6) {
                    this.divX = -this.divX;
                    this.divY = -this.divY;
                    this.player.invertAnimation();
                    return true;
                }
                this.stop();
                return false;
            }
        }
        this.moveCount = 16;
        this.move();
        return true;
    }

    private void setPlayerAnimation(int ani) {
        this.player.setAnimation(ani);
    }

    private void setPlayerDisplay(int state) {
        switch (state) {
            case 0: 
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: {
                if (this.gsf.getNumExplosions() > 0) {
                    this.playerDisplay.setState(2);
                    return;
                }
            }
            case 3: 
            case 5: 
            case 8: {
                this.playerDisplay.setState(state);
                return;
            }
        }
    }

    private void move() {
        this.moveX();
        this.moveY();
    }

    private void moveX() {
        if (this.divX == 0) {
            return;
        }
        int xDir = (1 - this.divX) / 2;
        if (this.player.levelX < this.xMin + xDir || this.player.levelX > this.xMax + xDir || !this.gsf.scrollH(this.divX)) {
            this.player.moveX(this.divX);
        }
        this.moveCount -= Math.abs(this.divX);
        if (this.moveCount == 0) {
            this.player.moveLevelPos(this.divX / Math.abs(this.divX), 0);
        }
    }

    private void moveY() {
        if (this.divY == 0) {
            return;
        }
        int yDir = (1 - this.divY) / 2;
        if (this.player.levelY < this.yMin + yDir || this.player.levelY > this.yMax + yDir || !this.gsf.scrollV(this.divY)) {
            this.player.moveY(this.divY);
        }
        this.moveCount -= Math.abs(this.divY);
        if (this.moveCount == 0) {
            this.player.moveLevelPos(0, this.divY / Math.abs(this.divY));
        }
    }

    private void teleport() {
        int ySize = Bomba.level.getHeight();
        int xSize = Bomba.level.getWidth();
        for (int y = 0; y < ySize; ++y) {
            for (int x = 0; x < xSize; ++x) {
                if (this.gsf.getId(x, y) != 't' || x == this.player.levelX && y == this.player.levelY) continue;
                this.gsf.setPlayerPos(x, y, this.player);
                this.player.setLevelPos(x, y);
                this.player.teleporting = true;
                this.gsf.paint();
                return;
            }
        }
    }

    public static void sleep(long ms) {
        if (ms < (long)0) {
            return;
        }
        try {
            Thread.sleep(ms);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void createFader(int color) {
        this.br = new BlendRaster(24, 70, 128, 128, 4, 4, color);
        this.br.speed = 5;
        this.br.setListener(this);
    }

    public void startBlendNextLevel() {
        this.state = 5;
        this.setPlayerDisplay(8);
        this.createFader(65280);
        this.clock.pause();
    }

    public void startBlendLostLive() {
        this.state = 11;
        this.setPlayerDisplay(3);
        this.createFader(0xFF0000);
        this.clock.pause();
    }

    public void paint(Graphics g) {
        if (Player.anim == null) {
            return;
        }
        g = this.startPaint(g);
        switch (this.state) {
            case 1: {
                if (this.bgImage != null) {
                    g.drawImage(this.bgImage, 0, 0, 20);
                    this.bgImage = null;
                    Config.gc();
                }
                this.state = 2;
            }
            case 2: {
                this.checkField();
                this.checkMove();
                this.gsf.update(g);
                this.player.paint(g);
                Config.paintClock(g, this.clock);
                int bombs = this.gsf.getNumBombs();
                if (bombs != this.oldBombs) {
                    this.oldBombs = bombs;
                    Config.paintBombs(g, bombs);
                }
                if (this.lives == this.oldLives) break;
                this.oldLives = this.lives;
                Config.paintLives(g, this.lives, this.player);
                break;
            }
            case 15: {
                g.setColor(0);
                if (Bomba.isSmallScreen()) {
                    g.fillRect(0, 0, 176, 220);
                } else {
                    g.fillRect(24, 70, 128, 128);
                }
                Font font = Font.getFont((int)0, (int)1, (int)16);
                int fOffset = 128 - font.getHeight();
                try {
                    Image image = Image.createImage((String)"/teaser.png");
                    int iOffset = fOffset - image.getHeight();
                    g.setColor(0xFF0000);
                    g.setFont(font);
                    if (Bomba.isSmallScreen()) {
                        g.drawImage(image, 88, 220, 33);
                        g.drawString("Good bye", 88, 220 - Config.idCard.getHeight(), 33);
                    } else {
                        g.drawImage(image, 88, 198 - font.getHeight(), 33);
                        g.drawString("Good bye", 88, 198, 33);
                    }
                    image = null;
                    Config.gc();
                    fOffset = iOffset;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.state = 3;
                break;
            }
            case 12: {
                Config.paintLives(g, this.lives, this.player);
                Config.paintClock(g, this.clock);
                Config.paintBombs(g, this.gsf.getNumBombs());
                if (this.lives == 0) {
                    Config.paintGameOver(g);
                } else {
                    Config.paintLostLive(g);
                }
                this.state = 13;
                break;
            }
            case 6: {
                Config.paintCountBonus(g, this.bonus, this.timeBonus, this.score);
                if (this.bonus > 0) {
                    --this.bonus;
                    ++this.score;
                    break;
                }
                if (this.timeBonus > 0) {
                    --this.timeBonus;
                    ++this.score;
                    break;
                }
                this.state = 7;
                break;
            }
            case 8: {
                Config.paintNextLevel(g);
                this.state = 9;
                break;
            }
            case 10: 
            case 14: 
            case 17: {
                if (this.bgImage != null) {
                    g.drawImage(this.bgImage, 0, 0, 20);
                    this.bgImage = null;
                    Config.gc();
                }
                this.gsf.paint(g);
            }
            case 5: 
            case 11: 
            case 16: {
                int clipX = g.getClipX();
                int clipY = g.getClipY();
                int clipW = g.getClipWidth();
                int clipH = g.getClipHeight();
                g.clipRect(24, 70, 128, 128);
                this.br.paint(g);
                g.setClip(clipX, clipY, clipW, clipH);
                break;
            }
            case 4: {
                if (!this.menu.isVisible()) break;
                this.gsf.paint(g);
                this.player.paint(g);
                this.menu.paint(g, 88);
                break;
            }
        }
        this.playerDisplay.paint(g);
        this.stopPaint(g);
    }

    public void keyReleased(int keyCode) {
        switch (this.state) {
            case 4: {
                if (!this.menu.isVisible()) break;
                this.handleMenu(keyCode);
                break;
            }
            case 13: {
                if (this.lives == 0) {
                    this.state = 15;
                    break;
                }
                if (Bomba.isSmallScreen()) {
                    repaint = true;
                }
                this.newGame();
                this.repaint();
                this.serviceRepaints();
                this.br.invert();
                this.state = 14;
                break;
            }
            case 7: {
                this.state = 8;
                break;
            }
            case 9: {
                ++this.level;
                if (Bomba.isSmallScreen()) {
                    repaint = true;
                }
                this.newGame();
                this.repaint();
                this.serviceRepaints();
                this.br.invert();
                this.state = 10;
                break;
            }
            case 2: {
                if (keyCode == -6 || keyCode == -7) {
                    this.state = 4;
                    this.action = 0;
                    this.pressed = false;
                    this.menu.setVisible(true);
                    this.clock.pause();
                    this.stopThread();
                    this.repaint();
                    return;
                }
                if (this.player.getAnimation() == 4) break;
                this.pressed = false;
                if (this.getGameAction(keyCode) != 8 || this.gsf == null || this.player == null) break;
                switch (this.gsf.getId(this.player.levelX, this.player.levelY)) {
                    case 'A': 
                    case 'B': 
                    case 'C': {
                        this.action = 8;
                    }
                }
                break;
            }
        }
    }

    public void keyPressed(int keyCode) {
        if (keyCode == -6 || keyCode == -7) {
            return;
        }
        if (this.state == 2 && this.player.getAnimation() != 4) {
            int gameAction = this.getGameAction(keyCode);
            switch (gameAction) {
                case 1: 
                case 2: 
                case 5: 
                case 6: {
                    this.action = gameAction;
                    this.pressed = true;
                }
            }
        }
    }

    public void run() {
        Thread thisThread = Thread.currentThread();
        while (this.runner == thisThread) {
            if (this.state != 3) {
                long time = System.currentTimeMillis();
                this.repaint();
                time = System.currentTimeMillis() - time;
                GameDisplayable.sleep((long)25 - time);
                continue;
            }
            this.exitGame();
        }
    }

    public void select(MenuItem mi) {
        if (mi == this.cont) {
            this.state = 2;
            this.jbInit();
            this.menu.setVisible(false);
            this.startThread();
            this.clock.start();
            return;
        }
        if (mi == this.exit) {
            this.state = 15;
            this.menu.setVisible(false);
            this.repaint();
            this.startThread();
            return;
        }
    }

    public void rasterFinished(BlendRaster blend) {
        switch (this.state) {
            case 11: {
                this.state = 12;
                if (--this.lives <= 0) {
                    Config.playGameOverSound();
                } else {
                    Config.playLostLiveSound();
                }
                return;
            }
            case 5: {
                Config.playNextLevelSound();
                this.bonus = Bomba.level.getBonus();
                this.timeBonus = (int)(this.clock.getTime() / (long)1000);
                Bomba.level.setNextLevel();
                this.state = 6;
                this.player.reset();
                return;
            }
            case 10: 
            case 14: {
                Config.playStartSound();
                this.state = 1;
                this.br = null;
                return;
            }
            case 16: {
                this.teleport();
                this.br.invert();
                this.state = 17;
                return;
            }
            case 17: {
                this.state = 2;
                this.br = null;
                if (!this.pressed) {
                    this.action = 0;
                }
                return;
            }
        }
    }

    public void pause() {
        if (this.state == 2) {
            this.state = 4;
            this.menu.setVisible(true);
            this.clock.pause();
            this.stopThread();
            this.repaint();
            this.serviceRepaints();
        }
    }

    static {
        INIT = '\u0001';
        PLAY = (char)2;
        EXIT = (char)3;
        MENU = (char)4;
        NEXTLEVEL_FADE_IN = (char)5;
        NEXTLEVEL_COUNTBONUS = (char)6;
        NEXTLEVEL_COUNTBONUS_WAIT = (char)7;
        NEXTLEVEL_CARD = (char)8;
        NEXTLEVEL_CARD_WAIT = (char)9;
        NEXTLEVEL_FADE_OUT = (char)10;
        LOSTLIVE_FADE_IN = (char)11;
        LOSTLIVE_CARD = (char)12;
        LOSTLIVE_CARD_WAIT = (char)13;
        LOSTLIVE_FADE_OUT = (char)14;
        GAMEOVER = (char)15;
        TELEPORT_FADE_IN = (char)16;
        TELEPORT_FADE_OUT = (char)17;
    }
}

