/*
 * Decompiled with CFR 0.152.
 */
package bomba;

import bomba.Bomba;
import bomba.LevelElements;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;

public class Level {
    public static final char NOGO1 = 'n';
    public static final char NOGO2 = 'N';
    public static final char NOGO3 = 'P';
    public static final char NOGO4 = 'W';
    public static final char SOLID = 's';
    public static final char PLAYER = 'p';
    public static final char FIXED = 'f';
    public static final char OIL = 'o';
    public static final char NULL = ' ';
    public static final char EINS = '1';
    public static final char ROLLTREPPE_HR = 'r';
    public static final char ROLLTREPPE_HL = 'l';
    public static final char ROLLTREPPE_VU = 'u';
    public static final char ROLLTREPPE_VD = 'd';
    public static final char TELEPORTER = 't';
    public static final char BOMB1 = 'A';
    public static final char BOMB2 = 'B';
    public static final char BOMB3 = 'C';
    public static final char MINE1 = 'm';
    public static final char FALL = '-';
    public static final char EXPLODE0 = '+';
    public static final char EXPLODE1 = '*';
    public static final char EXPLODE2 = '!';
    public static final char EXPLODE3 = '#';
    public static final char WEG = '?';
    public static LevelElements elements;
    public static int actual;
    public static final int[] BONUS;
    static char[][] level;
    private static int bombs;
    private static int startX;
    private static int startY;
    private static int lastLevel;
    private static int matrixRnd;
    private static int matrixRnd2;
    private static final long SEK = 1000L;
    private static final long[] TIMES;

    public Level() throws IOException {
        elements = new LevelElements();
    }

    public void setLevel(int level) {
        actual = level;
    }

    public void setNextLevel() {
        if (++actual >= BONUS.length) {
            actual = 0;
        }
        this.setLevel(actual);
    }

    public char[][] getLevel(int num) {
        try {
            InputStream is = this.getClass().getResourceAsStream(String.valueOf(String.valueOf(new StringBuffer("/level_").append(num).append(".dat"))));
            int w = (is.read() - 48) * 10 + is.read() - 48;
            int h = (is.read() - 48) * 10 + is.read() - 48;
            is.read();
            if (w < 1 || w > 32 || h < 1 || h > 32) {
                h = 0;
                w = 0;
            }
            int[][] levelMatrix = new int[][]{{1, 0, 0}, {0, 1, 0}};
            int transW = w;
            int transH = h;
            if (num != lastLevel) {
                matrixRnd = (int)System.currentTimeMillis();
                matrixRnd += matrixRnd / 11 + matrixRnd / 3 + matrixRnd2;
                matrixRnd &= 7;
                ++matrixRnd2;
                matrixRnd2 &= 7;
            }
            int signX = 1;
            int signY = 1;
            int addX = 0;
            int addY = 0;
            if ((matrixRnd & 1) != 0) {
                signX = -1;
                addX = w - 1;
            }
            if ((matrixRnd & 2) != 0) {
                signY = -1;
                addY = h - 1;
            }
            if ((matrixRnd & 4) == 0) {
                levelMatrix = new int[][]{{signX, 0, addX}, {0, signY, addY}};
            } else {
                levelMatrix = new int[][]{{0, signY, addY}, {signX, 0, addX}};
                transW = h;
                transH = w;
            }
            lastLevel = num;
            level = new char[transH][transW];
            startX = 0;
            startY = 0;
            bombs = 0;
            int transX = 0;
            int transY = 0;
            int c = 0;
            for (int y = 0; y < h; ++y) {
                boolean lf = false;
                for (int x = 0; x < w; ++x) {
                    transX = x * levelMatrix[0][0] + y * levelMatrix[0][1] + levelMatrix[0][2];
                    transY = x * levelMatrix[1][0] + y * levelMatrix[1][1] + levelMatrix[1][2];
                    if (!lf) {
                        while ((c = is.read()) != -1 && c != 13 && (c < 32 || c > 127)) {
                        }
                        boolean bl = lf = c == -1 || c == 13;
                    }
                    if (lf) {
                        Level.level[transY][transX] = 32;
                        continue;
                    }
                    if (levelMatrix[0][0] == 0) {
                        switch (c) {
                            case 117: {
                                c = 108;
                                break;
                            }
                            case 100: {
                                c = 114;
                                break;
                            }
                            case 108: {
                                c = 117;
                                break;
                            }
                            case 114: {
                                c = 100;
                            }
                        }
                    }
                    if (levelMatrix[0][0] == -1 || levelMatrix[0][1] == -1) {
                        switch (c) {
                            case 108: {
                                c = 114;
                                break;
                            }
                            case 114: {
                                c = 108;
                            }
                        }
                    }
                    if (levelMatrix[1][0] == -1 || levelMatrix[1][1] == -1) {
                        switch (c) {
                            case 117: {
                                c = 100;
                                break;
                            }
                            case 100: {
                                c = 117;
                            }
                        }
                    }
                    switch (c) {
                        case 112: {
                            startX = transX;
                            startY = transY;
                            break;
                        }
                        case 65: 
                        case 66: 
                        case 67: 
                        case 109: {
                            ++bombs;
                        }
                    }
                    Level.level[transY][transX] = (char)c;
                }
                if (lf) continue;
                is.read();
            }
            char[][] cArray = level;
            return cArray;
        }
        catch (IOException e) {
            e.printStackTrace();
            char[][] cArray = null;
            return cArray;
        }
    }

    public int getStartX() {
        return startX;
    }

    public int getStartY() {
        return startY;
    }

    public int getWidth() {
        return level[0].length;
    }

    public int getHeight() {
        return level.length;
    }

    public long getTime() {
        return TIMES[actual];
    }

    public int getBonus() {
        return BONUS[actual];
    }

    public int getNumBombs() {
        return bombs;
    }

    public int getLevelNum() {
        return actual;
    }

    public boolean paintElement(Graphics g, char c, int x, int y, int phase) {
        if (!Bomba.animated.paint(g, c, x, y, phase)) {
            return LevelElements.paint(g, c, x, y);
        }
        return true;
    }

    static {
        NOGO1 = (char)110;
        NOGO2 = (char)78;
        NOGO3 = (char)80;
        NOGO4 = (char)87;
        SOLID = (char)115;
        PLAYER = (char)112;
        FIXED = (char)102;
        OIL = (char)111;
        NULL = (char)32;
        EINS = (char)49;
        ROLLTREPPE_HR = (char)114;
        ROLLTREPPE_HL = (char)108;
        ROLLTREPPE_VU = (char)117;
        ROLLTREPPE_VD = (char)100;
        TELEPORTER = (char)116;
        BOMB1 = (char)65;
        BOMB2 = (char)66;
        BOMB3 = (char)67;
        MINE1 = (char)109;
        FALL = (char)45;
        EXPLODE0 = (char)43;
        EXPLODE1 = (char)42;
        EXPLODE2 = (char)33;
        EXPLODE3 = (char)35;
        WEG = (char)63;
        actual = 0;
        BONUS = new int[]{50, 50, 100, 100, 100, 150, 150, 250, 250, 500};
        bombs = 0;
        startX = 0;
        startY = 0;
        lastLevel = -1;
        matrixRnd = 0;
        matrixRnd2 = 0;
        SEK = 1000L;
        TIMES = new long[]{45000L, 45000L, 45000L, 45000L, 60000L, 90000L, 90000L, 105000L, 120000L, 120000L};
    }
}

