/*
 * Decompiled with CFR 0.152.
 */
package bomba;

import bomba.AnimatedElements;
import bomba.Bomba;
import bomba.Config;
import bomba.GameDisplayable;
import bomba.Help;
import bomba.Level;
import bomba.LevelCounter;
import bomba.MyCanvas;
import de.tuttas.GameAPI.Menu;
import de.tuttas.GameAPI.MenuItem;
import de.tuttas.GameAPI.MenuListener;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class StartDisplayable
extends MyCanvas
implements MenuListener {
    public static boolean titleSound = true;
    public static boolean effectSound = true;
    public static Image titleImage;
    public static final int MAX_LIVES = 3;
    public static final int MENU = 1;
    private static final int OPTIONSMENU = 2;
    private static final int STARTLEVEL = 3;
    private static final int START = 4;
    private static final int WAIT = 5;
    private static final int HELP = 6;
    private static final int ABOUT = 7;
    private static final int COLOR_ACTIVE = 0xFFFF00;
    private static final int COLOR_INACTIVE = 0x555555;
    public int state = 1;
    private Help helpScreen;
    private int level;
    private int score;
    private int lives;
    private LevelCounter counter;
    private Menu m1;
    private Menu m2;
    private Menu m3;
    private MenuItem start = new MenuItem("Start", 0xFFFF00, 0x555555, 16);
    private MenuItem options = new MenuItem("Options", 0xFFFF00, 0x555555, 16);
    private MenuItem help = new MenuItem("Help", 0xFFFF00, 0x555555, 16);
    private MenuItem about = new MenuItem("About", 0xFFFF00, 0x555555, 16);
    private MenuItem exit = new MenuItem("Exit", 0xFFFF00, 0x555555, 16);
    private MenuItem titelSoundItem = new MenuItem("Titel [ON]", 0xFFFF00, 0x555555, 16);
    private MenuItem effectSoundItem = new MenuItem("Effects [ON]", 0xFFFF00, 0x555555, 16);
    private MenuItem back = new MenuItem("Back", 0xFFFF00, 0x555555, 16);
    private MenuItem startNew = new MenuItem("New Game", 0xFFFF00, 0x555555, 16);
    private MenuItem startOld = new MenuItem("Resume Game", 0xFFFF00, 0x555555, 16);
    private MenuItem startLevel = new MenuItem("Select Level", 0xFFFF00, 0x555555, 16);

    public StartDisplayable() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void run() {
        Thread thisThread = Thread.currentThread();
        while (this.runner == thisThread) {
            this.repaint();
            if (this.state == 5) {
                GameDisplayable.sleep(1000L);
                Config.stopTitleSound();
                titleImage = null;
                this.counter = null;
                this.help = null;
                Bomba.animated.free();
                this.stopThread();
                Config.gc();
                Bomba.startGame(this.level, this.score, this.lives);
                continue;
            }
            GameDisplayable.sleep(40L);
        }
    }

    private void jbInit() throws Exception {
        this.m1 = new Menu(20);
        this.m1.add(this.start);
        this.m1.add(this.options);
        this.m1.add(this.help);
        this.m1.add(this.about);
        this.m1.add(this.exit);
        this.m1.setListener(this);
        this.m2 = new Menu(20);
        this.m2.add(this.titelSoundItem);
        this.m2.add(this.effectSoundItem);
        this.m2.add(this.back);
        this.m2.setListener(this);
        this.m3 = new Menu(20);
        this.m3.add(this.startNew);
        this.m3.add(this.startOld);
        this.m3.add(this.startLevel);
        this.m3.add(this.back);
        this.m3.setListener(this);
        MenuItem.width = 114;
        this.init();
        this.m1.setSelectedItem(this.start);
    }

    public void init() {
        try {
            titleImage = Image.createImage((String)"/titel.png");
            this.state = 1;
            this.counter = new LevelCounter(Bomba.startLevel, 1, Level.BONUS.length, Menu.right, Menu.left);
            Bomba.animated = new AnimatedElements();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void keyPressed(int keyCode) {
        if (this.state == 5) {
            return;
        }
        int action = this.getGameAction(keyCode);
        Menu menu = null;
        switch (this.state) {
            case 1: {
                menu = this.m1;
                break;
            }
            case 2: {
                menu = this.m2;
                break;
            }
            case 4: {
                menu = this.m3;
            }
        }
        switch (this.state) {
            case 3: {
                switch (action) {
                    case 1: 
                    case 2: {
                        this.counter.down();
                        this.repaint();
                        break;
                    }
                    case 5: 
                    case 6: {
                        this.counter.up();
                        this.repaint();
                        break;
                    }
                    case 8: {
                        this.level = this.counter.getValue();
                        this.score = 0;
                        this.lives = 3;
                        this.state = 5;
                        this.startThread();
                    }
                }
                return;
            }
            case 7: {
                this.stopThread();
                this.state = 1;
                this.repaint();
                return;
            }
            case 6: {
                switch (action) {
                    case 1: 
                    case 2: {
                        this.helpScreen.next(-1);
                        break;
                    }
                    case 5: 
                    case 6: {
                        this.helpScreen.next(1);
                        break;
                    }
                    case 8: {
                        this.state = 1;
                        this.stopThread();
                        this.repaint();
                    }
                }
                return;
            }
        }
        switch (action) {
            case 1: 
            case 2: {
                menu.up();
                this.repaint();
                break;
            }
            case 5: 
            case 6: {
                menu.down();
                this.repaint();
                break;
            }
            case 8: {
                menu.select();
            }
        }
    }

    public void paint(Graphics g) {
        g = this.startPaint(g);
        if (this.state == 5) {
            g.setColor(0);
            g.fillRect(0, 0, 176, 220);
            Font font = Font.getFont((int)0, (int)1, (int)16);
            int fOffset = 220 - font.getHeight();
            g.setColor(0xFF0000);
            g.setFont(font);
            try {
                Image image = Image.createImage((String)"/teaser.png");
                int iOffset = fOffset - image.getHeight();
                if (Bomba.isSmallScreen()) {
                    g.drawImage(image, 88, 220, 33);
                    g.drawString("Loading...", 88, 220 - Config.idCard.getHeight(), 33);
                } else {
                    g.drawImage(image, 88, 220 - g.getFont().getHeight(), 33);
                    g.drawString("Loading...", 88, 220, 33);
                }
                image = null;
                Config.gc();
                fOffset = iOffset;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (this.state == 6 || this.state == 7) {
            this.helpScreen.paint(g);
        } else {
            g.drawImage(titleImage, 0, 0, 20);
            if (this.state == 1) {
                this.m1.paint(g, 88);
            } else if (this.state == 2) {
                g.setColor(0xFFFFFF);
                g.setFont(Font.getFont((int)64, (int)0, (int)8));
                g.drawString("Options", 88, 20 - g.getFont().getHeight() - 0, 17);
                this.m2.paint(g, 88);
            } else if (this.state == 4) {
                g.setColor(0xFFFFFF);
                g.setFont(Font.getFont((int)64, (int)0, (int)8));
                g.drawString("Start Game", 88, 20 - g.getFont().getHeight() - 0, 17);
                this.m3.paint(g, 88);
            } else if (this.state == 3) {
                g.setColor(0xFFFFFF);
                g.setFont(Font.getFont((int)64, (int)0, (int)8));
                g.drawString("Select Level", 88, 20 - g.getFont().getHeight() - 0, 17);
                g.setFont(Font.getFont((int)64, (int)1, (int)16));
                g.setColor(0xFFFF00);
                this.counter.paint(g, 88, 20);
            }
        }
        this.stopPaint(g);
    }

    public void select(MenuItem mi) {
        if (mi == this.start) {
            this.state = 4;
            this.m3.setSelectedItem(this.startNew);
            this.repaint();
            return;
        }
        if (mi == this.startOld) {
            this.level = Bomba.startLevel;
            this.score = Bomba.startScore;
            this.lives = Bomba.startLives;
            this.state = 5;
            this.startThread();
            return;
        }
        if (mi == this.startNew) {
            this.level = 1;
            this.score = 0;
            this.lives = 3;
            this.state = 5;
            this.startThread();
            return;
        }
        if (mi == this.help) {
            this.state = 5;
            this.repaint();
            this.serviceRepaints();
            GameDisplayable.sleep(500L);
            this.helpScreen = new Help(1);
            this.state = 6;
            this.startThread();
            return;
        }
        if (mi == this.about) {
            this.state = 5;
            this.repaint();
            this.serviceRepaints();
            GameDisplayable.sleep(500L);
            this.helpScreen = new Help(9);
            this.state = 7;
            this.startThread();
            return;
        }
        if (mi == this.exit) {
            Config.stopTitleSound();
            Bomba.quitApp();
        }
        if (mi == this.options) {
            this.state = 2;
            this.m2.setSelectedItem(this.titelSoundItem);
            this.repaint();
            return;
        }
        if (mi == this.startLevel) {
            this.counter = new LevelCounter(Bomba.startLevel, 1, Level.BONUS.length, Menu.right, Menu.left);
            this.state = 3;
            this.repaint();
            return;
        }
        if (mi == this.titelSoundItem) {
            boolean bl = titleSound = !titleSound;
            if (titleSound) {
                this.titelSoundItem.text = "Titel [ON]";
                Config.playTitleSound();
            } else {
                this.titelSoundItem.text = "Titel [OFF]";
                Config.stopTitleSound();
            }
            this.repaint();
            return;
        }
        if (mi == this.effectSoundItem) {
            effectSound = !effectSound;
            this.effectSoundItem.text = effectSound ? "Effects [ON]" : "Effects [OFF]";
            this.repaint();
            return;
        }
        if (mi == this.back) {
            this.state = 1;
            this.repaint();
            return;
        }
    }

    static {
        MAX_LIVES = 3;
        MENU = 1;
        OPTIONSMENU = 2;
        STARTLEVEL = 3;
        START = 4;
        WAIT = 5;
        HELP = 6;
        ABOUT = 7;
        COLOR_ACTIVE = 0xFFFF00;
        COLOR_INACTIVE = 0x555555;
    }
}

