/*
 * Decompiled with CFR 0.152.
 */
package bomba;

import bomba.Number;
import java.util.Calendar;
import java.util.Date;
import javax.microedition.lcdui.Graphics;

public class Clock {
    private final Date date;
    private final Calendar calendar;
    private long time;
    private boolean paused;
    private boolean zero;

    public Clock(long start) {
        this.date = new Date(start);
        this.calendar = Calendar.getInstance();
        this.calendar.setTime(this.date);
        this.time = System.currentTimeMillis();
    }

    public void paint(Graphics g, int x, int y, Number num) {
        if (this.zero) {
            this.pause();
        } else {
            this.tick();
        }
        g.setColor(0xFF0000);
        num.digits = 1;
        num.value = this.calendar.get(12);
        num.paint(g, x, y);
        int x2 = x + 2 * num.width + num.width / 2;
        int y2 = y + num.image.getHeight() / 2;
        g.drawLine(x2, y2 - 3, x2, y2 - 2);
        g.drawLine(x2, y2 + 3, x2, y2 + 2);
        num.value = this.calendar.get(13);
        num.paint(g, x + 3 * num.width, y);
    }

    public long getTime() {
        return this.date.getTime();
    }

    public void tick() {
        if (this.paused) {
            return;
        }
        if (this.date.getTime() - (System.currentTimeMillis() - this.time) < (long)0) {
            this.zero = true;
        } else {
            this.date.setTime(this.date.getTime() - (System.currentTimeMillis() - this.time));
            this.calendar.setTime(this.date);
            this.time = System.currentTimeMillis();
        }
    }

    public void start() {
        this.time = System.currentTimeMillis();
        this.paused = false;
    }

    public void pause() {
        this.paused = true;
    }
}

