/*
 * Decompiled with CFR 0.152.
 */
package de.tuttas.GameAPI;

import de.tuttas.GameAPI.ScrollTextListener;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class ScrollText {
    public static final int UP = 1;
    public static final int DOWN = 2;
    public String[] text;
    public int speed = 1;
    private int width;
    private int height;
    public int direction;
    private ScrollTextListener listener;
    public int y;
    private int ymax;

    public ScrollText(String[] t, int w, int h, int d) {
        this.text = t;
        this.width = w;
        this.height = h;
        this.direction = d;
        this.y = d == 1 ? h : -this.text.length * Font.getDefaultFont().getHeight();
        this.ymax = this.text.length * Font.getDefaultFont().getHeight();
    }

    public void reset() {
        this.y = this.direction == 1 ? this.height : -this.text.length * Font.getDefaultFont().getHeight();
    }

    public void setListener(ScrollTextListener l) {
        this.listener = l;
    }

    public void paint(Graphics g) {
        int starty = this.y + g.getClipY();
        for (int i = 0; i < this.text.length; ++i) {
            g.drawString(this.text[i], this.width / 2 + g.getClipX(), starty, 17);
            starty += Font.getDefaultFont().getHeight();
        }
        if (this.direction == 1) {
            if (this.y < -this.ymax && this.listener != null) {
                this.listener.scrollFinished(this);
            } else {
                this.y -= this.speed;
            }
        } else if (this.y > 0 && this.listener != null) {
            this.listener.scrollFinished(this);
        } else {
            this.y += this.speed;
        }
    }

    static {
        UP = 1;
        DOWN = 2;
    }
}

