/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.painter;

import com.sun.lwuit.Component;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.Image;
import com.sun.lwuit.Painter;
import com.sun.lwuit.geom.Rectangle;
import com.sun.lwuit.plaf.Style;

public class BackgroundPainter
implements Painter {
    private Component a;

    public BackgroundPainter(Component component) {
        this.a = component;
    }

    public void paint(Graphics graphics, Rectangle rectangle) {
        Style style = this.a.getStyle();
        int n2 = rectangle.getX();
        int n3 = rectangle.getY();
        int n4 = rectangle.getSize().getWidth();
        int n5 = rectangle.getSize().getHeight();
        if (n4 <= 0 || n5 <= 0) {
            return;
        }
        Image image = style.getBgImage();
        if (image == null) {
            if (this.a.hasFocus() && this.a.isFocusPainted()) {
                graphics.setColor(style.getBgSelectionColor());
                graphics.fillRect(n2, n3, n4, n5, style.getBgTransparency());
                return;
            }
            graphics.setColor(style.getBgColor());
            graphics.fillRect(n2, n3, n4, n5, style.getBgTransparency());
            return;
        }
        if (style.isScaleImage()) {
            if (image.getWidth() != n4 || image.getHeight() != n5) {
                image = image.scaled(n4, n5);
                style.setBgImage(image, true);
            }
        } else {
            int n6 = image.getWidth();
            int n7 = image.getHeight();
            for (int i2 = 0; i2 < n4; i2 += n6) {
                for (int i3 = 0; i3 < n5; i3 += n7) {
                    graphics.drawImage(style.getBgImage(), n2 + i2, n3 + i3);
                }
            }
            return;
        }
        graphics.drawImage(style.getBgImage(), n2, n3);
    }
}

