/*
 * Decompiled with CFR 0.152.
 */
package net.cachapa.weightwatch;

import com.sun.lwuit.Graphics;
import com.sun.lwuit.Image;
import java.util.Vector;
import net.cachapa.weightwatch.Bmi;
import net.cachapa.weightwatch.Database;
import net.cachapa.weightwatch.LineChartMonth;
import net.cachapa.weightwatch.LineChartYear;
import net.cachapa.weightwatch.Plan;
import net.cachapa.weightwatch.Preferences;
import net.cachapa.weightwatch.Trend;
import net.cachapa.weightwatch.Value;
import net.cachapa.weightwatch.util.MyDate;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class WeightWatch {
    private Database a;
    private LineChartMonth a;
    private LineChartYear a;
    private Preferences a = new Preferences();

    public boolean addValue(long l2, double d2) {
        MyDate myDate = new MyDate(l2);
        Value value = new Value(myDate, d2);
        Value value2 = this.a.getValueBefore(myDate);
        value.trend = value2 == null ? d2 : Trend.getTrend(value2, value);
        boolean bl2 = this.a.addValue(value);
        if (this.a.getLatestValue() != value) {
            this.regenerateTrendValuesAfter(myDate);
        }
        return bl2;
    }

    public Vector getFullDatabase() {
        return this.a.getValues();
    }

    public Preferences getPreferences() {
        return this.a;
    }

    public void regenerateTrendValues() {
        Vector vector = this.a.getValues();
        int n2 = vector.size();
        Value value = null;
        for (int i2 = 0; i2 < n2; ++i2) {
            Value value2 = (Value)vector.elementAt(i2);
            ((Value)vector.elementAt(i2)).trend = Trend.getTrend(value, value2);
            this.a.updateValue(value2);
            value = value2;
        }
    }

    public void regenerateTrendValuesAfter(MyDate myDate) {
        Vector vector = this.a.getValues();
        int n2 = vector.size();
        Value value = null;
        for (int i2 = 0; i2 < n2; ++i2) {
            Value value2 = (Value)vector.elementAt(i2);
            if (!value2.date.isBefore(myDate)) {
                value2.trend = Trend.getTrend(value, value2);
                this.a.updateValue(value2);
            }
            value = value2;
        }
    }

    public Plan getPlan() {
        return this.a.getPlan();
    }

    public Database getDatabase() {
        return this.a;
    }

    public double getCurrentBmi() {
        double d2;
        double d3 = this.a.getUserHeight();
        Value value = this.a.getLatestValue();
        if (d3 != 0.0 && value.trend != 0.0) {
            d2 = Bmi.calculateBMI(value.trend, d3);
            d2 = (double)((int)(d2 * 10.0)) / 10.0;
        } else {
            d2 = 0.0;
        }
        return d2;
    }

    public Image drawMonthChart(MyDate myDate, int n2, int n3) {
        Image image = Image.createImage(n2, n3);
        Graphics graphics = image.getGraphics();
        this.a.drawChart(graphics, n2, n3, myDate, this.a, this.a);
        return image;
    }

    public Image drawYearChart(MyDate myDate, int n2, int n3) {
        Image image = Image.createImage(n2, n3);
        Graphics graphics = image.getGraphics();
        this.a.drawChart(graphics, n2, n3, myDate, this.a, this.a);
        return image;
    }

    public void deleteValue(Value value) {
        this.a.a(value);
        this.regenerateTrendValuesAfter(value.date);
    }

    public void deleteDatabase() {
        this.a.deleteDatabase();
    }
}

