/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.html;

import com.sun.lwuit.Button;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.html.HTMLComponent;
import java.util.Enumeration;
import java.util.Vector;

class HTMLLink
extends Button
implements ActionListener {
    String link;
    HTMLComponent htmlC;
    Vector childLinks;
    HTMLLink parentLink;

    public HTMLLink(String text, String link, HTMLComponent htmlC, HTMLLink parentLink) {
        super(text);
        this.setUIID("HTMLLink");
        this.link = link;
        this.htmlC = htmlC;
        this.parentLink = parentLink;
        this.setTickerEnabled(false);
        this.addActionListener(this);
        this.getPressedStyle().setFont(this.getUnselectedStyle().getFont());
        if (parentLink != null) {
            this.setFocusable(false);
            parentLink.addChildLink(this);
        }
        if (htmlC.firstFocusable == null) {
            htmlC.firstFocusable = this;
        }
    }

    protected void focusGained() {
        this.setChildrenFocused(true);
    }

    protected void focusLost() {
        this.setChildrenFocused(false);
    }

    private void setChildrenFocused(boolean focused) {
        if (this.parentLink != null || this.childLinks == null) {
            return;
        }
        Enumeration e = this.childLinks.elements();
        while (e.hasMoreElements()) {
            HTMLLink child = (HTMLLink)e.nextElement();
            child.setFocus(focused);
            child.repaint();
        }
    }

    public void addChildLink(HTMLLink childLink) {
        if (this.childLinks == null) {
            this.childLinks = new Vector();
        }
        this.childLinks.addElement(childLink);
    }

    public void actionPerformed(ActionEvent evt) {
        boolean process = true;
        if (this.htmlC.getHTMLCallback() != null) {
            process = this.htmlC.getHTMLCallback().linkClicked(this.htmlC, this.htmlC.convertURL(this.link));
        }
        if (process) {
            if (!this.link.startsWith("#")) {
                this.htmlC.setPage(this.htmlC.convertURL(this.link));
            } else {
                String anchorName = this.link.substring(1);
                this.htmlC.goToAnchor(anchorName);
            }
        }
    }
}

