/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.html;

import com.sun.lwuit.Button;
import com.sun.lwuit.CheckBox;
import com.sun.lwuit.Command;
import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.Display;
import com.sun.lwuit.Font;
import com.sun.lwuit.Form;
import com.sun.lwuit.Label;
import com.sun.lwuit.List;
import com.sun.lwuit.RadioButton;
import com.sun.lwuit.TextArea;
import com.sun.lwuit.TextField;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.html.DocumentInfo;
import com.sun.lwuit.html.DocumentRequestHandler;
import com.sun.lwuit.html.Element;
import com.sun.lwuit.html.ForLabel;
import com.sun.lwuit.html.HTMLBullet;
import com.sun.lwuit.html.HTMLCallback;
import com.sun.lwuit.html.HTMLComboBox;
import com.sun.lwuit.html.HTMLFont;
import com.sun.lwuit.html.HTMLForm;
import com.sun.lwuit.html.HTMLInputFormat;
import com.sun.lwuit.html.HTMLLink;
import com.sun.lwuit.html.HTMLTable;
import com.sun.lwuit.html.HTMLTableModel;
import com.sun.lwuit.html.ImageThreadQueue;
import com.sun.lwuit.html.MultiComboBox;
import com.sun.lwuit.html.OptionItem;
import com.sun.lwuit.html.Parser;
import com.sun.lwuit.html.RedirectThread;
import com.sun.lwuit.layouts.BorderLayout;
import com.sun.lwuit.layouts.BoxLayout;
import com.sun.lwuit.layouts.FlowLayout;
import com.sun.lwuit.plaf.Border;
import com.sun.lwuit.plaf.UIManager;
import com.sun.lwuit.table.TableLayout;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class HTMLComponent
extends Container
implements ActionListener {
    private static boolean FIXED_WIDTH = true;
    static final boolean SUPPORT_INPUT_FORMAT = true;
    private static final boolean CLEAN_ON_PAGE_REQUEST = false;
    private static int INDENT_BLOCKQUOTE = 20;
    private static int INDENT_DD = 10;
    private static int INDENT_OL = 10;
    private static int INDENT_UL = 10;
    private static int MIN_MULTI_COMBOBOX_ITEMS = 4;
    private static int MAX_MULTI_COMBOBOX_ITEMS = 6;
    private static int DEFAULT_TEXTFIELD_SIZE = 20;
    private static int DEFAULT_TEXTAREA_COLS = 20;
    private static int DEFAULT_TEXTAREA_ROWS = 2;
    static final int JUSTIFY = 5;
    private static int HR_THICKNESS = 3;
    private static HTMLFont DEFAULT_FONT = new HTMLFont(null, Font.createSystemFont(0, 0, 0));
    private static int COLOR_VISITED_LINKS = 0x990099;
    static Hashtable fonts = new Hashtable();
    private static final int INPUT_CHECKBOX = 0;
    private static final int INPUT_HIDDEN = 1;
    private static final int INPUT_PASSWORD = 2;
    private static final int INPUT_RADIO = 3;
    private static final int INPUT_RESET = 4;
    private static final int INPUT_SUBMIT = 5;
    private static final int INPUT_TEXT = 6;
    private static final int INPUT_BUTTON = 7;
    private static final int INPUT_FILE = 8;
    private static final int INPUT_IMAGE = 9;
    private static String[] INPUT_TYPE_STRINGS = new String[]{"checkbox", "hidden", "password", "radio", "reset", "submit", "text", "button", "file", "image"};
    private static Vector INPUT_TYPES = new Vector();
    private static final char[] ORDERED_LIST_TYPE_IDENTIFIERS = new char[]{'1', 'A', 'a', 'I', 'i'};
    private static final int LIST_NUMERIC = 0;
    private static final int LIST_UPPERCASE = 1;
    private static final int LIST_LOWERCASE = 2;
    private static final int LIST_ROMAN_UPPER = 3;
    private static final int LIST_ROMAN_LOWER = 4;
    private static final String[] ROMAN_NUMERALS_ONES = new String[]{"", "I", "II", "III", "IV", "V", "VI", "VII", "VIII", "IX"};
    private static final String[] ROMAN_NUMERALS_TENS = new String[]{"", "X", "XX", "XXX", "XL", "L", "LX", "LXX", "LXXX", "XC"};
    private static final int BULLET_DISC = 1;
    private static final int BULLET_CIRCLE = 2;
    private static final int BULLET_SQUARE = 3;
    private boolean loadCSS;
    int contCount = 0;
    private static final int DEFAULT_BGCOLOR = 0xFFFFFF;
    private static final int DEFAULT_TEXT_COLOR = 0;
    private static final int DEFAULT_LINK_COLOR = 255;
    private int bgColor = 0xFFFFFF;
    private int textColor = 0;
    private int linkColor = 255;
    private DocumentRequestHandler handler;
    private RedirectThread redirectThread;
    private ImageThreadQueue threadQueue;
    private HTMLCallback htmlCallback;
    private DocumentInfo docInfo;
    private Element document;
    private String pageURL;
    private int pageStatus = -3;
    private boolean pageError;
    private String title;
    private int displayWidth;
    private boolean cancelled;
    private boolean cancelledCaught;
    private boolean showImages = true;
    private Hashtable accessKeys = new Hashtable();
    private Hashtable anchors;
    private Hashtable inputFields;
    Component firstFocusable;
    private HTMLFont defaultFont = DEFAULT_FONT;
    private Container mainContainer;
    private Container curContainer;
    private Container curLine;
    private int x;
    private int width;
    private int leftIndent;
    private boolean lastWasEmpty;
    private HTMLFont font;
    private String link;
    private HTMLLink mainLink;
    private char accesskey = '\u0000';
    private String anchor;
    private boolean linkVisited;
    private HTMLForm curForm;
    private TextArea curTextArea;
    private List curComboBox;
    private boolean optionTag;
    private boolean optionSelected;
    private String optionValue;
    private int ulLevel;
    private int olIndex;
    private Vector olUpperLevelIndex;
    private int listType;
    private Vector tables;
    private Vector tableCells;
    private HTMLTableModel curTable;
    private Vector fieldsets;
    private int preTagCount = 0;
    private int quoteTagCount = 0;
    private String labelForID;
    private Vector containers = new Vector();

    public static void addFont(String fontKey, Font font) {
        fonts.put(fontKey, new HTMLFont(fontKey.toLowerCase(), font));
    }

    public static void addCharEntity(String symbol, int code) {
        Parser.addCharEntity(symbol, code);
    }

    public static void addCharEntitiesRange(String[] symbols, int startcode) {
        Parser.addCharEntitiesRange(symbols, startcode);
    }

    public static void setMaxThreads(int threadsNum) {
        ImageThreadQueue.setMaxThreads(threadsNum);
    }

    public HTMLComponent(DocumentRequestHandler handler) {
        this.setLayout(new BorderLayout());
        this.handler = handler;
        this.threadQueue = new ImageThreadQueue(this);
        this.setHandlesInput(true);
        this.setScrollableY(true);
        this.setScrollableX(false);
        this.setSmoothScrolling(true);
        HTMLFont italic = new HTMLFont(null, Font.createSystemFont(0, 2, 0));
        HTMLFont monospace = new HTMLFont(null, Font.createSystemFont(32, 0, 0));
        fonts.put(Element.TAG_NAMES[13], italic);
        fonts.put(Element.TAG_NAMES[26], new HTMLFont(null, Font.createSystemFont(0, 1, 0)));
        fonts.put(Element.TAG_NAMES[11], italic);
        fonts.put(Element.TAG_NAMES[10], monospace);
        fonts.put(Element.TAG_NAMES[24], monospace);
        fonts.put(Element.TAG_NAMES[20], monospace);
        fonts.put(Element.TAG_NAMES[27], italic);
        fonts.put(Element.TAG_NAMES[9], italic);
        fonts.put(Element.TAG_NAMES[22], monospace);
        fonts.put(Element.TAG_NAMES[14], new HTMLFont(null, Font.createSystemFont(0, 1, 16)));
        fonts.put(Element.TAG_NAMES[15], new HTMLFont(null, Font.createSystemFont(0, 2, 16)));
        fonts.put(Element.TAG_NAMES[16], new HTMLFont(null, Font.createSystemFont(0, 1, 0)));
    }

    public DocumentRequestHandler getRequestHandler() {
        return this.handler;
    }

    public DocumentInfo getDocumentInfo() {
        return this.docInfo;
    }

    public void setHTMLCallback(HTMLCallback callback) {
        this.htmlCallback = callback;
    }

    public HTMLCallback getHTMLCallback() {
        return this.htmlCallback;
    }

    public void setDefaultFont(String fontKey, Font font) {
        this.defaultFont = new HTMLFont(fontKey, font);
        if (fontKey != null) {
            fonts.put(fontKey.toLowerCase(), this.defaultFont);
        }
    }

    public void setShowImages(boolean show) {
        this.showImages = show;
    }

    public void scrollPixels(int pixels, boolean animate) {
        int scrollToY = this.getScrollY() + pixels;
        this.scrollTo(scrollToY, animate);
    }

    public void scrollPages(int pages, boolean animate) {
        int scrollToY = this.getScrollY() + this.getHeight() * pages;
        this.scrollTo(scrollToY, animate);
    }

    private void scrollTo(int y, boolean animate) {
        if (y < 0) {
            y = 0;
        } else if (y > this.getPreferredH() - this.getHeight()) {
            y = this.getPreferredH() - this.getHeight();
        }
        if (animate) {
            this.scrollRectToVisible(this.getX(), y, this.getWidth(), this.getHeight(), this);
        } else {
            this.setScrollY(y);
        }
    }

    public void setBodyText(String htmlText) {
        this.setBodyText(htmlText, null);
    }

    public boolean setBodyText(String htmlText, String encoding) {
        return this.setHTML(htmlText, encoding, null, false);
    }

    public boolean setHTML(String htmlText, String encoding, String title, boolean isFullHTML) {
        boolean success = true;
        InputStreamReader isr = this.getStream(htmlText, encoding, title, isFullHTML);
        if (isr == null) {
            isr = this.getStream("Encoding error loading string", null, title, isFullHTML);
            success = false;
        }
        final InputStreamReader isReader = isr;
        new Thread(){

            public void run() {
                Element doc = Parser.getInstance().parse(isReader, HTMLComponent.this.htmlCallback);
                HTMLComponent.this.documentReady(null, doc);
            }
        }.start();
        return success;
    }

    private InputStreamReader getStream(String htmlText, String encoding) {
        return this.getStream(htmlText, encoding, null, false);
    }

    private InputStreamReader getStream(String htmlText, String encoding, String title, boolean isFullHTML) {
        if (!isFullHTML) {
            String titleStr = "";
            if (title != null) {
                titleStr = "<head><title>" + title + "</title></head>";
            }
            htmlText = "<html>" + titleStr + "<body>" + htmlText + "</body></html>";
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(htmlText.getBytes());
        InputStreamReader isr = null;
        if (encoding != null) {
            try {
                isr = new InputStreamReader((InputStream)bais, encoding);
            }
            catch (UnsupportedEncodingException uee) {
                uee.printStackTrace();
            }
        }
        if (isr == null) {
            isr = new InputStreamReader(bais);
        }
        return isr;
    }

    public void cancel() {
        this.cancelled = true;
        this.cancelRedirectsAndImages();
    }

    public void setPage(String pageURL) {
        this.setPage(new DocumentInfo(pageURL));
    }

    void setPage(final DocumentInfo docInfo) {
        this.cancelRedirectsAndImages();
        if (this.pageStatus == 0 || this.pageStatus == 1 || this.pageStatus == 2) {
            this.cancel();
            int waitTime = 0;
            while (true) {
                if (this.pageStatus == -1 || waitTime >= 2500) break;
                System.out.println("Waiting for previous page to cancel " + System.currentTimeMillis());
                try {
                    Thread.sleep(50L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                waitTime += 50;
            }
        }
        this.cancelled = false;
        this.cancelledCaught = false;
        new Thread(){

            public void run() {
                InputStreamReader isr = null;
                HTMLComponent.this.setPageStatus(0);
                try {
                    InputStream is = HTMLComponent.this.handler.resourceRequested(docInfo);
                    if (is != null) {
                        isr = new InputStreamReader(is, docInfo.getEncoding());
                    }
                }
                catch (UnsupportedEncodingException uee) {
                    boolean cont = true;
                    if (HTMLComponent.this.htmlCallback != null) {
                        cont = HTMLComponent.this.htmlCallback.parsingError(9, null, null, null, "Page encoding not supported - " + docInfo.getEncoding());
                    }
                    if (cont) {
                        isr = new InputStreamReader(HTMLComponent.this.handler.resourceRequested(docInfo));
                    }
                    isr = HTMLComponent.this.getStream("Page encoding not supported", null);
                    HTMLComponent.this.setPageStatus(-2);
                }
                if (HTMLComponent.this.cancelled) {
                    isr = HTMLComponent.this.getStream("Page loading cancelled by user", null);
                    HTMLComponent.this.setPageStatus(-1);
                }
                if (isr == null) {
                    if (HTMLComponent.this.htmlCallback != null) {
                        HTMLComponent.this.htmlCallback.parsingError(10, null, null, null, "Error connecting to stream");
                    }
                    HTMLComponent.this.setPageStatus(-2);
                    isr = HTMLComponent.this.getStream("Error connecting to stream", null);
                } else {
                    HTMLComponent.this.setPageStatus(1);
                }
                Element newDoc = null;
                try {
                    newDoc = Parser.getInstance().parse(isr, HTMLComponent.this.htmlCallback);
                }
                catch (IllegalArgumentException iae) {
                    iae.printStackTrace();
                    HTMLComponent.this.setPageStatus(-2);
                    isr = HTMLComponent.this.getStream("Parsing error " + iae.getMessage(), null);
                    newDoc = Parser.getInstance().parse(isr, HTMLComponent.this.htmlCallback);
                }
                if (HTMLComponent.this.cancelled) {
                    isr = HTMLComponent.this.getStream("Page loading cancelled by user", null);
                    newDoc = Parser.getInstance().parse(isr, HTMLComponent.this.htmlCallback);
                    HTMLComponent.this.setPageStatus(-1);
                }
                HTMLComponent.this.setPageStatus(2);
                HTMLComponent.this.documentReady(docInfo, newDoc);
            }
        }.start();
    }

    void documentReady(DocumentInfo docInfo, Element newDocument) {
        this.pageURL = null;
        if (docInfo != null) {
            this.pageURL = docInfo.getUrl();
        }
        this.docInfo = docInfo;
        this.document = newDocument;
        this.cleanup();
        this.rebuildPage();
        if (!this.cancelled || this.cancelledCaught) {
            Display.getInstance().callSerially(new Runnable(){

                public void run() {
                    int hash;
                    HTMLComponent.this.removeAll();
                    HTMLComponent.this.addComponent("Center", (Component)HTMLComponent.this.mainContainer);
                    HTMLComponent.this.setScrollY(0);
                    HTMLComponent.this.revalidate();
                    HTMLComponent.this.repaint();
                    if (HTMLComponent.this.getComponentForm() != null) {
                        if (HTMLComponent.this.firstFocusable != null && HTMLComponent.this.firstFocusable.getY() < HTMLComponent.this.getHeight()) {
                            HTMLComponent.this.getComponentForm().setFocused(HTMLComponent.this.firstFocusable);
                        } else {
                            HTMLComponent.this.getComponentForm().setFocused(HTMLComponent.this.mainContainer);
                        }
                    }
                    HTMLComponent.this.setPageStatus(3);
                    if (!HTMLComponent.this.showImages || HTMLComponent.this.threadQueue.getQueueSize() == 0) {
                        HTMLComponent.this.setPageStatus(4);
                    } else {
                        HTMLComponent.this.threadQueue.startRunning();
                    }
                    if (HTMLComponent.this.pageURL != null && (hash = HTMLComponent.this.pageURL.indexOf(35)) != -1 && HTMLComponent.this.pageURL.length() > hash + 1) {
                        String anchorName = HTMLComponent.this.pageURL.substring(hash + 1);
                        HTMLComponent.this.goToAnchor(anchorName);
                    }
                }
            });
        } else {
            this.setPageStatus(-1);
            InputStreamReader isr = this.getStream("Page loading cancelled by user", null);
            Element newDoc = Parser.getInstance().parse(isr, this.htmlCallback);
            this.documentReady(docInfo, newDoc);
        }
    }

    public String getTitle() {
        return this.title;
    }

    public String getPageURL() {
        return this.pageURL;
    }

    public int getPageStatus() {
        return this.pageStatus;
    }

    void setPageStatus(final int status) {
        if (!this.pageError || status == 0) {
            this.pageStatus = status;
            if (this.htmlCallback != null) {
                if (Display.getInstance().isEdt()) {
                    this.htmlCallback.pageStatusChanged(this, status, this.pageURL);
                } else {
                    Display.getInstance().callSerially(new Runnable(){

                        public void run() {
                            HTMLComponent.this.htmlCallback.pageStatusChanged(HTMLComponent.this, status, HTMLComponent.this.pageURL);
                        }
                    });
                }
            }
            this.pageError = status == -2 || status == -1;
            this.cancelledCaught = status == -1;
        }
    }

    private HTMLFont getCounterpartFont(int tag, HTMLFont font) {
        int attribute = -1;
        switch (tag) {
            case 55: {
                attribute = 0;
                break;
            }
            case 56: {
                attribute = 1;
                break;
            }
            case 57: {
                attribute = 2;
                break;
            }
            case 58: {
                attribute = 3;
            }
        }
        if (attribute == -1) {
            return font;
        }
        HTMLFont cFont = font.getCounterpartFont(attribute);
        if (cFont != null) {
            return cFont;
        }
        HTMLFont bestFit = null;
        Enumeration e = fonts.elements();
        while (e.hasMoreElements()) {
            HTMLFont hFont = (HTMLFont)e.nextElement();
            if (!hFont.isCounterpart(attribute, font)) continue;
            if (attribute == 2) {
                if (bestFit != null && bestFit.getSize() <= hFont.getSize()) continue;
                bestFit = hFont;
                continue;
            }
            if (attribute == 3) {
                if (bestFit != null && bestFit.getSize() >= hFont.getSize()) continue;
                bestFit = hFont;
                continue;
            }
            font.setCounterpartFont(attribute, hFont);
            return hFont;
        }
        if (bestFit == null) {
            bestFit = font;
        }
        font.setCounterpartFont(attribute, bestFit);
        return bestFit;
    }

    private void cleanup() {
        this.displayWidth = Display.getInstance().getDisplayWidth();
        this.leftIndent = 0;
        this.x = 0;
        this.containers = new Vector();
        this.anchors = new Hashtable();
        this.anchor = null;
        this.accesskey = '\u0000';
        Enumeration e = this.accessKeys.keys();
        while (e.hasMoreElements()) {
            int keyCode = (Integer)e.nextElement();
            this.getComponentForm().removeKeyListener(keyCode, this);
        }
        this.accessKeys = new Hashtable();
        this.fieldsets = new Vector();
        this.curTable = null;
        this.tables = new Vector();
        this.tableCells = new Vector();
        this.ulLevel = 0;
        this.olIndex = Integer.MIN_VALUE;
        this.olUpperLevelIndex = new Vector();
        this.listType = 0;
        this.font = this.defaultFont;
        this.labelForID = null;
        this.inputFields = new Hashtable();
        this.link = null;
        this.linkVisited = false;
        this.mainLink = null;
        this.firstFocusable = null;
        this.curForm = null;
        this.curTextArea = null;
        this.curComboBox = null;
        this.optionTag = false;
        this.optionSelected = false;
        this.preTagCount = 0;
        this.quoteTagCount = 0;
        this.mainContainer = new Container();
        this.mainContainer.setScrollableX(false);
        this.mainContainer.setLayout(new BoxLayout(2));
        this.curContainer = this.mainContainer;
        this.curLine = new Container();
        this.lastWasEmpty = false;
        this.width = Display.getInstance().getDisplayWidth() - this.getStyle().getMargin(1) - this.getStyle().getPadding(1) - this.getStyle().getMargin(3) - this.getStyle().getPadding(3) - 10;
    }

    private void rebuildPage() {
        Element html = this.document.getChildById(2);
        Element body = null;
        Element head = null;
        if (html != null) {
            String dir = html.getAttributeById(59);
            UIManager.getInstance().getLookAndFeel().setRTL(dir != null && dir.equals("rtl"));
            body = html.getChildById(0);
            head = html.getChildById(1);
        }
        this.title = null;
        if (head != null) {
            Element titleText;
            Element titleTag;
            String baseURL;
            Element baseTag = head.getChildById(51);
            if (baseTag != null && (baseURL = baseTag.getAttributeById(14)) != null && this.docInfo != null) {
                this.docInfo.setBaseURL(baseURL);
            }
            if ((titleTag = head.getChildById(3)) != null && (titleText = titleTag.getChildById(60)) != null) {
                this.title = titleText.getAttributeById(3);
            }
        }
        if (this.htmlCallback != null) {
            Display.getInstance().callSerially(new Runnable(){

                public void run() {
                    HTMLComponent.this.htmlCallback.titleUpdated(HTMLComponent.this, HTMLComponent.this.title);
                }
            });
        }
        if (body != null) {
            this.bgColor = Element.getColor(body.getAttributeById(7), 0xFFFFFF);
            this.textColor = Element.getColor(body.getAttributeById(9), 0);
            this.linkColor = Element.getColor(body.getAttributeById(8), 255);
            this.mainContainer.getStyle().setBgColor(this.bgColor);
            this.mainContainer.getStyle().setBgTransparency(255);
            this.processTag(body, 1);
            if (this.loadCSS) {
                body.setAssociatedComponents(this.mainContainer);
            }
            this.newLine(1);
        } else {
            System.out.println("no BODY tag was found in page.");
        }
        if (!this.cancelled) {
            this.checkRedirect(head);
        }
    }

    private void checkRedirect(Element head) {
        String content;
        String httpequiv;
        Element meta;
        if (head != null && (meta = head.getChildById(49)) != null && (httpequiv = meta.getAttributeById(55)) != null && httpequiv.equalsIgnoreCase("refresh") && (content = meta.getAttributeById(54)) != null) {
            int seperator = content.indexOf(59);
            String redirectURL = null;
            if (seperator != -1) {
                String tempUrl = content.substring(seperator + 1);
                redirectURL = "";
                for (int i = 0; i < tempUrl.length(); ++i) {
                    char ch = tempUrl.charAt(i);
                    if (Parser.isWhiteSpace(ch)) continue;
                    redirectURL = redirectURL + ch;
                }
                if (redirectURL.startsWith("url=")) {
                    redirectURL = redirectURL.substring(4);
                }
                content = content.substring(0, seperator);
            }
            int redirectTime = -1;
            try {
                redirectTime = Integer.parseInt(content);
                this.redirectThread = new RedirectThread(this, redirectTime, redirectURL);
                new Thread(this.redirectThread).start();
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
    }

    void cancelRedirectsAndImages() {
        if (this.redirectThread != null) {
            this.redirectThread.cancel();
            this.redirectThread = null;
        }
        this.threadQueue.discardQueue();
    }

    private void newLine(int align) {
        if (this.curLine.getPreferredH() == 0) {
            this.curLine.setPreferredH(this.font.getHeight());
        }
        this.lastWasEmpty = this.curLine.getComponentCount() == 0;
        this.curContainer.addComponent(this.curLine);
        this.curLine = new Container();
        this.curLine.getStyle().setBgTransparency(0);
        if (!FIXED_WIDTH) {
            this.curLine.setLayout(new FlowLayout(align));
        }
        this.curLine.setScrollableX(false);
        this.curLine.getStyle().setMargin(1, this.leftIndent);
        this.x = this.leftIndent;
    }

    private void newLineIfNotEmpty(int align) {
        if (this.curLine.getComponentCount() > 0) {
            this.newLine(align);
        }
    }

    private void newLineIfLastWasNotEmpty(int align) {
        if (!this.lastWasEmpty) {
            this.newLine(align);
        }
    }

    private void showPreTagText(String text, int align) {
        if (text == null || text.equals("")) {
            return;
        }
        String line = "";
        for (int c = 0; c < text.length(); ++c) {
            char ch = text.charAt(c);
            if (ch == '\n') {
                this.addString(line, align);
                this.newLine(align);
                line = "";
                continue;
            }
            line = line + ch;
        }
    }

    private Vector getWords(String text, int align, boolean returnComps) {
        Vector<Object> words = new Vector<Object>();
        String word = "";
        for (int c = 0; c < text.length(); ++c) {
            char ch = text.charAt(c);
            if (ch == ' ' || ch == '\n' || ch == '\r' || ch == '\t' || ch == '\n') {
                if (word.equals("")) continue;
                if (returnComps) {
                    words.addElement(this.addString(word + ' ', align));
                } else {
                    words.addElement(word);
                }
                word = "";
                continue;
            }
            if (!returnComps && this.font.stringWidth(word + ch) > this.width - this.leftIndent) {
                words.addElement(word);
                word = "" + ch;
                continue;
            }
            word = word + ch;
        }
        if (!word.equals("")) {
            if (returnComps) {
                words.addElement(this.addString(word, align));
            } else {
                words.addElement(word);
            }
        }
        return words;
    }

    private Vector showText(String text, int align) {
        return this.getWords(text, align, true);
    }

    private Vector showTextFixedWidth(String text, int align) {
        Vector<Label> comps = new Vector<Label>();
        if (text == null || text.equals("")) {
            return comps;
        }
        int spaceW = this.width - this.x;
        Vector words = this.getWords(text, align, false);
        if (words.size() > 0) {
            int w = 0;
            String wordStr = "";
            if (Parser.isWhiteSpace(text.charAt(0)) && this.curLine.getComponentCount() != 0) {
                wordStr = " ";
            }
            while (w < words.size()) {
                String nextWord = (String)words.elementAt(w);
                String space = "";
                if (!wordStr.equals("") && !wordStr.equals(" ")) {
                    space = " ";
                }
                if (this.font.stringWidth(wordStr + space + nextWord) > spaceW - 2) {
                    comps.addElement(this.addString(wordStr, align));
                    this.newLineIfNotEmpty(align);
                    spaceW = this.width - this.x;
                    wordStr = nextWord;
                } else {
                    wordStr = wordStr + space + nextWord;
                }
                ++w;
            }
            if (Parser.isWhiteSpace(text.charAt(text.length() - 1))) {
                wordStr = wordStr + " ";
            }
            comps.addElement(this.addString(wordStr, align));
        }
        return comps;
    }

    private Label addString(String str, int align) {
        Label lbl = null;
        int color = this.textColor;
        if (this.link != null) {
            lbl = new HTMLLink(str, this.link, this, this.mainLink);
            color = this.linkColor;
            if (this.linkVisited) {
                color = COLOR_VISITED_LINKS;
            }
            lbl.getSelectedStyle().setFont(this.font.getFont());
            if (this.mainLink == null) {
                this.mainLink = (HTMLLink)lbl;
            }
            if (this.accesskey != '\u0000') {
                this.addAccessKey(this.accesskey, lbl);
            }
            lbl.getSelectedStyle().setMargin(0, 0, 0, 0);
            lbl.getSelectedStyle().setPadding(0, 0, 0, 0);
        } else if (this.labelForID != null) {
            lbl = new ForLabel(str, this, this.labelForID);
            if (this.accesskey != '\u0000') {
                this.addAccessKey(this.accesskey, lbl);
            }
        } else {
            lbl = new Label(str);
        }
        lbl.getStyle().setMargin(0, 0, 0, 0);
        lbl.getStyle().setPadding(0, 0, 0, 0);
        lbl.getUnselectedStyle().setFgColor(color);
        lbl.getSelectedStyle().setFgColor(color);
        lbl.getUnselectedStyle().setFont(this.font.getFont());
        lbl.setGap(0);
        lbl.setTickerEnabled(false);
        lbl.setEndsWith3Points(false);
        if (align != 5) {
            lbl.setAlignment(align);
        }
        lbl.getUnselectedStyle().setBgTransparency(0);
        this.curLine.addComponent(lbl);
        if (this.anchor != null) {
            this.anchors.put(this.anchor, lbl);
        }
        if (FIXED_WIDTH) {
            if (align != 1) {
                if (align == 5) {
                    Vector words = this.getWords(str, align, false);
                    if (words.size() > 1) {
                        int spaceW = this.font.getFont().stringWidth(" ");
                        int spacesToAdd = (this.width - lbl.getPreferredW()) / spaceW;
                        int spacesPerWord = spacesToAdd / (words.size() - 1);
                        int addtlSpaces = spacesToAdd % (words.size() - 1);
                        String newStr = (String)words.elementAt(0);
                        for (int i = 1; i < words.size(); ++i) {
                            for (int j = 0; j < spacesPerWord; ++j) {
                                newStr = newStr + ' ';
                            }
                            if (i <= addtlSpaces) {
                                newStr = newStr + ' ';
                            }
                            newStr = newStr + ' ' + (String)words.elementAt(i);
                        }
                        lbl.setText(newStr);
                    }
                } else {
                    lbl.setPreferredW(this.width);
                }
                this.x = this.width;
                this.newLine(align);
            } else {
                this.x += lbl.getPreferredW();
            }
        }
        return lbl;
    }

    void addAccessKey(int accessKey, Component cmp) {
        this.accessKeys.put(new Integer(accessKey), cmp);
        Form form = this.getComponentForm();
        if (form != null) {
            form.addKeyListener(accessKey, this);
        }
    }

    protected void initComponent() {
        super.initComponent();
        Enumeration e = this.accessKeys.keys();
        while (e.hasMoreElements()) {
            int keyCode = (Integer)e.nextElement();
            this.getComponentForm().addKeyListener(keyCode, this);
        }
    }

    private void handleImage(Element imgElement, int align, Command cmd) {
        String imageUrl = imgElement.getAttributeById(30);
        Label imgLabel = null;
        if (imageUrl != null) {
            String alignStr = imgElement.getAttributeById(6);
            int iWidth = this.calcSize(this.getWidth(), imgElement.getAttributeById(23), 0);
            int iHeight = this.calcSize(this.getHeight(), imgElement.getAttributeById(24), 0);
            int hspace = this.getInt(imgElement.getAttributeById(26));
            int vspace = this.getInt(imgElement.getAttributeById(27));
            int totalWidth = iWidth + hspace * 2;
            if (FIXED_WIDTH && this.x + totalWidth >= this.width) {
                this.newLine(align);
            }
            String altText = imgElement.getAttributeById(25);
            if (this.link != null) {
                imgLabel = new HTMLLink(altText, this.link, this, this.mainLink);
                if (this.mainLink == null) {
                    this.mainLink = (HTMLLink)imgLabel;
                }
                if (this.accesskey != '\u0000') {
                    this.addAccessKey(this.accesskey, imgLabel);
                }
                ((Button)imgLabel).getPressedStyle().setPadding(vspace + 1, vspace + 1, hspace + 1, hspace + 1);
            } else if (cmd != null) {
                imgLabel = new Button(cmd);
                if (altText != null && !altText.equals("")) {
                    imgLabel.setText(altText);
                }
                if (this.firstFocusable == null) {
                    this.firstFocusable = imgLabel;
                }
            } else {
                imgLabel = new Label(altText);
            }
            imgLabel.setPreferredSize(new Dimension(iWidth, iHeight));
            imgLabel.getSelectedStyle().setPadding(vspace, vspace, hspace, hspace);
            imgLabel.getUnselectedStyle().setPadding(vspace, vspace, hspace, hspace);
            imgLabel.getUnselectedStyle().setBorder(Border.createLineBorder(1));
            imgLabel.getSelectedStyle().setBorder(Border.createLineBorder(1));
            this.curLine.addComponent(imgLabel);
            this.x += totalWidth;
            imgLabel.setAlignment(this.getHorizAlign(alignStr, align, false));
            imgLabel.setVerticalAlignment(this.getVertAlign(alignStr, 4));
            if (this.showImages) {
                if (this.docInfo != null) {
                    imageUrl = this.docInfo.convertURL(imageUrl);
                }
                this.threadQueue.add(imgLabel, imageUrl);
            }
            if (this.loadCSS) {
                imgElement.setAssociatedComponents(imgElement);
            }
        }
    }

    private void handleInput(Element element, int align) {
        String type = element.getAttributeById(19);
        if (type == null) {
            return;
        }
        int typeID = INPUT_TYPES.indexOf(type.toLowerCase());
        String name = element.getAttributeById(37);
        String id = element.getAttributeById(1);
        String value = element.getAttributeById(38);
        if (typeID == -1) {
            return;
        }
        if (value == null) {
            value = "";
        }
        Component cmp = null;
        switch (typeID) {
            case 0: {
                CheckBox cb = new CheckBox();
                if (element.getAttributeById(32) != null) {
                    cb.setSelected(true);
                }
                cmp = cb;
                if (this.curForm == null) break;
                this.curForm.addCheckBox(name, cb, value);
                break;
            }
            case 1: {
                if (this.curForm == null) break;
                this.curForm.addInput(name, value, null);
                break;
            }
            case 2: 
            case 6: {
                HTMLInputFormat inputFormat;
                TextField tf = new TextField(value);
                if (typeID == 2) {
                    tf.setConstraint(65536);
                }
                if ((inputFormat = HTMLInputFormat.getInputFormat(element.getAttributeById(34))) != null) {
                    tf = (TextField)inputFormat.applyConstraints(tf);
                    if (this.curForm != null) {
                        this.curForm.setInputFormat(tf, inputFormat);
                    }
                }
                int size = this.getInt(element.getAttributeById(31));
                int maxlen = this.getInt(element.getAttributeById(36));
                if (size == 0) {
                    size = DEFAULT_TEXTFIELD_SIZE;
                }
                if (maxlen != 0) {
                    tf.setMaxSize(maxlen);
                    if (size > maxlen) {
                        size = maxlen;
                    }
                }
                tf.setPreferredW(tf.getStyle().getFont().stringWidth("W") * size);
                tf.getSelectedStyle().setFont(this.font.getFont());
                tf.getUnselectedStyle().setFont(this.font.getFont());
                cmp = tf;
                if (this.curForm == null) break;
                this.curForm.addInput(name, cmp, value);
                break;
            }
            case 3: {
                RadioButton rb = new RadioButton(" ");
                if (element.getAttributeById(32) != null) {
                    rb.setSelected(true);
                }
                cmp = rb;
                if (this.curForm == null) break;
                this.curForm.addRadioButton(name, rb, value);
                break;
            }
            case 7: {
                break;
            }
            case 4: {
                Command resetCmd = null;
                if (this.curForm != null) {
                    if (!value.equals("")) {
                        this.curForm.setResetText(value);
                    }
                    resetCmd = this.curForm.getResetCommand();
                }
                if (resetCmd == null) {
                    resetCmd = new Command(HTMLForm.getDefaultResetText());
                }
                Button resetButton = new Button(resetCmd);
                cmp = resetButton;
                break;
            }
            case 5: {
                Command submitCmd = null;
                if (this.curForm != null) {
                    if (!value.equals("")) {
                        this.curForm.setSubmitText(value);
                    }
                    submitCmd = this.curForm.getSubmitCommand();
                    this.curForm.hasSubmitButton = true;
                }
                if (submitCmd == null) {
                    submitCmd = new Command(HTMLForm.getDefaultSubmitText());
                }
                Button submitButton = new Button(submitCmd);
                cmp = submitButton;
                break;
            }
            case 9: {
                Command submitCmd = null;
                if (this.curForm != null) {
                    submitCmd = this.curForm.getSubmitCommand();
                    this.curForm.hasSubmitButton = true;
                }
                this.handleImage(element, align, submitCmd);
                break;
            }
        }
        if (cmp != null) {
            String aKey = element.getAttributeById(12);
            if (aKey != null && aKey.length() == 1) {
                this.addAccessKey(aKey.charAt(0), cmp);
            }
            if (this.loadCSS) {
                element.setAssociatedComponents(cmp);
            }
            if (this.curForm != null && this.curForm.action == null) {
                cmp.setEnabled(false);
            } else if (this.firstFocusable == null) {
                this.firstFocusable = cmp;
            }
            if (id != null) {
                this.inputFields.put(id, cmp);
            }
        }
        this.addCmp(cmp, align);
    }

    private void addCmp(Component cmp, int align) {
        if (cmp != null) {
            if (FIXED_WIDTH && this.x + cmp.getPreferredW() > this.width) {
                this.newLine(align);
            }
            this.curLine.addComponent(cmp);
            this.x += cmp.getPreferredW();
        }
    }

    private void updateMargin(int delta) {
        this.leftIndent += delta;
        this.x += delta;
        this.curLine.getStyle().setMargin(1, this.leftIndent);
    }

    private void handleTableCell(Element tdTag, int align) {
        String cHeight;
        int pH;
        Element tableTag;
        this.newLineIfNotEmpty(align);
        this.tableCells.addElement(this.curContainer);
        Container cell = new Container();
        cell.setLayout(new BoxLayout(2));
        int border = 0;
        Element trTag = tdTag.getParent();
        if (trTag != null && (tableTag = trTag.getParent()) != null) {
            border = this.getInt(tableTag.getAttributeById(60));
        }
        cell.getUnselectedStyle().setPadding(border, border, border, border);
        cell.getSelectedStyle().setPadding(border, border, border, border);
        TableLayout.Constraint constraint = new TableLayout.Constraint();
        int halign = this.getHorizAlign(tdTag.getParent().getAttributeById(6), align, false);
        int valign = this.getVertAlign(tdTag.getParent().getAttributeById(49), 4);
        halign = this.getHorizAlign(tdTag.getAttributeById(6), halign, false);
        valign = this.getVertAlign(tdTag.getAttributeById(49), valign);
        int colspan = this.getInt(tdTag.getAttributeById(45));
        int rowspan = this.getInt(tdTag.getAttributeById(47));
        String cWidth = tdTag.getAttributeById(23);
        int pW = this.getPercentage(cWidth);
        if ((pW <= 0 || pW >= 100) && (pW = this.getInt(cWidth)) != 0) {
            cell.setPreferredW(pW);
        }
        if (((pH = this.getPercentage(cHeight = tdTag.getAttributeById(24))) <= 0 || pH >= 100) && (pH = this.getInt(cHeight)) != 0) {
            cell.setPreferredH(pH);
        }
        constraint.setHorizontalAlign(halign);
        constraint.setVerticalAlign(valign);
        this.curContainer = cell;
        if (this.curTable != null) {
            this.curTable.addCell(cell, tdTag.getId() == 44, constraint);
        }
        if (this.loadCSS) {
            tdTag.setAssociatedComponents(cell);
        }
    }

    private void processTag(Element element, int align) {
        if (this.cancelled && !this.cancelledCaught) {
            return;
        }
        int curAlign = align;
        HTMLFont oldFont = this.font;
        block57: for (int i = 0; i < element.getNumChildren() && (!this.cancelled || this.cancelledCaught); ++i) {
            Element child = element.getChildAt(i);
            switch (child.getId()) {
                case 60: {
                    String text = child.getAttributeById(3);
                    if (this.curComboBox != null && this.optionTag) {
                        OptionItem oi = new OptionItem(text, this.optionValue);
                        this.curComboBox.addItem(oi);
                        if (!this.optionSelected) break;
                        this.curComboBox.setSelectedItem(oi);
                        if (this.curForm == null) break;
                        this.curForm.setDefaultValue(this.curComboBox, oi);
                        break;
                    }
                    if (this.curTextArea != null) {
                        this.curTextArea.setText(text);
                        if (this.curForm == null) break;
                        this.curForm.setDefaultValue(this.curTextArea, text);
                        break;
                    }
                    if (this.preTagCount != 0) {
                        this.showPreTagText(text, curAlign);
                        break;
                    }
                    Vector comps = null;
                    comps = FIXED_WIDTH ? this.showTextFixedWidth(text, curAlign) : this.showText(text, curAlign);
                    if (!this.loadCSS) break;
                    child.setAssociatedComponents(comps);
                    break;
                }
                case 28: {
                    String aKey;
                    this.link = child.getAttributeById(14);
                    if (this.link != null && this.htmlCallback != null) {
                        int linkProps = this.htmlCallback.getLinkProperties(this, this.convertURL(this.link));
                        if ((linkProps & 2) != 0) {
                            this.link = null;
                        } else if ((linkProps & 1) != 0) {
                            this.linkVisited = true;
                        }
                    }
                    this.anchor = child.getAttributeById(37);
                    if (this.link == null || (aKey = child.getAttributeById(12)) == null || aKey.length() != 1) break;
                    this.accesskey = aKey.charAt(0);
                    break;
                }
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: {
                    this.font = (HTMLFont)fonts.get(child.getName());
                    if (this.font == null) {
                        this.font = oldFont;
                    }
                }
                case 21: {
                    curAlign = this.getHorizAlign(child.getAttributeById(6), align, true);
                    this.adjustAlignment(align, curAlign);
                    this.newLineIfNotEmpty(curAlign);
                    this.newLineIfLastWasNotEmpty(curAlign);
                    this.pushContainer(child);
                    break;
                }
                case 12: {
                    curAlign = this.getHorizAlign(child.getAttributeById(6), align, true);
                    this.adjustAlignment(align, curAlign);
                    this.newLineIfNotEmpty(curAlign);
                    this.pushContainer(child);
                    break;
                }
                case 59: {
                    this.newLineIfNotEmpty(curAlign);
                    Container newCont = new Container();
                    newCont.setUIID("HTMLFieldset");
                    if (this.fieldsets.size() == 0) {
                        newCont.getStyle().setMargin(1, 0);
                    }
                    newCont.setLayout(new BoxLayout(2));
                    this.curContainer.addComponent(newCont);
                    this.fieldsets.addElement(this.curContainer);
                    this.curContainer = newCont;
                    if (!this.loadCSS) break;
                    child.setAssociatedComponents(newCont);
                    break;
                }
                case 8: {
                    if (this.loadCSS) {
                        child.setAssociatedComponents(this.curLine);
                    }
                    this.newLine(curAlign);
                    break;
                }
                case 29: {
                    this.newLineIfNotEmpty(curAlign);
                    this.newLine(curAlign);
                    this.pushContainer(child);
                    break;
                }
                case 30: {
                    this.newLineIfNotEmpty(curAlign);
                    this.pushContainer(child);
                    break;
                }
                case 33: {
                    this.newLineIfNotEmpty(curAlign);
                    ++this.ulLevel;
                    this.updateMargin(INDENT_UL);
                    if (this.ulLevel == 1 && this.olIndex == Integer.MIN_VALUE) {
                        this.newLine(curAlign);
                    }
                    this.pushContainer(child);
                    break;
                }
                case 32: {
                    this.newLineIfNotEmpty(curAlign);
                    if (this.olIndex != Integer.MIN_VALUE) {
                        String indexStr = ORDERED_LIST_TYPE_IDENTIFIERS[this.listType] + "" + this.olIndex;
                        this.olUpperLevelIndex.addElement(indexStr);
                    }
                    this.olIndex = this.getInt(child.getAttributeById(50), 1);
                    this.listType = this.getOrderedListType(child);
                    this.updateMargin(INDENT_OL);
                    if (this.olUpperLevelIndex.size() == 0 && this.ulLevel == 0) {
                        this.newLine(curAlign);
                    }
                    this.pushContainer(child);
                    break;
                }
                case 34: {
                    this.pushContainer(child);
                    if (child.getParent().getId() == 32) {
                        this.olIndex = this.getInt(child.getAttributeById(38), this.olIndex);
                        int itemListType = this.getOrderedListType(child, this.listType);
                        this.showTextFixedWidth(this.getListIndexString(this.olIndex, itemListType) + ". ", align);
                        break;
                    }
                    this.addCmp(new HTMLBullet(this.getUnorderedListType(child, this.ulLevel), this.font.getFont().getHeight(), this.textColor), curAlign);
                    break;
                }
                case 7: {
                    this.newLineIfNotEmpty(curAlign);
                    this.updateMargin(INDENT_BLOCKQUOTE);
                    this.newLine(curAlign);
                    this.pushContainer(child);
                    break;
                }
                case 31: {
                    this.newLineIfNotEmpty(curAlign);
                    this.updateMargin(INDENT_DD);
                    this.pushContainer(child);
                    break;
                }
                case 52: {
                    this.newLineIfNotEmpty(curAlign);
                    Label hr = new Label();
                    hr.setUIID("HTMLHR");
                    int hrWidth = this.calcSize(this.width, child.getAttributeById(23), this.width);
                    int hrHeight = this.getInt(child.getAttributeById(31), HR_THICKNESS);
                    hr.setPreferredW(hrWidth);
                    hr.setPreferredH(hrHeight);
                    this.curLine.addComponent(hr);
                    this.newLine(curAlign);
                    if (!this.loadCSS) break;
                    child.setAssociatedComponents(hr);
                    break;
                }
                case 46: {
                    this.handleImage(child, curAlign, null);
                    break;
                }
                case 22: {
                    ++this.preTagCount;
                    this.pushContainer(child);
                }
                case 9: 
                case 10: 
                case 11: 
                case 13: 
                case 20: 
                case 24: 
                case 26: 
                case 27: {
                    this.font = (HTMLFont)fonts.get(child.getName());
                    if (this.font != null) break;
                    this.font = oldFont;
                    break;
                }
                case 55: 
                case 56: 
                case 57: 
                case 58: {
                    this.font = this.getCounterpartFont(child.getId(), this.font);
                    break;
                }
                case 35: {
                    this.curForm = new HTMLForm(this, child.getAttributeById(20), child.getAttributeById(22), child.getAttributeById(21));
                    this.pushContainer(child);
                    break;
                }
                case 36: {
                    this.handleInput(child, curAlign);
                    break;
                }
                case 38: {
                    String multi = child.getAttributeById(41);
                    if (multi != null) {
                        this.curComboBox = new MultiComboBox(true);
                        Container comboCont = new Container(new BorderLayout());
                        this.curComboBox.setItemGap(0);
                        comboCont.setUIID("ComboBox");
                        this.curComboBox.setUIID("List");
                        comboCont.addComponent("Center", (Component)this.curComboBox);
                    } else {
                        this.curComboBox = new HTMLComboBox();
                    }
                    String name = child.getAttributeById(37);
                    if (this.curForm != null) {
                        this.curForm.addInput(name, this.curComboBox, null);
                    }
                    if (!this.loadCSS) break;
                    child.setAssociatedComponents(this.curComboBox);
                    break;
                }
                case 53: {
                    String label;
                    if (this.curComboBox == null || (label = child.getAttributeById(52)) == null) break;
                    this.curComboBox.addItem(label);
                    break;
                }
                case 39: {
                    this.optionTag = true;
                    this.optionValue = child.getAttributeById(38);
                    if (this.curComboBox == null || child.getAttributeById(42) == null) break;
                    this.optionSelected = true;
                    break;
                }
                case 40: {
                    String aKey;
                    this.curTextArea = new TextArea(this.getInt(child.getAttributeById(58), DEFAULT_TEXTAREA_ROWS), this.getInt(child.getAttributeById(57), DEFAULT_TEXTAREA_COLS));
                    this.addCmp(this.curTextArea, curAlign);
                    if (this.loadCSS) {
                        child.setAssociatedComponents(this.curTextArea);
                    }
                    if ((aKey = element.getAttributeById(12)) == null || aKey.length() != 1) break;
                    this.addAccessKey(aKey.charAt(0), this.curTextArea);
                    break;
                }
                case 23: {
                    this.addQuote(curAlign);
                    ++this.quoteTagCount;
                    break;
                }
                case 42: {
                    this.newLineIfNotEmpty(curAlign);
                    if (this.curTable != null) {
                        HTMLTableModel newTable;
                        this.tables.addElement(this.curTable);
                        this.curTable = newTable = new HTMLTableModel();
                    } else {
                        this.curTable = new HTMLTableModel();
                    }
                    this.width /= 2;
                    break;
                }
                case 45: {
                    break;
                }
                case 43: 
                case 44: {
                    if (this.curTable == null) break;
                    this.handleTableCell(child, curAlign);
                    break;
                }
                case 37: {
                    this.labelForID = child.getAttributeById(39);
                    String aKey = child.getAttributeById(12);
                    if (aKey == null || aKey.length() != 1) break;
                    this.accesskey = aKey.charAt(0);
                }
            }
            if (child.getNumChildren() > 0) {
                this.processTag(child, curAlign);
            }
            switch (child.getId()) {
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: {
                    this.font = oldFont;
                }
                case 21: {
                    curAlign = align;
                    this.newLineIfNotEmpty(curAlign);
                    this.popContainer();
                    this.newLine(curAlign);
                    continue block57;
                }
                case 12: {
                    curAlign = align;
                    this.newLineIfNotEmpty(curAlign);
                    this.popContainer();
                    continue block57;
                }
                case 59: {
                    Container upperContainer;
                    this.newLineIfNotEmpty(curAlign);
                    this.curContainer = upperContainer = (Container)this.fieldsets.lastElement();
                    this.fieldsets.removeElement(this.curContainer);
                    continue block57;
                }
                case 7: {
                    this.newLineIfNotEmpty(curAlign);
                    this.newLine(curAlign);
                    this.updateMargin(-INDENT_BLOCKQUOTE);
                    this.popContainer();
                    continue block57;
                }
                case 30: {
                    this.popContainer();
                    continue block57;
                }
                case 31: {
                    this.newLineIfNotEmpty(curAlign);
                    this.updateMargin(-INDENT_DD);
                    this.popContainer();
                    continue block57;
                }
                case 29: {
                    this.newLine(curAlign);
                    this.popContainer();
                    continue block57;
                }
                case 28: {
                    this.link = null;
                    this.linkVisited = false;
                    this.mainLink = null;
                    this.anchor = null;
                    this.accesskey = '\u0000';
                    continue block57;
                }
                case 33: {
                    --this.ulLevel;
                    if (this.ulLevel == 0 && this.olIndex == Integer.MIN_VALUE) {
                        this.newLine(curAlign);
                    }
                    this.updateMargin(-INDENT_UL);
                    this.popContainer();
                    continue block57;
                }
                case 32: {
                    if (this.olUpperLevelIndex.size() != 0) {
                        String indexStr = (String)this.olUpperLevelIndex.lastElement();
                        this.olUpperLevelIndex.removeElementAt(this.olUpperLevelIndex.size() - 1);
                        this.listType = this.getOrderedListType(indexStr.charAt(0), 0);
                        this.olIndex = this.getInt(indexStr.substring(1));
                    } else {
                        this.olIndex = Integer.MIN_VALUE;
                    }
                    if (this.olIndex == Integer.MIN_VALUE && this.ulLevel == 0) {
                        this.newLine(curAlign);
                    }
                    this.updateMargin(-INDENT_OL);
                    this.popContainer();
                    continue block57;
                }
                case 34: {
                    if (this.olIndex != Integer.MIN_VALUE) {
                        ++this.olIndex;
                    }
                    this.newLine(curAlign);
                    this.popContainer();
                    continue block57;
                }
                case 22: {
                    --this.preTagCount;
                    this.popContainer();
                }
                case 9: 
                case 10: 
                case 11: 
                case 13: 
                case 20: 
                case 24: 
                case 26: 
                case 27: 
                case 55: 
                case 56: 
                case 57: 
                case 58: {
                    this.font = oldFont;
                    continue block57;
                }
                case 35: {
                    if (this.curForm != null && !this.curForm.hasSubmitButton && this.curForm.getNumFields() > 0) {
                        Button submitButton = new Button(this.curForm.getSubmitCommand());
                        this.addCmp(submitButton, curAlign);
                        this.curForm.hasSubmitButton = true;
                    }
                    this.curForm = null;
                    this.popContainer();
                    continue block57;
                }
                case 40: {
                    String name = child.getAttributeById(37);
                    if (this.curForm != null) {
                        this.curForm.addInput(name, this.curTextArea, null);
                    }
                    this.curTextArea = null;
                    continue block57;
                }
                case 38: {
                    if (this.curComboBox instanceof MultiComboBox) {
                        Container comboCont = this.curComboBox.getParent();
                        int minSize = Math.min(MIN_MULTI_COMBOBOX_ITEMS, this.curComboBox.size());
                        int maxSize = Math.min(this.curComboBox.size(), MAX_MULTI_COMBOBOX_ITEMS);
                        int size = Math.min(maxSize, Math.max(this.getInt(child.getAttributeById(31)), minSize));
                        Component renderCmp = this.curComboBox.getRenderer().getListCellRendererComponent(this.curComboBox, "X", 0, false);
                        comboCont.setPreferredH((renderCmp.getPreferredH() + renderCmp.getStyle().getMargin(0) + renderCmp.getStyle().getMargin(2) + this.curComboBox.getItemGap()) * size + this.curComboBox.getStyle().getPadding(0) + this.curComboBox.getStyle().getPadding(2));
                        comboCont.setPreferredW(100);
                        this.addCmp(comboCont, curAlign);
                    } else {
                        this.addCmp(this.curComboBox, curAlign);
                    }
                    this.curComboBox = null;
                    continue block57;
                }
                case 39: {
                    this.optionTag = false;
                    this.optionSelected = false;
                    this.optionValue = null;
                    continue block57;
                }
                case 23: {
                    --this.quoteTagCount;
                    this.addQuote(curAlign);
                    continue block57;
                }
                case 42: {
                    this.newLineIfNotEmpty(curAlign);
                    this.curTable.commitRowIfNotEmpty();
                    if (this.curTable.getRowCount() != 0) {
                        int border;
                        HTMLTable table = new HTMLTable(this.curTable);
                        if (this.loadCSS) {
                            child.setAssociatedComponents(table);
                        }
                        if ((border = this.getInt(child.getAttributeById(60))) > 0) {
                            table.getUnselectedStyle().setBorder(Border.createLineBorder(border));
                            table.getSelectedStyle().setBorder(Border.createLineBorder(border));
                            table.getUnselectedStyle().setPadding(border, border, border, border);
                            table.getSelectedStyle().setPadding(border, border, border, border);
                        } else {
                            table.getUnselectedStyle().setBorder(null);
                            table.getSelectedStyle().setBorder(null);
                            table.setDrawBorder(false);
                        }
                        this.addCmp(table, curAlign);
                        this.newLineIfNotEmpty(curAlign);
                    }
                    if (this.tables.size() == 0) {
                        this.curTable = null;
                    } else {
                        this.curTable = (HTMLTableModel)this.tables.lastElement();
                        this.tables.removeElement(this.curTable);
                    }
                    this.width *= 2;
                    if (this.width <= this.displayWidth) continue block57;
                    this.width = this.displayWidth;
                    continue block57;
                }
                case 45: {
                    if (this.curTable == null) continue block57;
                    this.curTable.commitRow();
                    continue block57;
                }
                case 43: 
                case 44: {
                    if (this.curTable == null) continue block57;
                    this.newLineIfNotEmpty(curAlign);
                    this.curContainer = (Container)this.tableCells.lastElement();
                    this.tableCells.removeElement(this.curContainer);
                    continue block57;
                }
                case 37: {
                    this.labelForID = null;
                    this.accesskey = '\u0000';
                }
            }
        }
    }

    private void adjustAlignment(int align, int curAlign) {
        if (!FIXED_WIDTH && align != curAlign && this.curLine.getComponentCount() == 0) {
            this.curLine.setLayout(new FlowLayout(curAlign));
        }
    }

    private int getUnorderedListType(Element element, int defaultType) {
        String listTypeStr = element.getAttributeById(19);
        if (listTypeStr == null) {
            return defaultType;
        }
        if (listTypeStr.equalsIgnoreCase("disc")) {
            return 1;
        }
        if (listTypeStr.equalsIgnoreCase("circle")) {
            return 2;
        }
        if (listTypeStr.equalsIgnoreCase("square")) {
            return 3;
        }
        return defaultType;
    }

    private int getOrderedListType(Element element) {
        return this.getOrderedListType(element, 0);
    }

    private int getOrderedListType(Element element, int defaultListType) {
        String listTypeStr = element.getAttributeById(19);
        if (listTypeStr != null && listTypeStr.length() > 0) {
            char c = listTypeStr.charAt(0);
            return this.getOrderedListType(c, defaultListType);
        }
        return defaultListType;
    }

    private int getOrderedListType(char c, int defaultListType) {
        for (int j = 0; j < ORDERED_LIST_TYPE_IDENTIFIERS.length; ++j) {
            if (c != ORDERED_LIST_TYPE_IDENTIFIERS[j]) continue;
            return j;
        }
        return defaultListType;
    }

    private String getListIndexString(int index, int type) {
        if (index <= 0) {
            return index + "";
        }
        switch (type) {
            case 0: {
                return index + "";
            }
            case 1: {
                return this.getLiteral(index, 'A');
            }
            case 2: {
                return this.getLiteral(index, 'a');
            }
            case 3: {
                return this.getRomanIndexString(index);
            }
            case 4: {
                return this.getRomanIndexString(index).toLowerCase();
            }
        }
        return "";
    }

    private String getLiteral(int index, char baseChar) {
        String literal = "";
        while (index > 0) {
            literal = (char)(index % 26 + baseChar - 1) + literal;
            index /= 26;
        }
        return literal;
    }

    private String getRomanIndexString(int index) {
        return ROMAN_NUMERALS_TENS[(index %= 100) / 10] + ROMAN_NUMERALS_ONES[index % 10];
    }

    private void pushContainer(Element element) {
        if (this.loadCSS) {
            Container cont = new Container(new BoxLayout(2));
            cont.setScrollableX(false);
            cont.getStyle().setBgTransparency(0);
            element.setAssociatedComponents(cont);
            this.curContainer.addComponent(cont);
            this.containers.addElement(this.curContainer);
            this.curContainer = cont;
        }
    }

    private void popContainer() {
        if (this.loadCSS) {
            Container prevContainer;
            this.curContainer = prevContainer = (Container)this.containers.lastElement();
            this.containers.removeElement(this.curContainer);
        }
    }

    private void addQuote(int curAlign) {
        String quote = null;
        quote = this.quoteTagCount == 0 ? "\"" : "'";
        if (FIXED_WIDTH && this.width - this.x < this.font.stringWidth(quote)) {
            this.newLine(curAlign);
        }
        this.addString(quote, curAlign);
    }

    private int getHorizAlign(String alignment, int defaultAlign, boolean allowJustify) {
        if (alignment != null) {
            if (alignment.equals("left")) {
                return 1;
            }
            if (alignment.equals("right")) {
                return 3;
            }
            if (alignment.equals("center") || alignment.equals("middle")) {
                return 4;
            }
            if (alignment.equals("justify")) {
                return allowJustify && FIXED_WIDTH ? 5 : 4;
            }
        }
        return defaultAlign;
    }

    private int getVertAlign(String alignment, int defaultAlign) {
        if (alignment != null) {
            if (alignment.equals("top")) {
                return 0;
            }
            if (alignment.equals("bottom")) {
                return 2;
            }
            if (alignment.equals("center") || alignment.equals("middle")) {
                return 4;
            }
        }
        return defaultAlign;
    }

    private int getInt(String intStr, int defaultValue) {
        try {
            int num = Integer.parseInt(intStr);
            return num;
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    private int getInt(String intStr) {
        return this.getInt(intStr, 0);
    }

    private int getPercentage(String percent) {
        if (percent == null || !percent.endsWith("%")) {
            return 0;
        }
        return this.getInt(percent.substring(0, percent.length() - 1));
    }

    private int calcSize(int origDim, String requestedDim, int defaultDim) {
        if (requestedDim == null) {
            return defaultDim;
        }
        boolean percent = false;
        if (requestedDim.endsWith("%")) {
            percent = true;
            requestedDim = requestedDim.substring(0, requestedDim.length() - 1);
        } else if (requestedDim.endsWith("px")) {
            requestedDim = requestedDim.substring(0, requestedDim.length() - 2);
        }
        int dim = 0;
        try {
            dim = Integer.parseInt(requestedDim);
        }
        catch (Exception e) {
            dim = -1;
        }
        if (dim < 0) {
            return origDim;
        }
        if (percent) {
            return origDim * dim / 100;
        }
        return dim;
    }

    Hashtable getInputFields() {
        return this.inputFields;
    }

    void selectComponent(Component cmp) {
        this.getComponentForm().setFocused(cmp);
        this.getComponentForm().scrollComponentToVisible(cmp);
        if (cmp instanceof RadioButton) {
            ((RadioButton)cmp).setSelected(true);
        } else if (cmp instanceof CheckBox) {
            CheckBox cb;
            cb.setSelected(!(cb = (CheckBox)cmp).isSelected());
        }
    }

    String convertURL(String url) {
        if (this.docInfo != null) {
            return this.docInfo.convertURL(url);
        }
        return url;
    }

    void goToAnchor(String anchorName) {
        Label anchorCmp = (Label)this.anchors.get(anchorName);
        if (anchorCmp != null) {
            int cx = anchorCmp.getX();
            int cy = anchorCmp.getY();
            int h = this.getHeight();
            if (anchorCmp.getAbsoluteY() - this.getY() + h > this.getPreferredH()) {
                h = this.getPreferredH() - (anchorCmp.getAbsoluteY() - this.getY());
            }
            this.scrollRectToVisible(cx, cy, this.getWidth(), h, anchorCmp);
        }
    }

    public void layoutContainer() {
        if (FIXED_WIDTH && this.displayWidth != 0 && Display.getInstance().getDisplayWidth() != this.displayWidth) {
            new Thread(){

                public void run() {
                    HTMLComponent.this.cleanup();
                    HTMLComponent.this.rebuildPage();
                }
            }.start();
        }
        super.layoutContainer();
    }

    public void actionPerformed(ActionEvent evt) {
        if (this.getComponentForm().getFocused() instanceof TextField) {
            return;
        }
        int keyCode = evt.getKeyEvent();
        Object obj = this.accessKeys.get(new Integer(keyCode));
        if (obj != null) {
            if (obj instanceof HTMLLink) {
                HTMLLink htmlLink = (HTMLLink)obj;
                htmlLink.actionPerformed(null);
            } else if (obj instanceof ForLabel) {
                ((ForLabel)obj).triggerAction();
            } else if (obj instanceof Component) {
                this.selectComponent((Component)obj);
            }
        }
    }

    static {
        for (int i = 0; i < INPUT_TYPE_STRINGS.length; ++i) {
            INPUT_TYPES.addElement(INPUT_TYPE_STRINGS[i]);
        }
    }
}

