/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.html;

import com.sun.lwuit.Label;
import com.sun.lwuit.html.HTMLComponent;
import com.sun.lwuit.html.ImageThread;
import java.util.Enumeration;
import java.util.Vector;

class ImageThreadQueue {
    private static int DEFAULT_MAX_THREADS;
    HTMLComponent htmlC;
    Vector queue = new Vector();
    Vector running = new Vector();
    Vector urls = new Vector();
    static int maxThreads;
    int threadCount;
    boolean started;

    ImageThreadQueue(HTMLComponent htmlC) {
        this.htmlC = htmlC;
    }

    static void setMaxThreads(int threadsNum) {
        maxThreads = threadsNum;
    }

    synchronized void add(Label imgLabel, String imageUrl) {
        if (this.started) {
            throw new IllegalStateException("ImageThreadQueue alreadey started! stop/cancel first");
        }
        int index = this.urls.indexOf(imageUrl);
        if (index != -1) {
            ImageThread t = (ImageThread)this.queue.elementAt(index);
            t.addLabel(imgLabel);
        } else {
            ImageThread t = new ImageThread(imageUrl, imgLabel, this.htmlC, this);
            this.queue.addElement(t);
            this.urls.addElement(imageUrl);
        }
    }

    int getQueueSize() {
        return this.queue.size();
    }

    synchronized void startRunning() {
        this.urls = new Vector();
        int threads = Math.min(this.queue.size(), maxThreads);
        this.started = threads > 0;
        for (int i = 0; i < threads; ++i) {
            ImageThread t = (ImageThread)this.queue.firstElement();
            this.queue.removeElementAt(0);
            this.running.addElement(t);
            ++this.threadCount;
            new Thread(t).start();
        }
        if (!this.started) {
            this.htmlC.setPageStatus(4);
        }
    }

    synchronized void threadFinished(ImageThread finishedThread, boolean success) {
        this.running.removeElement(finishedThread);
        if (this.queue.size() > 0) {
            ImageThread t = (ImageThread)this.queue.firstElement();
            this.queue.removeElementAt(0);
            this.running.addElement(t);
            new Thread(t).start();
        } else {
            --this.threadCount;
        }
        boolean bl = this.started = this.threadCount > 0;
        if (!this.started) {
            this.htmlC.setPageStatus(4);
        }
    }

    synchronized void discardQueue() {
        this.queue.removeAllElements();
        Enumeration e = this.running.elements();
        while (e.hasMoreElements()) {
            ImageThread t = (ImageThread)e.nextElement();
            t.cancel();
        }
        this.running.removeAllElements();
        this.threadCount = 0;
        this.started = false;
    }

    public String toString() {
        ImageThread t;
        String str = "---- Running ----\n";
        int i = 1;
        Enumeration e = this.running.elements();
        while (e.hasMoreElements()) {
            t = (ImageThread)e.nextElement();
            str = str + "#" + i + ": " + t.imageUrl + "\n";
            ++i;
        }
        i = 1;
        str = str + "Queue:\n";
        e = this.queue.elements();
        while (e.hasMoreElements()) {
            t = (ImageThread)e.nextElement();
            str = str + "#" + i + ": " + t.imageUrl + "\n";
            ++i;
        }
        str = str + "---- count:" + this.threadCount + " ----\n";
        return str;
    }

    static {
        maxThreads = DEFAULT_MAX_THREADS = 2;
    }
}

