/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit;

import com.sun.lwuit.Button;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.Image;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.plaf.DefaultLookAndFeel;
import com.sun.lwuit.plaf.LookAndFeel;
import com.sun.lwuit.plaf.UIManager;

public class CheckBox
extends Button {
    private boolean selected = false;

    public CheckBox(String text) {
        this(text, (Image)null);
    }

    public CheckBox() {
        this("");
    }

    public CheckBox(Image icon) {
        this("", icon);
    }

    public CheckBox(String text, Image icon) {
        super(text, icon);
        this.setUIID("CheckBox");
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
        this.repaint();
    }

    void released() {
        if (this.isEnabled()) {
            this.selected = !this.isSelected();
        }
        super.released();
    }

    public void paint(Graphics g) {
        UIManager.getInstance().getLookAndFeel().drawCheckBox(g, this);
    }

    protected Dimension calcPreferredSize() {
        return UIManager.getInstance().getLookAndFeel().getCheckBoxPreferredSize(this);
    }

    protected String paramString() {
        return super.paramString() + ", selected = " + this.selected;
    }

    int getAvaliableSpaceForText() {
        Image[] rButtonImages;
        LookAndFeel l = UIManager.getInstance().getLookAndFeel();
        if (l instanceof DefaultLookAndFeel && (rButtonImages = ((DefaultLookAndFeel)l).getCheckBoxImages()) != null) {
            int index = this.isSelected() ? 1 : 0;
            return super.getAvaliableSpaceForText() - rButtonImages[index].getWidth();
        }
        return super.getAvaliableSpaceForText() - (this.getHeight() + this.getGap());
    }
}

