/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.html;

import com.sun.lwuit.plaf.UIManager;

class FormatConstraint {
    static final int TYPE_LOWERCASE = 1;
    static final int TYPE_UPPERCASE = 2;
    static final int TYPE_NUMERIC = 4;
    static final int TYPE_SYMBOL = 8;
    static final int TYPE_ANY = 16;
    static final int COUNT_EXACTLY_ONE = Integer.MIN_VALUE;
    static final int COUNT_NO_LIMIT = Integer.MAX_VALUE;
    int type;
    int count;

    public FormatConstraint(int type, String countStr) {
        if (countStr.equals("*")) {
            this.count = Integer.MAX_VALUE;
        } else if (countStr.equals("")) {
            this.count = Integer.MIN_VALUE;
        } else {
            try {
                this.count = Integer.parseInt(countStr);
            }
            catch (NumberFormatException nfe) {
                System.out.println("Invalid FormatConstraint count " + countStr);
            }
        }
        this.type = type;
    }

    public String toString() {
        String str = "";
        if (this.count != Integer.MIN_VALUE) {
            str = this.count == Integer.MAX_VALUE ? str + UIManager.getInstance().localize("html.format.anynumber", "any number of") : str + UIManager.getInstance().localize("html.format.upto", "up to") + " " + this.count;
        }
        str = str + " ";
        String orString = " " + UIManager.getInstance().localize("html.format.or", "or") + " ";
        String or = "";
        if ((this.type & 0x10) != 0) {
            str = str + "any";
        } else {
            if ((this.type & 1) != 0) {
                str = str + UIManager.getInstance().localize("html.format.lowercase", "lowercase");
                or = orString;
            }
            if ((this.type & 2) != 0) {
                str = str + or + UIManager.getInstance().localize("html.format.uppercase", "uppercase");
                or = orString;
            }
            if ((this.type & 4) != 0) {
                str = str + or + UIManager.getInstance().localize("html.format.numeric", "numeric");
                or = orString;
            }
            if ((this.type & 8) != 0) {
                str = str + or + UIManager.getInstance().localize("html.format.symbol", "symbol");
            }
        }
        str = str + " ";
        str = this.count != Integer.MIN_VALUE && this.count != 1 ? str + UIManager.getInstance().localize("html.format.chars", "characters") : str + UIManager.getInstance().localize("html.format.char", "character");
        return str;
    }
}

