/*
 * Decompiled with CFR 0.152.
 */
package com.gn4me.waka.menu;

import com.gn4me.waka.Drawable;
import com.gn4me.waka.Resources;
import com.gn4me.waka.Setting;
import com.gn4me.waka.SoundsPlayer;
import javax.microedition.lcdui.Graphics;

public class SoundOptions
implements Drawable {
    private int lastAction = -1;
    private int lastX;
    private int sound;
    private int x;
    private int y;
    private int width = 360;
    private int height = 100;
    private Setting setting = Setting.getInstance();

    public SoundOptions() {
        this.sound = this.setting.getSound();
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public void setPosition(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public void paint(Graphics g) {
        int j;
        g.drawImage(Resources.MENU_SOUND, this.x + 180 - Resources.MENU_SOUND.getWidth() / 2, this.y, 20);
        int yy = this.y + 50;
        int xx = 30;
        g.drawImage(Resources.SOUND_MINS, xx, yy + Resources.SOUND1.getHeight() / 2 - Resources.SOUND_MINS.getHeight() / 2, 20);
        xx += 10 + Resources.SOUND_MINS.getWidth();
        for (j = 0; j < this.sound; ++j) {
            g.drawImage(Resources.SOUND1, xx, yy, 20);
            xx += 10;
        }
        for (j = 0; j < 25 - this.sound; ++j) {
            g.drawImage(Resources.SOUND2, xx, yy, 20);
            xx += 10;
        }
        g.drawImage(Resources.SOUND_PLUS, xx += Resources.SOUND1.getWidth(), yy + Resources.SOUND1.getHeight() / 2 - Resources.SOUND_PLUS.getHeight() / 2, 20);
    }

    public boolean contains(int x, int y) {
        return x > this.x && x < this.x + this.width && y > this.y && y < this.y + this.height;
    }

    public void pointerDragged(int x, int y) {
        if (!this.contains(x, y)) {
            this.lastAction = -1;
            return;
        }
        if (this.lastAction != 0 && this.lastAction != 1) {
            return;
        }
        if (x < this.lastX) {
            --this.sound;
            if (this.sound < 0) {
                this.sound = 0;
            }
        } else if (x > this.lastX) {
            ++this.sound;
            if (this.sound > 25) {
                this.sound = 25;
            }
        }
        SoundsPlayer.getInstance().setSoundLevel(this.sound);
        this.lastX = x;
        this.lastAction = 1;
    }

    public void pointerPressed(int x, int y) {
        if (!this.contains(x, y)) {
            this.lastAction = -1;
            return;
        }
        this.lastX = x;
        this.lastAction = 0;
    }

    public void pointerReleased(int x, int y) {
        if (!this.contains(x, y)) {
            this.lastAction = -1;
            this.sound = this.setting.getSound();
            return;
        }
        if (this.setting.getSound() != this.sound) {
            this.setting.setSound((byte)this.sound);
            this.setting.save();
            SoundsPlayer.getInstance().setSoundLevel(this.sound);
        }
        this.lastAction = 2;
    }
}

