/*
 * Decompiled with CFR 0.152.
 */
package com.gn4me.waka.objects;

import org.jbox2d.collision.AABB;
import org.jbox2d.collision.CircleDef;
import org.jbox2d.collision.PolygonDef;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.dynamics.World;
import org.jbox2d.dynamics.joints.Joint;
import org.jbox2d.dynamics.joints.RevoluteJointDef;

public class PhysicsWorld {
    private static final float WORLD_WIDTH = 3.6f;
    private static final float WORLD_HEIGHT = 6.4f;
    private static PhysicsWorld physicsWorld;
    private World world;
    private AABB worldAABB;
    private Body ground;
    static /* synthetic */ Class class$com$gn4me$waka$objects$PhysicsWorld;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PhysicsWorld getInstance() {
        Class clazz = class$com$gn4me$waka$objects$PhysicsWorld == null ? (class$com$gn4me$waka$objects$PhysicsWorld = PhysicsWorld.class$("com.gn4me.waka.objects.PhysicsWorld")) : class$com$gn4me$waka$objects$PhysicsWorld;
        synchronized (clazz) {
            if (physicsWorld == null) {
                physicsWorld = new PhysicsWorld();
            }
        }
        return physicsWorld;
    }

    public static PhysicsWorld getNewInstance() {
        if (physicsWorld == null) {
            return PhysicsWorld.getInstance();
        }
        physicsWorld.reset();
        return physicsWorld;
    }

    private PhysicsWorld() {
        this.createWorld();
    }

    private void reset() {
        for (Body body = this.world.getBodyList(); body != null && body.getNext() != null; body = body.getNext()) {
            this.world.destroyBody(body);
        }
        for (Joint joint = this.world.getJointList(); joint != null && joint.getNext() != null; joint = joint.getNext()) {
            this.world.destroyJoint(joint);
        }
        this.createGround();
    }

    private void createWorld() {
        this.worldAABB = new AABB();
        this.worldAABB.lowerBound = new Vec2(0.0f, 0.0f);
        this.worldAABB.upperBound = new Vec2(3.6f, 6.4f);
        Vec2 gravity = new Vec2(0.0f, -10.0f);
        boolean doSleep = true;
        this.world = new World(this.worldAABB, gravity, doSleep);
        this.createGround();
    }

    private void createGround() {
        PolygonDef sd = new PolygonDef();
        sd.setAsBox(2.0f, 0.5f);
        BodyDef bd = new BodyDef();
        bd.position.set(0.0f, 7.0f);
        this.ground = this.world.createBody(bd);
        this.ground.createShape(sd);
    }

    public Body createBoX(float x, float y, float width, float height, int angle, boolean computeMass, float friction, float restitution, float density, Vec2 linearVelocity, Vec2 position) {
        x += width / 2.0f;
        y += height / 2.0f;
        x /= 100.0f;
        y /= 100.0f;
        y = 6.4f - y;
        width /= 100.0f;
        height /= 100.0f;
        Body body = null;
        BodyDef bd = new BodyDef();
        if (position == null) {
            bd.position.set(x, y);
        } else {
            bd.position = position;
        }
        bd.angle = (float)Math.toRadians(angle);
        body = this.world.createBody(bd);
        if (linearVelocity != null) {
            body.setLinearVelocity(linearVelocity);
        }
        PolygonDef sd = new PolygonDef();
        sd.setAsBox(width / 2.0f, height / 2.0f);
        sd.density = density;
        sd.friction = 0.4f;
        sd.restitution = restitution;
        body.createShape(sd);
        if (computeMass) {
            body.setMassFromShapes();
        }
        return body;
    }

    public Body createBoX(float x, float y, float width, float height, int angle) {
        return this.createBoX(x, y, width, height, angle, true, 0.0f, 0.0f, 5.0f, null, null);
    }

    public Body createBoX(float width, float height, int angle, Vec2 linearVelocity, Vec2 position) {
        return this.createBoX(0.0f, 0.0f, width, height, angle, true, 0.0f, 0.0f, 5.0f, linearVelocity, position);
    }

    public Body createBoX(float x, float y, float width, float height, int angle, boolean computeMass) {
        return this.createBoX(x, y, width, height, angle, computeMass, 0.0f, 0.0f, 5.0f, null, null);
    }

    public Body createCircle(float x, float y, float raduis, float friction, float density, float restitution, Vec2 linearVelocity, Vec2 position) {
        x += raduis;
        y += raduis;
        x /= 100.0f;
        y /= 100.0f;
        y = 6.4f - y;
        Body body = null;
        CircleDef circleDef = new CircleDef();
        circleDef.density = density;
        circleDef.restitution = restitution;
        circleDef.radius = raduis /= 100.0f;
        circleDef.friction = 0.01f;
        BodyDef bodyDef = new BodyDef();
        if (position == null) {
            bodyDef.position.set(x, y);
        } else {
            bodyDef.position = position;
        }
        body = this.world.createBody(bodyDef);
        body.createShape(circleDef);
        body.setMassFromShapes();
        if (linearVelocity != null) {
            body.setLinearVelocity(linearVelocity);
        }
        return body;
    }

    public Body createCircle(float x, float y, float raduis) {
        return this.createCircle(x, y, raduis, 0.0f, 5.0f, 0.1f, null, null);
    }

    public Body createCircle(float raduis, Vec2 linearVelocity, Vec2 position) {
        return this.createCircle(0.0f, 0.0f, raduis, 0.0f, 5.0f, 0.1f, linearVelocity, position);
    }

    public Body createCompoundShape(float x, float y, float width, float height) {
        x += width / 2.0f;
        y += height / 2.0f;
        x /= 100.0f;
        y /= 100.0f;
        y = 6.4f - y;
        width /= 100.0f;
        height /= 100.0f;
        Body body = null;
        BodyDef bd = new BodyDef();
        bd.position.set(x, y);
        body = this.world.createBody(bd);
        PolygonDef sd = new PolygonDef();
        sd.setAsBox(width / 2.0f, height / 2.0f);
        sd.density = 5.0f;
        sd.friction = 0.4f;
        sd.restitution = 0.0f;
        body.createShape(sd);
        sd = new PolygonDef();
        sd.setAsBox(height / 2.0f, width / 2.0f);
        sd.density = 5.0f;
        sd.friction = 0.4f;
        sd.restitution = 0.0f;
        body.createShape(sd);
        body.setMassFromShapes();
        return body;
    }

    public Joint createJoint(Body body1, Body body2, float x, float y) {
        y /= 100.0f;
        y = 6.4f - y;
        Vec2 point = new Vec2(x /= 100.0f, y);
        if (body1 == null) {
            body1 = this.ground;
        }
        if (body2 == null) {
            body2 = this.ground;
        }
        RevoluteJointDef rjd = new RevoluteJointDef();
        rjd.initialize(body1, body2, point);
        return this.world.createJoint(rjd);
    }

    public void cycle() {
        this.world.step(0.033333335f, 10);
        System.out.println(this.world.getBodyCount());
    }

    public void removeBody(Body body) {
        this.world.destroyBody(body);
    }

    public void removeJoint(Joint joint) {
        this.world.destroyJoint(joint);
    }

    public int getY(int y) {
        return (int)(640.0f - (float)y);
    }

    public float screenToWorldX(int x) {
        return x / 100;
    }

    public int worldToScreenX(float x) {
        return (int)(x * 100.0f);
    }

    public float screenToWorldY(int y) {
        float yy = y / 100;
        return 6.4f - yy;
    }

    public int worldToScreenY(float y) {
        return (int)((6.4f - y) * 100.0f);
    }

    public static void clean() {
        physicsWorld = null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

