/*
 * Decompiled with CFR 0.152.
 */
package com.goodnews.games.loading;

import com.goodnews.games.loading.LoaderListener;
import com.goodnews.games.loading.ProgressBar;
import java.util.Vector;

public abstract class ResourceLoader
implements Runnable {
    private Vector vecListeners = new Vector();
    private int finishedSteps;

    public ResourceLoader(int stepsNumber) {
        this.addListener(new ProgressBar(stepsNumber));
    }

    public int getFinishedSteps() {
        return this.finishedSteps;
    }

    public void incrementFinishedSteps(int steps) {
        this.finishedSteps += steps;
        for (int j = 0; j < this.vecListeners.size(); ++j) {
            ((LoaderListener)this.vecListeners.elementAt(j)).loaderStepped(this.finishedSteps);
        }
    }

    private void finished() {
        for (int j = 0; j < this.vecListeners.size(); ++j) {
            ((LoaderListener)this.vecListeners.elementAt(j)).loaderFinished();
        }
        this.vecListeners.removeAllElements();
    }

    private void started() {
        for (int j = 0; j < this.vecListeners.size(); ++j) {
            ((LoaderListener)this.vecListeners.elementAt(j)).loaderStarted();
        }
    }

    public void addListener(LoaderListener loaderListener) {
        this.vecListeners.addElement(loaderListener);
    }

    public void start() {
        new Thread(this).start();
        this.started();
    }

    public void run() {
        this.load();
        this.finished();
    }

    public void removeAllListners() {
        this.vecListeners.removeAllElements();
    }

    public abstract void load();
}

