/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.collision;

import org.jbox2d.collision.AABB;
import org.jbox2d.collision.CircleDef;
import org.jbox2d.collision.MassData;
import org.jbox2d.collision.Shape;
import org.jbox2d.collision.ShapeDef;
import org.jbox2d.common.Mat22;
import org.jbox2d.common.Vec2;
import org.jbox2d.common.XForm;

public class CircleShape
extends Shape {
    public float m_radius;
    public Vec2 m_localPosition;

    public CircleShape(ShapeDef def) {
        super(def);
        CircleDef circleDef = (CircleDef)def;
        this.m_type = 1;
        this.m_localPosition = circleDef.localPosition.clone();
        this.m_radius = circleDef.radius;
    }

    public void updateSweepRadius(Vec2 center) {
        Vec2 d = this.m_localPosition.sub(center);
        this.m_sweepRadius = d.length() + this.m_radius - 0.04f;
    }

    public boolean testPoint(XForm transform, Vec2 p) {
        Vec2 center = transform.position.add(Mat22.mul(transform.R, this.m_localPosition));
        Vec2 d = p.sub(center);
        return Vec2.dot(d, d) <= this.m_radius * this.m_radius;
    }

    public void computeAABB(AABB aabb, XForm transform) {
        Vec2 p = transform.position.add(Mat22.mul(transform.R, this.m_localPosition));
        aabb.lowerBound.set(p.x - this.m_radius, p.y - this.m_radius);
        aabb.upperBound.set(p.x + this.m_radius, p.y + this.m_radius);
    }

    public void computeSweptAABB(AABB aabb, XForm transform1, XForm transform2) {
        Vec2 p1 = transform1.position.add(Mat22.mul(transform1.R, this.m_localPosition));
        Vec2 p2 = transform2.position.add(Mat22.mul(transform2.R, this.m_localPosition));
        Vec2 lower = Vec2.min(p1, p2);
        Vec2 upper = Vec2.max(p1, p2);
        aabb.lowerBound.set(lower.x - this.m_radius, lower.y - this.m_radius);
        aabb.upperBound.set(upper.x + this.m_radius, upper.y + this.m_radius);
    }

    public void computeMass(MassData massData) {
        massData.mass = this.m_density * (float)Math.PI * this.m_radius * this.m_radius;
        massData.center = this.m_localPosition.clone();
        massData.I = massData.mass * (0.5f * this.m_radius * this.m_radius + Vec2.dot(this.m_localPosition, this.m_localPosition));
    }

    public float getRadius() {
        return this.m_radius;
    }

    public Vec2 getLocalPosition() {
        return this.m_localPosition.clone();
    }
}

