/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.collision;

import org.jbox2d.collision.AABB;
import org.jbox2d.collision.BroadPhase;
import org.jbox2d.collision.CircleShape;
import org.jbox2d.collision.FilterData;
import org.jbox2d.collision.MassData;
import org.jbox2d.collision.PolygonShape;
import org.jbox2d.collision.ShapeDef;
import org.jbox2d.common.Vec2;
import org.jbox2d.common.XForm;
import org.jbox2d.dynamics.Body;

public abstract class Shape {
    public int uid = uidcount++;
    private static int uidcount = 0;
    public int m_type;
    public Shape m_next;
    public Body m_body;
    public float m_sweepRadius;
    public float m_density;
    public float m_friction;
    public float m_restitution;
    public int m_proxyId;
    public FilterData m_filter;
    public boolean m_isSensor;
    public Object m_userData;

    public Shape(ShapeDef def) {
        this.m_userData = def.userData;
        this.m_friction = def.friction;
        this.m_restitution = def.restitution;
        this.m_density = def.density;
        this.m_body = null;
        this.m_sweepRadius = 0.0f;
        this.m_next = null;
        this.m_proxyId = Integer.MAX_VALUE;
        this.m_filter = new FilterData();
        this.m_filter.categoryBits = def.filter.categoryBits;
        this.m_filter.maskBits = def.filter.maskBits;
        this.m_filter.groupIndex = def.filter.groupIndex;
        this.m_isSensor = def.isSensor;
    }

    public float getFriction() {
        return this.m_friction;
    }

    public void setFriction(float friction) {
        this.m_friction = friction;
    }

    public float getRestitution() {
        return this.m_restitution;
    }

    public void setRestitution(float restitution) {
        this.m_restitution = restitution;
    }

    public void setFilterData(FilterData filter) {
        this.m_filter.set(filter);
    }

    public FilterData getFilterData() {
        return this.m_filter;
    }

    public int getType() {
        return this.m_type;
    }

    public boolean isSensor() {
        return this.m_isSensor;
    }

    public Object getUserData() {
        return this.m_userData;
    }

    public void setUserData(Object o) {
        this.m_userData = o;
    }

    public Body getBody() {
        return this.m_body;
    }

    public Shape getNext() {
        return this.m_next;
    }

    public float getSweepRadius() {
        return this.m_sweepRadius;
    }

    public abstract boolean testPoint(XForm var1, Vec2 var2);

    public abstract void computeAABB(AABB var1, XForm var2);

    public abstract void computeSweptAABB(AABB var1, XForm var2, XForm var3);

    public abstract void computeMass(MassData var1);

    public abstract void updateSweepRadius(Vec2 var1);

    public boolean synchronize(BroadPhase broadPhase, XForm transform1, XForm transform2) {
        if (this.m_proxyId == Integer.MAX_VALUE) {
            return false;
        }
        AABB aabb = new AABB();
        this.computeSweptAABB(aabb, transform1, transform2);
        if (broadPhase.inRange(aabb)) {
            broadPhase.moveProxy(this.m_proxyId, aabb);
            return true;
        }
        return false;
    }

    public void refilterProxy(BroadPhase broadPhase, XForm transform) {
        if (this.m_proxyId == Integer.MAX_VALUE) {
            return;
        }
        broadPhase.destroyProxy(this.m_proxyId);
        AABB aabb = new AABB();
        this.computeAABB(aabb, transform);
        boolean inRange = broadPhase.inRange(aabb);
        this.m_proxyId = inRange ? broadPhase.createProxy(aabb, this) : Integer.MAX_VALUE;
    }

    public static Shape create(ShapeDef def) {
        if (def.type == 1) {
            return new CircleShape(def);
        }
        if (def.type == 2) {
            return new PolygonShape(def);
        }
        return null;
    }

    public static void destroy(Shape s) {
        s.destructor();
    }

    public void destructor() {
    }

    public void createProxy(BroadPhase broadPhase, XForm transform) {
        AABB aabb = new AABB();
        this.computeAABB(aabb, transform);
        boolean inRange = broadPhase.inRange(aabb);
        this.m_proxyId = inRange ? broadPhase.createProxy(aabb, this) : Integer.MAX_VALUE;
    }

    public void destroyProxy(BroadPhase broadPhase) {
        if (this.m_proxyId != Integer.MAX_VALUE) {
            broadPhase.destroyProxy(this.m_proxyId);
            this.m_proxyId = Integer.MAX_VALUE;
        }
    }
}

