/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.collision;

import org.jbox2d.collision.Distance;
import org.jbox2d.collision.Shape;
import org.jbox2d.common.Sweep;
import org.jbox2d.common.Vec2;
import org.jbox2d.common.XForm;

public class TOI {
    public static float timeOfImpact(Shape shape1, Sweep sweep1, Shape shape2, Sweep sweep2) {
        float r1 = shape1.getSweepRadius();
        float r2 = shape2.getSweepRadius();
        float t0 = sweep1.t0;
        Vec2 v1 = sweep1.c.sub(sweep1.c0);
        Vec2 v2 = sweep2.c.sub(sweep2.c0);
        float omega1 = sweep1.a - sweep1.a0;
        float omega2 = sweep2.a - sweep2.a0;
        float alpha = 0.0f;
        Vec2 p1 = new Vec2();
        Vec2 p2 = new Vec2();
        int k_maxIterations = 20;
        int iter = 0;
        Vec2 normal = new Vec2(0.0f, 0.0f);
        float distance = 0.0f;
        float targetDistance = 0.0f;
        while (true) {
            float t = (1.0f - alpha) * t0 + alpha;
            XForm xf1 = new XForm();
            XForm xf2 = new XForm();
            sweep1.getXForm(xf1, t);
            sweep2.getXForm(xf2, t);
            distance = Distance.distance(p1, p2, shape1, xf1, shape2, xf2);
            if (iter == 0) {
                targetDistance = distance > 0.08f ? 0.06f : Math.max(0.002f, distance - 0.02f);
            }
            if (distance - targetDistance < 0.002f || iter == 20) break;
            normal = p2.sub(p1);
            normal.normalize();
            float approachVelocityBound = Vec2.dot(normal, v1.sub(v2)) + Math.abs(omega1) * r1 + Math.abs(omega2) * r2;
            if (Math.abs(approachVelocityBound) < 1.1920929E-7f) {
                alpha = 1.0f;
                break;
            }
            float dAlpha = (distance - targetDistance) / approachVelocityBound;
            float newAlpha = alpha + dAlpha;
            if (newAlpha < 0.0f || 1.0f < newAlpha) {
                alpha = 1.0f;
                break;
            }
            if (newAlpha < 1.0000119f * alpha) break;
            alpha = newAlpha;
            ++iter;
        }
        return alpha;
    }
}

